// planeview.cpp : implementation of the CPlaneView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"

#include "PlaneVw.h"                                           

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CMetDoc*			ptMet;
extern CPlaneDoc*		ptPlaneDoc;
extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CPlaneView

IMPLEMENT_DYNCREATE(CPlaneView, CTextViewTool)

BEGIN_MESSAGE_MAP(CPlaneView, CTextViewTool)
	//{{AFX_MSG_MAP(CPlaneView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlaneView construction/destruction

CPlaneView::CPlaneView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);
}

CPlaneView::~CPlaneView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();
}

/************************************************************************
 *  PlaneVw.cpp				U p d a t e F o n t s 						*
 ************************************************************************/
void CPlaneView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
//m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 

		//	used to get fixed left margin and defined "max" char width
GetLeftMarginAndCharX_LP (m_wPointSize, &m_CharX);	// defines m_LeftMargin, m_CharX
}

/************************************************************************
 *  PlaneVw.cpp			O n I n i t i a l U p d a t e					*
 ************************************************************************/
void CPlaneView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}



/////////////////////////////////////////////////////////////////////////////
// CPlaneView drawing
/************************************************************************
 *  PlaneVw.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CPlaneView::SetXTabs (CDC* pDC, CPlaneDoc* ptPlaneDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   

//X_TAB = (m_bForPrinter? 4 : 2)*CharX;
X_TAB = m_LeftMargin;
m_dY = LogPixYToUse;
m_Xleft  = X_TAB;


m_Xtext	= m_Xleft + CharX;
int X_help = GetRightPos (pDC, m_Xleft+CharX, IDS_UNUSABLE);
m_Xpos1 = GetRightPos (pDC, X_help+2*CharX, IDS_POSITION1);
m_Xpos2 = GetRightPos (pDC, m_Xpos1+CharX, IDS_POSITION2);
m_Xpos3 = GetRightPos (pDC, m_Xpos2+CharX, IDS_POSITION3);
m_Xpos4 = GetRightPos (pDC, m_Xpos3+CharX, IDS_POSITION4);
m_Xpos5 = GetRightPos (pDC, m_Xpos4+CharX, IDS_POSITION5);

m_Xright = m_Xpos5 + CharX;
m_dX = m_Xright - m_Xleft;
}


/************************************************************************
 *  PlaneVw.cpp			D r a w P l S p e e d C o n s					*
 ************************************************************************/
void CPlaneView::DrawPlSpeedCons (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CString	szDim;
CFont* ptOldFont;
double	fConvert;
short	nSpeedDim, nPrefsSpeedDim;
short	nVolDim;
short	nClimbDim, nPrefsClimbDim;

ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft	(pDC, m_Xtext, *ptY, IDS_SPEEDCONS);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;


RsrcAlignRight (pDC, m_Xpos1, *ptY, IDS_SPEED); 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_CONSUMPTION); 
RsrcAlignRight (pDC, m_Xpos5, *ptY, IDS_CLIMBRATE); 
(*ptY) += m_LineY;  


					/* print dimensions of table	*/
nPrefsSpeedDim = ptDim->DistDimToSpeedDim (ptDim->Distance());
ptDim->GetDimCstring (&szDim, nPrefsSpeedDim);
TextAlignRight (pDC, m_Xpos1, *ptY, szDim); 

ptDim->GetDimCstring (&szDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_CONSDIM, szDim); 

nPrefsClimbDim = ptDim->AltDimToClimbDim(ptDim->Altitude());
ptDim->GetDimCstring (&szDim, nPrefsClimbDim);
TextAlignRight (pDC, m_Xpos5, *ptY, szDim); 
(*ptY) += dY;

								// plane parameter dimensions
nSpeedDim = Plane.GetSpeedDim();
nVolDim = Plane.GetVolDim();
nClimbDim = Plane.GetClimbDim();


								// climb parameters	
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_CLIMB); 

fConvert = ptDim->ConvertSpeed (Plane.GetClimbSpeed(), nSpeedDim, nPrefsSpeedDim);
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_SPEED, (short)(fConvert + 0.5));

fConvert = ptDim->ConvertVolume (Plane.GetClimbCons(), nVolDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_CONS, (short)(fConvert + 0.5));

fConvert = ptDim->ConvertSpeed (Plane.GetClimbRate(), nClimbDim, nPrefsClimbDim);
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_SPEED, (short)(fConvert + 0.5));

(*ptY) += dY;  


								// cruise parameters	
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_CRUISE);

fConvert = ptDim->ConvertSpeed (Plane.GetCruiseSpeed(), nSpeedDim, nPrefsSpeedDim);
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_SPEED, (short)(fConvert + 0.5));

fConvert = ptDim->ConvertVolume (Plane.GetCruiseCons(), nVolDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_CONS, (short)(fConvert + 0.5));

					/* climb rate=0 while cruising	*/
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_SPEED, (short)0);
 
(*ptY) += dY;  


								// descend parameters
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_DESCEND); 

fConvert = ptDim->ConvertSpeed (Plane.GetDescSpeed(), nSpeedDim, nPrefsSpeedDim);
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_SPEED, (short)(fConvert + 0.5));

fConvert = ptDim->ConvertVolume (Plane.GetDescCons(), nVolDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_CONS, (short)(fConvert + 0.5));

fConvert = ptDim->ConvertSpeed (Plane.GetDescRate(), nClimbDim, nPrefsClimbDim);
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_SPEED, (short)(fConvert - 0.5));

(*ptY) += dY; 
}


/************************************************************************
 *  PlaneVw.cpp				D r a w F l P l a n I n f o					*
 ************************************************************************/
void CPlaneView::DrawFlPlanInfo (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CFont* ptOldFont;

							/* Angaben zum Flugplan	*/
ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft	(pDC, m_Xtext, *ptY, IDS_FLPLINFO);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

									/* Lfz.- Kennung	*/
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FLPLIDENT); 
TextAlignRight (pDC, m_Xpos1, *ptY, Plane.GetIdent());
 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_FLPLTYPE); 
TextAlignRight (pDC, m_Xpos5, *ptY, Plane.GetType()); 
(*ptY) += dY;  


CString szSSR;
switch (Plane.GetSSRType())
	{
	case SS_NONE: szSSR = "N"; break;
	case SS_NOCODING: szSSR = "0"; break;
	case SS_2DIGITS_A: szSSR = "2"; break;
	case SS_4DIGITS_A: szSSR = "4"; break;
	case SS_MODE_A_C: szSSR = "C"; break;
	}
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FLPLEQUIP); 
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_FLPLEQUIP, 
					(LPCTSTR)Plane.GetEquipment(), (LPCTSTR)szSSR);
 
CString szEmergFrq, szFrq;
if (Plane.HasEmRadioUHF())
	{
	szFrq.LoadString (IDS_UHF);
	szEmergFrq += szFrq;
	}
if (Plane.HasEmRadioVHF())
	{
	szFrq.LoadString (IDS_VHF);
	if (szEmergFrq.GetLength() > 0) szEmergFrq += " ";
	szEmergFrq += szFrq;
	}
if (Plane.HasEmRadioELBA())
	{
	szFrq.LoadString (IDS_ELBA);
	if (szEmergFrq.GetLength() > 0) szEmergFrq += " ";
	szEmergFrq += szFrq;
	}
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_FLPLEMERG); 
TextAlignRight (pDC, m_Xpos5, *ptY, szEmergFrq); 
(*ptY) += dY;  

	 
	 						   // "Farbe und Markierung"
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FLPLCOLOR); 
TextAlignLeft (pDC, m_Xpos1, *ptY, Plane.GetColor()); 
(*ptY) += dY;  
				
							  // "Wirbelschleppenkategorie"
CString szWakeCat;
switch (Plane.GetWakeCategory ())
	{
	case WT_HEAVY:	szWakeCat = "H";	break;
	case WT_MEDIUM: szWakeCat = "M";	break;
	case WT_LIGHT:	szWakeCat = "L";	break;
	}
RsrcAlignLeft (pDC, m_Xtext,  *ptY, IDS_FLPLWAKECAT); 
TextAlignRight (pDC, m_Xpos1, *ptY, szWakeCat); 
(*ptY) += dY;  
}


/************************************************************************
 *  PlaneVw.cpp				D r a w P l S t a r t						*
 ************************************************************************/
void CPlaneView::DrawPlStart (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CString	szDim;
CFont* ptOldFont;
double	fConvert;
double	fObstHeight_m;
BOOL	bShowMinimal;
short nMassDim, nLenDim;


							/* Start - land distances	*/
ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft	(pDC, m_Xtext, *ptY, IDS_STARTLAND);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

								/* print headline of table	*/
RsrcAlignRight (pDC, m_Xpos1, *ptY, IDS_MASS); 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_ROLLDIST); 
fObstHeight_m = 15.0;
fConvert = ptDim->ConvertDist (fObstHeight_m, DIM_METER, ptDim->RwyLength());
ptDim->GetDimCstring (&szDim, ptDim->RwyLength());
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_OBSTDIST, (short)fConvert, (LPCTSTR)szDim);
(*ptY) += dY;  

							/* print dimensions of table	*/
ptDim->GetDimCstring (&szDim, ptDim->Mass());
TextAlignRight (pDC, m_Xpos1, *ptY, szDim); 
ptDim->GetDimCstring (&szDim, ptDim->RwyLength());
TextAlignRight (pDC, m_Xpos3, *ptY, szDim); 
TextAlignRight (pDC, m_Xpos5, *ptY, szDim); 
(*ptY) += dY;  

	
								// plane parameter dimensions
Plane.GetStartLandDim(&nMassDim, &nLenDim);

								/* Start/Land parameters	*/
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_STARTMAX);

fConvert = ptDim->ConvertMass (Plane.GetStartMass(0), nMassDim, ptDim->Mass());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

					/* roll distance		*/
if (Plane.GetStartRoll(0) != NO_RWY)
    {
    fConvert = ptDim->ConvertDist (Plane.GetStartRoll(0), nLenDim, ptDim->RwyLength());
    RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDS_F_DIST, (short)fConvert);
    }

					/* distance over 15 m obstacle	*/
fConvert = ptDim->ConvertDist (Plane.GetStartObst(0), nLenDim, ptDim->RwyLength());
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDS_F_DIST, (short)fConvert);
(*ptY) += dY;  


bShowMinimal = (Plane.GetStartObst(1) != NO_RWY);
if (bShowMinimal)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_STARTMIN);

	fConvert = ptDim->ConvertMass (Plane.GetStartMass(1), nMassDim, ptDim->Mass());
	RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

	if (Plane.GetStartRoll(1) != NO_RWY)
		{
		fConvert = ptDim->ConvertDist (Plane.GetStartRoll(1), nLenDim, ptDim->RwyLength());
		RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDS_F_DIST, (short)fConvert);
		}

    fConvert = ptDim->ConvertDist (Plane.GetStartObst(1), nLenDim, ptDim->RwyLength());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDS_F_DIST, (short)fConvert);

	(*ptY) += dY;  
	}
}

/************************************************************************
 *  PlaneVw.cpp				D r a w P l L a n d							*
 ************************************************************************/
void CPlaneView::DrawPlLand (CDC* pDC, int* ptY, int dY, CPlane& Plane)
{
double	fConvert;
BOOL	bShowMinimal;
short nMassDim, nLenDim;
	
								// plane parameter dimensions
Plane.GetStartLandDim(&nMassDim, &nLenDim);

								/* Start/Land parameters	*/
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_LANDMAX);

fConvert = ptDim->ConvertMass (Plane.GetLandMass(0), nMassDim, ptDim->Mass());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

					/* roll distance		*/
if (Plane.GetLandRoll(0) != NO_RWY)
    {
    fConvert = ptDim->ConvertDist (Plane.GetLandRoll(0), nLenDim, ptDim->RwyLength());
    RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDS_F_DIST, (short)fConvert);
    }

					/* distance over 15 m obstacle	*/
fConvert = ptDim->ConvertDist (Plane.GetLandObst(0), nLenDim, ptDim->RwyLength());
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDS_F_DIST, (short)fConvert);
(*ptY) += dY;  


bShowMinimal = (Plane.GetLandObst(1) != NO_RWY);
if (bShowMinimal)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_LANDMIN);

	fConvert = ptDim->ConvertMass (Plane.GetLandMass(1), nMassDim, ptDim->Mass());
	RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

	if (Plane.GetLandRoll(1) != NO_RWY)
		{
		fConvert = ptDim->ConvertDist (Plane.GetLandRoll(1), nLenDim, ptDim->RwyLength());
		RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDS_F_DIST, (short)fConvert);
		}

    fConvert = ptDim->ConvertDist (Plane.GetLandObst(1), nLenDim, ptDim->RwyLength());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDS_F_DIST, (short)fConvert);

	(*ptY) += dY;  
	}
}


/************************************************************************
 *  PlaneVw.cpp				D r a w P l A r m s							*
 ************************************************************************/
void CPlaneView::DrawPlArms (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CString	szDim;
CFont* ptOldFont;
double	fConvert;
short	nArmDim = Plane.GetLeverArmDim();

float	fNoArm = Plane.GetUndefArm (nArmDim);


							/* Hebelarme (m)	*/
ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
ptDim->GetDimCstring (&szDim, ptDim->Arm());
pDC->SetBkMode(OPAQUE);
RsrcAlignLeftEx	(pDC, m_Xtext, *ptY, IDS_LEVERARMS, (LPCTSTR)szDim);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

								/* print headline of table	*/
RsrcAlignRight (pDC, m_Xpos1, *ptY, IDS_POSITION1); 
RsrcAlignRight (pDC, m_Xpos2, *ptY, IDS_POSITION2); 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_POSITION3); 
RsrcAlignRight (pDC, m_Xpos4, *ptY, IDS_POSITION4); 
RsrcAlignRight (pDC, m_Xpos5, *ptY, IDS_POSITION5); 
(*ptY) += dY;  

								// seat rows
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_SEATROW);

fConvert = ptDim->ConvertDist (Plane.GetRowArm(0), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_ARM, fConvert);

if(Plane.GetRowArm(1) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetRowArm(1), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos2, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetRowArm(2) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetRowArm(2), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetRowArm(3) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetRowArm(3), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos4, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetRowArm(4) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetRowArm(4), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_ARM, fConvert);
	}
(*ptY) += dY;  

								// lug arms
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_LUGGAGE);

fConvert = ptDim->ConvertDist (Plane.GetLugArm(0), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_ARM, fConvert);

if(Plane.GetLugArm(1) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetLugArm(1), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos2, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetLugArm(2) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetLugArm(2), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetLugArm(3) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetLugArm(3), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos4, *ptY, IDF_ARM, fConvert);
	}
if(Plane.GetLugArm(4) != fNoArm)
	{
	fConvert = ptDim->ConvertDist (Plane.GetLugArm(4), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_ARM, fConvert);
	}

(*ptY) += dY;  
}

/************************************************************************
 *  PlaneVw.cpp				D r a w P l T a n k V o l					*
 ************************************************************************/
void CPlaneView::DrawPlTankVol (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CString	szDim;
CFont* ptOldFont;
double	fConvert;
short nVolDim, nArmDim;
	
								// plane parameter dimensions
Plane.GetTankDim(&nVolDim, &nArmDim);

							/* Treibstofftanks	*/
ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FUELTANKS);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

								/* print headline of table	*/
ptDim->GetDimCstring (&szDim, ptDim->Volume());
RsrcAlignLeftEx	(pDC, m_Xtext, *ptY, IDS_VOL_DIM, (LPCTSTR)szDim);

RsrcAlignRight (pDC, m_Xpos1, *ptY, IDS_TANK1); 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_TANK2); 
RsrcAlignRight (pDC, m_Xpos5, *ptY, IDS_TANK3); 
(*ptY) += dY;  

								// Usable Volumes
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_USABLE); 
								/* capacity of tank 1		*/
fConvert = ptDim->ConvertVolume (Plane.GetUseTankVol(0), nVolDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_TANK, (short)fConvert);

if (Plane.GetUseTankVol(1) != NO_FUEL)
    {							/* capacity of tank 2		*/
	fConvert = ptDim->ConvertVolume (Plane.GetUseTankVol(1), nVolDim, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_TANK, (short)fConvert);
	}

if (Plane.GetUseTankVol(2) != NO_FUEL)
    {							/* capacity of tank 3		*/
	fConvert = ptDim->ConvertVolume (Plane.GetUseTankVol(2), nVolDim, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_TANK, (short)fConvert);
	}
(*ptY) += dY;  


								// Unusable Volumes
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_UNUSABLE); 

fConvert = ptDim->ConvertVolume (Plane.GetUnuseTankVol(0), nVolDim, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_TANK, (short)fConvert);

if (Plane.GetUnuseTankVol(1) != NO_FUEL)
    {				
	fConvert = ptDim->ConvertVolume (Plane.GetUnuseTankVol(1), nVolDim, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_TANK, (short)fConvert);
	}

if (Plane.GetUnuseTankVol(2) != NO_FUEL)
    {				
	fConvert = ptDim->ConvertVolume (Plane.GetUnuseTankVol(2), nVolDim, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_TANK, (short)fConvert);
	}

(*ptY) += dY;  
}

/************************************************************************
 *  PlaneVw.cpp				D r a w P l T a n k A r m s					*
 ************************************************************************/
void CPlaneView::DrawPlTankArms (CDC* pDC, int* ptY, int dY, CPlane& Plane)
{
CString	szDim;
double	fConvert;
short nVolDim, nArmDim;
float	fNoArm;	
								// plane parameter dimensions
Plane.GetTankDim(&nVolDim, &nArmDim);
fNoArm = Plane.GetUndefArm (nArmDim);

					/* lever arms of tanks		*/
ptDim->GetDimCstring (&szDim, ptDim->Arm());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDS_LEVERARM, (LPCTSTR)szDim); 

if (Plane.GetTankArm(0) != fNoArm)
    {					/* lever arm of tank 1		*/
    fConvert = ptDim->ConvertDist (Plane.GetTankArm(0), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_ARM, fConvert);
    }

if (Plane.GetTankArm(1) != fNoArm)
    {					/* lever arm of tank 2		*/
    fConvert = ptDim->ConvertDist (Plane.GetTankArm(1), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_ARM, fConvert);
    }

if (Plane.GetTankArm(2) != fNoArm)
    {					/* lever arm of tank 3		*/
    fConvert = ptDim->ConvertDist (Plane.GetTankArm(2), nArmDim, ptDim->Arm());
	RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_ARM, fConvert);
    }

(*ptY) += dY;  
}

/************************************************************************
 *  PlaneVw.cpp				D r a w P l L i m i t s						*
 ************************************************************************/
void CPlaneView::DrawPlLimits (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane)
{
CString	szDim;
CFont* ptOldFont;
double	fConvert;
short nMassDim, nArmDim;

							/* Limits for Center of Gravity	*/
ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft	(pDC, m_Xtext, *ptY, IDS_LIMCENTGRV);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

								/* print headline of table	*/
RsrcAlignRight (pDC, m_Xpos1, *ptY, IDS_MASS); 
RsrcAlignRight (pDC, m_Xpos3, *ptY, IDS_FRONT); 
RsrcAlignRight (pDC, m_Xpos5, *ptY, IDS_BACK); 
(*ptY) += dY;  

							/* print dimensions of table	*/
ptDim->GetDimCstring (&szDim, ptDim->Mass());
TextAlignRight (pDC, m_Xpos1, *ptY, szDim); 
ptDim->GetDimCstring (&szDim, ptDim->Arm());
TextAlignRight (pDC, m_Xpos3, *ptY, szDim); 
TextAlignRight (pDC, m_Xpos5, *ptY, szDim); 
(*ptY) += dY;  

nMassDim = Plane.GetMassDim();	// plane parameter dimensions
nArmDim  = Plane.GetArmDim();

					/* Maximal Mass and	Limits (Front, Back)	*/
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_MAXIMAL); 

fConvert = ptDim->ConvertMass (Plane.GetMass(0), nMassDim, ptDim->Mass());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

fConvert = ptDim->ConvertDist (Plane.GetFrontArm(0), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_ARM, fConvert);

fConvert = ptDim->ConvertDist (Plane.GetBackArm(0), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_ARM, fConvert);
(*ptY) += dY;  

					/* Minimal Mass and	Limits (Front, Back)	*/
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_MINIMAL); 

fConvert = ptDim->ConvertMass (Plane.GetMass(1), nMassDim, ptDim->Mass());
RsrcAlignRightEx (pDC, m_Xpos1, *ptY, IDF_WEIGHT, fConvert);

fConvert = ptDim->ConvertDist (Plane.GetFrontArm(1), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos3, *ptY, IDF_ARM, fConvert);

fConvert = ptDim->ConvertDist (Plane.GetBackArm(1), nArmDim, ptDim->Arm());
RsrcAlignRightEx (pDC, m_Xpos5, *ptY, IDF_ARM, fConvert);
(*ptY) += dY;  
}

/************************************************************************
 *  PlaneVw.cpp			D r a w P l E m p t y V a l u e s				*
 ************************************************************************/
void CPlaneView::DrawPlEmptyValues (CDC* pDC, int* ptY, int dY, CPlane& Plane)
{
CString	szDim, szArmDim;
double	fConvert;
short nMassDim, nArmDim;


nMassDim = Plane.GetMassDim();	// plane parameter dimensions
nArmDim  = Plane.GetArmDim();

								/* Leermasse, Leermoment	*/
ptDim->GetDimCstring (&szDim, ptDim->Mass());
fConvert = ptDim->ConvertMass (Plane.GetEmptyMass(), nMassDim, ptDim->Mass());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDS_EMPTYMASS, 
								(short)fConvert, (LPCTSTR)szDim);
(*ptY) += dY;  

ptDim->GetDimCstring (&szArmDim, ptDim->Arm());
ptDim->GetDimCstring (&szDim, ptDim->Mass());
fConvert = ptDim->ConvertDist (Plane.GetEmptyTorq(), nArmDim, ptDim->Arm());
fConvert = ptDim->ConvertMass (fConvert, nMassDim, ptDim->Mass());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDS_EMPTYTORQ, 
					(long)fConvert, (LPCTSTR)szArmDim, (LPCTSTR)szDim);
(*ptY) += dY;  
}



/************************************************************************
 *  PlaneVw.cpp				D r a w P l C o s t							*
 ************************************************************************/
void CPlaneView::DrawPlCost (CDC* pDC, int* ptY, int dY, CPlane& Plane)
{
					/* Betriebskosten		*/
short nCost = Plane.GetCost();
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDS_COSTPERHOUR, nCost);
(*ptY) += dY;  
}

/************************************************************************
 *  PlaneVw.cpp    		 	 D r a w P l a n e	 						*
 ************************************************************************/
BOOL CPlaneView::DrawPlane (CDC* pDC, CPlaneDoc* ptPlaneDoc, 
						DWORD* ptIndex,
					    int* ptY, BOOL bDraw)
{
BOOL	bEndOfPage = FALSE;
short	Y_SEP;
CString szText;
CFont* ptOldFont;

ActivateDrawing (bDraw);
pDC->SetBkMode(TRANSPARENT);


BOOL	bOK=FALSE;						// get actual plane
CPlane	ActPlane;
short nIndex;
if (ptPlaneDoc != NULL)
	{
	nIndex = ptPlaneDoc->GetActIndex();
	bOK = ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane);
	}


ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

if (bOK)							// "Flugzeug:%s       Datum:..."
	{
	RsrcAlignLeftEx (pDC, m_Xleft, *ptY, IDF_PLANE, (LPCTSTR)ptPlaneDoc->GetActPlaneName ());

	UINT uDay, uMonth, uYear;
	ptCalc->GetTime (&uDay, &uMonth, &uYear);
	RsrcAlignRightEx (pDC, m_Xright, *ptY, IDF_DATE, uDay, uMonth, uYear);
	(*ptY) += m_LineY;  
	(*ptY) += m_LineY;  

								// title of table
	/********** Geschwindigkeiten/Treibstoffverbrauch *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	this->DrawPlSpeedCons (pDC, ptY, m_LineY, m_BLineY,
									&m_BoldFont, ActPlane);
 

	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;  


	/********** Flugplan *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	this->DrawFlPlanInfo (pDC, ptY, m_LineY, m_BLineY,	&m_BoldFont, ActPlane);

	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;


	/********** Start und Landung *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	this->DrawPlStart (pDC, ptY, m_LineY, m_BLineY,	&m_BoldFont, ActPlane);
	DrawGrayHorzLine (pDC, *ptY+m_LineY/2);
	(*ptY) += m_LineY;
	this->DrawPlLand (pDC, ptY, m_LineY, ActPlane);


	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;


	/********** Hebelarme *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	this->DrawPlArms (pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ActPlane);

	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;


	if (ActPlane.GetTankCnt() > 0)
		{
		/********** Treibstofftanks *******************/
		Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

		this->DrawPlTankVol (pDC, ptY, m_LineY, m_BLineY,	&m_BoldFont, ActPlane);
		DrawGrayHorzLine (pDC, *ptY+m_LineY/2);
		(*ptY) += m_LineY;
		this->DrawPlTankArms (pDC, ptY, m_LineY, ActPlane);

		DrawHorzLine (pDC, *ptY+m_LineY/2);
		DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
		(*ptY) += m_LineY;
		}

	/********** Grenzwerte zur Schwerpunktlage *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	this->DrawPlLimits (pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ActPlane);
	DrawGrayHorzLine (pDC, *ptY+m_LineY/2);
	(*ptY) += m_LineY;
	this->DrawPlEmptyValues (pDC, ptY, m_LineY, ActPlane);

	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;


	/********** Betriebskosten *******************/
	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

	(*ptY) += m_LineY;
	this->DrawPlCost (pDC, ptY, m_LineY, ActPlane);

	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;
	}	// plane OK

if (!m_bDraw && !m_bForPrinter)
	{
	this->SetTotalHeight (*ptY);
	this->SetTotalWidth (m_Xright + m_Xleft);
	}

pDC->SelectObject (ptOldFont);


return bEndOfPage;
}


/************************************************************************
 *  PlaneVw.cpp				D r a w P a g e H e a d e r 				*
 ************************************************************************/
void CPlaneView::DrawPageHeader (CDC* pDC, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
int	Y1, Frame;
CFont*	ptOldFont;

ActivateDrawing (bDraw);

Y1 = *ptY + 2*LineY;			/* Draw single line frame	*/ 
if (bDraw) Rectangle(pDC, m_Xleft, *ptY, m_Xleft + dX, Y1);

Frame = (LineY/4);
if (bDraw)
	{ 
	if (bMMText)Rectangle(pDC, m_Xleft+Frame, *ptY+Frame, m_Xleft + dX-Frame, Y1-Frame);
		else	Rectangle(pDC, m_Xleft-Frame, *ptY+Frame, m_Xleft + dX+Frame, Y1-Frame);
	}

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

Y1 = *ptY+LineY/2;
RsrcAlignCenter (pDC, (m_Xleft + dX + m_Xleft)/2, Y1, IDS_TITLE1);

pDC->SelectObject (ptOldFont);

Y1 += LineY;

*ptY = Y1 + 2*LineY;
}



/************************************************************************
 *  PlaneVw.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CPlaneView::PrintPage (CDC* pDC, int nPageToPrint)
{
CPlaneDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	nPage = 1;

DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		this->DrawPageHeader (pDC, m_LineY, &Y, m_dX, bDraw); 
		m_bMore = DrawPlane (pDC, pDoc, &dwIndex, &Y, bDraw);
		nPage++;
		} while (!bDraw);
	}    
}                                  


/************************************************************************
 *  PlaneVw.cpp    	 			 O n D r a w							*
 ************************************************************************/
void CPlaneView::OnDraw(CDC* pDC)
{
	CPlaneDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            
	int	Y = m_LineY;

	if (pDoc != NULL)
	{
		BOOL	bMore = FALSE;
		DWORD 	dwIndex = 0;

		bMore = DrawPlane (pDC, pDoc, &dwIndex, &Y, m_bDraw);
	}	
}

/************************************************************************
 *  PlaneVw.cpp				P r e p a r e X T a b s						* 
 ************************************************************************/
void CPlaneView::PrepareXTabs (CDC* pDC)
{
CPlaneDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  PlaneVw.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CPlaneView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CPlaneDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    

	this->PrepareXTabs (pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);						// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);

	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}

/************************************************************************
 *  PlaneVw.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CPlaneView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CPlaneDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after printing 
	this->PrepareXTabs(pDC);
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}

/////////////////////////////////////////////////////////////////////////////
// CPlaneView printing

/************************************************************************
 *  PlaneVw.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CPlaneView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

UINT nMinPage = 1;						// Number of the first page of the document
UINT nMaxPage = 1;						// Number of the last page of the document
pInfo->SetMinPage (nMinPage);
pInfo->SetMaxPage (nMaxPage);

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  PlaneVw.cpp   		 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CPlaneView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CPlaneDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  PlaneVw.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CPlaneView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  PlaneVw.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CPlaneView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CPlaneView diagnostics

#ifdef _DEBUG
void CPlaneView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CPlaneView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}
#endif //_DEBUG

CPlaneDoc* CPlaneView::GetDocument() // non-debug version  w a s  inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPlaneDoc)));
//	return (CPlaneDoc*)m_pDocument;
	return ptPlaneDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CPlaneView message handlers




void CPlaneView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
