// PlaneVw.h : interface of the CPlaneView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "..\CPPTOOLS\TxVwTool.h"

class CPlaneView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	int m_Xtext, m_Xpos1, m_Xpos2, m_Xpos3, m_Xpos4, m_Xpos5, m_Xdate;


protected: // create from serialization only
	DECLARE_DYNCREATE(CPlaneView)

// Attributes
public:
	CPlaneDoc* GetDocument();

// Operations
public:

// Implementation
public:
	CPlaneView();
	virtual ~CPlaneView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CPlaneDoc* ptPlaneDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void DrawPlSpeedCons (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawFlPlanInfo (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawPlStart (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawPlLand (CDC* pDC, int* ptY, int dY, CPlane& Plane);
	void DrawPlArms (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawPlTankVol (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawPlTankArms (CDC* pDC, int* ptY, int dY, CPlane& Plane);
	void DrawPlLimits (CDC* pDC, int* ptY, int dY, int dYbold,
								CFont* ptBoldFont, CPlane& Plane);
	void DrawPlEmptyValues (CDC* pDC, int* ptY, int dY, CPlane& Plane);
	void DrawPlCost (CDC* pDC, int* ptY, int dY, CPlane& Plane);

	BOOL DrawPlane (CDC* pDC, CPlaneDoc* ptPlaneDoc, DWORD* ptIndex,
					int* ptY, BOOL bDraw = TRUE);
	void DrawPageHeader (CDC* pDC, int LineY, int* ptY, int dX, BOOL bDraw);
 	void PrintPage (CDC* pDC, int nPageToPrint);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CPlaneView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//#ifndef _DEBUG  // debug version in wayview.cpp
//inline CPlaneDoc* CPlaneView::GetDocument()
//   { return (CPlaneDoc*)m_pDocument; }
//#endif

/////////////////////////////////////////////////////////////////////////////
