// PlaneDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "resource.h"  

#include "InitDoc.h"
#include "DimDoc.h"    
 
#include "PlPlnDlg.h"
#include "StLaDlg.h"    
#include "ArmsDlg.h"
#include "TankDlg.h"

#include "PlaneDoc.h"
#include "PlaneDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// CPlaneDlg dialog


CPlaneDlg::CPlaneDlg(CWnd* pParent, CPlaneDoc* ptDoc)
	: CDlgTool(CPlaneDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPlaneDlg)
	m_nListIndex = -1;
	m_nSpeedDim = -1;
	m_nVolDim = -1;
	m_nCost = 0;
	m_lEmptyMass=0;
	m_lMass0 = 0;
	m_lMass1 = 0;
	m_nClimbDim = -1;
	m_nArmDim = -1;
	m_szTorqDim = _T("");
	m_nMassDim = -1;
	m_szMassDim = _T("");
	m_nCruiseSpd = 0;
	m_nClimbSpd = 0;
	m_fClimbRate = 0;
	m_lCruiseCons = 0;
	m_lClimbCons = 0;
	m_fBackArm0=0;
	m_fBackArm1=0;
	m_fFrntArm0=0;
	m_fFrntArm1=0;
	m_fEmptyTorq=0;
	m_nDescSpd = 0;
	m_lDescCons = 0;
	m_fDescRate = 0;
	m_szName = _T("");
	//}}AFX_DATA_INIT
	
m_ptDoc = ptDoc;
m_bChanged = FALSE;           
m_bInsert = FALSE;

this->ReadDataBaseFromDoc ();
}

CPlaneDlg::~CPlaneDlg()
{
this->DeleteDataBase();
}

/************************************************************************
 *  PlaneDlg.cpp	  		D e l e t e D a t a B a s e					*
 ************************************************************************/
void CPlaneDlg::DeleteDataBase()
{  
m_ptDoc->DeleteArrayOf (&m_ActList);
}

/************************************************************************
 *  PlaneDlg.cpp	  	R e a d D a t a B a s e	F r o m D o c			*
 ************************************************************************/
void CPlaneDlg::ReadDataBaseFromDoc()
{                   					// copy database from Doc to Dlg
m_ptDoc->GetDataBase (&m_ActList);
m_bChanged = FALSE;
m_ptDoc->SetModifiedFlag(FALSE);
}

/************************************************************************
 *  PlaneDlg.cpp	  	W r i t e D a t a B a s e I n t o D o c 		*
 ************************************************************************/
BOOL CPlaneDlg::WriteDataBaseIntoDoc()
{ 				
BOOL	bWritten = FALSE;				  
if (m_bChanged || m_ptDoc->WasConverted())
	{                                   // copy database from Dlg to Doc
	m_ptDoc->SetDataBase (&m_ActList);  
	m_ptDoc->SetModifiedFlag(TRUE);  
	bWritten = TRUE;
	}               
return bWritten;
}



/************************************************************************
 *  PlaneDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CPlaneDlg::SetData (CPlane& Plane)
{  
m_nSpeedDim = ptDim->GetPUIndex (CRUISESPEED,Plane.GetSpeedDim());
m_nVolDim = ptDim->GetPUIndex (VOLUME, Plane.GetVolDim());
m_nClimbDim = ptDim->GetPUIndex (CLIMBRATE, Plane.GetClimbDim());
m_nArmDim = ptDim->GetPUIndex (ARM, Plane.GetArmDim()); 
m_nMassDim = ptDim->GetPUIndex (MASS, Plane.GetMassDim());

ptDim->GetDimCstring (&m_szMassDim, ptDim->GetPUDim (MASS, m_nMassDim));
ptDim->GetDimCstring (&m_szTorqDim, ptDim->GetPUDim (ARM, m_nArmDim));
m_szTorqDim += m_szMassDim;

m_szName 		= Plane.GetName();
m_nClimbSpd		= (short)Plane.GetClimbSpeed();
m_nCruiseSpd	= (short)Plane.GetCruiseSpeed();
m_nDescSpd		= (short)Plane.GetDescSpeed();

m_lClimbCons	= (short)Plane.GetClimbCons();
m_lCruiseCons	= (short)Plane.GetCruiseCons();
m_lDescCons		= (short)Plane.GetDescCons();

m_fClimbRate	= Plane.GetClimbRate();
m_fDescRate		= Plane.GetDescRate();


m_nCost			= Plane.GetCost();

m_lMass0		= (long)Plane.GetMass(0);
m_lMass1		= (long)Plane.GetMass(1);
m_fFrntArm0		= Plane.GetFrontArm(0);
m_fFrntArm1		= Plane.GetFrontArm(1);
m_fBackArm0		= Plane.GetBackArm(0);
m_fBackArm1 	= Plane.GetBackArm(1);

m_lEmptyMass	= (long)Plane.GetEmptyMass ();
m_fEmptyTorq	= Plane.GetEmptyTorq ();
}	

/************************************************************************
 *  PlaneDlg.cpp	  		 	G e t D a t a  							*
 ************************************************************************/
BOOL CPlaneDlg::GetData (CPlane* ptPlane)
{ 
	BOOL bOK = TRUE;

ptPlane->SetSpeedDim(ptDim->GetPUDim (CRUISESPEED, m_nSpeedDim));
ptPlane->SetVolDim(ptDim->GetPUDim (VOLUME, m_nVolDim));
ptPlane->SetClimbDim(ptDim->GetPUDim (CLIMBRATE, m_nClimbDim));
ptPlane->SetArmDim(ptDim->GetPUDim (ARM, m_nArmDim));
ptPlane->SetMassDim(ptDim->GetPUDim (MASS, m_nMassDim));
	           
ptPlane->SetName(m_szName);

ptPlane->SetClimbSpeed(m_nClimbSpd);
ptPlane->SetCruiseSpeed(m_nCruiseSpd);
ptPlane->SetDescSpeed(m_nDescSpd);

ptPlane->SetClimbCons((float)m_lClimbCons);
ptPlane->SetCruiseCons((float)m_lCruiseCons);
ptPlane->SetDescCons((float)m_lDescCons);

ptPlane->SetClimbRate(m_fClimbRate);
ptPlane->SetDescRate(m_fDescRate);


ptPlane->SetCost(m_nCost);					// costs

ptPlane->SetMassCnt (2);					// masses, center of gravity limits
if (m_lMass0 < m_lMass1)
{
	AfxMessageBox (IDS_WARN_MASS_ORDER);
	bOK = FALSE;
}

ptPlane->SetMass(0, (float)m_lMass0);
ptPlane->SetMass(1, (float)m_lMass1);


if (m_fFrntArm0 > m_fBackArm0)
{
	CString szMsg;
	szMsg.Format (IDF_WARN_ARM_ORDER, m_fFrntArm0, m_fBackArm0);
	AfxMessageBox (szMsg);
	bOK = FALSE;
}

if (m_fFrntArm1 > m_fBackArm1)
{
	CString szMsg;
	szMsg.Format (IDF_WARN_ARM_ORDER, m_fFrntArm1, m_fBackArm1);
	AfxMessageBox (szMsg);
	bOK = FALSE;
}

ptPlane->SetFrontArm(0, m_fFrntArm0);
ptPlane->SetFrontArm(1, m_fFrntArm1);
ptPlane->SetBackArm(0, m_fBackArm0);
ptPlane->SetBackArm(1, m_fBackArm1);

if (m_lEmptyMass > m_lMass1)
{
	CString szMsg;
	szMsg.Format (IDF_WARN_EMPTY_WEIGHT, m_lEmptyMass, m_lMass1);
	AfxMessageBox (szMsg);
	bOK = FALSE;
}

ptPlane->SetEmptyMass ((float)m_lEmptyMass);
ptPlane->SetEmptyTorq (m_fEmptyTorq);

return bOK;
}	

/************************************************************************
 *  PlaneDlg.cpp	  		 F i l l P l a n e L i s t 					*
 ************************************************************************/
void CPlaneDlg::FillPlaneList (CPtrArray* ptPlanes)
{
CListBox* ptList = (CListBox*)GetDlgItem (IDC_PLLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<ptPlanes->GetSize(); i++)
	{      
	CPlane Plane((LPPLANE)ptPlanes->GetAt(i));
	szText = Plane.GetName();
	ptList->AddString((LPCTSTR)szText);  
	}              
}                             

/************************************************************************
 *  PlaneDlg.cpp	  		 	O n N e w L i s t		 				*
 ************************************************************************/
short CPlaneDlg::OnNewList (CPtrArray* ptPlanes)
{
this->FillPlaneList(ptPlanes);   

BOOL bData = (ptPlanes->GetSize() > 0);
short nListIndex = bData? m_ptDoc->GetActIndex () : -1;     

if (nListIndex >=0)
	m_ActPlane.SetPtr((LPPLANE)m_ActList.GetAt(nListIndex));

this->DisableControl (IDC_PLCHANGE, !bData);  
this->DisableControl (IDC_PLDEL, !bData);  
return nListIndex;
}

/************************************************************************
 *  PlaneDlg.cpp	  		 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CPlaneDlg::DoDataExchange(CDataExchange* pDX)
{   
this->ActivateDimGroups();

if (pDX->m_bSaveAndValidate)
		{  
		m_nOldIndex 	= m_nListIndex;	  
		}
    else{   
	 	LPPLANE lpLoadPlane = NULL;
		if (m_nListIndex >= 0 && m_nListIndex<m_ActList.GetSize())	
			lpLoadPlane = (LPPLANE)m_ActList.GetAt(m_nListIndex);   
	
		if (lpLoadPlane != NULL)
			{
			CPlane Plane(lpLoadPlane); 
			this->SetData (Plane);    
	        }
    	}
    	
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPlaneDlg)
	DDX_LBIndex(pDX, IDC_PLLIST, m_nListIndex);
	DDX_CBIndex(pDX, IDC_PLSPDDIM, m_nSpeedDim);
	DDX_CBIndex(pDX, IDC_PLCONSDIM, m_nVolDim);
	DDX_Text(pDX, IDC_PLCOST, m_nCost);
	DDV_MinMaxInt(pDX, m_nCost, 0, 30000);
	DDX_Mass(pDX, IDC_PLEMPTYMASS, m_lEmptyMass);
	DDV_Mass(pDX, m_lEmptyMass, 100, 15000);
	DDX_Mass(pDX, IDC_PLMASS0, m_lMass0);
	DDV_Mass(pDX, m_lMass0, 100, 15000);
	DDX_Mass(pDX, IDC_PLMASS1, m_lMass1);
	DDV_Mass(pDX, m_lMass1, 100, 15000);
	DDX_CBIndex(pDX, IDC_PLCLIMBDIM, m_nClimbDim);
	DDX_CBIndexArmDim(pDX, IDC_PLARMDIM, m_nArmDim);
	DDX_Text(pDX, IDC_PLTORQDIM, m_szTorqDim);
	DDX_CBIndex(pDX, IDC_PLMASSDIM, m_nMassDim);
	DDX_Text(pDX, IDC_PLMASS2DIM, m_szMassDim);
	DDX_CruiseSpeed(pDX, IDC_PLCRUISESPD, m_nCruiseSpd);
	DDV_CruiseSpeed(pDX, m_nCruiseSpd, 5, 1000);
	DDX_CruiseSpeed(pDX, IDC_PLCLIMBSPD, m_nClimbSpd);
	DDV_CruiseSpeed(pDX, m_nClimbSpd, 5, 1000);
	DDX_ClimbRate(pDX, IDC_PLCLIMBRATE, m_fClimbRate);
	DDV_ClimbRate(pDX, m_fClimbRate, -10000.f, 10000.f);
	DDX_Volume(pDX, IDC_PLCRUISECONS, m_lCruiseCons);
	DDV_Volume(pDX, m_lCruiseCons, 0, 2000);
	DDX_Volume(pDX, IDC_PLCLIMBCONS, m_lClimbCons);
	DDV_Volume(pDX, m_lClimbCons, 0, 2000);
	DDX_Arm(pDX, IDC_PLBACKARM0, m_fBackArm0);
	DDV_Arm(pDX, m_fBackArm0, -5.f, 10.f);
	DDX_Arm(pDX, IDC_PLBACKARM1, m_fBackArm1);
	DDV_Arm(pDX, m_fBackArm1, -5.f, 10.f);
	DDX_Arm(pDX, IDC_PLFRNTARM0, m_fFrntArm0);
	DDV_Arm(pDX, m_fFrntArm0, -5.f, 10.f);
	DDX_Arm(pDX, IDC_PLFRNTARM1, m_fFrntArm1);
	DDV_Arm(pDX, m_fFrntArm1, -5.f, 10.f);
	DDX_Torq(pDX, IDC_PLEMPTYTORQ, m_fEmptyTorq);
	DDV_Torq(pDX, m_fEmptyTorq, 100.f, 15000.f);
	DDX_CruiseSpeed(pDX, IDC_PLDESCSPD, m_nDescSpd);
	DDV_CruiseSpeed(pDX, m_nDescSpd, 5, 1000);
	DDX_Volume(pDX, IDC_PLDESCCONS, m_lDescCons);
	DDV_Volume(pDX, m_lDescCons, 0, 2000);
	DDX_ClimbRate(pDX, IDC_PLDESCRATE, m_fDescRate);
	DDV_ClimbRate(pDX, m_fDescRate, -10000.f, 10000.f);
	DDX_Text(pDX, IDC_PLNAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 11);
	//}}AFX_DATA_MAP
	
if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{  
		this->GetData (&m_ActPlane);  
		if (!this->InsertAfter (&m_ActPlane))
			pDX->Fail();		// DDV_MaxChars(pDX, m_szName, 12); must be last DDX_...
		}
	else{
		if (m_nOldIndex>=0 && m_nOldIndex<m_ActList.GetSize())
			{
			LPPLANE lpOldPlane = (LPPLANE)m_ActList.GetAt(m_nOldIndex);   

			if (!this->GetData (&m_ActPlane))
				pDX->Fail();

			if (!m_ActPlane.IsEqual(lpOldPlane))
				{  									// data has been changed !!
						// check if new name already used at other position in this array
				short nTestIndex = this->PlaneNameToIndex (m_ActPlane.GetName());
				if ((nTestIndex > -1) && (nTestIndex != m_nOldIndex))
					{
					AfxMessageBox (IDS_SAME_NAME);
					pDX->Fail();
					}
				else{
					this->InsertAfter (&m_ActPlane);  	// save new data     
					delete lpOldPlane;                  // free old data
					}
				}
          	} 
     // else list was empty
		}
    }
}


BEGIN_MESSAGE_MAP(CPlaneDlg, CDlgTool)
	//{{AFX_MSG_MAP(CPlaneDlg)
	ON_LBN_SELCHANGE(IDC_PLLIST, OnSelchangeList)
	ON_BN_CLICKED(IDC_PLINS, OnInsert)
	ON_BN_CLICKED(IDC_PLDEL, OnDelete)
	ON_BN_CLICKED(IDC_PLCHANGE, OnChange)
	ON_CBN_SELCHANGE(IDC_PLARMDIM, OnSelChangeArmDim)
	ON_CBN_SELCHANGE(IDC_PLMASSDIM, OnSelChangeMassDim)
	ON_BN_CLICKED(IDC_PLSTARTLAND, OnStartLand)
	ON_BN_CLICKED(IDC_PLROWLUG, OnRowLugArms)
	ON_BN_CLICKED(IDC_PLTANK, OnTanks)
	ON_BN_CLICKED(IDC_PLFLIGHTPLAN, OnFlightPlan)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  PlaneDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CPlaneDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CPlaneDlg message handlers

/************************************************************************
 *  PlaneDlg.cpp	  		 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CPlaneDlg::OnInitDialog()
{                 // value DlgID,	dim DlgID
this->AddDimGroup (IDC_PLCRUISESPD, IDC_PLSPDDIM);
this->AddDimGroup (IDC_PLCLIMBSPD, IDC_PLSPDDIM);
this->AddDimGroup (IDC_PLDESCSPD, IDC_PLSPDDIM);

this->AddDimGroup (IDC_PLCRUISECONS, IDC_PLCONSDIM);
this->AddDimGroup (IDC_PLCLIMBCONS, IDC_PLCONSDIM);
this->AddDimGroup (IDC_PLDESCCONS, IDC_PLCONSDIM);

this->AddDimGroup (IDC_PLCLIMBRATE, IDC_PLCLIMBDIM);
this->AddDimGroup (IDC_PLDESCRATE, IDC_PLCLIMBDIM);

this->AddDimGroup (IDC_PLMASS0, IDC_PLMASSDIM);
this->AddDimGroup (IDC_PLMASS1, IDC_PLMASSDIM);
this->AddDimGroup (IDC_PLEMPTYMASS, IDC_PLMASSDIM);

this->AddDimGroup (IDC_PLEMPTYTORQ, IDC_PLARMDIM);
this->AddDimGroup (IDC_PLEMPTYTORQ, IDC_PLMASSDIM);

this->AddDimGroup (IDC_PLFRNTARM0, IDC_PLARMDIM);
this->AddDimGroup (IDC_PLBACKARM0, IDC_PLARMDIM);
this->AddDimGroup (IDC_PLFRNTARM1, IDC_PLARMDIM);
this->AddDimGroup (IDC_PLBACKARM1, IDC_PLARMDIM);

      
this->FillDimPU (IDC_PLSPDDIM, CRUISESPEED);
this->FillDimPU (IDC_PLCONSDIM, VOLUME);
this->FillDimPU (IDC_PLCLIMBDIM, CLIMBRATE);
this->FillDimPU (IDC_PLARMDIM, ARM);
this->FillDimPU (IDC_PLMASSDIM, MASS);
							
m_nListIndex = this->OnNewList (&m_ActList);

// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  PlaneDlg.cpp	  		 G e t S o r t e d I n d e x 				*
 ************************************************************************/
short CPlaneDlg::GetSortedIndex (CPlane* ptPlane)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

        								// get new name to insert 
CString	szNewName = ptPlane->GetName();

IndMin  = 0;
IndMax  = m_ActList.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (m_ActList.GetSize() > 0)
   {
   do	{  
        LPPLANE lpTestPlane = (LPPLANE)m_ActList.GetAt((int)i);
        CPlane	TestPlane (lpTestPlane);
        CString szTestName = TestPlane.GetName();
        
        int iCmp = szNewName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  PlaneDlg.cpp	  		P l a n e N a m e T o I n d e x 			*
 ************************************************************************/
short CPlaneDlg::PlaneNameToIndex (CString szName)
{
short nIndex = -1;
short i;

for (i=0; i<m_ActList.GetSize() && (nIndex == -1); i++)
	{							// search used name...
    CPlane	TestPlane ((LPPLANE)m_ActList.GetAt((int)i));
    CString szTestName = TestPlane.GetName();
    
    if (szName.Compare ((LPCTSTR)szTestName) == 0)
		nIndex = i;
	}

return nIndex;
}

/************************************************************************
 *  PlaneDlg.cpp	  		 I n s e r t A f t e r						*
 ************************************************************************/
BOOL CPlaneDlg::InsertAfter(CPlane* ptPlane)	
{					
short nNewIndex;
if (m_bInsert)
	{
	short i;
//	nNewIndex = this->GetSortedIndex (ptPlane); 

	CString	szNewName = ptPlane->GetName();

	for (i=0; i<m_ActList.GetSize(); i++)
		{							// search used name...
        CPlane	TestPlane ((LPPLANE)m_ActList.GetAt((int)i));
        CString szTestName = TestPlane.GetName();
        
        if (szNewName.Compare ((LPCTSTR)szTestName) == 0)
			{
			AfxMessageBox (IDS_SAME_NAME);
			return FALSE;
			}
		}

	nNewIndex = m_nListIndex+1; 
	m_ActList.InsertAt (nNewIndex, ptPlane->CreatePtr());	// insert new  
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ActList.RemoveAt (m_nOldIndex); 	// delete old database entry 
	m_ActList.InsertAt (m_nOldIndex, ptPlane->CreatePtr());	// insert new
	}
		
m_bChanged = TRUE;           
if (ptInit->IsSaveSignal())
	MessageBeep(MB_OK);	
	
	              			// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (IDC_PLLIST);    
CString szNewName = ptPlane->GetName();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);    
	m_nListIndex = nNewIndex;
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.CompareNoCase((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(m_nOldIndex, (LPCTSTR)szNewName);  
		}   
	}
return TRUE;
}

/************************************************************************
 *  PlaneDlg.cpp	  		 O n S e l c h a n g e L i s t				*
 ************************************************************************/
void CPlaneDlg::OnSelchangeList()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_PLLIST);    
short nNewIndex = ptList->GetCurSel ();

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{      
		this->UpdateData(FALSE);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetCurSel (m_nListIndex);		  
		}

	m_ActPlane.SetPtr((LPPLANE)m_ActList.GetAt(m_nListIndex));
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	}
}



/************************************************************************
 *  PlaneDlg.cpp	  			 O n I n s e r t 						*
 ************************************************************************/
void CPlaneDlg::OnInsert()
{
	// TODO: Add your control notification handler code here  
m_bInsert = TRUE;
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	if (m_ActList.GetSize() == 1)
		{
		this->DisableControl (IDC_PLCHANGE, FALSE);  
		this->DisableControl (IDC_PLDEL, FALSE);  
		}
	this->SelectItem (IDC_PLNAME);
	}
m_bInsert = FALSE;	
}

/************************************************************************
 *  PlaneDlg.cpp	  			 O n C h a n g e		 				*
 ************************************************************************/
void CPlaneDlg::OnChange()
{
	// TODO: Add your control notification handler code here
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	}
}
	
/************************************************************************
 *  PlaneDlg.cpp	  			 O n D e l e t e						*
 ************************************************************************/
void CPlaneDlg::OnDelete()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_PLLIST);    
short nDeleteIndex = ptList->GetCurSel (); 
LPPLANE lpPlane = (LPPLANE)m_ActList.GetAt(nDeleteIndex); 
delete lpPlane;
m_ActList.RemoveAt (nDeleteIndex); 
m_bChanged = TRUE;           

ptList->DeleteString (nDeleteIndex);

if (m_ActList.GetSize() > 0)
	{ 
	m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 
	m_ActPlane.SetPtr((LPPLANE)m_ActList.GetAt(m_nListIndex));
	this->UpdateData(FALSE);
	}
else{
	this->DisableControl (IDC_PLCHANGE, TRUE);
	this->DisableControl (IDC_PLDEL, TRUE);
	m_nListIndex = -1;  
	}	
}


/************************************************************************
 *  PlaneDlg.cpp	  			OnSelChangeArmDim						*
 ************************************************************************/
void CPlaneDlg::OnSelChangeArmDim() 
{
	// TODO: Add your control notification handler code here
CComboBox* ptList = (CComboBox*)GetDlgItem (IDC_PLARMDIM);    
m_nArmDim = ptList->GetCurSel ();

ptDim->GetDimCstring (&m_szMassDim, ptDim->GetPUDim (MASS, m_nMassDim));
ptDim->GetDimCstring (&m_szTorqDim, ptDim->GetPUDim (ARM, m_nArmDim));
m_szTorqDim += m_szMassDim;

SetText(IDC_PLTORQDIM, m_szTorqDim);	
}

/************************************************************************
 *  PlaneDlg.cpp	  			OnSelChangeMassDim						*
 ************************************************************************/
void CPlaneDlg::OnSelChangeMassDim() 
{
	// TODO: Add your control notification handler code here
CComboBox* ptList = (CComboBox*)GetDlgItem (IDC_PLMASSDIM);    
m_nMassDim = ptList->GetCurSel ();

ptDim->GetDimCstring (&m_szMassDim, ptDim->GetPUDim (MASS, m_nMassDim));
ptDim->GetDimCstring (&m_szTorqDim, ptDim->GetPUDim (ARM, m_nArmDim));
m_szTorqDim += m_szMassDim;

SetText(IDC_PLMASS2DIM, m_szMassDim);
SetText(IDC_PLTORQDIM, m_szTorqDim);	
}

/************************************************************************
 *  PlaneDlg.cpp			C h a n g e P l a n e						*
 ************************************************************************/
BOOL CPlaneDlg::ChangePlane (short nIndex, CPlane Plane)   // unused
{
BOOL bChanged = FALSE;

LPPLANE lpPlane = (LPPLANE)m_ActList.GetAt(nIndex);
if (lpPlane != NULL)
	{  
	delete lpPlane;						// delete old plane ptr
	}

lpPlane = Plane.CreatePtr();
if (lpPlane != NULL)
	{  
	m_ActList.SetAt (nIndex, lpPlane);    // set new plane ptr 
	bChanged = TRUE;      
	}

return bChanged;
}

/************************************************************************
 *  PlaneDlg.cpp	  			O n F l i g h t P l a n					*
 ************************************************************************/
void CPlaneDlg::OnFlightPlan() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
CPlaneFlPlDlg FlightPlanDlg(this, &m_ActPlane);

int RetVal = FlightPlanDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		FlightPlanDlg.GetData (&m_ActPlane);
		break;
	case IDCANCEL:
		break;
	}
}


/************************************************************************
 *  PlaneDlg.cpp	  			O n S t a r t L a n d 					*
 ************************************************************************/
void CPlaneDlg::OnStartLand() 
{
	// TODO: Add your control notification handler code here
CStartLandDlg StartLand(this, &m_ActPlane);

int RetVal = StartLand.DoModal();
switch (RetVal)
	{
	case IDOK:   
		StartLand.GetData (&m_ActPlane);
		break;
	case IDCANCEL:
		break;
	}
}

/************************************************************************
 *  PlaneDlg.cpp	  			O n R o w L u g A r m s					*
 ************************************************************************/
void CPlaneDlg::OnRowLugArms() 
{
	// TODO: Add your control notification handler code here
CArmsDlg Arms(this, &m_ActPlane);

int RetVal = Arms.DoModal();
switch (RetVal)
	{
	case IDOK:   
		Arms.GetData (&m_ActPlane);
		break;
	case IDCANCEL:
		break;
	}
}

/************************************************************************
 *  PlaneDlg.cpp	  			O n T a n k s							*
 ************************************************************************/
void CPlaneDlg::OnTanks() 
{
// TODO: Add your control notification handler code here
CTankDlg Tanks(this, &m_ActPlane);

int RetVal = Tanks.DoModal();
switch (RetVal)
	{
	case IDOK:   
		Tanks.GetData (&m_ActPlane);
		break;
	case IDCANCEL:
		break;
	}
}
