// PlaneDlg.h : header file
//
#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CPlaneDlg dialog     
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CPlaneDoc;
class CPlaneDlg : public CDlgTool
{
// Construction
public:   
	
	CPlaneDlg(CWnd* pParent = NULL, CPlaneDoc* ptDoc=NULL);	// standard constructor
	~CPlaneDlg();   
	void ReadDataBaseFromDoc();
	BOOL WriteDataBaseIntoDoc();

// Dialog Data
	//{{AFX_DATA(CPlaneDlg)
	enum { IDD = IDD_PLANEBOX };
	int		m_nListIndex;
	int		m_nSpeedDim;
	int		m_nVolDim;
	int		m_nCost;
	long	m_lEmptyMass;
	long	m_lMass0;
	long	m_lMass1;
	int		m_nClimbDim;
	int		m_nArmDim;
	CString	m_szTorqDim;
	int		m_nMassDim;
	CString	m_szMassDim;
	short	m_nCruiseSpd;
	short	m_nClimbSpd;
	float	m_fClimbRate;
	long	m_lCruiseCons;
	long	m_lClimbCons;
	float	m_fBackArm0;
	float	m_fBackArm1;
	float	m_fFrntArm0;
	float	m_fFrntArm1;
	float	m_fEmptyTorq;
	short	m_nDescSpd;
	long	m_lDescCons;
	float	m_fDescRate;
	CString	m_szName;
	//}}AFX_DATA

BOOL		m_bInsert;
CPlaneDoc* 	m_ptDoc;
CPtrArray	m_ActList;		// actual plane array
CPlane		m_ActPlane;
short		m_nOldIndex;
BOOL		m_bChanged;           
 
// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support  
	void DeleteDataBase();
	void SetData (CPlane& Plane);
	BOOL GetData (CPlane* ptPlane);
	void FillPlaneList (CPtrArray* ptPlanes);   
	short OnNewList (CPtrArray* ptPlanes);
	short PlaneNameToIndex (CString szName);
	BOOL InsertAfter(CPlane* ptPlane);	
	short GetSortedIndex (CPlane* ptPlane);
	BOOL ChangePlane (short nIndex, CPlane Plane);

	// Generated message map functions
	//{{AFX_MSG(CPlaneDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeList();
	afx_msg void OnInsert();
	afx_msg void OnDelete();
	afx_msg void OnChange();
	afx_msg void OnSelChangeArmDim();
	afx_msg void OnSelChangeMassDim();
	afx_msg void OnStartLand();
	afx_msg void OnRowLugArms();
	afx_msg void OnTanks();
	afx_msg void OnFlightPlan();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
