// PlaneDoc.cpp : implementation of the CPlaneDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"

#include "PlaneDoc.h"  
#include "PlaneDlg.h"				

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              
extern CDimDoc*		ptDim;
extern BOOL			bDemo;

 
/////////////////////////////////////////////////////////////////////////////
// CPlaneDoc

IMPLEMENT_DYNCREATE(CPlaneDoc, CDocument)

BEGIN_MESSAGE_MAP(CPlaneDoc, CDocument)
	//{{AFX_MSG_MAP(CPlaneDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlaneDoc construction/destruction

CPlaneDoc::CPlaneDoc()
{
	// TODO: add one-time construction code here  
m_bConverted = FALSE;     
m_nSelected = -1; 
}

CPlaneDoc::~CPlaneDoc()
{   
if (this->IsModified())  
	{
	CString szPath = this->GetPathName(); 
	this->OnSaveDocument (szPath);
	}

this->DeleteArrayOf (&m_Planes);
}
   

/************************************************************************
 *  PlaneDoc.cpp			A c t i v a t e P l a n e  					*
 ************************************************************************/
void CPlaneDoc::ActivatePlane (CWnd* ptWnd, short nID)
{     
				  // called from view, so we need the parent wnd (mainframe)
CMenu*	ptSubMenu = this->GetSubMenu (ptWnd->GetParent(), m_nColumn);

if (m_nSelected >= 0 && ptSubMenu != NULL)  // remove check mark from old plane  
    ptSubMenu->CheckMenuItem ((UINT)(ID_PLANE_FIRST + m_nSelected), MF_UNCHECKED | MF_BYCOMMAND);
    
m_nSelected = nID;

if (m_nSelected >= 0 && ptSubMenu != NULL)	// set check mark at new plane
    ptSubMenu->CheckMenuItem ((UINT)(ID_PLANE_FIRST + m_nSelected), MF_CHECKED | MF_BYCOMMAND);

CPlane Plane ((LPPLANE)m_Planes.GetAt(m_nSelected));
ptInit->SetPlaneName (Plane.GetName());
}



/************************************************************************
 *  PlaneDoc.cpp			D e l e t e A r r a y O f 					*
 ************************************************************************/
void CPlaneDoc::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	LPPLANE ptEntry;
	if ((ptEntry = (LPPLANE)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting PlaneDoc LPPLANE %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 
/************************************************************************
 *  PlaneDoc.cpp				C o p y P l a n e s						*
 ************************************************************************/
void CPlaneDoc::CopyPlanes (CPtrArray* ptDest, CPtrArray* ptSource)
{
short i;
for (i=0; i<ptSource->GetSize(); i++) 
	{
	LPPLANE	lpDocPlane = NULL;         

	lpDocPlane = (LPPLANE)ptSource->GetAt (i);    
	if (lpDocPlane != NULL)
		{
		LPPLANE lpCpyPlane = new PLANETYPE;	 
		
		TRACE ("CPlaneDoc::CopyPlanes Create LPPLANE %d\n", i);

		_fmemcpy (lpCpyPlane, lpDocPlane, sizeof(PLANETYPE)); 
		ptDest->Add (lpCpyPlane);    
		}
	}
}        

/************************************************************************
 *  PlaneDoc.cpp			G e t D a t a B a s e 						*
 ************************************************************************/
void CPlaneDoc::GetDataBase (CPtrArray* ptPlaneList)
{    
                              	// copy database from Doc to Dlg
this->DeleteArrayOf (ptPlaneList);
this->CopyPlanes (ptPlaneList, &m_Planes);   
}   

/************************************************************************
 *  PlaneDoc.cpp			S e t D a t a B a s e 						*
 ************************************************************************/
void CPlaneDoc::SetDataBase (CPtrArray* ptPlaneList)
{     
                          		 // copy database from Dlg to Doc
this->DeleteArrayOf (&m_Planes);
this->CopyPlanes (&m_Planes, ptPlaneList);   
}


/************************************************************************
 *  PlaneDoc.cpp			G e t P l a n e P t r						*
 ************************************************************************/
LPPLANE CPlaneDoc::GetPlanePtr (short nIndex)
{
LPPLANE lpPlane = NULL;

if (nIndex>=0 && nIndex<m_Planes.GetSize())
	{
	lpPlane = (LPPLANE)m_Planes.GetAt (nIndex);  
	} 
return lpPlane;      
}
 
/************************************************************************
 *  PlaneDoc.cpp			G e t P l a n e P t r						*
 ************************************************************************/
BOOL CPlaneDoc::GetPlanePtr (short nIndex, CPlane* ptPlane)
{
BOOL bOK = FALSE;

if (nIndex >= 0 && nIndex < m_Planes.GetSize())
	{
	LPPLANE lpPlane = (LPPLANE)m_Planes.GetAt(nIndex);
	ptPlane->SetPtr (lpPlane);
	bOK = TRUE;
	}

return bOK;
}
                        
/************************************************************************
 *  PlaneDoc.cpp			G e t A c t P l a n e N a m e  				*
 ************************************************************************/
CString CPlaneDoc::GetActPlaneName ()
{     
CString szName;

if (m_nSelected >= 0)
	{
	CPlane Plane ((LPPLANE)m_Planes.GetAt(m_nSelected));
	szName = Plane.GetName();
	}
else{
	szName.LoadString(IDS_MISSING);
	}

return szName;
}

/************************************************************************
 *  PlaneDoc.cpp			G e t S p e e d S t r i n g					*
 *  Purpose: returns string like "89 kt"								*
 ************************************************************************/
CString CPlaneDoc::GetSpeedString (short nIndex, short nDestSpeedDim)
{
	CString szSpeed, szDim;
	short nSpeed = 0;

	CPlane	ActPlane;
	if (this->GetPlanePtr(nIndex, &ActPlane))
	{
		float fSpeed = ActPlane.GetCruiseSpeed();

		double fConvert;
		fConvert = ptDim->ConvertSpeed (fSpeed, ActPlane.GetSpeedDim(), nDestSpeedDim);
		nSpeed = (short)(fConvert+0.5);
	}

	ptDim->GetDimCstring(&szDim, nDestSpeedDim);
	szSpeed.Format ("%4d %s", nSpeed, szDim);

	return szSpeed;
}

/************************************************************************
 *  PlaneDoc.cpp			O n N e w D o c u m e n t					*
 ************************************************************************/
BOOL CPlaneDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)     
	
//this->DeleteArrayOf (&m_Planes);
    
return TRUE;
}   

/************************************************************************
 *  PlaneDoc.cpp			D e l e t e C o n t e n t s					*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CPlaneDoc::DeleteContents()
{
this->DeleteArrayOf (&m_Planes);
}

/************************************************************************
 *  PlaneDoc.cpp			O n O p e n D o c u m e n t					*
 ************************************************************************/
BOOL CPlaneDoc::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened)
	{
	if (m_bConverted)
		{
		if (this->OnSaveDocument (pszPathName, FALSE))		// don't confirm
			{
			m_bConverted = FALSE;
			if (ptInit->IsSaveSignal())
				MessageBeep(MB_OK);	
			}
		}
	}

return bOpened;
}


/************************************************************************
 *  PlaneDoc.cpp			O n S a v e D o c u m e n t					*
 ************************************************************************/
BOOL CPlaneDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
BOOL bSaved = FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFileExt = this->GetTitle();
	szText.Format (IDF_SAVE_FILE, (LPCTSTR)szFileExt);
	bDoSave = (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{
	if (bDemo)
		{
		AfxMessageBox (IDS_SAVE_DISABLED);
		return bSaved;
		}
	else{
		bSaved = CDocument::OnSaveDocument(pszPathName); 
		}
	}        
else{   
    this->SetModifiedFlag (FALSE);
	}

return bSaved;
}


/************************************************************************
 *  PlaneDoc.cpp  		 		 C h a n g e 							*
 ************************************************************************/
BOOL CPlaneDoc::Change(CWnd* ptWnd)
{  
BOOL 	bChanged = FALSE;
CPlaneDlg PlaneDlg(ptWnd, this);

int RetVal = PlaneDlg.DoModal();
switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
		if (PlaneDlg.WriteDataBaseIntoDoc()) 
			{             
			this->OnSaveDocument (szPath);
 			bChanged = TRUE;
 			}     
 	//	ptInit->SetPlaneDocPath(szPath); // uses path of LocDoc   
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
return bChanged;	
} 

/************************************************************************
 *  PlaneDoc.cpp  		 		 H e a d e r T o V e r s 				*
 ************************************************************************/
short CPlaneDoc::HeaderToVers (char* ptHeader)
{  
short nVersion = 0;
CString szTestVers; 

szTestVers.LoadString (IDS_PL_VERS1); 
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 1;

szTestVers.LoadString (IDS_PL_VERS21);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = 2;

szTestVers.LoadString (IDS_PL_VERS);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = ACT_PLANE_VERS;

return nVersion;
} 
     
/************************************************************************
 *  PlaneDoc.cpp  		 		V e r s T o H e a d e r 				*
 ************************************************************************/
void CPlaneDoc::VersToHeader (LPSTR lpHeader, short nVersion)
{      
CString szVers;
switch (nVersion)
	{
	case 1:	szVers.LoadString (IDS_PL_VERS1);	break; 
	case 2:	szVers.LoadString (IDS_PL_VERS21);	break; 
	case ACT_PLANE_VERS:	
			szVers.LoadString (IDS_PL_VERS);	break; 
	default: szVers.Empty();	break;
    }

_fstrcpy (lpHeader, (LPCTSTR)szVers);
}      

/************************************************************************
 *  PlaneDoc.cpp  		 		G e t S u b M e n u 					*
 ************************************************************************/
CMenu* CPlaneDoc::GetSubMenu (CWnd* ptWnd, short nColumn)   
{
CMenu* ptSubMenu = NULL;

CMenu* pMenu = ptWnd->GetMenu();   
if (pMenu != NULL)
	ptSubMenu = pMenu->GetSubMenu(nColumn);
return ptSubMenu;
}

/************************************************************************
 *  PlaneDoc.cpp  		 		D e l P l a n e M e n u					*
 ************************************************************************/
BOOL CPlaneDoc::DelPlaneMenu (CWnd* ptWnd, short nColumn)
{       
BOOL	bOK = FALSE;   
m_nColumn	= nColumn;
                    // called from mainframe, so we dont need GetParent

 //   POPUP "&Flugzeuge"
 //   BEGIN
 //       MENUITEM "&Bearbeiten...",              ID_INP_PLANE
 //       MENUITEM "Be&ladung...",                ID_INP_LOAD
 //       MENUITEM SEPARATOR
 //   END


CMenu* ptSubMenu = this->GetSubMenu (ptWnd, m_nColumn);
if (ptSubMenu != NULL)
	{
	short i;
	UINT uCnt = ptSubMenu->GetMenuItemCount();
	
	for (i = uCnt; i>2; i--)				// delete all except Item 0, 1 and 2
		 ptSubMenu->DeleteMenu (i, MF_BYPOSITION);
	
	m_nSelected = -1;	
	bOK = TRUE;
	} 
return bOK;
}         



/************************************************************************
 *  PlaneDoc.cpp  		 		N e w P l a n e M e n u					*
 ************************************************************************/
BOOL CPlaneDoc::NewPlaneMenu (CWnd* ptWnd, short nColumn)
{       
BOOL	bOK = FALSE;   
m_nColumn	= nColumn;
                    // called from mainframe, so we dont need GetParent
CMenu* ptSubMenu = this->GetSubMenu (ptWnd, m_nColumn);
if (ptSubMenu != NULL)
	{
//	ptSubMenu->DeleteMenu (3, MF_BYPOSITION);
	
	if (m_Planes.GetSize() == 0)
		{
		CString	szMissing;   	
		szMissing.LoadString (IDS_MISSING);	
		ptSubMenu->AppendMenu (MF_GRAYED | MF_STRING, ID_PLANE_FIRST + 0, (LPCTSTR)szMissing);  
	    m_nSelected = -1;            	/* there is no plane	*/
	    }
	else{                 
		BOOL	bStop = FALSE;
		short	i;
	    for (i=0; i<m_Planes.GetSize() && !bStop; i++)
			{ 
			CPlane Plane((LPPLANE)m_Planes.GetAt(i));  
			if (i<MAX_PLANE_CNT)
			    { 
				ptSubMenu->AppendMenu (MF_ENABLED | MF_STRING, (UINT)(ID_PLANE_FIRST + i), 
								(LPCTSTR)Plane.GetName());  
			    }
			else{ 
				AfxMessageBox (IDS_MAX_PLANES);   
				bStop = TRUE;
				}
			}
		}
	
	if (m_Planes.GetSize() > 0)    
	    {			    		/* try to find index of last selected plane */
	    BOOL	bFound = FALSE;
	    m_nSelected = 0;     	/* default: use first plane					*/
	    CString szSelPlane = ptInit->GetPlaneName(); 	// name of last selected plane
		short	i;
	    for (i=0; i<m_Planes.GetSize() && !bFound; i++)
			{ 
			CPlane Plane((LPPLANE)m_Planes.GetAt(i));  
			bFound = (szSelPlane.Compare ((LPCTSTR)Plane.GetName()) == 0);
			if (bFound) 
				m_nSelected = i; 
			}
		} 
		
	if (m_nSelected >= 0)
	    ptSubMenu->CheckMenuItem ((UINT)(ID_PLANE_FIRST + m_nSelected), MF_CHECKED | MF_BYCOMMAND);
	    
	bOK = TRUE;
	} 
return bOK;
}         


/************************************************************************
 *  PlaneDoc.cpp  		 		S e r i a l i z e 						*
 ************************************************************************/
void CPlaneDoc::Serialize(CArchive& ar)
{    
short i, nVersion;

if (ar.IsStoring())
	{  
		// TODO: add storing code here     
	nVersion = ACT_PLANE_VERS;  
	VersToHeader ((LPSTR)&m_szHeader, nVersion);	
	ar.Write (&m_szHeader, MAX_HEADER_SIZE);    
	
	for (i=0; i<m_Planes.GetSize(); i++)
		{
		LPPLANE lpPlane = (LPPLANE)m_Planes.GetAt(i);
		CPlane Plane(lpPlane);
		Plane.Serialize (ar);  
		}      
	m_bConverted = FALSE;		
	}
else{
		// TODO: add loading code here   
	m_bConverted = FALSE;

	ar.Read (&m_szHeader, MAX_HEADER_SIZE);
	nVersion = this->HeaderToVers (m_szHeader);  
	
	if (nVersion < ACT_PLANE_VERS)
		{	  
		CString szText;
	    szText.Format(IDS_CONVERT_PL, (LPCTSTR)this->GetTitle());
		if (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES) 
			{ 
			m_bConverted = TRUE; 
            }
        else{ 
        	AfxMessageBox (IDS_BAD_PL_VERS);
        	return;
        	}
        }
	
	
 
	CFile* ptFile = ar.GetFile();
	DWORD	dwLength = (DWORD)ptFile->GetLength();
	  
	DWORD dwBlockSize;  			// get number of entries:
	switch (nVersion)
		{
		case 1:	dwBlockSize = sizeof (PLANETYPE1);	break;
		case 2:	dwBlockSize = sizeof (PLANETYPE2);	break;
		case ACT_PLANE_VERS:	dwBlockSize = sizeof (PLANETYPE);	break;
        }
	short nCnt = (short)((dwLength - MAX_HEADER_SIZE) / dwBlockSize);
	
	for (i=0; i<nCnt; i++)
		{
		CPlane Plane; 
		Plane.Serialize (ar, nVersion);
		LPPLANE lpPlane = Plane.CreatePtr();	   	
		if (lpPlane != NULL)
			{  
			TRACE ("CPlaneDoc::Serialize Add lpPlane %d\n", i);

			m_Planes.Add (lpPlane);       	// add new Element        
 			}  
		} 
 	}  
}



/////////////////////////////////////////////////////////////////////////////
// CPlaneDoc diagnostics

#ifdef _DEBUG
void CPlaneDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPlaneDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPlaneDoc commands
