// PlaneDoc.h : interface of the CPlaneDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "Plane.h"

class CPlaneDoc : public CDocument
{         
private:
	#define MAX_HEADER_SIZE 20
    
    char m_szHeader[MAX_HEADER_SIZE];     
    short		m_nColumn;
	CPtrArray	m_Planes;             
	short	m_nSelected;
 	BOOL	m_bConverted; 
    
protected: // create from serialization only
	DECLARE_DYNCREATE(CPlaneDoc)

// Attributes
public:
// Operations
public:           
	void ActivatePlane (CWnd* ptWnd, short nID);
 	void DeleteArrayOf (CPtrArray* ptArray);
	void CopyPlanes (CPtrArray* ptDest, CPtrArray* ptSource);
	void GetDataBase (CPtrArray* ptPlaneList);
	void SetDataBase (CPtrArray* ptPlaneList);
 	LPPLANE GetPlanePtr (short nIndex);
	BOOL GetPlanePtr (short nIndex, CPlane* ptPlane);

	CString GetActPlaneName ();
	CString GetSpeedString (short nIndex, short nDestSpeedDim);

    BOOL WasConverted(){return m_bConverted;}     
	short	GetActIndex() { return m_nSelected; }

	CMenu* GetSubMenu (CWnd* ptWnd, short nColumn);
	BOOL DelPlaneMenu (CWnd* ptWnd, short nColumn);
 	BOOL NewPlaneMenu (CWnd* ptWnd, short nColumn);
   						  
// Implementation
public:
	CPlaneDoc();
	virtual ~CPlaneDoc();  
	virtual BOOL OnNewDocument();  
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
    
	BOOL Change(CWnd* ptWnd);
	
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:    
	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);   
	
// Generated message map functions
protected:
	//{{AFX_MSG(CPlaneDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
