#ifndef __PROT_GARMIN_LINK1__
#define __PROT_GARMIN_LINK1__

/*********************************************************************
 *					P r o t G a r m i n L i n k 1 . h			     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "GpsDevice.h"
#include "GarminLink1Ev.h"
#include "GarminProtocols.h"

class CFile;
class CProtGarminLink1 : public CGpsDevice
{    
DECLARE_DYNAMIC(CProtGarminLink1)
     
protected:
	CGarminProtocols* m_ptProtocols;
	CFile*				m_ptLogFile;
	BOOL	m_bRealCommand;
	BOOL	m_bSimulateProtocolArray;

protected: // create from serialization only

// Attributes
// Operations
public:
	virtual BOOL SendCommand (unsigned char uFunc, unsigned char* ptData, short nLen);
	virtual BOOL SendCommand(unsigned char uCmd);
	virtual BOOL SendProductRqst();
	virtual BOOL SendNumberOfRecords(short nRecordCnt);

							// used in derived classes also
	short CalcWptTransRecords(short nWptCnt);
	short CalcRteTransRecords(short nWptCnt);
	BOOL SendRouteLinkData();
	BOOL SendTransferCompleted(short nCmd);
	void SimulateProtocolArray();
	BOOL IsRealCommand();

	void SetProtocols(short nProductID, double fSoftwareVersion);
	void SplitProtocols(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile);
	short GetPidProt();
	short GetCmndProt();
	short GetWptProt();
	short GetRteTrans();
	short GetRteWptProt();
	short GetRteHdrProt();
	short GetTrkPointProt();
	short GetTrkHdrProt();

								// used for Link1 only
	BOOL SendAck(unsigned char uFunc);
	BOOL SendNoAck(unsigned char uFunc);

// Implementation

public:
	CProtGarminLink1();
	virtual ~CProtGarminLink1();



						// used in derived classes also
	void SetLogFilePtr(CFile* ptFile) { m_ptLogFile = ptFile; }
	void CopyWptName (unsigned char* lpOut, short nOffs, short nBytes, 
						char* szName, short nLen);

	void SendGarminWpt(short nProt, double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt);
	void SendRteWpt(double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt);
	void SendWpt(double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC);

	void SetZeroTermString(unsigned char* lpOut, short* ptOffs, char* szText, short nMaxLen);

	void SetSubClass (SubClassType* ptSubClass);

	virtual void FuncToString (unsigned char uFunc, char* szFunc);
	void WriteToFile (CFile* ptFile, CGarminLink1Event* ptEvt);

						// used in Link1 only
	BOOL GetNextGarminEvent (CGarminLink1Event* ptGE);
	unsigned char FillByte (unsigned char* lpOut, short nFirstByte, short nLastByte);
	void CheckGarminESC (BOOL bInsert, unsigned char* lpData, int* ptCnt, BOOL* ptHandleESC);

	BOOL SendG55Reply (CGarminLink1Event* ptGE);

private:
	void ShiftArrayUp (unsigned char* lpData, long lCnt);
	void ShiftArrayDown (unsigned char* lpData, long lCnt);
	virtual void SaveData (unsigned char uFunc, unsigned char* ptData, short nLen);


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
