/*********************************************************************
 *				P r o t G a r m i n L i n k 1 U s b . c p p			 *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "GarminLink1UsbEv.h"
#include "ProtGarminLink1Usb.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "InitDoc.h"  
//#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"		  // defines PF_MAX_TANK...
#include "Calc.h"			// this statement must be after PlaneDoc.h

/*
 * Internal interfaces that are common regardless of underlying 
 * OS implementation. 
 */


long g_lEvents;

/************************************************************************
 *  Garmin.cpp				C G a r m i n 					CONSTRUCTOR	*
 ************************************************************************/
CProtGarminLink1Usb::CProtGarminLink1Usb()	:
	CProtGarminLink1 ()
{
	m_hReadThread = NULL;
	m_dwReadThreadId = -1;
	m_nReadMode = CSerCom::ReadMode_InterruptPipe;

			// thread synchronization
	BOOL bManualReset = FALSE;				// auto reset in WaitForSingleObject		
	BOOL bInitialState = TRUE;
	m_hClearToAccess = CreateEvent(	NULL,	// no security
									bManualReset, bInitialState, 
									NULL);	// no name
	g_lEvents = 0;
	m_nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Xfer_Cmplt;	// default for reading data
			// should be changed for writing routes or waypoints
}


/************************************************************************
 *  Garmin.cpp			~ C G a r m i n						DESTRUCTOR	*
 ************************************************************************/
CProtGarminLink1Usb::~CProtGarminLink1Usb()
{
	this->DeleteArrayOf (&m_EventQueue);

	CloseHandle (m_hClearToAccess);
}

/************************************************************************
 *  Garmin.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CProtGarminLink1Usb::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CGarminLink1UsbEvent* ptEntry;
	if ((ptEntry = (CGarminLink1UsbEvent*)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}          


/************************************************************************
 *  Garmin.cpp			A p p e n d Q u e u e E v e n t P t r			*
 ************************************************************************/
long CProtGarminLink1Usb::AppendQueueEventPtr (CGarminLink1UsbEvent* ptGarminEvent)
{
	long lAddedIndex = -1;

	CString szMsg;
	if (CSerCom::WaitForSignaledEvent(m_hClearToAccess, &szMsg))
	{
		if (ptGarminEvent != NULL)
		{  
			lAddedIndex = m_EventQueue.Add (ptGarminEvent);      // add new Element  
		}
	}
	else
	{
		AfxMessageBox("AppendQueueEventPtr: " + szMsg);
	}

	SetEvent (m_hClearToAccess);

	return lAddedIndex;
}

/************************************************************************
 *  Garmin.cpp			G e t Q u e u e E v e n t 						*
 *  copies lIndex-th event into ptGarminEvent and						*
 *  deletes the copied entry form queue									*
 ************************************************************************/
BOOL CProtGarminLink1Usb::GetQueueEvent(long lIndex, CGarminLink1UsbEvent* ptGarminEvent)
{
	BOOL bOK = FALSE;

	CString szMsg;
	if (CSerCom::WaitForSignaledEvent(m_hClearToAccess, &szMsg))
	{
		if (lIndex >= 0 && lIndex < m_EventQueue.GetSize())
		{
			CGarminLink1UsbEvent* ptQueueEvent=NULL;
			ptQueueEvent = (CGarminLink1UsbEvent*)m_EventQueue.GetAt(lIndex);
			if (ptQueueEvent != NULL)
			{
				*ptGarminEvent = *ptQueueEvent;	// copy event to target memory

				delete ptQueueEvent;
				m_EventQueue.RemoveAt(lIndex);
				bOK = TRUE;
			}
		}
	}
	else
	{
		AfxMessageBox("GetQueueEvent: " + szMsg);
	}
	SetEvent (m_hClearToAccess);

	return bOK;
}



/************************************************************************
 *  ProtGarminUsb.cpp			S a v e D a t a							*
 ************************************************************************/
void CProtGarminLink1Usb::SaveData (short nFunc, unsigned char* ptData, short nLen)
{
	if (m_ptLogFile != NULL)
	{
		char szHexBuff[2048];
		long	lHexLen = 0;
		char	szFunc[32];

		FuncToString (nFunc, szFunc);

		lHexLen = sprintf (szHexBuff, "\r\n\r\nHost sends cmd %s (%d,%04X):\r\n", 
						szFunc, nFunc, nFunc);
		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);

		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, nLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
	}
}


/************************************************************************
 *  ProtGarminUsb.cpp			S e n d Protocol C o m m a n d			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendProtocolCommand (unsigned char uFunc, 
									unsigned char* ptData, short nLen)
{
	short nOffs = 0;

	SaveData(uFunc, ptData, nLen);

	unsigned char lpOut[4096];

	*(lpOut + nOffs++) = CGarminLink1UsbEvent::USB_Protocol_Layer;
	*(lpOut + nOffs++) = 0;
	*(lpOut + nOffs++) = 0;
	*(lpOut + nOffs++) = 0;

	*(lpOut + nOffs++) = uFunc;
	*(lpOut + nOffs++) = 0;
	*(lpOut + nOffs++) = 0;
	*(lpOut + nOffs++) = 0;

	*((DWORD*)(lpOut+nOffs)) = nLen;
	nOffs += sizeof(DWORD);

	for (short i=0; i<nLen; i++)
		*(lpOut + nOffs++) = *(ptData + i);


	return this->WriteUSB (lpOut, nOffs);
}

/************************************************************************
 *  ProtGarminUsb.cpp			S e n d C o m m a n d					*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendCommand (unsigned char uFunc, 
									unsigned char* ptData, short nLen)
{
	short nOffs = 0;

	SaveData(uFunc, ptData, nLen);

	*(m_lpOut + 0) = CGarminLink1UsbEvent::Application_Layer;
	*(m_lpOut + 1) = 0;
	*(m_lpOut + 2) = 0;
	*(m_lpOut + 3) = 0;

	*(m_lpOut + 4) = (unsigned char)uFunc;
	*(m_lpOut + 5) = 0;
	*(m_lpOut + 6) = 0;
	*(m_lpOut + 7) = 0;

	*((long*)(m_lpOut+8)) = nLen;

	nOffs = 12;

	for (short i=0; i<nLen; i++)
		*(this->m_lpOut + nOffs++) = *(ptData + i);


	return this->WriteUSB (m_lpOut, nOffs);
}

/************************************************************************
 *  ProtGarminUsb.cpp			S e n d C o m m a n d		 			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendCommand(unsigned char uCmd)
{							// see page 8
	unsigned char ptData[2];
	ptData[0] = uCmd;		// one or
	ptData[1] = 0;			// two bytes, But first has to be considered
	return SendCommand (CGarminLink1UsbEvent::Pid_Command_Data, ptData, 2);
}

/************************************************************************
 *  ProtGarminUsb.cpp			S e n d P r o d u c t R q s t 			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendProductRqst()
{
	unsigned char ptData[2];
	short nLen = 0;

	return SendCommand (CGarminLink1UsbEvent::Pid_Product_Rqst, ptData, nLen);
}

/************************************************************************
 *  Garmin.cpp			S e n d N u m b e r O f R e c o r d s			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendNumberOfRecords(short nRecordCnt)
{
	unsigned char ptData[2];
	short nLen = 2;

	ptData[0] = (unsigned char)nRecordCnt;
	ptData[1] = 0;

	return SendCommand (CGarminLink1UsbEvent::Pid_Records, ptData, nLen);
}


/************************************************************************
 *  Garmin.cpp				S p l i t S t a r t S e s s i o n			*
 ************************************************************************/
void CProtGarminLink1Usb::SplitStartSession(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile)
{
	if (lDataLen == 4)
	{
		char szHexBuff[2048];
		long	lHexLen = 0;

		unsigned serial_number = le_read32(ptData);
		lHexLen = sprintf (szHexBuff, "\r\n\r\nSerial number: %u\r\n", serial_number);

		if (ptFile != NULL)
			ptFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
	}
}



/************************************************************************
 *  Garmin.cpp			G e t N e x t G a r m i n E v e n t				*
 *  called in thread function DoReadThread								*
 *  GetNextGarminEvent has to return TRUE in order to stop the thread!	*
 ************************************************************************/
BOOL CProtGarminLink1Usb::GetNextGarminEvent (CGarminLink1UsbEvent* ptGE)
{
	BOOL	bTimeOut = FALSE;
	DWORD	dwRead = 0;
	BOOL	bMemOK = FALSE;
	DWORD	dwOffs = 0;

	unsigned char lpInp[4096];

	if (this->ReadUSB(m_nReadMode, (unsigned char*)lpInp, 4096, &dwRead))
	{
		if (dwRead >= 12)
		{
			short nPacketType = -1;
			short nPacketID = -1;
			DWORD dwDataSize = 0;

			nPacketType = *((BYTE*)(lpInp+0));
			nPacketID = *((short*)(lpInp + 4));
			dwDataSize = *((DWORD*)(lpInp + 8));

			if (m_nReadMode == CSerCom::ReadMode_InterruptPipe &&
				nPacketType == CGarminLink1UsbEvent::USB_Protocol_Layer &&
				nPacketID == CGarminLink1UsbEvent::Pid_Data_Available)
			{		// now read data via ReadFile instead DeviceIoControl
				m_nReadMode = CSerCom::ReadMode_BulkPipe;

					// call this func again with new read mode!
				return GetNextGarminEvent(ptGE);
			}
			else
			{ // Pid_Data_Available, use: DeviceIoControl
				ptGE->SetFunction ((byte)nPacketID);

				dwOffs = 12;			// length required once for USB header
										// real data length = iRead - length of header

				if (dwDataSize < 4096)
				{
					if (dwDataSize > dwRead-dwOffs)
					{		// there is more data to read...
						DWORD dwReadData = dwRead-dwOffs;
						DWORD dwRest = dwDataSize - dwReadData;
						dwOffs += dwReadData;

						short nLoops = 0;
						do
						{		
							if(this->ReadUSB(m_nReadMode, (unsigned char*)(lpInp + dwOffs), 4096-dwOffs, &dwRead))
							{
								dwOffs += dwRead;
								dwRest -= dwRead;
							}
							else
							{
								bTimeOut = TRUE;
								dwRest = 0;		// force to stop loop
								dwDataSize = 0;
							}


							nLoops++;
							if (nLoops > 100)
							{
								AfxMessageBox("GetNextGarminEvent, nLoops > 100");
								dwDataSize = 0;
								dwRest = 0;
								bTimeOut = TRUE;
							}
						} while (dwRest > 0);

						// all data of actual event received...
					} 


					bMemOK = ptGE->SetDataLen(dwDataSize);
					if (bMemOK)
					{
						if (dwDataSize > 0)
							ptGE->SetData (lpInp + 12);
					} 
					else
					{
						bTimeOut = TRUE;
					}
				} // dwDataSize OK
				else
				{
					CString szMsg;
					szMsg.Format("GetNextGarminEvent, DataSize=%ld too large!", dwDataSize);
					AfxMessageBox(szMsg);
					bTimeOut = TRUE;
				}

			}
		} // dwRead >= 12
	} // good ReadUSB
	else
	{	// error in ReadUSB
		bTimeOut = TRUE;
	}

	return bTimeOut;
}



/************************************************************************
 *  ProtGarminUsb.cpp			F u n c T o S t r i n g					*
 ************************************************************************/
void CProtGarminLink1Usb::FuncToString (short nFunc, char* szFunc)
{
    switch (nFunc)
	{
	case CGarminLink1UsbEvent::Pid_Data_Available:
		strcpy (szFunc, "Pid_Data_Available");
		break;

	case CGarminLink1UsbEvent::Pid_Start_Session:
		strcpy (szFunc, "Pid_Start_Session");
		break;	
	case CGarminLink1UsbEvent::Pid_Session_Started:
		strcpy (szFunc, "Pid_Session_Started");
		break;		



	case CGarminLink1UsbEvent::Pid_Version_Terrain_DB:
		strcpy (szFunc, "Pid_Version_Terrain_DB");
		break;
	case CGarminLink1UsbEvent::Pid_Protocol_Array:
		strcpy (szFunc, "Pid_Protocol_Array");
		break;
	case CGarminLink1UsbEvent::Pid_Product_Rqst:
		strcpy (szFunc, "Pid_Product_Rqst");
		break;
	case CGarminLink1UsbEvent::Pid_Product_Data:
		strcpy (szFunc, "Pid_Product_Data");
		break;


	default:
		CProtGarminLink1::FuncToString((unsigned char)nFunc, szFunc);
		break;
	}
}

/************************************************************************
 *  ProtGarminUsb.cpp			W r i t e T o F i l e					*
 ************************************************************************/
void CProtGarminLink1Usb::WriteToFile (CFile* ptFile, CGarminLink1UsbEvent* ptEvt)
{
	long	lLen;
	char	szFunc[32];
	char	szBuffer[256];

	short nFunc = ptEvt->GetFunction();
	FuncToString(nFunc, szFunc);

	long lDataLen = ptEvt->GetDataLen();
	unsigned char* ptData = ptEvt->GetDataPtr();

	if (ptData != NULL)
    {
    lLen = sprintf (szBuffer, "\r\nGPS sends %s (%d) with %ld bytes:\r\n", 
				szFunc, nFunc, lDataLen);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

    if (ptData != NULL)
		{
		char szHexBuff[1024];
		long	lHexLen = 0;
		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, lDataLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		if (ptFile != NULL)
			ptFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
		}
    }
}

/****************************************************************************
 *							D o R e a d T h r e a d							*
 ****************************************************************************/
DWORD WINAPI DoReadThread(LPVOID ptThreadData)
{      
	BOOL bStop = FALSE;
	BOOL bTimeout = FALSE;
	short nInitialReadMode;

	CProtGarminLink1Usb* ptProtGarminUSB = (CProtGarminLink1Usb*)ptThreadData;
	if (ptProtGarminUSB != NULL)
	{
		CDialog* ptDlg = ptProtGarminUSB->GetDlgPtr();
		HWND hWnd = ptDlg->GetSafeHwnd();

		do
		{
			nInitialReadMode = ptProtGarminUSB->GetReadMode();

			CGarminLink1UsbEvent* ptGarminUsbEv = NULL;
			ptGarminUsbEv = new CGarminLink1UsbEvent();
			if (ptGarminUsbEv == NULL)
			{
				bStop = TRUE;
				WPARAM wParam = 1;			// ERROR code
				LPARAM lParam = 0L;
				AfxMessageBox("DoReadThread: out of memory!");
				if (!::PostMessage(hWnd, WM_GPSEVENT, wParam, lParam))
					bStop = TRUE;
			}
			else
			{
				g_lEvents++;

				bTimeout = ptProtGarminUSB->GetNextGarminEvent (ptGarminUsbEv);
				if (bTimeout)
				{
					delete ptGarminUsbEv;	// got no data for this pointer

					bStop = TRUE;
					WPARAM wParam = 1;		// ERROR code
					LPARAM lParam = 0L;
					AfxMessageBox("DoReadThread: Timeout in GetNextGarminEvent!");
					if (!::PostMessage(hWnd, WM_GPSEVENT, wParam, lParam))
						bStop = TRUE;
				}
				else
				{			// got good data from GetNextGarminEvent
					WPARAM wParam = 0;			// no ERROR
					LPARAM lParam = 0L;

								// stop, if last event received from GPS
					short nFunc = ptGarminUsbEv->GetFunction();
					bStop = (nFunc == ptProtGarminUSB->GetStopThreadEvent());	

					if(bStop && nInitialReadMode == CSerCom::ReadMode_BulkPipe)
					{		// keep reading packets until it receives a zero length transfer
						long lDataLength = 0;
						do
						{
							CGarminLink1UsbEvent GarminUsbEv;
							bTimeout = ptProtGarminUSB->GetNextGarminEvent (&GarminUsbEv);
							if (bTimeout)
							{
						//		AfxMessageBox ("Timeout while looking for last read after TransferCompleted");
							}
						} while (lDataLength > 0);
					}

					long lAddedIndex = ptProtGarminUSB->AppendQueueEventPtr(ptGarminUsbEv);
					if (lAddedIndex >= 0)
					{
						lParam = (LPARAM)lAddedIndex;
						if (!::PostMessage(hWnd, WM_GPSEVENT, wParam, lParam))
							bStop = TRUE;
					}
				
				}
			}
		} while (!bStop);

	}
	//AfxMessageBox("Debug: DoReadThread finished");
	return 1;
}


long CProtGarminLink1Usb::GetNumberOfCreatedEvents()
{ 
	return g_lEvents;
}


//****************************************************************************************
//								S t a r t R e a d T h r e a d	
//****************************************************************************************
BOOL CProtGarminLink1Usb::StartReadThread(CDialog* ptDlg)
{
	BOOL bStarted = FALSE;

	m_ptDlg = ptDlg;
	m_nReadMode = CSerCom::ReadMode_InterruptPipe;

	if (m_hReadThread == NULL)
	{
		m_hReadThread = CreateThread(NULL,
				   0,
				   (LPTHREAD_START_ROUTINE)DoReadThread,
				   (LPVOID)this,
				   0,					// creation option
				   &m_dwReadThreadId);

		if (m_hReadThread == NULL)
		{
			CString szErr;
			CSerCom::ErrorIDtoText (GetLastError(), &szErr);
			AfxMessageBox("StartReadThread: " + szErr);
		}
		else
		{
			bStarted = TRUE;
			g_lEvents=0;
		}
	}
	return bStarted;
}


/************************************************************************
 *  ProtGarminUsb.cpp			C l o s e R e a d T h r e a d			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::CloseReadThread(CString* ptMsg)
{
	BOOL bExited = FALSE;
	int nLoopCnt = 0;

	CString szFunc("GetExitCodeThread ");
	CString szMsg;

	if (CSerCom::WaitForSignaledEvent(m_hReadThread, &szMsg))
	{
		DWORD dwExitCode = 0;
		if (GetExitCodeThread(m_hReadThread, &dwExitCode) > 0)
		{
			if (dwExitCode == 1)
			{
				szFunc = "CloseHandle ";
				szMsg = "Thread exited successfully!";

					// Closing a thread handle does not terminate the associated thread. 
					// To remove a thread object, you must terminate the thread, 
					// then close all handles to the thread.
				if (CloseHandle(m_hReadThread))
				{
					m_hReadThread = NULL;
					m_dwReadThreadId = - 1;
					bExited = TRUE;
				}
				else
				{
					DWORD dwError = GetLastError();
					if (dwError != STILL_ACTIVE)
					{
						CSerCom::ErrorIDtoText (GetLastError(), &szMsg);
						bExited = TRUE;	// error exit""

					}
				}
			}
		}
		else
		{
			DWORD dwError = GetLastError();
			if (dwError != STILL_ACTIVE)
			{
				CSerCom::ErrorIDtoText (dwError, &szMsg);
				bExited = TRUE;		// error exit!!
			}
		}
	}
//		nLoopCnt++;
//	} while (!bExited && nLoopCnt < 100);

	if(ptMsg != NULL)
		ptMsg->Format("%s %s loops=%d", (LPCTSTR)szFunc, (LPCTSTR)szMsg, nLoopCnt);

	return bExited;
}

/************************************************************************
 *  ProtGarminUsb.cpp			S e n d S t a r t S e s s i o n			*
 ************************************************************************/
BOOL CProtGarminLink1Usb::SendStartSession ()
{
	BOOL bStop = FALSE;

	unsigned char lpOut[32];

	lpOut[0] = CGarminLink1UsbEvent::USB_Protocol_Layer;
	lpOut[1] = 0;
	lpOut[2] = 0;
	lpOut[3] = 0;

	lpOut[4] = CGarminLink1UsbEvent::Pid_Start_Session;
	lpOut[5] = 0;
	lpOut[6] = 0;
	lpOut[7] = 0;

	long lDataLen = 0;
	*((long*)(lpOut+8)) = lDataLen;

	return this->WriteUSB (lpOut, 12);
}





/////////////////////////////////////////////////////////////////////////////
// CProtGarminLink1Usb diagnostics

#ifdef _DEBUG
void CProtGarminLink1Usb::AssertValid() const
{
	CSerCom::AssertValid();
}

void CProtGarminLink1Usb::Dump(CDumpContext& dc) const
{
	CSerCom::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CProtGarminLink1Usb, CSerCom)
