#ifndef __PROT_GARMIN_LINK1_USB__
#define __PROT_GARMIN_LINK1_USB__

/*********************************************************************
 *					P r o t G a r m i n L i n k 1 U s b . h		     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "ProtGarminLink1.h"
#include "GarminLink1UsbEv.h"


/*
 * New packet types in USB.
 */
#define GUSB_SESSION_START 5	/* We request units attention */
#define GUSB_SESSION_ACK   6	/* Unit responds that we have its attention */ 
#define GUSB_REQUEST_BULK  2	/* Unit requests we read from bulk pipe */

#define WM_GPSEVENT (WM_USER + 6)

class CFile;
class CProtGarminLink1Usb : public CProtGarminLink1
{    
DECLARE_DYNAMIC(CProtGarminLink1Usb)
     
private:
	HANDLE      m_hReadThread;	// thread to read data from GPS
	DWORD		m_dwReadThreadId;
	CDialog*	m_ptDlg;

	HANDLE		m_hClearToAccess;
	CPtrArray	m_EventQueue;		// array of CGarminLink1UsbEvent
	short		m_nLastEventFromGPS;
	short		m_nReadMode;

protected: // create from serialization only

// Attributes
// Operations
public:
	BOOL SendProtocolCommand (unsigned char uFunc, unsigned char* ptData, short nLen);
	void SplitStartSession(unsigned char* ptData, long lDataLen, CFile* ptFile);

	virtual BOOL SendCommand (unsigned char uFunc, unsigned char* ptData, short nLen);
	virtual BOOL SendCommand(unsigned char uCmd);
	virtual BOOL SendProductRqst();
	virtual BOOL SendNumberOfRecords(short nRecordCnt);
	
	CDialog* GetDlgPtr() { return m_ptDlg; }
	long GetNumberOfCreatedEvents();
	short GetReadMode() { return m_nReadMode; }

	long AppendQueueEventPtr (CGarminLink1UsbEvent* ptGarminEvent);
	BOOL GetQueueEvent(long lIndex, CGarminLink1UsbEvent* ptGarminEvent);
	void SetStopThreadEvent(short nLastEventFromGPS) { m_nLastEventFromGPS = nLastEventFromGPS; }
	short GetStopThreadEvent() { return m_nLastEventFromGPS; }

	// Implementation

public:
	CProtGarminLink1Usb();
	virtual ~CProtGarminLink1Usb();


	BOOL GetNextGarminEvent (CGarminLink1UsbEvent* ptGE);
	virtual void FuncToString (short nFunc, char* szFunc);
	void WriteToFile (CFile* ptFile, CGarminLink1UsbEvent* ptEvt);

	BOOL SendStartSession ();
	BOOL StartReadThread(CDialog* ptDlg);
	BOOL CloseReadThread(CString* ptMsg = NULL);



private:
	void DeleteArrayOf (CPtrArray* ptArray);
	virtual void SaveData (short nFunc, unsigned char* ptData, short nLen);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
