/*********************************************************************
 *						P r o t G a r m i n L i n k 2 . c p p	     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "GarminLink2Ev.h"
#include "ProtGarminLink2.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "InitDoc.h"  
//#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"		  // defines PF_MAX_TANK...
#include "Calc.h"			// this statement must be after PlaneDoc.h



extern CCalcDoc*		ptCalc;

/************************************************************************
 *  Garmin.cpp				C G a r m i n 					CONSTRUCTOR	*
 ************************************************************************/
CProtGarminLink2::CProtGarminLink2()	:
	CGpsDevice (9600, 8, 10, NO)
{
	m_ptProtocols = NULL;

	m_ptProtocols = new CGarminProtocols();

	m_ptLogFile = NULL;
	m_bRealCommand = TRUE;
	m_bSimulateProtocolArray = FALSE;
}


/************************************************************************
 *  Garmin.cpp			~ C G a r m i n						DESTRUCTOR	*
 ************************************************************************/
CProtGarminLink2::~CProtGarminLink2()
{
	if (m_ptProtocols != NULL)
		delete m_ptProtocols;
}

/************************************************************************
 *  ProtGarminLink1.cpp			S a v e D a t a							*
 ************************************************************************/
void CProtGarminLink2::SaveData (unsigned char uFunc, unsigned char* ptData, short nLen)
{
	if (m_ptLogFile != NULL)
	{
		char szHexBuff[2048];
		long	lHexLen = 0;
		char	szFunc[32];

		FuncToString (uFunc, szFunc);

		lHexLen = sprintf (szHexBuff, "\r\n\r\nHost sends cmd %s (%d,%02X):\r\n", 
						szFunc, (short)uFunc, (short)uFunc);
		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);

		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, nLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
	}
}

/************************************************************************
 *  ProtGarminLink1.cpp			S e n d C o m m a n d					*
 ************************************************************************/
BOOL CProtGarminLink2::SendCommand (unsigned char uFunc, 
									unsigned char* ptData, short nLen)
{
	short nOffs = 0;

	SaveData(uFunc, ptData, nLen);

	*(this->m_lpOut + nOffs++) = 0x10;
	*(this->m_lpOut + nOffs++) = uFunc;
	*(this->m_lpOut + nOffs++) = (unsigned char)nLen;

	for (short i=0; i<nLen; i++)
		*(this->m_lpOut + nOffs++) = *(ptData + i);

	*(this->m_lpOut + nOffs) = FillByte (this->m_lpOut, 1, nOffs - 1);
	nOffs++;


	int iWriteCnt;									// don't check first 2 header bytes
	iWriteCnt = nOffs - 2;				// try to double 0x10 bytes in data area only
	BOOL bInsert = TRUE;
	BOOL bHandleESC = TRUE;
	this->CheckGarminESC (bInsert, (m_lpOut+2), &iWriteCnt, &bHandleESC);
	nOffs = (short)iWriteCnt + 2;		// 2 bytes for header


	*(this->m_lpOut + nOffs++) = 0x10;
	*(this->m_lpOut + nOffs++) = 0x03;

	return this->Write (m_lpOut, nOffs);
}

/************************************************************************
 *  ProtGarminLink1.cpp			S e n d C o m m a n d		 			*
 ************************************************************************/
BOOL CProtGarminLink2::SendCommand(unsigned char uCmd)
{							// see page 8
	unsigned char ptData[2];
	ptData[0] = uCmd;		// one or
	ptData[1] = 0;			// two bytes, But first has to be considered
	return SendCommand (CGarminLink2Event::Pid_Command_Data, ptData, 2);
}


/************************************************************************
 *  ProtGarminLink1.cpp			S e n d A c k				 			*
 ************************************************************************/
BOOL CProtGarminLink2::SendAck(unsigned char uFunc)
{							// see page 8
	unsigned char ptData[2];
	ptData[0] = uFunc;		// one or
	ptData[1] = 0;			// two bytes, But first has to be considered
	return SendCommand (CGarminLink2Event::Pid_Ack_Byte, ptData, 2);
}

/************************************************************************
 *  ProtGarminLink1.cpp			S e n d N o A c k				 		*
 ************************************************************************/
BOOL CProtGarminLink2::SendNoAck(unsigned char uFunc)
{

	unsigned char ptData[2];
	ptData[0] = uFunc;
	ptData[1] = 0;
	return SendCommand (CGarminLink2Event::Pid_Nak_Byte, ptData, 2);
}

/************************************************************************
 *  ProtGarminLink1.cpp			S e n d P r o d u c t R q s t 			*
 ************************************************************************/
BOOL CProtGarminLink2::SendProductRqst()
{
	unsigned char ptData[2];
	short nLen = 1;

	ptData[0]= (unsigned char)20;

	return SendCommand (CGarminLink2Event::Pid_Product_Rqst, ptData, nLen);
}

/************************************************************************
 *  Garmin.cpp			S e n d N u m b e r O f R e c o r d s			*
 ************************************************************************/
BOOL CProtGarminLink2::SendNumberOfRecords(short nRecordCnt)
{
	unsigned char ptData[2];
	short nLen = 2;

	ptData[0] = (unsigned char)nRecordCnt;
	ptData[1] = 0;

	return SendCommand (CGarminLink2Event::Pid_Records, ptData, nLen);
}

/************************************************************************
 *  Garmin.cpp			C a l c R t e T r a n s R e c o r d s			*
 *  Anzahl der Datenstze, ohne Pid_Xfer_Cmplt							*
 ************************************************************************/
short CProtGarminLink2::CalcRteTransRecords(short nWptCnt)
{
	short nRecords;
	short nTrans, nHdr, nWpt, nLink;
	m_ptProtocols->GetProtocolRte(&nTrans, &nHdr, &nWpt, &nLink);

	if (nTrans == A200_RteTrans)
	{		// Anz Routen * (Pid_Rte_Hdr + Wpt1, Wpt2, Wpt3, ..., WptN)
		nRecords = 1 * (1 + nWptCnt);
	}

	if (nTrans == A201_RteTrans)
	{		// Anz Routen * (Pid_Rte_Hdr + 2 * (Wpt1, Wpt2, Wpt3, ..., WptN)-1)
		nRecords = 1 * (1 + 2*nWptCnt - 1);
	}

	return nRecords;
}


/*********************************************************************
 *  Garmin.cpp		S e n d T r a n s f e r C o m p l e t e d 		 *
 *********************************************************************/
BOOL CProtGarminLink2::SendTransferCompleted (short nCmd)
{
	unsigned char ptData[2];
	short nLen = 2;

	ptData[0] = (byte)nCmd;
	ptData[1] = 0x00;

	return SendCommand (CGarminLink2Event::Pid_Xfer_Cmplt, ptData, nLen);
}


/************************************************************************
 *  Garmin.cpp				S e t P r o t o c o l s						*
 ************************************************************************/
void CProtGarminLink2::SetProtocols(short nProductID, double fSoftwareVersion)
{
	m_ptProtocols->SetProtocols(nProductID, fSoftwareVersion);
}

/************************************************************************
 *  Garmin.cpp				S p l i t P r o t o c o l s					*
 ************************************************************************/
void CProtGarminLink2::SplitProtocols(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile)
{
	m_ptProtocols->SplitProtocols(ptData, lDataLen, ptFile);
}

/************************************************************************
 *  Garmin.cpp				G e t P i d P r o t 						*
 ************************************************************************/
short CProtGarminLink2::GetPidProt()
{
	short nPhys, nLink, nCmd;
	m_ptProtocols->GetProtocolBase(&nPhys, &nLink, &nCmd);
	return nLink;
}

/************************************************************************
 *  Garmin.cpp				G e t C m n d P r o t 						*
 ************************************************************************/
short CProtGarminLink2::GetCmndProt()
{
	short nPhys, nLink, nCmd;
	m_ptProtocols->GetProtocolBase(&nPhys, &nLink, &nCmd);
	return nCmd;
}

/************************************************************************
 *  Garmin.cpp				G e t R t e T r a n s						*
 ************************************************************************/
short CProtGarminLink2::GetRteTrans()
{
	short nTrans, nHdr, nWpt, nLink;
	m_ptProtocols->GetProtocolRte(&nTrans, &nHdr, &nWpt, &nLink);

	return nTrans;
}

/************************************************************************
 *  Garmin.cpp				G e t R t e W p t P r o t					*
 ************************************************************************/
short CProtGarminLink2::GetRteWptProt()
{
	short nTrans, nHdr, nWpt, nLink;
	m_ptProtocols->GetProtocolRte(&nTrans, &nHdr, &nWpt, &nLink);

	return nWpt;
}

/************************************************************************
 *  Garmin.cpp				G e t R t e H d r P r o t					*
 ************************************************************************/
short CProtGarminLink2::GetRteHdrProt()
{
	short nTrans, nHdr, nWpt, nLink;
	m_ptProtocols->GetProtocolRte(&nTrans, &nHdr, &nWpt, &nLink);

	return nHdr;
}

/************************************************************************
 *  Garmin.cpp				G e t T r k P o i n t P r o t				*
 ************************************************************************/
short CProtGarminLink2::GetTrkPointProt()
{
	short nTrans, nHdr, nPoint;
	m_ptProtocols->GetProtocolTrk(&nTrans, &nHdr, &nPoint);

	return nPoint;
}


/************************************************************************
 *  Garmin.cpp				 F i l l B y t e							*
 ************************************************************************/
unsigned char CProtGarminLink2::FillByte (unsigned char* lpOut, short nFirstByte, short nLastByte)
{
short	nFillByte;
short	N=1;
short	nSum = 0;
short	i;

for (i=nFirstByte; i<=nLastByte; i++)	// build check sum
	nSum += *(lpOut + i);
while (nSum > 256) nSum -= 256;	


do  {					// get fillbyte
    short nTotalSum = (short)(N++) * (short)256;
    nFillByte = nTotalSum - nSum;
    } while (nFillByte<0);

return (unsigned char)nFillByte;
}



/************************************************************************
 *  Garmin.cpp				C o p y W p t N a m e						*
 *  copies nBytes bytes into lpOut, starting at nOffs.					*
 *  source is szName with nMaxWptChars chars.							*
 *  if nMaxWptChars < nBytes, lpOut will get space chars				*
 ************************************************************************/
void CProtGarminLink2::CopyWptName (unsigned char* lpOut, short nOffs, short nBytes,
				char* szName, short nMaxWptChars)
{
short i;
BOOL	bEnd = FALSE;
int	ch = 0;
				    // use upper case letters only
for (i=0; i<nBytes; i++)	    // fill "nBytes" bytes of lpOut
    {
    if (!bEnd)
		{
		ch = *(szName+i);
		if (ch == '') ch = 'S';    // check: 
		if (ch == '+') ch = 0x20;   // convert "+" to space char
					    // stop copy on first space char
		bEnd = (ch == 0) || (ch == 0x20) || (i>=nMaxWptChars);
		}

    if (bEnd)
		{
		ch = 0x20;
		}
    else{
		if (!isupper (ch))
		    ch = toupper (ch);

		if (ch == '') ch = 'A';      // 
		if (ch == '') ch = 'O';      // 
		if (ch == '') ch = 'U';      // 
	
		}
    *(lpOut + nOffs + i) = ch;
    }
}



/********************************************************************************
 *  Garmin.cpp				S e n d G a r m i n W p t							*
 ********************************************************************************/
void CProtGarminLink2::SendGarminWpt(short nProt, double dLat, double dLon, CString szName,
						 CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt)
{
    CGarminWpt wpt(this);
    wpt.SetRteWpt(dLat, dLon, szName, 
                            szIndic, nCategory, fAlt_m, nCC, bStoreAsUserWpt);

    unsigned char ptData[512];
    short nLen = wpt.PrepareRteWpt(ptData, this->GetRteWptProt());
    this->SendCommand ((unsigned char)nProt, ptData, nLen); 
}                              

/********************************************************************************
 *  Garmin.cpp				S e n d R t e W p t									*
 ********************************************************************************/
void CProtGarminLink2::SendRteWpt(double dLat, double dLon, CString szName,
						 CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt)
{
	short nProt = CGarminLink2Event::Pid_Rte_Wpt_Data;
	this->SendGarminWpt(nProt, dLat, dLon, szName, szIndic, nCategory, fAlt_m, nCC, bStoreAsUserWpt);
}

/********************************************************************************
 *  Garmin.cpp				S e n d W p t										*
 ********************************************************************************/
void CProtGarminLink2::SendWpt(double dLat, double dLon, CString szName,
						 CString szIndic, short nCategory, double fAlt_m, short nCC)
{
	short nProt = CGarminLink2Event::Pid_Wpt_Data;
	this->SendGarminWpt(nProt, dLat, dLon, szName, szIndic, nCategory, fAlt_m, nCC, FALSE);
}

/************************************************************************
 *  Garmin.cpp			S e t Z e r o T e r m S t r i n g				*
 ************************************************************************/
void CProtGarminLink2::SetZeroTermString(unsigned char* lpOut, short* ptOffs, char* szText, short nMaxLen)
{
	unsigned char ch;
	short i=0;

	do	{
		ch = *(szText + i++);
		*(lpOut + (*ptOffs)++) = ch;
		} while (ch > 0 && i < nMaxLen);

	if (i== nMaxLen)
		*(lpOut + nMaxLen-1) = 0;
}


/*********************************************************************
 *  Garmin.cpp				S e t S u b C l a s s				     *
 *********************************************************************/
void CProtGarminLink2::SetSubClass (SubClassType* ptSubClass)
{
ptSubClass->nDummy = 0;
ptSubClass->lDummy = 0;
ptSubClass->ulDummy1 = 0xFFFFFFFF;
ptSubClass->ulDummy2 = 0xFFFFFFFF;
ptSubClass->ulDummy3 = 0xFFFFFFFF;
}


/************************************************************************
 *  Garmin.cpp				S h i f t A r r a y U p						*
 *  Input: lpData: First byte to shift up (byte whith smallest index)	*
 *			lCnt: Bytes to shift										*
 ************************************************************************/
void CProtGarminLink2::ShiftArrayUp (unsigned char* lpData, long lCnt)
{
long i;
for (i=lCnt-1; i>=0; i--)
	*(lpData + i+1) = *(lpData + i);
}

/************************************************************************
 *  Garmin.cpp			 S h i f t A r r a y D o w n					*
 *  Input: lpData: First byte to shift down	(byte whith smallest index)	*
 *			lCnt: Bytes to shift										*
 ************************************************************************/
void CProtGarminLink2::ShiftArrayDown (unsigned char* lpData, long lCnt)
{
short i;
for (i=0; i<lCnt; i++)
	*(lpData + i-1) = *(lpData + i);
}


/************************************************************************
 *  Garmin.cpp				C h e c k G a r m i n E S C 				*
 ************************************************************************/
void CProtGarminLink2::CheckGarminESC (BOOL bInsert, unsigned char* lpData, int* ptCnt, BOOL* ptHandleESC)
{					
long	i = 0;
long	lCnt = (long)*ptCnt;
long	lRest = lCnt;

while (i<lCnt)
	{
	if (*(lpData+i) == 0x10 && *ptHandleESC)
		{
		*ptHandleESC = TRUE;
		if (bInsert)
			{								// 0x10 will be uchanged
			this->ShiftArrayUp ((lpData+i), lRest);	// and copied here
			//*(lpData+i) = 0x10;			// already there
			lCnt++;
			*ptHandleESC = FALSE;			// accept next byte
			}
		else{
			lRest--;
			if (lRest > 0)					// 0x10 will be overwritten
					this->ShiftArrayDown ((lpData+i+1), lRest);
			else	*ptHandleESC = FALSE;	// accept next byte
			
			lRest--;
			lCnt--;
			}
		}
	else{					// nothing to change
		*ptHandleESC = TRUE;
		lRest--;
		}
		
	i++;
	}

(*ptCnt) = (int)lCnt;
}

/************************************************************************
 *  Garmin.cpp			S i m u l a t e P r o t o c o l A r r a y 		*
 ************************************************************************/
void CProtGarminLink2::SimulateProtocolArray()
{
	m_bSimulateProtocolArray = TRUE;
}

/************************************************************************
 *  Garmin.cpp				I s R e a l C o m m a n d 					*
 ************************************************************************/
BOOL CProtGarminLink2::IsRealCommand()
{
	m_bSimulateProtocolArray = FALSE;
	return m_bRealCommand;
}



/************************************************************************
 *  Garmin.cpp			G e t N e x t G a r m i n E v e n t				*
 ************************************************************************/
BOOL CProtGarminLink2::GetNextGarminEvent (CGarminLink2Event* ptGE)
{
	int				iRead = 0;
	unsigned char	szBinBuff[256];
	BOOL			bMemOK = FALSE;
	BOOL			bEnd = FALSE;

	//ptGE = (CGarminLink2Event*)new CGarminLink2Event ();

									// Reading Header:	
	iRead = this->BytesInQueue (3);
	if (iRead < 3)
    {
		if (m_bSimulateProtocolArray)
		{
			ptGE->SetFunction(CGarminLink2Event::Pid_Protocol_Array);
			m_bRealCommand = FALSE;
			return FALSE;		// no timeout
		}
		else
		{						// timeout
			return TRUE;
		}
    }

iRead = 3;
iRead = this->ReadComm(m_lpInp, (int)iRead);

if (iRead == 3)
	{								// read data length
	if (*(m_lpInp + 2)==0x10)	// length is preceeded by 0x10
		{							// real length is 4. byte of header!!
		iRead = 1;	
		iRead = this->ReadComm((m_lpInp+2), (int)iRead);
		if (iRead != 1)
			return TRUE;
		}
		
    if (*(m_lpInp + 0) == 0x10)
		{
		ptGE->SetFunction (*(m_lpInp + 1));
		m_bRealCommand = TRUE;
		bMemOK = ptGE->SetDataLen (*(m_lpInp + 2));
		}
	}					// reading header finished

								// Reading Data:	
if (ptGE->GetDataLen() > 0)
	{
	BOOL	bHandleESC = TRUE;
    long    lOffset;
    long    lRest;

    lOffset = 3;
    lRest = ptGE->GetDataLen();
    
 	do	{
	    iRead = this->BytesInQueue ((short)lRest);
	    if (iRead < lRest)
			{
			return TRUE;
			}
	
	    iRead = (int)lRest;
	    iRead = this->ReadComm((m_lpInp + lOffset), (int)iRead);
	    if (iRead == lRest)
			{
			BOOL bInsert = FALSE;		// remove GarminESC
			this->CheckGarminESC (bInsert, (m_lpInp+lOffset), &iRead, &bHandleESC);
			lOffset += iRead;
			lRest	-= iRead;
			}
		} while (lRest > 0);
                                              
	if (bMemOK)
	    {
		ptGE->SetData (m_lpInp + 3);
	    }                                              

	ptGE->SetFillByte (this->FillByte (m_lpInp, 1, (short)(3+ptGE->GetDataLen() - 1)));
	}

								// Reading Trailer:	
iRead = this->BytesInQueue (3);
if (iRead < 3)
	return TRUE;

								// get check sum
iRead = 1;	
iRead = this->ReadComm(szBinBuff, (int)iRead);
if (iRead == 1)
	{
	if (szBinBuff[0] == 0x10)
		{						// checksum is preceeded by 0x10
		iRead = 1;				// real check sum is 2. byte of trailer
		iRead = this->ReadComm(szBinBuff, (int)iRead);
		if (iRead != 1)
			return TRUE;
		}
	}
 
iRead = 2;
iRead = this->ReadComm((szBinBuff+1), (int)iRead);
if (iRead == 2)
	{
	ptGE->SetCheckSum (szBinBuff[0]);
	bEnd = (szBinBuff[1] == 0x10 && szBinBuff[2] == 0x03);
	}         
	
if (!ptGE->CheckSumOK() || !bEnd)
	{
//	lLen = sprintf (szBuffer, "\r\nCalculated FillByte=%d Read FillByte=%d, bEnd=%d",
//			ptGE->uFill, ptGE->uCheckSum, (short)bEnd);
//	if (nRefNum != 0)
//		FSWrite (nRefNum, &lLen, (Ptr)szBuffer);  
	MessageBeep (MB_ICONHAND);  
	} 

return (!bMemOK || (iRead <= 0));
}

/************************************************************************
 *  ProtGarminLink2.cpp			F u n c T o S t r i n g					*
 ************************************************************************/
void CProtGarminLink2::FuncToString (unsigned char uFunc, char* szFunc)
{
    switch (uFunc)
	{
	case CGarminLink2Event::Pid_Ack_Byte:
		strcpy (szFunc, "Pid_Ack_Byte");
		break;
	case CGarminLink2Event::Pid_Command_Data:
		strcpy (szFunc, "Pid_Command_Data");
		break;
	case CGarminLink2Event::Pid_Xfer_Cmplt:
		strcpy (szFunc, "Pid_Xfer_Cmplt");
		break;
	case CGarminLink2Event::Pid_Date_Time_Data:
		strcpy (szFunc, "Pid_Date_Time_Data");
		break;
	case CGarminLink2Event::Pid_Position_Data:
		strcpy (szFunc, "Pid_Position_Data");
		break;
	case CGarminLink2Event::Pid_Nak_Byte:
		strcpy (szFunc, "Pid_Nak_Byte");
		break;		
	case CGarminLink2Event::Pid_Records:
		strcpy (szFunc, "Pid_Records");
		break;
	case CGarminLink2Event::Pid_Rte_Hdr:
		strcpy (szFunc, "Pid_Rte_Hdr");
		break;
	case CGarminLink2Event::Pid_Rte_Wpt_Data:
		strcpy (szFunc, "Pid_Rte_Wpt_Data");
		break;
	case CGarminLink2Event::Pid_Almanac_Data:
		strcpy (szFunc, "Pid_Almanac_Data");
		break;
	case CGarminLink2Event::Pid_Wpt_Data:
		strcpy (szFunc, "Pid_Wpt_Data");
		break;

	case CGarminLink2Event::Pid_Protocol_Array:
		strcpy (szFunc, "Pid_Protocol_Array");
		break;
	case CGarminLink2Event::Pid_Product_Rqst:
		strcpy (szFunc, "Pid_Product_Rqst");
		break;
	case CGarminLink2Event::Pid_Product_Data:
		strcpy (szFunc, "Pid_Product_Data");
		break;


	default:
		strcpy (szFunc, "GE_UNKNOWN");
		break;
	}
}

/************************************************************************
 *  ProtGarminLink2.cpp			W r i t e T o F i l e					*
 ************************************************************************/
void CProtGarminLink2::WriteToFile (CFile* ptFile, CGarminLink2Event* ptEvt)
{
	long	lLen;
	char	szFunc[32];
	char	szBuffer[256];

	unsigned char uFunc = ptEvt->GetFunction();
	FuncToString(uFunc, szFunc);

	long lDataLen = ptEvt->GetDataLen();
	unsigned char* ptData = ptEvt->GetDataPtr();

	if (ptData != NULL)
    {
    lLen = sprintf (szBuffer, "\r\nGPS sends %s (%d) with %ld bytes:\r\n", 
				szFunc, (short)uFunc, lDataLen);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

    if (ptData != NULL)
		{
		char szHexBuff[1024];
		long	lHexLen = 0;
		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, lDataLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		if (ptFile != NULL)
			ptFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
		}
    }
}

/************************************************************************
 *  Garmin.cpp				S e n d G 5 5 R e p l y						*
 ************************************************************************/
BOOL CProtGarminLink2::SendG55Reply (CGarminLink2Event* ptGE)
{
BOOL bStop = FALSE;
//unsigned char m_lpOut[256];

*(m_lpOut + 0) = 0x10;
*(m_lpOut + 1) = CGarminLink2Event::Pid_Ack_Byte;
*(m_lpOut + 2) = 0x02;

*(m_lpOut + 3) = ptGE->GetFunction();
*(m_lpOut + 4) = 0x00;

*(m_lpOut + 5) = this->FillByte (m_lpOut, 1, 4);
*(m_lpOut + 6) = 0x10;
*(m_lpOut + 7) = 0x03;

this->Write (m_lpOut, 8);

return TRUE;
}




/////////////////////////////////////////////////////////////////////////////
// CProtGarminLink2 diagnostics

#ifdef _DEBUG
void CProtGarminLink2::AssertValid() const
{
	CSerCom::AssertValid();
}

void CProtGarminLink2::Dump(CDumpContext& dc) const
{
	CSerCom::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CProtGarminLink2, CSerCom)
