#ifndef __PROT_GARMIN_LINK2__
#define __PROT_GARMIN_LINK2__

/*********************************************************************
 *					P r o t G a r m i n L i n k 2 . h			     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "GpsDevice.h"
#include "GarminLink2Ev.h"
#include "GarminProtocols.h"

class CFile;
class CProtGarminLink2 : public CGpsDevice
{    
DECLARE_DYNAMIC(CProtGarminLink2)
     
private:
	CGarminProtocols* m_ptProtocols;
	CFile*				m_ptLogFile;
	BOOL	m_bRealCommand;
	BOOL	m_bSimulateProtocolArray;

protected: // create from serialization only

// Attributes
// Operations
public:
	BOOL SendCommand (unsigned char uFunc, unsigned char* ptData, short nLen);
	BOOL SendCommand(unsigned char uCmd);
	BOOL SendAck(unsigned char uFunc);
	BOOL SendNoAck(unsigned char uFunc);
	BOOL SendProductRqst();
	BOOL SendNumberOfRecords(short nRecordCnt);
	short CalcRteTransRecords(short nWptCnt);
	BOOL SendTransferCompleted(short nCmd);

	void SimulateProtocolArray();
	BOOL IsRealCommand();

	void SetProtocols(short nProductID, double fSoftwareVersion);
	void SplitProtocols(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile);
	short GetPidProt();
	short GetCmndProt();
	short GetRteTrans();
	short GetRteWptProt();
	short GetRteHdrProt();
	short GetTrkPointProt();

// Implementation

public:
	CProtGarminLink2();
	virtual ~CProtGarminLink2();

	void SetLogFilePtr(CFile* ptFile) { m_ptLogFile = ptFile; }

	unsigned char FillByte (unsigned char* lpOut, short nFirstByte, short nLastByte);

	void CopyWptName (unsigned char* lpOut, short nOffs, short nBytes, 
						char* szName, short nLen);

	void SendGarminWpt(short nProt, double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt);
	void SendRteWpt(double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC, BOOL bStoreAsUserWpt);
	void SendWpt(double dLat, double dLon, CString szName,
			CString szIndic, short nCategory, double fAlt_m, short nCC);

	void SetZeroTermString(unsigned char* lpOut, short* ptOffs, char* szText, short nMaxLen);

	void SetSubClass (SubClassType* ptSubClass);
	void CheckGarminESC (BOOL bInsert, unsigned char* lpData, int* ptCnt, BOOL* ptHandleESC);

	BOOL GetNextGarminEvent (CGarminLink2Event* ptGE);
	void FuncToString (unsigned char uFunc, char* szFunc);
	void WriteToFile (CFile* ptFile, CGarminLink2Event* ptEvt);

	BOOL SendG55Reply (CGarminLink2Event* ptGE);

private:
	void ShiftArrayUp (unsigned char* lpData, long lCnt);
	void ShiftArrayDown (unsigned char* lpData, long lCnt);
	void SaveData (unsigned char uFunc, unsigned char* ptData, short nLen);


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
