// QFind.cpp : implementation of the CNameList class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

/*
Verwaltet die Listen zur Eingabeuntersttzung (CNameList) und
zur Kartendarstellung (CLaLoList).

Angelegt und gelscht in CInitDoc als m_ptQuickFind
Aufruf aus:
	CInitDlg::OnStartInit()
		nActRegIndex = ptQuickFind->CheckRegionNames(ptRegion, m_ptInit->GetLocDocPath());
		ptQuickFind->Update (nActRegIndex);

*/



#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"	 //includes "NameList.h"
#include "DimDoc.h"

#include "LocDoc.h"
#include "RegioDlg.h"				// dialog to set regions to use

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// lqsort

#define		THRESH		4		/* threshold for insertion */
#define		MTHRESH		6		/* threshold for median */

static	COMPFUNC qcmp ; 	/* the comparison routine */
static	int	 qsz;		/* size of each record */
static	unsigned thresh;	/* THRESHold in chars */
static	unsigned mthresh;	/* MTHRESHold in chars */
 
/************************************************************************
 *  NameList.cpp					q s t								*
 ************************************************************************/
static void qst(char far *base, char far *max)
{
register char c, far *i, far *j, far *jj;
register int ii;
char far *mid, far *tmp;
unsigned lo, hi;

lo = max - base;		/* number of elements as chars */
do  {
    mid = i = base + qsz * ((lo / qsz) >> 1);
    if (lo >= mthresh)
	{
	j = (qcmp((jj = base), i) > 0 ? jj : i);
	if (qcmp(j, (tmp = max - qsz)) > 0)
	    {			     /* switch to first loser */
	    j = (j == jj ? i : jj);
	    if (qcmp(j, tmp) < 0)
		    j = tmp;
	    }
	if (j != i)
	    {
	    ii = qsz;
	    do	{
		c    = *i;
		*i++ = *j;
		*j++ = c;
		} while (--ii);
	    }
	}
		/*  Semi-standard quicksort partitioning/swapping   */
    for (i = base, j = max - qsz; ; )
	{
	while (i < mid && qcmp(i, mid) <= 0)
		i += qsz;
	while (j > mid)
	    {
	    if (qcmp(mid, j) <= 0)
		{
		j -= qsz;
		continue;
		}
	    tmp = i + qsz;  /* value of i after swap */
	    if (i == mid)
		{	    /* j <-> mid, new mid is j */
		mid = jj = j;
		}
	    else{	    /* i <-> j */
		jj = j;
		j -= qsz;
		}
	    goto swap;
	    }

	if (i == mid)
	    {
	    break;
	    }
	else{		/* i <-> mid, new mid is i */
	    jj = mid;
	    tmp = mid = i;  /* value of i after swap */
	    j -= qsz;
	    }

	swap:
	ii = qsz;
	do  {
	    c = *i;
	    *i++ = *jj;
	    *jj++ = c;
	    } while (--ii);
	i = tmp;
	}

    i = (j = mid) + qsz;
    if ((lo = j - base) <= (hi = max - i))
	{
	if (lo >= thresh)
	    qst(base, j);
	base = i;
	lo = hi;
	}
    else{
	if (hi >= thresh)
		qst(i, max);
	max = j;
	}
    } while (lo >= thresh);
}


/************************************************************************
 *  NameList.cpp  		 			l q s o r t 						*
 ************************************************************************/
void lqsort(void far *base, long n, unsigned size, COMPFUNC compar)
{
register char c, far *i, far *j, far *lo, far *hi;
char far *min, far *max;

if (n <= 1)
    return;
qsz = size;
qcmp = compar;
thresh = qsz * THRESH;
mthresh = qsz * MTHRESH;
max = (char far *)base + n * qsz;
if (n >= THRESH)
    {
    qst((char far *)base, max);
    hi = (char far *)base + thresh;
    }
else{
    hi = max;
    }

for (j = lo = (char  far *)base; (lo += qsz) < hi; )
    if (qcmp(j, lo) > 0)
	j = lo;

if (j != base)
    {			    /* swap j into place */
    for (i = (char far *)base, hi = (char far *)base + qsz; i < hi; )
		{
		c    = *j;
		*j++ = *i;
		*i++ = c;
		}
    }

for (min = (char far *)base; (hi = min += qsz) < max; )
    {
    while (qcmp(hi -= qsz, min) > 0)
	/* void */;

    if ((hi += qsz) != min)
		{
		for (lo = min + qsz; --lo >= min; )
		    {
		    c = *lo;
		    for (i = j = lo; (j -= qsz) >= hi; i = j)
			    *i = *j;
		    *i = c;
		    }
		}
    }
}
 
/************************************************************************
 *  NameList.cpp				l N a m e C m p					*
 ************************************************************************/
int lNameCmp (void FAR* elem1, void FAR* elem2)
{
int	cmpVal ;
LPSTR	p_1, p_2 ;

p_1 = (LPSTR)&(((NAMEINDEXTYPE FAR*)elem1)->szName);
p_2 = (LPSTR)&(((NAMEINDEXTYPE FAR*)elem2)->szName);
cmpVal = _fstricmp ( p_1, p_2 );
		 
return cmpVal;
} /* End of NameListCmp() */ 
 

/////////////////////////////////////////////////////////////////////////////
// CRegion

CRegion::CRegion()
{
	// TODO: add one-time construction code here  
m_nCnt	= -1;
m_bActiv = FALSE;
}

CRegion::CRegion(CString szName, short nCnt, BOOL bActiv)
{
	// TODO: add one-time construction code here  
m_szName = szName;
m_nCnt	= nCnt;
m_bActiv = bActiv;
}

void CRegion::GetName (char* szName)
{
short nCopyLen;
//m_szName --> char	szName[SIZEOF_REGNAME];

memset (szName, 0, SIZEOF_REGNAME);
nCopyLen = m_szName.GetLength();
if (nCopyLen >= SIZEOF_REGNAME)
	nCopyLen = SIZEOF_REGNAME - 1;

strncpy (szName, (LPCTSTR)m_szName, nCopyLen);
}	

CRegion::~CRegion()
{   
m_nCnt	= -1;
m_bActiv = FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// CNameList

/////////////////////////////////////////////////////////////////////////////
// CNameList construction/destruction

CNameList::CNameList()
{
	// TODO: add one-time construction code here  
m_ptNameList		= NULL;
m_lNameListMax		= 0; 
m_lNameListIndex	= 0;

m_nAddRegionIndex	= -1; 
m_ptDoc = 0; 
}

CNameList::~CNameList()
{   
this->Free();
}


/************************************************************************
 *  NameList.cpp					A l l o c							*
 ************************************************************************/
BOOL CNameList::Alloc (long lCnt)
{
BOOL bOK = TRUE;

this->Free();

if (lCnt > 0)
	{
 	m_ptNameList = new NAMEINDEXTYPE[lCnt];   
	if (m_ptNameList != NULL)  
		{
		m_lNameListMax = lCnt;  
		m_lNameListIndex = 0;
		}    
	else{
		bOK = FALSE;
		}
	}

return bOK;
}

/************************************************************************
 *  NameList.cpp					F r e e								*
 ************************************************************************/
void CNameList::Free ()
{
if (m_lNameListMax > 0)
	{
	delete [] m_ptNameList;
	m_ptNameList 	= NULL;
	m_lNameListMax  = 0; 
	m_lNameListIndex = 0;
	}
}

/************************************************************************
 *  NameList.cpp				S e t E n t r y							*
 ************************************************************************/
void CNameList::SetEntry (NAMEINDEXTYPE* ptSL, CString szName,
					short nCategory, short nIndex, short nRegIndex)
{
_fstrcpy (ptSL->szName, (LPCTSTR)szName);
ptSL->nCategory		= nCategory;
ptSL->nIndex		= nIndex;
ptSL->nRegionIndex	= nRegIndex;
}

/************************************************************************
 *  NameList.cpp				A d d E n t r y							*
 ************************************************************************/
void CNameList::AddEntry (CLocation* ptLocation, short nSubListIndex)
{
	if (m_nAddRegionIndex != -1)
	{
		NAMEINDEXTYPE* ptEntry;

		CString szName  = ptLocation->GetName();
		CString szIndic = ptLocation->GetIndicator();
		short nCategory = ptLocation->GetCategory();

		if (m_lNameListIndex < m_lNameListMax)
		{
			if (m_ptNameList != NULL)
			{
				if (szName.GetLength() > 0)
				{
					ptEntry = m_ptNameList + m_lNameListIndex;     
					this->SetEntry (ptEntry, szName,
												   nCategory,
												   nSubListIndex,
												   m_nAddRegionIndex);
					m_lNameListIndex++;
				}


				if (szIndic.GetLength() > 0)
				{
					if (szIndic.CompareNoCase(szName) != 0)
					{		// if szIndic != szName, store second entry for this location
						ptEntry = m_ptNameList + m_lNameListIndex;     
						this->SetEntry (ptEntry, szIndic,
													   nCategory,
													   nSubListIndex,
													   m_nAddRegionIndex);

						m_lNameListIndex++;
					}
				}
			}
		}
		else
		{
			AfxMessageBox ("NameList-Array limit reached");
		}
	}
}

/************************************************************************
 *  NameList.cpp					S o r t								*
 ************************************************************************/
void CNameList::Sort ()
{
if (m_lNameListIndex > 1 )
    {
     if (m_ptNameList != NULL)
		{
		lqsort((void FAR*)m_ptNameList, (long)m_lNameListIndex,
		       (unsigned)sizeof (NAMEINDEXTYPE), lNameCmp);
		}
    }
}   

/************************************************************************
 *  NameList.cpp		    	G e t I n d e x R a n g e				*
 *  Simple way to search names
 ************************************************************************/
BOOL CNameList::GetIndexRange (const char* ptName, long* ptFirst, long* ptLast)
{
BOOL bFound = FALSE;
BOOL bStop = FALSE;
long lCnt = this->GetSize();
long i;

for (i=0; i<lCnt && !bStop; i++)
	{
	NAMEINDEXTYPE* ptEntry=NULL;
	ptEntry = this->GetEntryPtr (i);
	if (ptEntry != NULL)
		{
		if (_fstricmp (ptName, (LPSTR)ptEntry->szName) == 0)
			{			    /* Name found	*/
			if (!bFound)
				{
				bFound = TRUE;
				*ptFirst = *ptLast = i;
				}
			else{
				*ptLast = i;		
				}
			}
		else{
			if (bFound)
				bStop = TRUE;
			}
		}
	}
return bFound;
}

/************************************************************************
 *  NameList.cpp	  		 G e t S o r t e d I n d					*
 *  Used in: GetSortedIndexRange										*	 
 ************************************************************************/
BOOL CNameList::GetSortedInd (const char* ptName, long* ptIndex, BOOL bCaseSensitive)
{
BOOL	bFound = FALSE;
BOOL	bUpperIntervall; 
long	lMinIndex, lMaxIndex, i, OldTestInd;

lMinIndex  = 0;
lMaxIndex  = this->GetSize();			/* legal ind: 0...cnt-1		*/
i = (lMinIndex + lMaxIndex) / 2;		/* i always < cnt !!		*/

if (lMaxIndex > 0)
	{
	int iCmp=1;

	do	{  
		NAMEINDEXTYPE* ptEntry=NULL;
		ptEntry = this->GetEntryPtr (i);
		if (ptEntry != NULL)
			{
			if (bCaseSensitive)
						iCmp = _fstrcmp ((LPSTR)ptName, (LPSTR)ptEntry->szName);
				else	iCmp = _fstricmp ((LPSTR)ptName, (LPSTR)ptEntry->szName);

			if (iCmp >=0)	bUpperIntervall = TRUE;
	    			else	bUpperIntervall = FALSE;

			if (bUpperIntervall)	lMinIndex = i;
							else	lMaxIndex = i;
					
			OldTestInd = i;
			i = (lMinIndex + lMaxIndex) / 2;
			}
		} while (i != OldTestInd);

	if (iCmp == 0)
		{
		*ptIndex = i;
		bFound = TRUE;
		}
	}                     
   
return bFound;
}

/****************************************************************************
 *	QFind.cpp					I n d e x T o R a n g e						*
 ****************************************************************************/
void CNameList::IndexToRange (long* ptFirstInd, long lIndex, long* ptLastInd)
{
BOOL bSameName;
NAMEINDEXTYPE* ptEntry=NULL;
long	j;						
char	szNameForRte[SIZEOF_ORT];
long	lCnt= this->GetSize();

*ptFirstInd = *ptLastInd = lIndex;

ptEntry = this->GetEntryPtr (lIndex);
if (ptEntry != NULL)
	{
	strcpy (szNameForRte, ptEntry->szName);
	
	bSameName = TRUE;				// get first index with same name	
	for (j=lIndex-1; j>=0 && bSameName; j--)
		{
		ptEntry = this->GetEntryPtr (j);
		if (ptEntry != NULL)
			{			   
			bSameName = (_fstricmp (ptEntry->szName, szNameForRte) == 0);
			if (bSameName) (*ptFirstInd)--;
			}
		}
	
	bSameName = TRUE;				// get last index with same name	
	for (j=lIndex+1; j<lCnt && bSameName; j++)
		{
		ptEntry = this->GetEntryPtr (j);
		if (ptEntry != NULL)
			{
			bSameName = (_fstricmp (ptEntry->szName, szNameForRte) == 0);
			if (bSameName) (*ptLastInd)++;
			}
		}
	}
}

/****************************************************************************
 *	QFind.cpp					I n d e x T o R a n g e	N					*
 ****************************************************************************/
BOOL CNameList::IndexToRangeN (short nCmpLen, long* ptFirstInd, long lIndex, long* ptLastInd)
{
BOOL bSameName;
NAMEINDEXTYPE* ptEntry=NULL;
long	j;						
char	szNameForRte[SIZEOF_ORT];
long	lCnt = this->GetSize();

*ptFirstInd = *ptLastInd = lIndex;

ptEntry = this->GetEntryPtr (lIndex);
if (ptEntry != NULL)
	{
	strcpy (szNameForRte, ptEntry->szName);
	if (nCmpLen > 1)					// delete abbreviation dot
		if (*(szNameForRte+nCmpLen-1)=='.') 
			{
			nCmpLen--;
			*(szNameForRte+nCmpLen) = 0;
			}
	
	bSameName = TRUE;				// get first index with same name	
	for (j=lIndex-1; j>=0 && bSameName; j--)
		{
		ptEntry = this->GetEntryPtr (j);
		if (ptEntry != NULL)
			{
			bSameName = (_fstrnicmp (ptEntry->szName, szNameForRte, nCmpLen) == 0);
			if (bSameName) (*ptFirstInd)--;
			}
		}
	
	bSameName = TRUE;				// get last index with same name	
	for (j=lIndex+1; j<lCnt && bSameName; j++)
		{
		ptEntry = this->GetEntryPtr (j);
		if (ptEntry != NULL)
			{
			bSameName = (_fstrnicmp (ptEntry->szName, szNameForRte, nCmpLen) == 0);
			if (bSameName) (*ptLastInd)++;
			}
		}
	}
	
return (*ptFirstInd != *ptLastInd);
}

/************************************************************************
 *  QFind.cpp		    G e t S o r t e d I n d e x R a n g e			*
 *  Purpose: To find location while mouse is moving						*
 ************************************************************************/
BOOL CNameList::GetSortedIndexRange (const char* ptName, long* ptFirst, long* ptLast)
{
BOOL bFound = FALSE;
long lIndex;
if (this->GetSortedInd (ptName, &lIndex))
	{
	this->IndexToRange (ptFirst, lIndex, ptLast);	
	bFound = TRUE;
	}
return bFound;
}

/************************************************************************
 *  NameList.cpp		    G e t R e g i o n N a m e					*
 ************************************************************************/
CString CNameList::GetRegionName (short nRegIndex)
{
CString szRegion;

if (nRegIndex >=0 && nRegIndex < m_ptRegions->GetSize())
	{
	CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(nRegIndex);
	if (ptRegion != NULL)
		{
		szRegion = ptRegion->GetName();
		}
	}
return szRegion;
}


/************************************************************************
 *  NameList.cpp		    		G e t L o c							*
 ************************************************************************/
BOOL CNameList::GetLoc (CLocation* ptLoc, long lIndex, short* ptActRegInd)
{
BOOL bOK = FALSE;
long lCnt = this->GetSize();

if (lIndex >=0 && lIndex < lCnt)
	{
	NAMEINDEXTYPE* ptEntry=NULL;
	ptEntry = this->GetEntryPtr (lIndex);
	if (ptEntry != NULL)
		{
		*ptActRegInd = ptEntry->nRegionIndex;

		if (*ptActRegInd >=0 && *ptActRegInd < m_ptRegions->GetSize())
			{
			if (m_ptDoc->GetRegionIndex() != *ptActRegInd)
				{			// switch to required region
				CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(*ptActRegInd);
				if (ptRegion != NULL)
					{
					CString szRegion = ptRegion->GetName();
					m_ptDoc->OnNewDocument(); 			// deletes old structures   
					m_ptDoc->OnOpenDocument (m_szLocPath + szRegion + (CString)".krd");
					m_ptDoc->SetRegionIndex (*ptActRegInd);
					}
				}
			*ptLoc = m_ptDoc->GetLocation (ptEntry->nCategory, ptEntry->nIndex);
			bOK = (ptLoc != NULL);
			}
		}
	}
return bOK;
}


/************************************************************************
 *  NameList.cpp		    S e t A c t R e g I n d e x 				*
 ************************************************************************/
short CNameList::SetActRegIndex (CLocation& Loc)
{
BOOL bFound = FALSE;
CString szName;
long	lFirstIndex, lLastIndex;
short	nActRegIndex = -1;

szName = Loc.GetName();

if (this->GetIndexRange ((LPCTSTR)szName, &lFirstIndex, &lLastIndex))
	{
	long i;

	for (i=lFirstIndex; i<=lLastIndex && !bFound; i++)
		{
		CLocation FoundLoc;		   // sets m_nRegionIndex in LocDoc!!
		this->GetLoc (&FoundLoc, i, &nActRegIndex);	
		bFound = Loc.IsEqual (FoundLoc);
		if (!bFound) nActRegIndex = -1;
		}
	}
return nActRegIndex;
}


/************************************************************************
 *  NameList.cpp	  		 G e t S o r t e d I n d e x N				*
 *  Used in: FindBestName
 ************************************************************************/
BOOL CNameList::GetSortedIndexN (const char* ptName, short CmpLen, long* ptIndex)
{
BOOL	bFound = FALSE;
BOOL	bUpperIntervall; 
long	lMinIndex, lMaxIndex, i, OldTestInd;
long	lCnt = this->GetSize();

lMinIndex  = 0;
lMaxIndex  = lCnt;							/* legal ind: 0...cnt-1		*/
i = (lMinIndex + lMaxIndex) / 2;			/* i always < cnt !!		*/

if (lMaxIndex > 0)
   {
   int iCmp=1;

   do	{  
		NAMEINDEXTYPE* ptEntry=NULL;
		ptEntry = this->GetEntryPtr (i);
		if (ptEntry != NULL)
			{
			iCmp = _fstrnicmp ((LPSTR)ptName, (LPSTR)ptEntry->szName, CmpLen);

			if (iCmp >=0)	bUpperIntervall = TRUE;
	    			else	bUpperIntervall = FALSE;

			if (bUpperIntervall)	lMinIndex = i;
							else	lMaxIndex = i;
					
			OldTestInd = i;
			i = (lMinIndex + lMaxIndex) / 2;
			}
		} while (i != OldTestInd);

	if (iCmp == 0)
		{
		*ptIndex = i;
		bFound = TRUE;
		}
	}                     
   
return bFound;
}

/************************************************************************
 *  NameList.cpp		    F i n d B e s t N a m e						*
 *  Purpose: To find name of location while typing new name				*
 ************************************************************************/
BOOL CNameList::FindBestName (char* ptName, short CmpLen)
{
BOOL	bFound = FALSE;
long i;

if (this->GetSortedIndexN (ptName, CmpLen, &i))
	{
	NAMEINDEXTYPE* ptEntry=NULL;
	ptEntry = this->GetEntryPtr (i);
	if (ptEntry != NULL)
		{					/* Ort found	*/
		strcpy (ptName, ptEntry->szName);
		bFound = TRUE;
		}
	}

return bFound;
}


/////////////////////////////////////////////////////////////////////////////
// CQuickFind

/////////////////////////////////////////////////////////////////////////////
// CQuickFind construction/destruction
IMPLEMENT_SERIAL(CQuickFind, CObject, 0 /* schema number*/ )

/************************************************************************
 *  QFind.cpp					CQuickFind							*
 ************************************************************************/
CQuickFind::CQuickFind()
{
	// TODO: add one-time construction code here  
	m_ptNameList = new CNameList;
	m_ptLaLoList = new CLaLoList;
}

/************************************************************************
 *  QFind.cpp					~ C Q u i c k F i n d					*
 ************************************************************************/
CQuickFind::~CQuickFind()
{   
this->Free();
this->DeleteArrayOfRgn (&m_Regions);
delete m_ptNameList;
delete m_ptLaLoList;
}

/************************************************************************
 *  QFind.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CQuickFind::DeleteArrayOfRgn (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CRegion* ptEntry;
	if ((ptEntry = (CRegion*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting QuickFind Region %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}

/************************************************************************
 *  QFind.cpp					A l l o c								*
 ************************************************************************/
BOOL CQuickFind::Alloc (long lCnt)
{
BOOL bOK1, bOK2;

bOK1 = m_ptNameList->Alloc (2*lCnt);
bOK2 = m_ptLaLoList->Alloc (lCnt);

return (bOK1 && bOK2);
}

/************************************************************************
 *  QFind.cpp					F r e e								*
 ************************************************************************/
void CQuickFind::Free ()
{
m_ptNameList->Free();
m_ptLaLoList->Free();
}

/************************************************************************
 *  QFind.cpp					SetLocDocPtr							*
 ************************************************************************/
void CQuickFind::SetLocDocPtr (CLocDoc* ptLocDoc) 
{ 				  
m_ptDoc = ptLocDoc;
m_ptNameList->SetLocDocPtr (ptLocDoc);
m_ptLaLoList->SetLocDocPtr (ptLocDoc);
}

/************************************************************************
 *  QFind.cpp					GetTotalEntryCnt						*
 ************************************************************************/
long CQuickFind::GetTotalEntryCnt()
{
long lTotalSize = 0;
short i;
short nRegCnt = m_Regions.GetSize(); 

for (i=0; i<nRegCnt; i++)
	{							// get total number of all waypoints
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);
	if (ptRegion != NULL)
		{
		if (ptRegion->GetCnt() >= 0)
			 lTotalSize += ptRegion->GetCnt();
		else AfxMessageBox ("Region Cnt = -1");
		} 		
	}
return lTotalSize;
}

/************************************************************************
 *  QFind.cpp					G e t R e g i o n C n t					*
 ************************************************************************/
short CQuickFind::GetRegionCnt()
{
short nRegCnt = m_Regions.GetSize(); 
return nRegCnt;
}

/************************************************************************
 *  QFind.cpp				R e g i o n S e t C n t						*
 ************************************************************************/
BOOL CQuickFind::RegionSetCnt (short nIndex, short nCnt)
{
BOOL	bChanged = FALSE;

CRegion* ptRegion = (CRegion*)m_Regions.GetAt (nIndex);
if (ptRegion != NULL)
	{
	ptRegion->SetCnt(nCnt);
	bChanged = TRUE;
	}
return bChanged;
}

/************************************************************************
 *  QFind.cpp				A d d E n t r y							*
 ************************************************************************/
void CQuickFind::AddEntry (CLocation* ptLocation, short nSubListIndex)
{
m_ptNameList->AddEntry (ptLocation, nSubListIndex);	    
m_ptLaLoList->AddEntry (ptLocation, nSubListIndex);	      
}

/************************************************************************
 *  QFind.cpp					S o r t								*
 ************************************************************************/
void CQuickFind::Sort ()
{
m_ptNameList->Sort();
m_ptLaLoList->Sort();
}  

/************************************************************************
 *  QFind.cpp			S e t R e g i o n I n d e x 					*
 ************************************************************************/
void CQuickFind::SetRegionIndex (short nIndex)
{
m_ptNameList->SetRegionIndex (nIndex);
m_ptLaLoList->SetRegionIndex (nIndex);
} 

/****************************************************************************
 *	QFind.cpp					G e t E n t r y C n t						*
 ****************************************************************************/
short CQuickFind::GetEntryCnt (CString szFullPath)
{
short nCnt;

CFile LocFile((LPCTSTR)szFullPath, CFile::modeRead);
DWORD dwLength = (DWORD)LocFile.GetLength();
DWORD dwBlockSize = sizeof (KOORDTYPE);
nCnt = (short)((dwLength - MAX_HEADER_SIZE) / dwBlockSize);

return nCnt;
}

/****************************************************************************
 *	QFind.cpp				RegionNameToIndex				*
 ****************************************************************************/
short CQuickFind::RegionNameToIndex (CString szRegNameExt)
{
short nIndex, i;
BOOL	bFound = FALSE;

nIndex = -1;
for (i=0; i<m_Regions.GetSize() && !bFound; i++)
	{
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);

	if (ptRegion != NULL)
		{
		CString szNameExt = ptRegion->GetName() + ".krd";
		if (szRegNameExt.CompareNoCase (szNameExt) == 0)
			{
			nIndex = i;
			bFound = TRUE;
			}
		}
	}
return nIndex;
}


/****************************************************************************
 *	QFind.cpp				G e t R e g i o n P t r 					*
 ****************************************************************************/
CRegion* CQuickFind::GetRegionPtr (CString szName)
{
short i;
BOOL	bFound = FALSE;
CRegion* ptRegion;

for (i=0; i<m_Regions.GetSize() && !bFound; i++)
	{
	ptRegion = (CRegion*)m_Regions.GetAt(i);

	if (ptRegion != NULL)
		{
		CString szTestName = ptRegion->GetName();
		bFound = (szTestName.CompareNoCase (szName) == 0);
		}
	}
if (!bFound)
	ptRegion = NULL;

return ptRegion;
}

/************************************************************************
 *  QFind.cpp	  			G e t S o r t e d I n d	e x					*
 ************************************************************************/
short CQuickFind::GetSortedIndex (CObArray& Regions, CRegion& Region)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

IndMin  = 0;
IndMax  = Regions.GetSize();				/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;					/* i always < cnt !!		*/

CString szName = Region.GetName();

if (Regions.GetSize() > 0)
   {
   do	{  
		CRegion* ptRegion = (CRegion*)Regions.GetAt(i);
        CString szTestName = ptRegion->GetName();
        
        int iCmp = szName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  QFind.cpp	  			G e t S o r t e d I n d	e x					*
 ************************************************************************/
short CQuickFind::GetSortedIndex (CStringArray& List, CString& szText)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

IndMin  = 0;
IndMax  = List.GetSize();				/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!		*/

if (List.GetSize() > 0)
   {
   do	{  
        CString szTestName = List.GetAt((int)i);
        
        int iCmp = szText.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}


/****************************************************************************
 *	QFind.cpp						E n u m F i l e s						*
 ****************************************************************************/
short CQuickFind::EnumFiles (CStringArray* ptRegions, CString szSearchPath)
{
short	nCnt=0;

if (ptRegions != NULL)
	{
	ptRegions->RemoveAll();				// delete old region array

	CFileFind finder;

	BOOL bWorking = finder.FindFile((LPCTSTR)szSearchPath);
	while (bWorking)
		{
		short	nIndex;
		bWorking = finder.FindNextFile();
		CString szFile = finder.GetFileName();
		nIndex = CQuickFind::GetSortedIndex (*ptRegions, szFile);
		ptRegions->InsertAt(nIndex, szFile);
	//	ptRegions->Add(finder.GetFileName());
		}
	nCnt = ptRegions->GetSize();
	}

/*
									// use a CComboBox for 16-Bit applications
ptComboRegions->ResetContent();			// delete old region popup
int iRetVal = ptComboRegions->Dir (DDL_READWRITE, (LPCSTR)szPath);
if (iRetVal != CB_ERR)		 // iRetVal = zero-based index of the last filename 
	{
	for (i=0; i<=iRetVal; i++)
		{
		CString szNameExt;
		ptComboRegions->GetLBText (i, szNameExt);
		ptRegions->Add (szNameExt);
		}
	}	 
*/


return nCnt;
}

/****************************************************************************
 *	QFind.cpp				C h e c k R e g i o n N a m e s 				*
 ****************************************************************************/
short CQuickFind::CheckRegionNames (CStringArray* ptRegions, CString szFullName)
{   
CString szOldName;
short	i;				
short	nActRegIndex = -1;
short	nFirstActivated = -1;
BOOL	bOldNameOK = FALSE;

	          				// get path name for koord database
short	nNameIndex = szFullName.ReverseFind('\\') + 1;
CString szPath = szFullName.Left (nNameIndex);
m_szLocPath = szPath;

szOldName = szFullName.Right (szFullName.GetLength() - nNameIndex);

m_ptNameList->SetLocPath (szPath);
m_ptLaLoList->SetLocPath (szPath);

szPath += (CString)"*.krd";             

short nCnt = this->EnumFiles (ptRegions, szPath);
if (nCnt > 0)		
	{	 
	for (i=0; i<nCnt; i++)
		{
		CString szNameExt;
		szNameExt = ptRegions->GetAt (i);
		short nDotIndex = szNameExt.ReverseFind ('.');
		if (nDotIndex > 0)		 // at least one char remains for name
			{						// open file, convert and sort
			m_ptDoc->OnNewDocument(); 			  
			m_ptDoc->SetRegionIndex (i); 
			if (m_ptDoc->OnOpenDocument (m_szLocPath + szNameExt))
				m_ptDoc->SortAllCategories();
				
			short	nCnt = this->GetEntryCnt (m_ptDoc->GetPathName());

			CRegion* ptRegion;
			CString szName = m_ptDoc->GetActRegionName();	// Germany
				
			ptRegion = this->GetRegionPtr (szName);
			if (ptRegion != NULL)
				{				// region was read from *.ini
				ptRegion->SetCnt(nCnt);		// set counter here!
				}
			else{				// there is a new region!!
				ptRegion = new CRegion (szName, nCnt, FALSE);
				short nIndex = this->GetSortedIndex (m_Regions, *ptRegion);
				m_Regions.InsertAt(nIndex, ptRegion);
				}

						// OnSaveDocument must be called after m_Regions.Add
						// in CLocDoc::Serialize RegionSetCnt uses last array element
			if (m_ptDoc->WasConverted() || m_ptDoc->WasSorted())
				{					// save converted or sorted file
				CString szPath = m_ptDoc->GetPathName(); 
				BOOL bConfirm = FALSE;
				if (m_ptDoc->OnSaveDocument (szPath, bConfirm))
					{
					if (ptInit->IsSaveSignal())
						MessageBeep(MB_OK);	
					}
				}
			} 
		} 
	}
else{
	AfxMessageBox (IDS_NOLOCDATA);
	}


m_ptDoc->OnNewDocument(); 

i=0;				// delete regions not found on disk:
while (i < m_Regions.GetSize())
	{				// and store first activated region ID
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);
	if (ptRegion != NULL)
		{			// delete if counter == -1
		if (ptRegion->GetCnt() == -1)	 // see ::Serialize
			{
			if (ptRegion->GetName().CompareNoCase("Germany") == 0 &&
				!ptInit->IsJustInstalled())
			{		// don't show warning, if Germany is missing after installation
				CString szFormat;      
				char	szBuffer[64];
				szFormat.LoadString (IDF_MISSING_RGN);
				sprintf (szBuffer, (LPCTSTR)szFormat, 
								   (LPCTSTR)ptRegion->GetName());
				AfxMessageBox((LPSTR)szBuffer);
			}
			m_Regions.RemoveAt (i);
			delete ptRegion;
			}
		else{
			if (nFirstActivated == -1)
				{
				if (ptRegion->IsActiv())
					nFirstActivated = i; // store first activated ID
				}
			i++;
			}
		}
	}
	

nActRegIndex = this->RegionNameToIndex (szOldName);
if (nActRegIndex >= 0)
	{
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(nActRegIndex);
	if (ptRegion != NULL)
		bOldNameOK = ptRegion->IsActiv();
	}

if (!bOldNameOK && nFirstActivated >= 0)
	{
	nActRegIndex = nFirstActivated;
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(nActRegIndex);
	if (ptRegion != NULL)
		szFullName = m_szLocPath + ptRegion->GetName() + (CString)".krd";
	}



if (nActRegIndex == -1 &&			// szOldName not found in actual region lists
	nFirstActivated == -1)			// no previous activated locdoc available
	{
	if (m_Regions.GetSize() > 0)
		{							// activate first region
		nActRegIndex = 0;
		CRegion* ptRegion = (CRegion*)m_Regions.GetAt(nActRegIndex);
		if (ptRegion != NULL)
			{
			ptRegion->SetActiv(TRUE);
			szFullName = m_szLocPath + ptRegion->GetName() + (CString)".krd";
			}
		}
	}

ptInit->SetLocDocPath(szFullName);    
m_ptDoc->SetPathName (szFullName);

return nActRegIndex;	
}


/************************************************************************
 *  QFind.cpp			A c t i v a t e R e g i o n						*
 ************************************************************************/
void CQuickFind::ActivateRegion (short nRegIndex)
{
if (nRegIndex >= 0 && nRegIndex < m_Regions.GetSize())
	{
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(nRegIndex);
	if (ptRegion != NULL)
		ptRegion->SetActiv(TRUE);
	}
}

/************************************************************************
 *  QFind.cpp				A d d R e g i o n s							*
 ************************************************************************/
void CQuickFind::AddRegions (CLocDoc* ptLocDoc)
{	
short i;
									// NameList and LaLoList arrays
									// have to be already allocated

CString szActLocPath = ptLocDoc->GetPathName();

m_ptNameList->SetRegionPtr (&m_Regions);
m_ptLaLoList->SetRegionPtr (&m_Regions);     

for (i=0; i<m_Regions.GetSize(); i++)
	{
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);

	if (ptRegion != NULL)
		{
		if (ptRegion->IsActiv())
			{
			CString szRegion = ptRegion->GetName();

			this->SetRegionIndex (i);		// activate creating new QFind lists

			ptLocDoc->OnNewDocument(); 			// deletes old structures  
			ptLocDoc->OnOpenDocument (m_szLocPath + szRegion + (CString)".krd");
			ptLocDoc->SetRegionIndex (i); 
			}
		}
	}

							// stop adding entries into QFind lists
this->SetRegionIndex (-1);

ptLocDoc->OnNewDocument(); 			// deletes old structures   
ptLocDoc->SetPathName(szActLocPath);
}


/****************************************************************************
 *	QFind.cpp				F i l l R e g i o n P U							*
 ****************************************************************************/
void CQuickFind::FillRegionPU (CComboBox* ptRegionPU)
{   
short i;
for (i=0; i<m_Regions.GetSize(); i++)
	{
	CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);

	if (ptRegion != NULL)
		{
		CString szRegion = ptRegion->GetName();
		ptRegionPU->AddString ((LPCTSTR)szRegion);
		}
	}
}

/************************************************************************
 *  QFind.cpp	  		 	G e t H o m e B a s e						*
 *  try to find szName in database										*
 ************************************************************************/
BOOL CQuickFind::GetHomeBase (CString szName, CLocation* ptLoc)
{
BOOL	bFound = FALSE;
long lFirstIndex, lLastIndex;

CNameList*	ptNameList = this->GetNameListPtr();

if (ptNameList->GetSortedIndexRange ((LPCTSTR)szName, &lFirstIndex, &lLastIndex))
	{
	short	nRegIndex;
	CLocation FoundLoc;
	if (ptNameList->GetLoc (&FoundLoc, lFirstIndex, &nRegIndex))
		{
		if (FoundLoc.IsValid())
			{
			*ptLoc = FoundLoc;
			bFound = TRUE;
			}
		}
	}
return bFound;
}


/************************************************************************
 *  QFind.cpp	  		 	G e t H o m e B a s e						*
 *  try to find first airport in database								*
 ************************************************************************/
BOOL CQuickFind::GetHomeBase (CLocation* ptLoc)
{
	BOOL	bFound = FALSE;

	CNameList*	ptNameList = this->GetNameListPtr();

	for (long i=0; i<ptNameList->GetSize() && !bFound; i++)
	{
		short	nRegIndex;
		CLocation FoundLoc;
		if (ptNameList->GetLoc (&FoundLoc, i, &nRegIndex))
		{
			if (FoundLoc.IsValid())
			{
				if (FoundLoc.GetCategory() == WP_AIRPORT)
				{
					*ptLoc = FoundLoc;
					bFound = TRUE;
				}
			}
		}
	}

	return bFound;
}

/************************************************************************
 *  QFind.cpp  		 		 U p d a t e		 						*
 *  Creates new lists for quick waypoint input and map drawing			*
 ************************************************************************/
BOOL CQuickFind::Update(short nActRegIndex)
{ 
BOOL	bOK = FALSE;
 
long lTotalSize = this->GetTotalEntryCnt();

if (this->Alloc(lTotalSize))	// free old and allocate new memory         
	{							// for CNameList and CLaLoList
	this->AddRegions(m_ptDoc);
	this->Sort ();
	bOK = TRUE;
	}
else{
	AfxMessageBox (IDS_REDUCEREGIONS);
	}

m_ptDoc->OnOpenDocument (m_ptDoc->GetPathName()); 
m_ptDoc->SetRegionIndex (nActRegIndex);	// restore actual LocDoc 

return bOK;
}

/************************************************************************
 *  QFind.cpp  		 		 C h a n g e 								*
 ************************************************************************/
BOOL CQuickFind::Change(CWnd* ptWnd)
{  
BOOL 	bChanged = FALSE;

CRegionDlg RegionDlg(ptWnd, &m_Regions, m_ptDoc);

int RetVal = RegionDlg.DoModal();
switch (RetVal)
	{
	case IDOK:
		this->Update(m_ptDoc->GetRegionIndex());
		bChanged = TRUE;
 		break;
	case IDCANCEL: 
		break;
	}		
return bChanged;	
} 

/************************************************************************
 *  QFind.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CQuickFind::Serialize(CArchive& ar)
{    
WORD	Word;
short	nRegionCnt, i;
BOOL	bActivated;
char	szName[SIZEOF_REGNAME];

if (ar.IsStoring())
	{				// TODO: add storing code here   
	nRegionCnt = m_Regions.GetSize();

 	ar << (WORD)nRegionCnt;

	for (i=0; i<nRegionCnt; i++)
		{
		CRegion* ptRegion = (CRegion*)m_Regions.GetAt(i);
		if (ptRegion != NULL)
			{
			ptRegion->GetName (szName);
			ar.Write (&szName, SIZEOF_REGNAME);		   
			ar << (WORD)ptRegion->IsActiv();
			}
		}
	}
else{					// TODO: add region data here    
 	ar.Read (&nRegionCnt, sizeof(short));
	
	for (i=0; i<nRegionCnt; i++)
		{
		ar.Read (szName, SIZEOF_REGNAME);

											// remove extention if available
		CString szRegion(szName);	    	// Germany.krd  	  ??
		short nDotIndex = szRegion.ReverseFind('.');
		if (nDotIndex >= 0) szRegion = szRegion.Left (nDotIndex);	// Germany

		ar >> Word;		bActivated=(BOOL)Word;

		short	nCnt = -1;			// will be set while reading from disk!
		CRegion* ptRegion = new CRegion (szRegion, nCnt, bActivated);
		short nIndex = CQuickFind::GetSortedIndex (m_Regions, *ptRegion);
		m_Regions.InsertAt(nIndex, ptRegion);
		}
	}
}
