// QFind.h : interface of the CNameList class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#ifndef __PF_QUICKFIND__
#define __PF_QUICKFIND__


typedef int (* COMPFUNC)(void far *,void far *);
void lqsort(void far *base, long n, unsigned size, COMPFUNC compar);

 typedef struct
	{
	char	szName[SIZEOF_ORT];
	short	nCategory;
	short	nIndex;						// region relative index!!
	short	nRegionIndex;
	} NAMEINDEXTYPE;

#include "Region.h"
#include "LaLoList.h"

class CLocDoc;	


class CNameList : public CObject
{         
private:
	NAMEINDEXTYPE*	m_ptNameList;
	long			m_lNameListMax; 
	long			m_lNameListIndex;

	CLocDoc*		m_ptDoc;
	CObArray*		m_ptRegions;	// to convert ListIndex to CLocation

	CString			m_szLocPath;
	short			m_nAddRegionIndex;

// Operations
public:           
	CNameList();
	virtual ~CNameList();  

	void SetLocDocPtr (CLocDoc* ptLocDoc) { m_ptDoc = ptLocDoc; }
 	void SetRegionPtr (CObArray* ptRegions) { m_ptRegions = ptRegions; }     

	BOOL Alloc (long lCnt);
	void Free ();				 

	void SetRegionIndex (short nIndex) { m_nAddRegionIndex = nIndex; }
	void SetEntry (NAMEINDEXTYPE* ptSL, CString szName,
			short nCategory, short nIndex, short nRegIndex);
	void AddEntry (CLocation* ptLocation, short nSubListIndex);

	long GetSize(){return m_lNameListIndex;}
	NAMEINDEXTYPE* GetEntryPtr (long i){return m_ptNameList + i;}

	short SetActRegIndex (CLocation& Loc);

	void Sort ();
   
	BOOL GetIndexRange (const char* ptName, long* ptFirst, long* ptLast);

	BOOL GetSortedInd (const char* ptName, long* ptIndex, BOOL bCaseSensitive=FALSE);
	void IndexToRange (long* ptFirstInd, long lIndex, long* ptLastInd);
	BOOL IndexToRangeN (short nCmpLen, long* ptFirst, long lIndex, long* ptLast);
	BOOL GetSortedIndexRange (const char* ptName, long* ptFirst, long* ptLast);

	void SetLocPath (CString szPath) { m_szLocPath = szPath; }
	CString GetRegionName (short nRegIndex);
	BOOL GetLoc (CLocation* ptLoc, long lIndex, short* ptActRegInd);

	BOOL GetSortedIndexN (const char* ptName, short CmpLen, long* ptIndex);
	BOOL FindBestName (char* ptName, short CmpLen);
	
};

/////////////////////////////////////////////////////////////////////////////

class CRegion;

class CQuickFind : public CObject
{         
DECLARE_SERIAL(CQuickFind)

private:
	CLocDoc*		m_ptDoc;
	CObArray		m_Regions;
	CString			m_szLocPath;
	CNameList*		m_ptNameList;
	CLaLoList*		m_ptLaLoList;

public:
	CQuickFind();
	virtual ~CQuickFind();  
	
 	void DeleteArrayOfRgn (CObArray* ptArray);
	BOOL Alloc (long lCnt);
	void Free ();	
				 
	void SetLocDocPtr (CLocDoc* ptLocDoc);
 
	CNameList* GetNameListPtr () { return m_ptNameList; }
	CLaLoList* GetLaLoListPtr () { return m_ptLaLoList; }
	CObArray*  GetRegionsPtr() { return &m_Regions; }

 	void AddEntry (CLocation* ptLocation, short nSubListIndex);
	void Sort ();
	void SetRegionIndex (short nIndex);

	long GetTotalEntryCnt();
	short GetRegionCnt();

	BOOL RegionSetCnt (short nIndex, short nCnt);
 	short GetEntryCnt (CString szFullPath);
	short RegionNameToIndex (CString szRegNameExt);
	CRegion* GetRegionPtr (CString szName);
	static short GetSortedIndex (CObArray& Regions, CRegion& Region);

	static short GetSortedIndex (CStringArray& List, CString& szText);
	static short EnumFiles (CStringArray* ptRegions, CString szSearchPath);
	short CheckRegionNames (CStringArray* ptRegions, CString szFullName);
	void ActivateRegion (short nRegIndex);
	void AddRegions (CLocDoc* ptLocDoc);
 	void FillRegionPU (CComboBox* ptRegionPU);
	BOOL GetHomeBase (CString szName, CLocation* ptLoc);
	BOOL GetHomeBase (CLocation* ptLoc);

	BOOL Update(short nActRegIndex);
	BOOL Change(CWnd* ptWnd);
	void Serialize(CArchive& ar);

};

/////////////////////////////////////////////////////////////////////////////
#endif
