// RegioDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"	 //includes "NameList.h"

#include "LocDoc.h"
#include "Region.h"

#include "RegioDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// CRegionDlg dialog
/* used to select regions of locations and airspaces
*/


CRegionDlg::CRegionDlg(CWnd* pParent, CObArray* ptRegions, CLocDoc* ptDoc)
	: CDialog(CRegionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegionDlg)
	//}}AFX_DATA_INIT
m_ptRegions = ptRegions;
m_ptDoc		= ptDoc;
}


void CRegionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegionDlg)
	DDX_Control(pDX, ID_RGDELLIST, m_DelList);
	DDX_Control(pDX, ID_RGADDLIST, m_AddList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegionDlg, CDialog)
	//{{AFX_MSG_MAP(CRegionDlg)
	ON_BN_CLICKED(ID_RGADDALL, OnAddAll)
	ON_BN_CLICKED(ID_RGADDSEL, OnAddSelected)
	ON_BN_CLICKED(ID_RGDELALL, OnDelAll)
	ON_BN_CLICKED(ID_RGDELSEL, OnDelSelected)
	ON_LBN_DBLCLK(ID_RGADDLIST, OnDblclkAddList)
	ON_LBN_DBLCLK(ID_RGDELLIST, OnDblclkDelList)
	ON_BN_CLICKED(IDOK, OnDone)
	ON_WM_CLOSE()
	ON_LBN_SELCHANGE(ID_RGADDLIST, OnSelchangeAddList)
	ON_LBN_SELCHANGE(ID_RGDELLIST, OnSelchangeDelList)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegionDlg message handlers

/************************************************************************
 *  RegioDlg.cpp			D i s a b l e C o n t r o l					*
 ************************************************************************/
void CRegionDlg::DisableControl (int nID, BOOL bDisable)
{ 
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->EnableWindow (!bDisable);
}

/************************************************************************
 *  RegioDlg.cpp	  		 O n A d d A l l 							*
 ************************************************************************/
void CRegionDlg::OnAddAll() 
{
	// TODO: Add your control notification handler code here
int i = 0;
while (i < m_AddList.GetCount())	// for all passive regions:	
	{
	CString szRegion;
	m_AddList.GetText (i, szRegion);	// passive region name
	if (m_DelList.FindString (-1, (LPCTSTR)szRegion) != LB_OKAY)
		{			// move szRegion from add list to del list
		m_AddList.DeleteString (i);
		m_DelList.AddString ((LPCTSTR)szRegion);
		}
	else{
		i++;
		} 
	}

this->DisableControl (ID_RGADDSEL, TRUE);
this->DisableControl (ID_RGADDALL, TRUE);
this->DisableControl (ID_RGDELALL, (m_DelList.GetCount()==0));
this->DisableControl (IDOK, (m_DelList.GetCount()==0));
}

/************************************************************************
 *  RegioDlg.cpp	  		O n A d d S e l e c t e d  					*
 ************************************************************************/
void CRegionDlg::OnAddSelected() 
{
	// TODO: Add your control notification handler code here
int nMaxSelCnt = m_AddList.GetCount();

int* ptInt = new int[nMaxSelCnt];			// Allocate new memory
int nActSelCnt = m_AddList.GetSelItems (nMaxSelCnt, (LPINT)ptInt);
if (nActSelCnt > 0)
	{
	int i;
	for (i=0; i<nActSelCnt; i++)
		{
		CString szRegion;
		int nIndex = ptInt[i];
		
		short nDelIndex = nIndex - i;
		m_AddList.GetText (nDelIndex, szRegion);
		if (m_DelList.FindString (-1, (LPCTSTR)szRegion) != LB_OKAY)
			{
			m_AddList.DeleteString (nDelIndex);
			m_DelList.AddString ((LPCTSTR)szRegion);
			} 
		}

	this->DisableControl (ID_RGADDSEL, TRUE);
	this->DisableControl (ID_RGADDALL, (m_AddList.GetCount()==0));
	this->DisableControl (ID_RGDELALL, (m_DelList.GetCount()==0));
	this->DisableControl (IDOK, (m_DelList.GetCount()==0));
	}
delete [] ptInt;
}

/************************************************************************
 *  RegioDlg.cpp	  		 O n D e l A l l	 						*
 ************************************************************************/
void CRegionDlg::OnDelAll() 
{
	// TODO: Add your control notification handler code here
int i = 0;
while (i < m_DelList.GetCount())	// for all active regions:	
	{
	CString szRegion;
	m_DelList.GetText (i, szRegion);	// active region name
	if (m_AddList.FindString (-1, (LPCTSTR)szRegion) != LB_OKAY)
		{	
		m_DelList.DeleteString (i);		// remove from active list
		m_AddList.AddString ((LPCTSTR)szRegion); 
		}
	else{
		i++;
		}
	}

this->DisableControl (ID_RGDELSEL, TRUE);
this->DisableControl (ID_RGDELALL, TRUE);
this->DisableControl (ID_RGADDALL, (m_AddList.GetCount()==0));
this->DisableControl (IDOK, TRUE);
}


/************************************************************************
 *  RegioDlg.cpp	  		 O n D e l S e l e c t e d					*
 ************************************************************************/
void CRegionDlg::OnDelSelected() 
{
	// TODO: Add your control notification handler code here
int nMaxSelCnt = m_DelList.GetCount();

int* ptInt = new int[nMaxSelCnt];			// Allocate new memory
int nActSelCnt = m_DelList.GetSelItems (nMaxSelCnt, (LPINT)ptInt);
if (nActSelCnt > 0)
	{
	int i;
	for (i=0; i<nActSelCnt; i++)
		{
		CString szRegion;
		int nIndex = ptInt[i];
		
		short nDelIndex = nIndex - i;
		m_DelList.GetText (nDelIndex, szRegion);
		if (m_AddList.FindString (-1, (LPCTSTR)szRegion) != LB_OKAY)
			{		// szRegion not found in add list
					// so we can move szRegion from del list to add list
			m_DelList.DeleteString (nDelIndex);
			m_AddList.AddString ((LPCTSTR)szRegion);
			} 
		}

	this->DisableControl (ID_RGDELSEL, TRUE);
	this->DisableControl (ID_RGADDALL, (m_AddList.GetCount()==0));
	this->DisableControl (ID_RGDELALL, (m_DelList.GetCount()==0));
	this->DisableControl (IDOK, (m_DelList.GetCount()==0));
	}
delete [] ptInt;
}

/************************************************************************
 *  RegioDlg.cpp	  		 F i l l A d d L i s t 						*
 ************************************************************************/
void CRegionDlg::FillAddList ()
{
CListBox* ptList = (CListBox*)GetDlgItem (ID_RGADDLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<m_ptRegions->GetSize(); i++)
	{      
	CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(i);
	if (!ptRegion->IsActiv())
		{					// show passive regions only
		szText = ptRegion->GetName();
		ptList->AddString((LPCTSTR)szText);  
		}
	}              

this->DisableControl (ID_RGADDSEL, TRUE);
this->DisableControl (ID_RGADDALL, (ptList->GetCount() == 0));
}                             

/************************************************************************
 *  RegioDlg.cpp	  		 F i l l D e l L i s t 						*
 ************************************************************************/
void CRegionDlg::FillDelList ()
{
CListBox* ptList = (CListBox*)GetDlgItem (ID_RGDELLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<m_ptRegions->GetSize(); i++)
	{      
	CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(i);
	if (ptRegion->IsActiv())
		{
		szText = ptRegion->GetName();
		ptList->AddString((LPCTSTR)szText);  
		}
	}              
this->DisableControl (ID_RGDELSEL, TRUE);
this->DisableControl (ID_RGDELALL, (ptList->GetCount() == 0));
}                             

/************************************************************************
 *  RegioDlg.cpp	  		O n I n i t D i a l o g 					*
 ************************************************************************/
BOOL CRegionDlg::OnInitDialog() 
{

this->FillAddList();
this->FillDelList();
	// TODO: Add extra initialization here



CDialog::OnInitDialog();


return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  RegioDlg.cpp	  		 O n D b l c l k A d d L i s t 				*
 ************************************************************************/
void CRegionDlg::OnDblclkAddList() 
{
	// TODO: Add your control notification handler code here
OnAddSelected();
}

/************************************************************************
 *  RegioDlg.cpp	  		 O n D b l c l k D e l L i s t 				*
 ************************************************************************/
void CRegionDlg::OnDblclkDelList() 
{
	// TODO: Add your control notification handler code here
OnDelSelected();
}

/************************************************************************
 *  RegioDlg.cpp	  			R e g i o n I s L o a d e d				*
 ************************************************************************/
BOOL CRegionDlg::RegionIsLoaded(CString szName) 
{
BOOL	bLoaded = FALSE;
bLoaded = (szName.Compare (m_ptDoc->GetActRegionName()) == 0);
return bLoaded;
}


/************************************************************************
 *  RegioDlg.cpp	  			ActivateLocRegions		 				*
 ************************************************************************/
BOOL CRegionDlg::ActivateLocRegions(short* ptIndexOfFirstActivated)
{
	BOOL	bChanged = FALSE;
	short i;
	short	nFirstActivated = -1;
	CString szRegion;

	for (i=0; i<m_ptRegions->GetSize(); i++)
	{								// for all regions:
		CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(i);
		if (ptRegion != NULL)
		{
			szRegion = ptRegion->GetName();
			short nErr = m_DelList.FindStringExact(-1, (LPCTSTR)szRegion);
			if (nErr != LB_ERR)
			{						// active region name
				if (!ptRegion->IsActiv())
					bChanged = TRUE;
				ptRegion->SetActiv (TRUE);

				if (nFirstActivated == -1)
					nFirstActivated = i;	// store first activated region
			}
			else
			{						// passive region
				if (ptRegion->IsActiv())
					bChanged = TRUE;
				ptRegion->SetActiv (FALSE);
			}
		}  
	}

	*ptIndexOfFirstActivated = nFirstActivated;
	return bChanged;
}


/************************************************************************
 *  RegioDlg.cpp	  				 O n D o n e		 				*
 ************************************************************************/
void CRegionDlg::OnDone() 
{
	// TODO: Add your control notification handler code here
	short i;
	short	nFirstActivated = -1;
	BOOL	bChanged = FALSE;
	BOOL	bLoaded	= FALSE;
	BOOL	bRegionSelected = TRUE;
	CString szRegion;


	bChanged = ActivateLocRegions(&nFirstActivated);


	// either gets first selected region name
	// OR - if nothing selected - first activated region name						
	int nMaxSelCnt = m_DelList.GetCount();
	int* ptInt = new int[nMaxSelCnt];			// Allocate new memory
	int nActSelCnt = m_DelList.GetSelItems (nMaxSelCnt, (LPINT)ptInt);
	if (nActSelCnt > 0)
	{
		i = (short)ptInt[0];	 // first selection
		m_DelList.GetText (i, szRegion);
		if (this->RegionIsLoaded(szRegion))
			 bLoaded = TRUE;		// SELECTED region is already loaded
		else bLoaded = FALSE;
	}
	else
	{							// nothing selected
	//forMac:	if (!bLoaded)
		{
			i = nFirstActivated;
			if (i==-1)
			{
				bRegionSelected = FALSE;
			}
			else
			{		// use first activated region
				CRegion* ptRegion = (CRegion*)m_ptRegions->GetAt(i);
				szRegion = ptRegion->GetName();

				if (this->RegionIsLoaded (szRegion))
					bLoaded = TRUE;		// activated region is already loaded
			}
		}
	}
	delete [] ptInt;



	if (!bLoaded && bRegionSelected)
	{
		CString szLocPath = ptInit->GetActualPath (); 

		m_ptDoc->OnNewDocument(); 			// deletes old structures  
		m_ptDoc->SetRegionIndex (i); 
		m_ptDoc->OnOpenDocument (szLocPath + szRegion + (CString)".krd");
	}


	CAirspaceRegionsDoc* ptAirspaceRegionsDoc = ptInit->GetAirspaceRegionsDocPtr();
	if (ptAirspaceRegionsDoc != NULL)
		if (ptAirspaceRegionsDoc->ActivateFor(m_ptRegions))
			bChanged = TRUE;

	if (bChanged)	CDialog::OnOK();
		else		CDialog::OnCancel();	            
}

void CRegionDlg::OnSelchangeAddList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->DisableControl (ID_RGADDSEL, (m_AddList.GetSelCount()==0));
}

void CRegionDlg::OnSelchangeDelList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->DisableControl (ID_RGDELSEL, (m_DelList.GetSelCount()==0));
}

/************************************************************************
 *  RegioDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CRegionDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
