// RelKoDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    

#include "LocDoc.h"
#include "WayPoint.h"
#include "RelKoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CRelKoordDlg 


CRelKoordDlg::CRelKoordDlg(CWnd* pParent, CWayPoint* ptWpt,
				CObArray* ptWpts, short nIndex)
	: CDlgTool(CRelKoordDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRelKoordDlg)
	m_nCatIndex = -1;
	m_szCountryCode = "";
	m_szName = "";
	m_szIndicator = "";
	m_nMWK = 0;
	m_dDist = 0;
	m_lElevation = 0;
	m_dVAR = 0;
	m_fFreq = (float)0.;
	m_bGras = FALSE;
	m_lRange = 0;
	m_nRwyLen = 0;
	m_nTopography = -1;
	m_lElevDiff = 0;
	m_nListIndex = -1;
	m_nDistDim = -1;
	m_nDiffDim = -1;
	m_nElevDim = -1;
	m_nLenDim = -1;
	m_nRangeDim = -1;
	m_nRwyDir = -1;
	//}}AFX_DATA_INIT

m_ptWpt = ptWpt;
m_ptWayPoints	= ptWpts;
	
m_nOldIndex = m_nListIndex = nIndex; 
}

/************************************************************************
 *  RelKoDlg.cpp	  		 	F i l l C a t P U 						*
 ************************************************************************/
void CRelKoordDlg::FillCatPU ()
{      
CComboBox* ptCategory = (CComboBox*)GetDlgItem (IDC_RKCATEGORY);

CString szText;
short i;
for (i=0; i<CT_CNT; i++)
	{
	szText.LoadString (ID_CA_AIRPORT + i);  
	ptCategory->AddString((LPCTSTR)szText);  
	}
} 

/************************************************************************
 *  RelKoDlg.cpp	  		 	F i l l M i n A l t P U 				*
 ************************************************************************/
void CRelKoordDlg::FillMinAltPU ()
{
CComboBox* ptTopography = (CComboBox*)GetDlgItem (IDC_RKTOPO);
CString szText;
short i;
for (i=0; i<3; i++)
	{
	szText.LoadString (ID_TO_COUNTRY + i);  
	ptTopography->AddString((LPCTSTR)szText);  
	}
}

/************************************************************************
 *  RelKoDlg.cpp	  		 F i l l L o c a t i o n L i s t 			*
 ************************************************************************/
void CRelKoordDlg::FillLocationList (CObArray* ptWayPts)
{
CListBox* ptList = (CListBox*)GetDlgItem (IDC_RKLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<ptWayPts->GetSize(); i++)
	{      
	CWayPoint* ptActWay = (CWayPoint*)ptWayPts->GetAt(i);   
	szText = ptActWay->GetName();
	ptList->AddString((LPCTSTR)szText);  
	}  
}                             

/************************************************************************
 *  RelKoDlg.cpp	  		 	F i l l R w y D i r P U					*
 ************************************************************************/
void CRelKoordDlg::FillRwyDirPU ()
{      
CComboBox* ptRwyDir = (CComboBox*)GetDlgItem (IDC_RKRWYDIR);

CString szText;
short i;
for (i=0; i<19; i++)
	{
	szText.LoadString (ID_RD_01 + i);  
	ptRwyDir->AddString((LPCTSTR)szText);  
	}
}                                                                           


/************************************************************************
 *  RelKoDlg.cpp	  		 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CRelKoordDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

if (pDX->m_bSaveAndValidate)
		{  
		m_nOldIndex 	= m_nListIndex;	  
		m_nOldCategory	= m_nCatIndex;
		}

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRelKoordDlg)
	DDX_CBIndex(pDX, IDC_RKCATEGORY, m_nCatIndex);
	DDX_Text(pDX, IDC_RKCC, m_szCountryCode);
	DDV_MaxChars(pDX, m_szCountryCode, 2);
	DDX_Text(pDX, IDC_RKNAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 17);
	DDX_Text(pDX, IDC_RKINDICATOR, m_szIndicator);
	DDV_MaxChars(pDX, m_szIndicator, 5);
	DDX_Text(pDX, IDC_RKMWK, m_nMWK);
	DDV_MinMaxInt(pDX, m_nMWK, 0, 360);
	DDX_Text(pDX, IDC_RKDIST, m_dDist);
	DDV_MinMaxDouble(pDX, m_dDist, 0., 12000.);
	DDX_Alt(pDX, IDC_RKELEV, m_lElevation);
	DDV_AltOptional(pDX, m_lElevation, -5000, 15000);
	DDX_Variation(pDX, IDC_RKVAR, m_dVAR);
	DDV_Angle(pDX, m_dVAR, -180., 180.);
	DDX_Freq(pDX, IDC_RKFRQ, m_fFreq);
	DDV_FreqOptional(pDX, m_fFreq, 108.f, 1750.f);
	DDX_Check(pDX, IDC_RKGRAS, m_bGras);
	DDX_Dist(pDX, IDC_RKRANGE, m_lRange);
	DDV_DistOptional(pDX, m_lRange, 0, 255);
	DDX_RwyOpt(pDX, IDC_RKRWYLEN, m_nRwyLen);
	DDV_RwyOpt(pDX, m_nRwyLen, 100, 5000);
	DDX_CBIndex(pDX, IDC_RKTOPO, m_nTopography);
	DDX_Alt(pDX, IDC_RKELEVDIFF, m_lElevDiff);
	DDV_AltOptional(pDX, m_lElevDiff, -250, 250);
	DDX_LBIndex(pDX, IDC_RKLIST, m_nListIndex);
	DDX_CBIndex(pDX, IDC_RKDISTDIM, m_nDistDim);
	DDX_CBIndex(pDX, IDC_RKDIFFDIM, m_nDiffDim);
	DDX_CBIndex(pDX, IDC_RKELEVDIM, m_nElevDim);
	DDX_CBIndex(pDX, IDC_RKLENDIM, m_nLenDim);
	DDX_CBIndex(pDX, IDC_RKRANGEDIM, m_nRangeDim);
	DDX_CBIndex(pDX, IDC_RKRWYDIR, m_nRwyDir);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRelKoordDlg, CDlgTool)
	//{{AFX_MSG_MAP(CRelKoordDlg)
	ON_LBN_SELCHANGE(IDC_RKLIST, OnSelchangeList)
	ON_CBN_SELCHANGE(IDC_RKCATEGORY, OnSelchangeCategory)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CRelKoordDlg 
/************************************************************************
 *  RelKo.cpp	  				S e t D a t a  							*
 ************************************************************************/
void CRelKoordDlg::SetData (CWayPoint* ptWpt)
{  
m_nDistDim = ptDim->GetPUIndex (DISTANCE, ptWpt->GetDistDim());
m_nElevDim = ptDim->GetPUIndex (ALTITUDE, ((CLocation*)ptWpt)->GetElevDim());
m_nRangeDim = ptDim->GetPUIndex (DISTANCE, ptWpt->GetDistDim());
m_nLenDim = ptDim->GetPUIndex (RWYLENGTH, ptWpt->GetLenDim());
m_nDiffDim = ptDim->GetPUIndex (ALTITUDE, ptWpt->GetDiffDim());    

m_nCatIndex = CLocDoc::CategoryToIndex(ptWpt->GetCategory());	        

m_szName 		= ptWpt->GetName();
m_szIndicator	= ptWpt->GetIndicator(); 
m_szCountryCode = ptWpt->GetCountryCode();

m_nMWK			= 0;
m_dDist			= 0;

if (ptWpt->GetLat() != NO_KOORD && ptWpt->GetLon() != NO_KOORD)
    {					    /* are Koords of ActWpt available?    */
    double dDist, dKurs;	
								// get selected wpt of route:
	CWayPoint* ptSelWpt = (CWayPoint*)m_ptWayPoints->GetAt(m_nListIndex);   
	
    dDist = ptSelWpt->Distance ((CLatLon)*ptWpt,	// actual location	
								&dKurs);

    m_nMWK = (int)dKurs - ptWpt->GetVariation();
	if (m_nMWK < 0) m_nMWK += 360;

	m_dDist = ptDim->ConvertDist (dDist, DIM_NM, ptWpt->GetDistDim());
    }


m_dVAR			= (double)ptWpt->GetVariation();   
m_bGras 		= ptWpt->IsGras();

	 
if (ptWpt->IsAirport ())
	{
	switch (ptWpt->GetRwyDir())
		{
		case  1:	m_nRwyDir = 0;	break;	 //Rwy 01/19 => 1. PU entry: Index=0
		case  2:	m_nRwyDir = 1;	break;
		case  3:	m_nRwyDir = 2;	break;
		case  4:	m_nRwyDir = 3;	break;
		case  5:	m_nRwyDir = 4;	break;
		case  6:	m_nRwyDir = 5;	break;
		case  7:	m_nRwyDir = 6;	break;
		case  8:	m_nRwyDir = 7;	break;
		case  9:	m_nRwyDir = 8;	break;
		case 10:	m_nRwyDir = 9;	break;
		case 11:	m_nRwyDir =10;	break;
		case 12:	m_nRwyDir =11;	break;
		case 13:	m_nRwyDir =12;	break;
		case 14:	m_nRwyDir =13;	break;
		case 15:	m_nRwyDir =14;	break;
		case 16:	m_nRwyDir =15;	break;
		case 17:	m_nRwyDir =16;	break;
		case  0:	m_nRwyDir =17;	break;
		default:	m_nRwyDir = NO_RWYDIR; break;
		}

  	m_lRange = NO_LONG;					// reset range
	HideControl (IDC_RKRANGE_TXT, TRUE);
	HideControl (IDC_RKRANGE, TRUE);
	HideControl (IDC_RKRANGEDIM, TRUE);

	HideControl (IDC_RKRWYDIR_TXT, FALSE);
	HideControl (IDC_RKRWYDIR, FALSE);
	}
else{
	ptWpt->GetRange(&m_lRange);
 
 	m_nRwyDir = NO_RWYDIR;		// reset runway direction
	HideControl (IDC_RKRWYDIR_TXT, TRUE);
	HideControl (IDC_RKRWYDIR, TRUE);

	HideControl (IDC_RKRANGE_TXT, FALSE);
	HideControl (IDC_RKRANGE, FALSE);
	HideControl (IDC_RKRANGEDIM, FALSE);
	}


switch (ptWpt->GetTopography())
	{
	case Country:	m_nTopography = 0;	break;
	case City:		m_nTopography = 1;	break;
	case bigCity:	m_nTopography = 2;	break;
	}
	
ptWpt->GetAltitude(&m_lElevation); 
ptWpt->GetFrequency(&m_fFreq); 
ptWpt->GetRwyLen(&m_nRwyLen); 
ptWpt->GetElevDiff(&m_lElevDiff);   
}	

/************************************************************************
 *  RelKoDlg.cpp	  		 	G e t D a t a  							*
 ************************************************************************/
void CRelKoordDlg::GetData (CWayPoint* ptWpt)
{           
((CLocation*)ptWpt)->SetElevDim(ptDim->GetPUDim (ALTITUDE, m_nElevDim));
ptWpt->SetDistDim(ptDim->GetPUDim (DISTANCE, m_nRangeDim));
ptWpt->SetLenDim(ptDim->GetPUDim (RWYLENGTH, m_nLenDim));
ptWpt->SetDiffDim(ptDim->GetPUDim (ALTITUDE, m_nDiffDim));    
	                  
ptWpt->SetCategory(CLocDoc::IndexToCategory((CATEGORYINDEX)m_nCatIndex));		
	
ptWpt->SetName(m_szName);
ptWpt->SetIndicator(m_szIndicator); 
ptWpt->SetCountryCode(m_szCountryCode); 
ptWpt->SetVariation((short)m_dVAR);   
ptWpt->SetGras(m_bGras);

								// get selected wpt of route:
CWayPoint* ptSelWpt = (CWayPoint*)m_ptWayPoints->GetAt(m_nListIndex);   

								// get distance from selected wpt
short nDistDim = ptDim->GetPUDim (DISTANCE, m_nDistDim);    
double dDist_NM = ptDim->ConvertDist (m_dDist, nDistDim, DIM_NM);

								// use selected wpt, course and dist
								// to calculate Lat Lon of ptWpt
ptWpt->FromRelKoords ((CLatLon)*ptSelWpt,
    				(short)(m_nMWK + ptWpt->GetVariation()),
					  dDist_NM);

short nTopo;
switch (m_nTopography)
	{
	case 0: nTopo = Country;	break;
	case 1: nTopo = City;		break;
	case 2: nTopo = bigCity;	break;
	}
ptWpt->SetTopography(nTopo);

ptWpt->SetAltitude(m_lElevation); 
ptWpt->SetFrequency(m_fFreq); 
ptWpt->SetRwyLen(m_nRwyLen); 
ptWpt->SetElevDiff(m_lElevDiff);   

if (ptWpt->IsAirport ())
	{
	short nRwyDir;				// 10*degrees
	switch (m_nRwyDir)
		{	 
		case  0:	nRwyDir = 1;	break;		// 1. PU entry: Index=1 => Rwy 01/19 
		case  1:	nRwyDir = 2;	break;	 
		case  2:	nRwyDir = 3;	break;
		case  3:	nRwyDir = 4;	break;
		case  4:	nRwyDir = 5;	break;
		case  5:	nRwyDir = 6;	break;
		case  6:	nRwyDir = 7;	break;
		case  7:	nRwyDir = 8;	break;
		case  8:	nRwyDir = 9;	break;
		case  9:	nRwyDir =10;	break;
		case 10:	nRwyDir =11;	break;
		case 11:	nRwyDir =12;	break;
		case 12:	nRwyDir =13;	break;
		case 13:	nRwyDir =14;	break;
		case 14:	nRwyDir =15;	break;
		case 15:	nRwyDir =16;	break;
		case 16:	nRwyDir =17;	break;
		case 17:	nRwyDir = 0;	break;
		case NO_RWYDIR:
		default:	nRwyDir = NO_RWYDIR; break;
		}
	ptWpt->SetRwyDir(nRwyDir);
	}
else{
	ptWpt->SetRange(m_lRange);
	}
 
}	

/************************************************************************
 *  RelKoDlg.cpp	  		 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CRelKoordDlg::OnInitDialog()
{             
this->FillCatPU ();
this->FillMinAltPU ();
this->FillLocationList (m_ptWayPoints);
this->FillRwyDirPU ();

this->AddDimGroup (IDC_RKDIST, IDC_RKDISTDIM);
this->AddDimGroup (IDC_RKELEV, IDC_RKELEVDIM);
this->AddDimGroup (IDC_RKRANGE, IDC_RKRANGEDIM);
this->AddDimGroup (IDC_RKRWYLEN, IDC_RKLENDIM);
this->AddDimGroup (IDC_RKELEVDIFF, IDC_RKDIFFDIM);
      
this->FillDimPU (IDC_RKDISTDIM, DISTANCE);
this->FillDimPU (IDC_RKELEVDIM, ALTITUDE);
this->FillDimPU (IDC_RKRANGEDIM, DISTANCE);
this->FillDimPU (IDC_RKLENDIM, RWYLENGTH);
this->FillDimPU (IDC_RKDIFFDIM, ALTITUDE);    


this->SetData (m_ptWpt);

// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  KoordDlg.cpp	  		 O n S e l c h a n g e L i s t				*
 ************************************************************************/
void CRelKoordDlg::OnSelchangeList()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_RKLIST);    
short nNewIndex = ptList->GetCurSel ();

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{      
		this->SetData (m_ptWpt);
 		this->UpdateData(FALSE);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetCurSel (m_nListIndex);		  
		}
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	}
}

void CRelKoordDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
if (this->UpdateData(TRUE))
	{
	this->GetData(m_ptWpt);
	CDlgTool::OnOK();
	}
}

void CRelKoordDlg::OnSelchangeCategory() 
{
	// TODO: Add your control notification handler code here
CWayPoint TempWpt;

if (this->UpdateData(TRUE))
	{
	this->GetData(&TempWpt);
	if (TempWpt.IsAirport ())
		{
		HideControl (IDC_RKRANGE_TXT, TRUE);
		HideControl (IDC_RKRANGE, TRUE);
		HideControl (IDC_RKRANGEDIM, TRUE);

		HideControl (IDC_RKRWYDIR_TXT, FALSE);
		HideControl (IDC_RKRWYDIR, FALSE);
		}
	else{
		HideControl (IDC_RKRWYDIR_TXT, TRUE);
		HideControl (IDC_RKRWYDIR, TRUE);

		HideControl (IDC_RKRANGE_TXT, FALSE);
		HideControl (IDC_RKRANGE, FALSE);
		HideControl (IDC_RKRANGEDIM, FALSE);
		}
	this->UpdateData(FALSE);
	}
}


/************************************************************************
 *  RelKoDlg.cpp				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CRelKoordDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

