// RteView.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"			// fabs
#include "pf.h"

#include "MainFrm.h"
#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h

#include "ElevDoc.h"		// CriticalLegPoints		
#include "WayDoc.h"
#include "RteView.h"    

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CMetDoc*			ptMet;
extern CPlaneDoc*		ptPlaneDoc;
extern CElevDoc*		ptElevDoc;


/////////////////////////////////////////////////////////////////////////////
// CRouteView

IMPLEMENT_DYNCREATE(CRouteView, CMapView)

BEGIN_MESSAGE_MAP(CRouteView, CMapView)
	//{{AFX_MSG_MAP(CRouteView)
	ON_COMMAND(ID_MP_ROUTE          , OnMenuRoute)
	ON_COMMAND(ID_MP_FOTO           , OnMenuFoto)
	ON_COMMAND(ID_ME_LABEL		    , OnMenuLABEL)
	ON_UPDATE_COMMAND_UI(ID_ME_LABEL, OnUpdateLabel)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()


CRouteView::CRouteView()
{
m_ptColor = ptInit->GetColorPtr();
m_ptMapDoc = ptInit->GetMapDocPtr();
}

CRouteView::~CRouteView()
{
}

/************************************************************************
 *  WayView.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CRouteView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CWayDoc* ptWayDoc = GetDocument();

if (ptWayDoc != NULL)
	{
	BOOL	bShowNav = FALSE;

					// if latlon to center is NOT valid
	if (!ptInit->IsLatLonToCenterValid() || !m_Border.IsValid())
		ptWayDoc->GetMapBorder (&m_Border, bShowNav);

					
//	ptWayDoc->GetMapBorder (&m_Border, bShowNav);
	this->ResetScroll ();

	CMapView::SetMapTitle (ptWayDoc->GetTitle());
	CMapView::OnUpdate (pSender, lHint, pHint);
	}
}


void CRouteView::OnSize(UINT nType, int cx, int cy) 
{
CMapView::OnSize(nType, cx, cy);

	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen

}


/////////////////////////////////////////////////////////////////////////////
// Zeichnung CRouteView 



/****************************************************************************
 *	RteView.cpp				R t e C r i t i c a l L e g						*
 ****************************************************************************/
void RteCriticalLeg (CLatLon& LLenter, CLatLon& LLleave, long lElev_ft, void* ptData)
{
	if (ptData != NULL)
	{
		CRouteView* ptView = (CRouteView*)ptData;

		CDC*		pDC = ptView->GetDCPtr ();
		CMap*		ptMap = ptView->GetMapPtr ();
		CColorDoc*	ptColor = ptView->GetColorDocPtr ();

		DRECT rMap = ptMap->GetBorder();
		double dEnterLon, dLeaveLon;
		if (CLatLon::GetMapLon(rMap.left, LLenter.GetLon(), rMap.right, &dEnterLon) &&
			CLatLon::GetMapLon (rMap.left, LLleave.GetLon(), rMap.right, &dLeaveLon))
		{
			long LPx0, LPy0, LPx1, LPy1;	

			ptMap->XYtoLP (dEnterLon, LLenter.GetLat(), &LPx0, &LPy0);
			ptMap->XYtoLP (dLeaveLon, LLleave.GetLat(), &LPx1, &LPy1);

			COLORREF LegCol = ptColor->GetColCriticalLine();
			ptColor->DrawLeg (pDC, LPx0, LPy0, LPx1, LPy1, 
							TRUE /* bScMap */, LegCol);
		}
	}
}

/****************************************************************************
 *	CRouteView.c				D r a w O n M a p							*
 ****************************************************************************/
void CRouteView::DrawOnMap (CDC* pDC, BOOL bAntipod)
{
	CWayDoc* ptWayDoc = GetDocument();
	ASSERT_VALID(ptWayDoc);

	// TODO: add draw code for native data here            
int	CharX, LineY;

CFont NewFont; 
CreateNewFont(&NewFont);
CFont* ptOldFont = this->ChangeFont (pDC, &NewFont, &CharX, &LineY); 

if (ptWayDoc != NULL)
	{
	short i;
	long LPx0, LPy0, LPx1, LPy1;				
	double dLon0, dLon1, Way0Lon;
	COLORREF LegCol;
	BOOL bShowActWpt=FALSE;

	dLon0 = Way0Lon = 0.;

	m_ptMercator->Clip(TRUE);			/* draw on map only		*/

//	CPlane	ActPlane;
//	CCalculate* ptLegs=NULL;
//	if (ptPlaneDoc != NULL)
//		{
//		short nIndex = ptPlaneDoc->GetActIndex();
//		if (ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane))
//			{
//			ptLegs = ptWayDoc->GetCalculationPtr();
//			ptLegs->Activate(&ActPlane);		// destroys calculation of CMovingMapDoc::PrepareForRte()
//			}							// if here is no call to m_ptLegs->DoConsumCalc(...).
//		}

	CLatLon LLold;			// for RteCriticalLeg
	long	lAlt_old;

	for (i=0; i<ptWayDoc->GetWayPointCnt(); i++)
		{
		CWayPoint WayPt;
		if (ptWayDoc->GetWayPointPtr (i, &WayPt))
			{
			CLatLon LLact(WayPt.GetLat(), WayPt.GetLon());	// for RteCriticalLeg
			long lAlt = WayPt.GetActAlt_ft();

			if (i==0)
				{
				dLon1 = this->GetLonForAntipodMap(WayPt.GetLon());
				}
			else{
				dLon1 = dLon0 + m_Border.FlightAngle (Way0Lon, WayPt.GetLon());
									
				if (this->LegIsAntipod (dLon0, m_Border.FlightAngle (Way0Lon, WayPt.GetLon())))
					{
					CPoint pLeaveSideLP, pEnterSideLP;
					this->ChangeMapSide (pDC, LPx1, LPy1, 
								WayPt.GetLat(), dLon1, 	 // wpt outside
								&pLeaveSideLP, &pEnterSideLP);

					m_ptColor->DrawLeg (pDC, LPx1, LPy1, 
							pLeaveSideLP.x, pLeaveSideLP.y, 
							FALSE /* bScMap */, LegCol);

					LPx0 = pEnterSideLP.x;
					LPy0 = pEnterSideLP.y;
						
					dLon1 = this->GetLonForAntipodMap(WayPt.GetLon());
					}
				}
				
			m_ptMercator->XYtoLP (dLon1, WayPt.GetLat(), &LPx1, &LPy1);
			
			if (i==0)
				{
				pDC->MoveTo (LPx1, LPy1);  // for DrawLabel
				}
			else{
				m_ptColor->DrawLeg (pDC, LPx0, LPy0, LPx1, LPy1, 
								FALSE /* bScMap */, LegCol);

				if (ptElevDoc != NULL && m_ptMapDoc->IsActivated(SHOW_ELEV))
					{
					this->SetDCPtr (pDC);	// for RteCriticalLeg
					BOOL bOrtho = FALSE;
					ptElevDoc->CriticalLegPoints(LLold, lAlt_old, LLact, lAlt,
							RteCriticalLeg, bOrtho, this);
					}
				}


			Way0Lon = WayPt.GetLon();
			dLon0 = dLon1;					

			LPx0 = LPx1;
			LPy0 = LPy1;

			LLold = LLact;				// for RteCriticalLeg
			lAlt_old = lAlt;
			}

		bShowActWpt = (i==ptWayDoc->GetActInd()) && !pDC->IsPrinting();
		
		if (m_ptMapDoc->IsActivated (SHOW_MAP))
			 LegCol = m_ptColor->GetColMapLineDisabled ();
		else LegCol = m_ptColor->GetLegColor (/*bScMap*/ FALSE, bShowActWpt);

		if (m_ptMapDoc->IsActivated(SHOW_LABEL) || bShowActWpt)
			{												/* name of waypoint		*/
			double	TextAngle;
			BOOL	bRightAlign;
			short	nSizeLP;
			CString	szNameForRte;     
 		
			TextAngle = ptWayDoc->LabelDirection (i, &bRightAlign);
			nSizeLP = WayPt.GetTextWidth(pDC);
			szNameForRte = WayPt.GetNameForRte ();

			if (pDC->IsPrinting()) 	m_ptMercator->Clip(FALSE);	// allow drawing label outside of map
			m_ptMercator->DrawLabel (LPx1, LPy1, TextAngle,
				LineY, bRightAlign, szNameForRte, nSizeLP, bShowActWpt);
			if (pDC->IsPrinting()) 	m_ptMercator->Clip(TRUE);	/* draw on map only		*/
			}

										// begin draw bearing lines
		short nBearInd;
		for (nBearInd=0; nBearInd<2; nBearInd++)
			{
			if (WayPt.HasBearing (nBearInd))
				{
				double dNavLat, dNavLon, dMapLon;
				long   lLPx0, lLPy0, lLPx1, lLPy1;
				if (WayPt.GetBearLoc (nBearInd, &dNavLat, &dNavLon))
					{				// draw line from nav facility to WayPt
					m_ptMercator->XYtoLP (dNavLon, dNavLat, &lLPx0, &lLPy0);

					dMapLon = dNavLon + m_Border.FlightAngle (dNavLon, WayPt.GetLon());
					if (this->LegIsAntipod (dNavLon, m_Border.FlightAngle (dNavLon, WayPt.GetLon())))
						{
						CPoint pLeaveSideLP, pEnterSideLP;
						this->ChangeMapSide (pDC, lLPx0, lLPy0,  // nav facility
										WayPt.GetLat(), dMapLon, // wpt outside
										&pLeaveSideLP,			 // map leaving pt
										&pEnterSideLP);
																 // line from
						m_ptColor->DrawBear (pDC, LPx0, LPy0, 	 // nav facility to
								pLeaveSideLP.x, pLeaveSideLP.y,  // map leaving pt
								FALSE /* bScMap */);

						LPx0 = pEnterSideLP.x;
						LPy0 = pEnterSideLP.y;
							
						dMapLon = this->GetLonForAntipodMap(WayPt.GetLon());
						}

					m_ptMercator->XYtoLP (dMapLon, WayPt.GetLat(), &lLPx1, &lLPy1);
					m_ptColor->DrawBear (pDC, lLPx0, lLPy0,	// nav facility or enter pt
											lLPx1, lLPy1,		// wpt on other side
											FALSE /* bScMap */);
					}
				}
			}
		}	// end for wpts...

										// second loop to draw check points
	for (i=0; i<ptWayDoc->GetWayPointCnt(); i++)
		{
		CWayPoint WayPt;
		if (ptWayDoc->GetWayPointPtr (i, &WayPt))
			{							 // Kartenpunkt
			double dLon = this->GetLonForAntipodMap(WayPt.GetLon());
			m_ptMercator->XYtoLP (dLon, WayPt.GetLat(), &LPx1, &LPy1);
			m_ptColor->DrawCheckPoint (pDC, LPx1, LPy1, FALSE/* bScMap */, WayPt.IsUpDown());
			}
		}


//	if (ptLegs != NULL)
//		ptLegs->DeActivate ();

	m_ptMercator->Clip(FALSE);
	}	

pDC->SelectObject (ptOldFont);
NewFont.DeleteObject ();
}


/****************************************************************************
 *	CRouteView.c			S h o w F u l l R o u t e						*
 ****************************************************************************/
void CRouteView::ShowFullRoute ()
{
this->OnMenuRoute();
}


/****************************************************************************
 *	CRouteView.c			O n M e n u R o u t e 							*
 ****************************************************************************/
void CRouteView::OnMenuRoute() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
CWayDoc* ptWayDoc = GetDocument();
ASSERT_VALID(ptWayDoc);  

if (ptWayDoc != NULL)
	{	        
	BOOL	bShowNav = FALSE;

	ptInit->ResetLatLonToCenter();		// don't center any wpt of route

	ptWayDoc->GetMapBorder (&m_Border, bShowNav);
	this->ResetScroll ();

	this->Invalidate(FALSE);
	}
}

/****************************************************************************
 *	CRouteView.c			O n M e n u F o t o 							*
 ****************************************************************************/
void CRouteView::OnMenuFoto() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	CImage* ptImage = this->GetImagePtr();
	if (ptImage != NULL)
	{								// set name to save generated image
		CString szFileName;
		szFileName = ptImage->SaveAsDlg (this, "Flugstrecke", "Route");	
		if (szFileName.GetLength() > 0)
			this->SaveImage();
	}
}

/****************************************************************************
 *	CRouteView.c			O n M e n u L A B E L 							*
 ****************************************************************************/
void CRouteView::OnMenuLABEL() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
m_ptMapDoc->InvertActivateState(SHOW_LABEL);
this->Invalidate(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// Diagnose CRouteView

#ifdef _DEBUG
void CRouteView::AssertValid() const
{
	CMapView::AssertValid();
}

void CRouteView::Dump(CDumpContext& dc) const
{
	CMapView::Dump(dc);
}

CWayDoc* CRouteView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}
#endif //_DEBUG


void CRouteView::OnUpdateLabel(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->SetCheck (m_ptMapDoc->IsActivated(SHOW_LABEL));	
}
