// ScMpDlg.cpp: Implementierungsdatei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"
#include "InitDoc.h"	 //includes "NameList.h"
#include "MainFrm.h"

#include "ScMpDoc.h"
#include "ScMpDlg.h"

#include "..\Cpptools\DirBrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CScanMapDlg 

CScanMapDlg::CScanMapDlg(CWnd* pParent, CScanMapDoc* ptDoc)
	: CDlgTool(CScanMapDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CScanMapDlg)
	m_bAutoSel = TRUE;
	m_nType = -1;
	m_nListIndex = -1;
	m_szName = _T("");
	m_szPath = _T("");
	m_szState = _T("");
	//}}AFX_DATA_INIT
m_ptDoc = ptDoc;
m_nType = (short)LAMBERT;
m_bInsert = FALSE;
								// copy maps from doc into dlg
m_ptDoc->GetDataBase (&m_ActList);
m_nListIndex = m_ptDoc->GetActMapIndex();
m_bChanged = FALSE;
m_ptDoc->SetModifiedFlag(FALSE);
m_bCalibDlg = FALSE;
}


/************************************************************************
 *  ScMpDlg.cpp				~ C S c a n M a p D l g			Destructor	*
 ************************************************************************/
CScanMapDlg::~CScanMapDlg()
{
DeleteArrayOf (&m_ActList);
} 

/************************************************************************
 *  ScMpDlg.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CScanMapDlg::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CObject* ptEntry;
	if ((ptEntry = ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}


/************************************************************************
 *  ScMpDlg.cpp	  		W r i t e D a t a B a s e I n t o D o c 		*
 ************************************************************************/
BOOL CScanMapDlg::WriteDataBaseIntoDoc()
{ 				
BOOL	bWritten = FALSE;				  

BOOL bNewSelection = (m_ptDoc->GetActMapIndex() != m_nListIndex);

//if (m_bChanged || bNewSelection /*|| m_ptDoc->WasConverted()*/)
	{                                   // copy database from Dlg to Doc
	m_ptDoc->SetDataBase (&m_ActList);  
	m_ptDoc->SetModifiedFlag(TRUE);  
	m_ptDoc->SetActivateCalibDlg(m_bCalibDlg); 

	if (m_nListIndex > -1 && m_ActList.GetSize() > 0)
		m_ptDoc->ActivateMap (m_nListIndex);

	bWritten = TRUE;
	}               
return bWritten;
}



/************************************************************************
 *  ScMpDlg.cpp	  					S e t D a t a						*
 ************************************************************************/
void CScanMapDlg::SetData (CScannedMap* ptScannedMap)
{
m_nType = (short)ptScannedMap->GetProjection ();
m_bAutoSel = ptScannedMap->IsAutoSel();

short nStateID = ptScannedMap->IsCalibrated()?  IDS_DEF_FIXPT : IDS_UNDEF_FIXPT;
m_szState.LoadString (nStateID);

m_szName = ptScannedMap->GetName();
m_szPath = ptScannedMap->GetPath();

if (ptScannedMap->IsCalibrated())
	{
	this->DisableControl (IDC_SMCALIB, FALSE);  
	this->DisableControl (IDOK, FALSE);  
	}
else{
	this->DisableControl (IDOK, TRUE);  
	}
}

/************************************************************************
 *  ScMpDlg.cpp	  					G e t D a t a						*
 ************************************************************************/
void CScanMapDlg::GetData (CScannedMap* ptScannedMap)
{
	PROJECTION OldProjection = ptScannedMap->GetProjection();
	if (m_nType != OldProjection)
	{						// projection changed: reset calibration
		if (ptScannedMap->GetFixPtCnt() > 0)
		{					// need to remove all old fixpoints
			CString szMsg;
			szMsg.Format (IDF_DEL_CALIBRATION, (LPCTSTR)m_szName);
			int iRet = AfxMessageBox (szMsg, MB_YESNO);
			if (iRet == IDYES)
			{								
				m_bCalibDlg = TRUE;
				ptScannedMap->Reset();
			}
			else
			{
				m_nType = OldProjection;
			}
		}
	}

	ptScannedMap->SetProjection ((PROJECTION)m_nType);
	//ptScannedMap->SetAutoSel (this->GetControl (IDC_SMAUTOSEL));
	ptScannedMap->SetAutoSel (m_bAutoSel);
	ptScannedMap->SetName (m_szName);
	ptScannedMap->SetPath (m_szPath);
}

/************************************************************************
 *  ScMpDlg.cpp	  		 R e m o v e L i s t S e l e c t i o n			*
 ************************************************************************/
void CScanMapDlg::RemoveListSelection()
{
m_nListIndex = -1;  			   // remove selection
CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST); 
if (ptList != NULL)
	ptList->SetSel(m_nListIndex, FALSE);   
}

/************************************************************************
 *  ScMpDlg.cpp	  		 S e t L i s t S e l e c t i o n				*
 ************************************************************************/
void CScanMapDlg::SetListSelection(short nIndex)
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
	if (ptList != NULL)
		ptList->SetSel(nIndex, TRUE);
}

/************************************************************************
 *  ScMpDlg.cpp	  			M a p N a m e T o I n d e x 				*
 ************************************************************************/
short CScanMapDlg::MapNameToIndex (CString szName)
{
short nIndex = -1;
short i;

for (i=0; i<m_ActList.GetSize() && (nIndex == -1); i++)
	{							// search used name...
	CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt(i);
	CString	szTestName = ptMap->GetName();
	if (szName.Compare ((LPCTSTR)szTestName) == 0)
		nIndex = i;
	}

return nIndex;
}

/************************************************************************
 *  ScMpDlg.cpp	  				I n s e r t S o r t e d					*
 ************************************************************************/
BOOL CScanMapDlg::InsertSorted (CScannedMap* ptMap)
{
short nNewIndex;
					   // create new memory for actual map
if (m_bInsert)
	{
	nNewIndex = m_ptDoc->GetSortedIndex (m_ActList, ptMap);

	if (nNewIndex > 0)
		{
		CScannedMap* ptPrevMap = (CScannedMap*)m_ActList.GetAt(nNewIndex-1);
		CString szPrevName = ptPrevMap->GetName();
		CString	szNewName = ptMap->GetName();
		if (szNewName.Compare ((LPCTSTR)szPrevName) == 0)
			{
			AfxMessageBox (IDS_SAME_NAME);
			return FALSE;
			}
		}

	CScannedMap* ptNewMap = new CScannedMap (*ptMap);
	if (ptNewMap != NULL)
		{
		m_ActList.InsertAt (nNewIndex, ptNewMap);	// insert new  
		m_bChanged = TRUE;
		}

	RemoveListSelection();				// for multi selection list box

	m_nListIndex = nNewIndex;
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ActList.RemoveAt (m_nOldIndex); 	// delete old database entry 
	nNewIndex = m_ptDoc->GetSortedIndex (m_ActList, ptMap); 

	CScannedMap* ptNewMap = new CScannedMap (*ptMap);
	if (ptNewMap != NULL)
		{
		m_ActList.InsertAt (nNewIndex, ptNewMap);	// insert new
		m_bChanged = TRUE;

		if (nNewIndex > m_nOldIndex)
			if (m_nListIndex > m_nOldIndex && m_nListIndex <= nNewIndex)
				m_nListIndex--;   

		if (nNewIndex < m_nOldIndex)
			if (m_nListIndex >=	nNewIndex  && m_nListIndex < m_nOldIndex)
				m_nListIndex++;
		}
	}
		
if (m_bChanged)
	{
	if (ptInit->IsSaveSignal())
		MessageBeep(MB_OK);	
	}

	              				// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
CString szNewName = ptMap->GetName();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);    
	ptList->SetSel(nNewIndex, TRUE);	// for multi selection list box
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.CompareNoCase((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);  
		ptList->SetSel(nNewIndex, TRUE);	// for multi selection list box
		}   
	}

return TRUE;
}


/************************************************************************
 *  ScMpDlg.cpp	  			D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CScanMapDlg::DoDataExchange(CDataExchange* pDX)
{
if (pDX->m_bSaveAndValidate)
	{  
	m_nOldIndex 	= m_nListIndex;	  
	}
else{   
	CScannedMap* ptNewMap = NULL;
							
	if (m_nListIndex >= 0 && m_nListIndex<m_ActList.GetSize())	
		ptNewMap = (CScannedMap*)m_ActList.GetAt(m_nListIndex);

	if (ptNewMap != NULL)
		{
		m_ActMap.Reset();
		m_ActMap = *ptNewMap;
		this->SetData (ptNewMap);    
	    }
    }


	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CScanMapDlg)
	DDX_Check(pDX, IDC_SMAUTOSEL, m_bAutoSel);
	DDX_Radio(pDX, IDC_SMLAMBERT, m_nType);
	DDX_LBIndex(pDX, IDC_SMLIST, m_nListIndex);
	DDX_Text(pDX, IDC_SMPATH, m_szPath);
	DDV_MaxChars(pDX, m_szPath, 256);
	DDX_Text(pDX, IDC_SMSTATE, m_szState);
	DDX_Text(pDX, IDC_SMNAME, m_szName);
	//}}AFX_DATA_MAP


if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{
		m_ActMap.Reset();
		this->GetData (&m_ActMap);  		   
		if (!this->InsertSorted (&m_ActMap))	
			{				   // checks for double names
			pDX->Fail();    // DDX_Text(pDX, IDC_SMNAME, m_szName); must be last DDX_...
			}
		}
	else{				  // change-mode
		if (m_nOldIndex>=0 && m_nOldIndex<m_ActList.GetSize())
			{
			CScannedMap* ptOldMap = (CScannedMap*)m_ActList.GetAt(m_nOldIndex);

			this->GetData (&m_ActMap);  

			if (!m_ActMap.IsEqual(*ptOldMap))
				{  									// data has been changed !!
						// check if new name already used at other position in this array
				short nTestIndex = this->MapNameToIndex	(m_ActMap.GetName());
				if ((nTestIndex > -1) && (nTestIndex != m_nOldIndex))
					{
					AfxMessageBox (IDS_SAME_NAME);
					pDX->Fail();
					}
				else{
					this->InsertSorted (&m_ActMap);
					delete ptOldMap;
					}
				}
			}
		}
    }
}



BEGIN_MESSAGE_MAP(CScanMapDlg, CDlgTool)
	//{{AFX_MSG_MAP(CScanMapDlg)
	ON_BN_CLICKED(IDC_SMDELETE, OnDeleteMap)
	ON_LBN_SELCHANGE(IDC_SMLIST, OnSelChangeMapList)
	ON_BN_CLICKED(IDC_SMCALIB, OnCalibrateMap)
	ON_BN_CLICKED(IDC_SMINSERT, OnInsert)
	ON_BN_CLICKED(IDC_SMSELECT, OnSelectMapFile)
	ON_LBN_DBLCLK(IDC_SMLIST, OnDblclkList)
	ON_EN_CHANGE(IDC_SMNAME, OnChangeName)
	ON_BN_CLICKED(IDC_SMIMPORT, OnImport)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_SMEXPORT, OnExport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  ScMpDlg.cpp	  				F i l l M a p L i s t 					*
 ************************************************************************/
short CScanMapDlg::FillMapList ()
{
CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<m_ActList.GetSize(); i++)
	{      
	CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt (i);
	if (ptMap != NULL)
		{
		szText = ptMap->GetName();
		ptList->AddString((LPCTSTR)szText);  
		}
	}    
	          
BOOL bData = (m_ActList.GetSize() > 0);
short nListIndex = bData? m_nListIndex : -1;    

this->DisableControl (IDC_SMINSERT, !bData);	
this->DisableControl (IDC_SMCALIB, !bData);  
this->DisableControl (IDC_SMDELETE, !bData); 
this->DisableControl (IDOK, !bData);  
 
return nListIndex;
}                             


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CScanMapDlg 

/************************************************************************
 *  ScMpDlg.cpp	  				O n I n i t D i a l o g 				*
 ************************************************************************/
BOOL CScanMapDlg::OnInitDialog() 
{
	m_nListIndex = this->FillMapList ();

	if (m_nListIndex > -1)
	{
		CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
		if (ptList != NULL)
			ptList->SetSel(m_nListIndex);

		CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt (m_nListIndex);
		m_ActMap = *ptMap;
		this->DisableControl (IDC_SMINSERT, TRUE);
		this->DisableControl (IDC_SMEXPORT, FALSE);
	}
	else
	{
		this->DisableControl (IDC_SMEXPORT, TRUE);
	}

	CDlgTool::OnInitDialog();

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  ScMpDlg.cpp	  			O n S e l e c t M a p F i l e				*
 ************************************************************************/
void CScanMapDlg::OnSelectMapFile() 
{
	// TODO: Add your control notification handler code here
static char szFilter[] = "Karte (*.bmp)|*.bmp||"; 

CFileDialog dlg(TRUE, 	  					// File Open dialog
				NULL,						// no default extension
				"*.bmp",					// initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				this);						// parent window

//CString szPath = ptInit->GetActualPath() + "bmp";	// without NameExt
//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	m_szPath = dlg.GetPathName();
	this->SetText (IDC_SMPATH, m_szPath);

	CString szFileExt = dlg.GetFileName();
	CString szFile = szFileExt;			   // remove ext from file.ext
	short nDot = szFileExt.Find('.');
	if (nDot > 0) szFile = szFileExt.Left(nDot);
	this->SetText (IDC_SMNAME, szFile);
	this->SelectItem (IDC_SMNAME);
	}
}



/************************************************************************
 *  ScMpDlg.cpp	  					O n I n s e r t		 				*
 ************************************************************************/
void CScanMapDlg::OnInsert() 
{
	// TODO: Add your control notification handler code here
m_bInsert = TRUE;
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	if (m_ActList.GetSize() == 1)
		{
		this->DisableControl (IDC_SMCALIB, FALSE);  
		this->DisableControl (IDC_SMDELETE, FALSE);  
		}
	}
this->DisableControl (IDC_SMINSERT, TRUE);	// avoid to select Insert again
this->DisableControl (IDC_SMCALIB, FALSE); 	// force to select calibration
this->DisableControl (IDOK, TRUE);  // don't allow OK; new map is uncalibrated!

m_bInsert = FALSE;	
}


/************************************************************************
 *  ScMpDlg.cpp	  			O n C a l i b r a t e M a p					*
 ************************************************************************/
void CScanMapDlg::OnCalibrateMap() 
{
	// TODO: Add your control notification handler code here
m_bCalibDlg = TRUE;
CDlgTool::OnOK();
}


/************************************************************************
 *  ScMpDlg.cpp	  			O n D e l e t e M a p		 				*
 ************************************************************************/
void CScanMapDlg::OnDeleteMap() 
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    

short nDeleteIndex = ptList->GetCurSel (); 
if (nDeleteIndex > -1)
	{
	CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt(nDeleteIndex); 
	if (ptMap!=NULL)
		{
		delete ptMap;
		m_ActList.RemoveAt (nDeleteIndex); 
		m_bChanged = TRUE;           
		}

	ptList->DeleteString (nDeleteIndex);

	if (m_ActList.GetSize() > 0)
		{ 
		m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 
		ptList->SetSel(m_nListIndex, TRUE);	// for multi selection list box
		this->UpdateData(FALSE);
		}
	else{
		this->DisableControl (IDC_SMCALIB, TRUE);  
		this->DisableControl (IDC_SMDELETE, TRUE);  
		this->DisableControl (IDOK, FALSE);  
		this->RemoveListSelection();
		}
	}	 
}

/************************************************************************
 *  ScMpDlg.cpp	  				O n D b l c l k L i s t					*
 ************************************************************************/
void CScanMapDlg::OnDblclkList() 
{
	// TODO: Add your control notification handler code here
this->OnOK();
}

/************************************************************************
 *  ScMpDlg.cpp	  					O n O K								*
 ************************************************************************/
void CScanMapDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
m_bCalibDlg = FALSE;
CDlgTool::OnOK();
}

/************************************************************************
 *  ScMpDlg.cpp	  			O n S e l C h a n g e M a p L i s t			*
 ************************************************************************/
void CScanMapDlg::OnSelChangeMapList() 
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
short nNewIndex = ptList->GetCurSel ();
short nOldIndex = m_nListIndex;

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{  
		if (m_bCalibDlg)
			{						// projection of calibrated map changed!
			m_nListIndex = nOldIndex;
			ptList->SetSel(m_nListIndex, TRUE);	// use old map index again
			CDlgTool::OnOK();
			return;				// stop changing list and show calib dlg
			}
 		this->UpdateData(FALSE);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetSel (m_nListIndex, TRUE);		  
		}

	CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt (m_nListIndex);
	m_ActMap = *ptMap;
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	}	

this->DisableControl (IDC_SMINSERT, TRUE);

BOOL bDisableExport = (GetSelCnt() == 0);
this->DisableControl (IDC_SMEXPORT, bDisableExport);

BOOL bMultSel = (GetSelCnt() > 1);
this->DisableControl (IDC_SMCALIB, bMultSel);
this->DisableControl (IDC_SMDELETE, bMultSel);
}


/************************************************************************
 *  ScMpDlg.cpp	  				O n C h a n g e N a m e  				*
 ************************************************************************/
void CScanMapDlg::OnChangeName() 
{
	// TODO: Wenn es sich hierbei um ein RICHEDIT-Steuerelement handelt, sendet es
	// sendet diese Benachrichtigung nur, wenn die Funktion CDlgTool::OnInitDialog()
	// berschrieben wird, um die EM_SETEVENTMASK-Nachricht an das Steuerelement
	// mit dem ENM_CHANGE-Attribut ORed in die Maske lParam zu senden.
	
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen

BOOL bUsedName=FALSE;

this->GetText (IDC_SMNAME, m_szName);

if (m_szName.GetLength())				// check if used name:
	{
	CString szUsedName;
	short i;
	for (i=0; i<m_ActList.GetSize() && !bUsedName; i++)
		{      
		CScannedMap* ptMap = (CScannedMap*)m_ActList.GetAt (i);
		if (ptMap != NULL)
			{
			szUsedName = ptMap->GetName();
			bUsedName = (m_szName.Compare (szUsedName) == 0);
			}
		}    
	}

BOOL bDisable = (bUsedName 
			|| (m_szName.GetLength() == 0));
		//	|| (m_szPath.GetLength() == 0));

this->DisableControl (IDC_SMINSERT, bDisable);	
this->DisableControl (IDC_SMCALIB, !bDisable);
}

/************************************************************************
 *  ScMpDlg.cpp					TerminateWithBackSlash					*
 ************************************************************************/
void CScanMapDlg::TerminateWithBackSlash (CString& szPath)
{
					// check if base path terminates with slash
char cLast = szPath.GetAt (szPath.GetLength()-1);
if (cLast != '\\') szPath += "\\";
}


/************************************************************************
 *  ScMpDlg.cpp	  			P a t h C o n t a i n s 					*
 *  Purpose: Checks if szPath contains files with szExt (= "bmp")		*
 ************************************************************************/
BOOL CScanMapDlg::PathContains (CStringArray* ptFiles, CString szPath, CString szExt)
{
BOOL bFound = FALSE;
CString szSearchPath (szPath + "\\*." + szExt);	  // G:\ICAO1998\*.bmp

short nCnt = CQuickFind::EnumFiles (ptFiles, szSearchPath);  
bFound = (nCnt > 0);

return bFound;
}

/************************************************************************
 *  ScMpDlg.cpp	  			C o p y F i l e s							*
 *  Purpose: Copies files from ONE source dir to ONE dest dir			*
 *  Files: Name.ext of all files to be copied							*
 *			from szSourcePath to szDestPath								*
 ************************************************************************/
BOOL CScanMapDlg::CopyFiles (CStringArray& Files, CString szSourcePath, CString szDestPath)
{
BOOL bCopied = FALSE;

BeginWaitCursor();		// display the hourglass cursor

short i;
for (i=0; i<Files.GetSize(); i++)			 
	{
	CString szNameExt = Files.GetAt(i);				// N48E0061.bmp
	CString szSource = szSourcePath + "\\" + szNameExt;	// "G:\ICAO1998\N48E0061.bmp"
	CString szDest	= szDestPath + "\\" + szNameExt;

 	if (CopyFile ((LPCTSTR)szSource,	// pointer to name of an existing file 
					(LPCTSTR)szDest,	// pointer to filename to copy to 
					FALSE))				//   BOOL bFailIfExists = FALSE
		{
		bCopied = TRUE;
										// reset write protection of files copied from CD
		CFileStatus status;
		CFile::GetStatus(szDest, status );
		status.m_attribute = CFile::normal | CFile::archive;
		CFile::SetStatus(szDest, status );
		}
	}

EndWaitCursor();		// remove the hourglass cursor

return bCopied;
}

/************************************************************************
 *  ScMpDlg.cpp	  				C o p y F i l e s						*
 *  Purpose: Copies files from different source dirs to ONE dest dir	*
 *  FilePaths: Path/Name.ext of all files to be copied to szDestPath	*
 *  szDestPath must end with a backslash!!								*
 ************************************************************************/
BOOL CScanMapDlg::CopyFiles(CStringArray& FilePaths, CString szDestPath)
{
	BOOL bCopied = FALSE;

	BeginWaitCursor();		// display the hourglass cursor

	short i;
	for (i=0; i<FilePaths.GetSize(); i++)			 
	{
		CString szSource = FilePaths.GetAt(i);			// C:\PF\bmp\N48E0061.bmp
		CString szNameExt = CInitDoc::GetFileFromPath(szSource);
		CString szDest	= szDestPath + szNameExt;

 		if (CopyFile ((LPCTSTR)szSource,	// pointer to name of an existing file 
					(LPCTSTR)szDest,	// pointer to filename to copy to 
						FALSE))				//   BOOL bFailIfExists = FALSE
		{
			bCopied = TRUE;
											// reset write protection of files copied from CD
			CFileStatus status;
			CFile::GetStatus(szDest, status );
			status.m_attribute = CFile::normal | CFile::archive;
			CFile::SetStatus(szDest, status );
		}
	}

	EndWaitCursor();		// remove the hourglass cursor

	return bCopied;
}

/************************************************************************
 *  ScMpDlg.cpp	  			O n I m p o r t								*
 *  Purpose: Add contents of new *.scm file to ScMapDoc.scm				*
 ************************************************************************/
void CScanMapDlg::OnImport() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CString szMaps;
	szMaps.LoadString(IDS_MAPS);

	char szFilterLine[256];
	char szFilter[16];
	wsprintf (szFilter, "*%s", (LPCTSTR)CScanMapDoc::GetExt());
	wsprintf (szFilterLine, "%s (%s)|%s||", (LPCTSTR)szMaps, szFilter, szFilter);
//	static char szFilter[] = "Karten (*.scm)|*.scm||"; 

	CFileDialog dlg(TRUE, 	  				// File Open dialog
				NULL,						// no default extension
				szFilter,					// initial filename (*.scm)
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilterLine,
				this);						// parent window

	BOOL bImport = FALSE;
	int ret; 
	do	
	{								// select dir with *.scm
		ret = dlg.DoModal();
		if (ret==IDOK)
		{
			CString szFile = dlg.GetFileName();
										// don't select name of own *.scm file
			CString szScMpFile;
			szScMpFile.LoadString(IDS_SCANNED_MAP_FILE);
			bImport = (szFile.CompareNoCase (szScMpFile) != 0);
			if (!bImport)
				AfxMessageBox (IDS_SEL_NEW_SCM);
		}
	} while (ret==IDOK && !bImport);



	if (bImport)
	{
		CStringArray FilesToCopy;			// get CString array with long file names
		CString szBmpPath;

		CString szScmPath = ptInit->GetActualPath();	// without NameExt
 		szBmpPath = szScmPath  + "bmp";				// ActualPath/ + bmp

		szScmPath = dlg.GetPathName();				// source path on disk: G:\ICAO1998\ICAO.scm

		short	nNameIndex = szScmPath.ReverseFind('\\');
		CString szSourcePath = szScmPath.Left (nNameIndex);			// G:\ICAO1998

		if (this->PathContains (&FilesToCopy, szSourcePath, "bmp"))
		{
			CString szMsg;

			int iRet = AfxMessageBox (IDS_COPYMAPSTOPC, MB_YESNO);
			if (iRet == IDYES)
			{									// copy *.bmp to PC
				BOOL bCopyMaps=FALSE;

				szMsg = this->Format (IDF_COPYMAPSTOBMP, szBmpPath);
 				int iRet = AfxMessageBox (szMsg, MB_YESNO);
				if (iRet == IDYES)
				{								// copy *.bmp to C:\PF\bmp
					bCopyMaps = TRUE;
				}
				else
				{			
					CDirSelectDlg dlg;

					szMsg.LoadString (IDS_SELMAPPATH);
					dlg.SetTitle(szMsg);
					if(dlg.DoModal())				// get destination on PC
					{
						dlg.GetDirectory(szBmpPath);// C:\...
						bCopyMaps = TRUE;			// or C:\dir1\dir2

						short nSlashIndex = szBmpPath.GetLength()-1;
						char cSlash = szBmpPath.GetAt(nSlashIndex);
						if (cSlash == '\\')			// remove "\" if available
							szBmpPath = szBmpPath.Left (nSlashIndex);	// C:
					}
					else
					{
						bImport = FALSE;
					}
				}

				if (bCopyMaps)
					this->CopyFiles (FilesToCopy, szSourcePath, szBmpPath);	// copy maps
			}
			else
			{						// bmp files stay on removable disk
				szBmpPath = szSourcePath;
			}
		}

		if (!bImport)			// may be reset if GetDirectory-Dialog returned FALSE!
			return;

		if (this->UpdateData(TRUE))
		{		
								// save actual map name	
			CString szActMapName = m_ptDoc->GetMapName (m_nListIndex);

									// write actual array into doc
			m_ptDoc->SetDataBase (&m_ActList);  

									// add new maps into doc
			m_ptDoc->ActivateImportMode (szBmpPath);		// "D:\Code\Cpp_Win\PF40\bmp"
			m_ptDoc->OnOpenDocument (szScmPath);  // read from new file ("E:\Karten_CD\FromSpace\Eichung.scm")

									// read extended map array from doc into dlg
			m_ptDoc->GetDataBase (&m_ActList);

			m_bChanged = m_ptDoc->IsImported();
			if (m_bChanged)
			{
				this->FillMapList ();			// update dlg list
				m_nListIndex = m_ptDoc->MapNameToIndex (szActMapName);	// set previous selection

				if (m_nListIndex == -1)
				{								// there was nothing selected before
					if (m_ActList.GetSize() > 0)
						m_nListIndex = 0;			// select first entry
				}

				this->UpdateData (FALSE);
				if (ptInit->IsSaveSignal())
					MessageBeep(MB_OK);	
			}
		}
	}
}

/************************************************************************
 *  ScMpDlg.cpp	  			G e t S e l C n t							*
 ************************************************************************/
short CScanMapDlg::GetSelCnt()
{
	short nActSelCnt = 0;

	CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
	int nMaxSelCnt = ptList->GetCount();

	int* ptInt = new int[nMaxSelCnt];	// Allocate new memory
	nActSelCnt = (short)ptList->GetSelItems (nMaxSelCnt, (LPINT)ptInt);

	return nActSelCnt;
}

/************************************************************************
 *  ScMpDlg.cpp	  			O n E x p o r t								*
 ************************************************************************/
void CScanMapDlg::OnExport() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CDirSelectDlg dlg;

	CString szMsg;
	szMsg.LoadString (IDS_SELMAPPATH);
	dlg.SetTitle(szMsg);
	if(dlg.DoModal())				// get destination on PC
	{
		CString szDestPath;
		dlg.GetDirectory(szDestPath);	// ""D:\Update\Karten\Oberursel"
										// ensure, path ends with backslash
		short nSlashIndex = szDestPath.GetLength()-1;
		char cSlash = szDestPath.GetAt(nSlashIndex);
		if (cSlash != '\\')			// add "\" if missing
			szDestPath += "\\";		// "D:\Update\Karten\Oberursel\"


	    CScanMapDoc*	ptScanMapDoc;
		ptScanMapDoc	= new CScanMapDoc;  

		if (ptScanMapDoc != NULL)
		{
			BOOL bCopyBitmaps = FALSE;

			CString szScmFile("Calib.scm");
			CString szScmFullPath (szDestPath);
			szScmFullPath += szScmFile;
			ptScanMapDoc->SetTitle((LPCTSTR)szScmFile);
			ptScanMapDoc->SetPathName ((LPCTSTR)szScmFullPath);	// "D:\Update\Karten\Oberursel\Calib.scm"


									
			CStringArray PathsToCopy;		// create CString array with long file names
												// for each selected list entry
			CListBox* ptList = (CListBox*)GetDlgItem (IDC_SMLIST);    
			int nMaxSelCnt = ptList->GetCount();

			int* ptInt = new int[nMaxSelCnt];	// Allocate new memory
			int nActSelCnt = ptList->GetSelItems (nMaxSelCnt, (LPINT)ptInt);
			if (nActSelCnt > 0)
			{
				int i;
				for (i=0; i<nActSelCnt; i++)
				{
					int nIndex = ptInt[i];			// 0, ... N-1
					
					CScannedMap* ptEntry = (CScannedMap*)m_ActList.GetAt(nIndex); 
					if (ptEntry!=NULL)
					{
						CString szPath = ptEntry->GetPath();// "E:\Karten_CD\FrankfurtNord\FrankfurtNord.bmp"
						CString szFileExt = CInitDoc::GetFileFromPath(szPath);
						PathsToCopy.Add(szPath);

												// make copy from original entry
						CScannedMap* ptNewEntry = new CScannedMap(*ptEntry);	// get new memory
												// change path to new destination
						CString szFullDestPath(szDestPath);
						szFullDestPath += szFileExt;
						ptNewEntry->SetPath(szFullDestPath);// "D:\Update\Karten\Oberursel\FrankfurtNord.bmp"

						if (ptScanMapDoc->AppendMap(ptNewEntry))
							bCopyBitmaps = TRUE;
					}
				} // for each selected item
			} // nActSelCnt > 0

			delete [] ptInt;

			if (bCopyBitmaps)
			{
				this->CopyFiles (PathsToCopy, szDestPath);	// copy elev arrays
				ptScanMapDoc->OnSaveDocument(ptScanMapDoc->GetPathName());
			}

	        delete ptScanMapDoc;
		} // ptScanMapDoc != NULL
	} // DoModal	
}

/************************************************************************
 *  ScMpDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CScanMapDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

