#ifndef AFX_SCMPDLG_H__EAE380D3_456D_11D2_96EB_0060978B146F__INCLUDED_
#define AFX_SCMPDLG_H__EAE380D3_456D_11D2_96EB_0060978B146F__INCLUDED_

// ScMpDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CScanMapDlg 

class CScanMapDoc;
class CScanMapDlg : public CDlgTool
{
// Konstruktion
public:
	CScanMapDlg(CWnd* pParent = NULL, CScanMapDoc* ptDoc=NULL);   // Standardkonstruktor
	~CScanMapDlg();
	BOOL WriteDataBaseIntoDoc();


private:
	void DeleteArrayOf (CObArray* ptArray);
	void TerminateWithBackSlash (CString& szPath);
	BOOL PathContains (CStringArray* ptFiles, CString szPath, CString szExt);
	BOOL CopyFiles (CStringArray& Files, CString szSourcePath, CString szDestPath);
	BOOL CopyFiles(CStringArray& FilePaths, CString szDestPath);
	short GetSelCnt();

	void RemoveListSelection();
	void SetListSelection(short nIndex);
	short MapNameToIndex (CString szName);
	BOOL InsertSorted (CScannedMap* ptMap);
	short FillMapList ();
	CScannedMap	m_ActMap;
	CObArray	m_ActList;			// array of CScannedMap         
	BOOL		m_bChanged;
	BOOL		m_bCalibDlg;

// Dialogfelddaten
	//{{AFX_DATA(CScanMapDlg)
	enum { IDD = IDD_SCMPLIST };
	BOOL	m_bAutoSel;
	int		m_nType;
	int		m_nListIndex;
	CString	m_szName;
	CString	m_szPath;
	CString	m_szState;
	//}}AFX_DATA

private:
	CScanMapDoc* m_ptDoc;
	int			m_nOldIndex;
	int			m_bInsert;

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CScanMapDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

	void SetData (CScannedMap* ptScannedMap);
	void GetData (CScannedMap* ptScannedMap);

// Implementierung
protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CScanMapDlg)
	afx_msg void OnDeleteMap();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelChangeMapList();
	afx_msg void OnCalibrateMap();
	afx_msg void OnInsert();
	afx_msg void OnSelectMapFile();
	afx_msg void OnDblclkList();
	afx_msg void OnChangeName();
	virtual void OnOK();
	afx_msg void OnImport();
	afx_msg void OnExport();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // AFX_SCMPDLG_H__EAE380D3_456D_11D2_96EB_0060978B146F__INCLUDED_
