#ifndef __SCANMAPDOC__
#define __SCANMAPDOC__

#include "..\Cpptools\Image.h"

/************************************************************************
 *  							S c M p D o c . h 	 					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "ScanMap.h"
#include "ScaledMapList.h"		// to select different maps for same position


class CLocation;
class CWayDoc;
class CTrackDoc;
class CScanMapView;
class CDC;
class CScanMapDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CScanMapDoc)

protected:   


// Attributes
public:       
	CObArray	m_ScannedMaps;			// array of CScannedMap         
	short		m_nActMapIndex;
	BOOL		m_bShowCalibDlg;
	BOOL		m_bAutoSelect;

	CString		m_szMapFile;
	CImage*		m_ptDib;		// the applications main CImage pointer
	CScanMapView*	m_ptScMpView;	// view to receive a pointer of actual m_ptDib!!


private:
	BOOL	m_bAborted;
	WORD	m_wCmdID;
	BOOL	m_bImported;
	CString	m_szDestBmpPath;		// base path for imported bmps
	BOOL	m_bImport;
	short	m_nIncreaseCnt;
	double	m_dActFaktX;			// actual map scale factor X, 
	double	m_dActFaktY;			// actual map scale factor Y, 
									// used to set scale factor of new loaded maps
	CScaledMapList	m_ScaledMapList;

	// Operations
public:
	CScanMapDoc(CString szFileName = "");	
	~CScanMapDoc();   

	static CString GetExt();
	void GetDataBase (CObArray* ptMapList);
	void SetDataBase (CObArray* ptMapList);
	
	CSize OriginalToScaledLP(CSize pOriginalLP);
	CPoint OriginalToScaledLP(CPoint pOriginalLP);
	CPoint ScaledToOriginalLP(CPoint pScaledLP);
	void ChangeIncreaseCnt (short nDiff);
	BOOL CalcActFakt (CSize cImage, CSize* ptVirtLP);
	void SetIncreaseCnt(short nCnt) { m_nIncreaseCnt = nCnt; }
	short GetIncreaseCnt () { return m_nIncreaseCnt; }
	void SetScaleFaktX(double dFaktX) { m_dActFaktX = dFaktX; }
	void SetScaleFaktY(double dFaktY) { m_dActFaktY = dFaktY; }
	double GetScaleFaktX () { return m_dActFaktX; }
	double GetScaleFaktY () { return m_dActFaktY; }

    void SetAborted (BOOL bSet) { m_bAborted = bSet; }
	void SetCmdID (WORD wCmd) {	m_wCmdID=wCmd; }
	WORD GetCmdID () { return m_wCmdID;	}

 	BOOL IsAborted() { return m_bAborted; }
	BOOL IsImported() { return m_bImported; }

	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	BOOL	OpenBmpFile (CString szFile);		// see *.cpp 
	void	SetActMapIndex (short nIndex) { m_nActMapIndex = nIndex; }
	void	SaveMousePos(CPoint pMouseLP);
	void	SetActivateCalibDlg (BOOL bSet) { m_bShowCalibDlg = bSet; }
	void	SetAutoSelect (BOOL bSet) { m_bAutoSelect = bSet; }
	BOOL	IsActivatedCalibDlg() { return m_bShowCalibDlg; }
	BOOL	IsAutoSelectAllowed() { return m_bAutoSelect; }

	CString GetMapFile () { return m_szMapFile; }
	short	GetActMapIndex () { return m_nActMapIndex; }
	CImage*	GetDibPtr () { return m_ptDib; }
	void	SetViewPtr (CScanMapView* ptView) { m_ptScMpView = ptView; }

	BOOL AppendMap (CScannedMap* ptMap);
	BOOL AddMap (short nIndex, CScannedMap* ptMap);
	short GetSortedIndex (CObArray& Maps, CScannedMap* ptMap);
	short InsertMapSorted(CScannedMap* ptMap);
	BOOL ChangeMap (short nIndex, CScannedMap* ptNewMap);
	BOOL DeleteMap (short nIndex);
	short GetMapCnt ();
	CScannedMap* GetMapPtr (short nIndex);
	CString GetMapName (short nIndex);
	short MapNameToIndex (CString szName);
	short MapPathToIndex (CString szPath);

	BOOL IncreaseCntOK (CScannedMap* ptMap);
	BOOL ActivateMap (short nActIndex, CSize* ptSizeTotal=NULL);

	BOOL ActivateScMapForLatLon (CLatLon LatLon);
	BOOL GetVACIndexFor (CLatLon llAerodrome, short* ptVACIndex=NULL);
	BOOL IsOnVAC (double dLat, double dLon, CLatLon llAerodrome, short* ptVACIndex);
	BOOL ActivateNearestMap (CWayDoc* ptWayDoc);
	BOOL ActivateNearestMap (CTrackDoc* ptTrackDoc);
	BOOL SearchNextMovingMap (CTrackDoc* ptTrackDoc, CSize* ptSizeTotal);

	BOOL IsGoodCenterMap (CLatLon llActCenter, CScannedMap* ptMap);
	BOOL IsGoodNextMap (CLatLon llOldCenterSide, CLatLon llTestCenterSide,  
						double dActMapWidth,
						short nDir, CScannedMap* ptMap,	short* ptMaxQual);


	BOOL NextMapMiddle (CSize* ptSizeTotal, BOOL bLarger, BOOL* ptMapChanged);
	BOOL AssignIncreaseCountersFor(CDC* pDC, double dLat, double dLon);


	BOOL NextMapEast (CSize* ptSizeTotal, double dActLat);
	BOOL NextMapWest (CSize* ptSizeTotal, double dActLat);
	BOOL NextMapSouth (CSize* ptSizeTotal, double dActLon);
	BOOL NextMapNorth (CSize* ptSizeTotal, double dActLon);

	BOOL Change (CWnd* ptWnd);
	BOOL ChangeCalibration(CScanMapView* ptScMpView);
	void ActivateImportMode (CString szBmpPath);
	void Serialize(CArchive& ar);
     
private:
	void DeleteArrayOf (CObArray* ptArray);
	void CopyMaps (CObArray* ptDest, CObArray* ptSource);
	  
// Implementation
protected:          

	// Generated message map functions
protected:
	//{{AFX_MSG(CScanMapDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
