/************************************************************************
 *  						S c M p F i x P . c p p	  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "ScMpFixP.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapFixPt
IMPLEMENT_SERIAL(CMapFixPt, CObject, 0 /* schema number*/ )

#define pi 3.1415926
#define NO_POSITION -1000

/************************************************************************
 *  ScMpFixP.cpp			C M a p F i x P t				Constructor	*
 ************************************************************************/
CMapFixPt::CMapFixPt()
{ 
m_lX	= NO_POSITION;
m_lY	= NO_POSITION;
m_dLat = NO_KOORD;	 
m_dLon = NO_KOORD;  
}

/************************************************************************
 *  ScMpFixP.cpp			C M a p F i x P t				Constructor	*
 ************************************************************************/
CMapFixPt::CMapFixPt(long lX, long lY, double dLat, double dLon)
{ 
m_lX	= lX;
m_lY	= lY;
m_dLat = dLat;
m_dLon = dLon;
}

/************************************************************************
 *  ScMpFixP.cpp			C M a p F i x P t				Constructor	*
 ************************************************************************/
CMapFixPt::CMapFixPt(CMapFixPt& Source)
{ 
m_lX = Source.m_lX;
m_lY = Source.m_lY;
m_dLat = Source.m_dLat;
m_dLon = Source.m_dLon;
}

/************************************************************************
 *  ScMpFixP.cpp			C M a p F i x P t				Destructor	*
 ************************************************************************/
CMapFixPt::~CMapFixPt()
{
} 

/************************************************************************
 *  ScMpFixP.cpp				operator=								*
 ************************************************************************/
const CMapFixPt& CMapFixPt::operator=(const CMapFixPt& Source)
{
m_lX	= Source.m_lX;
m_lY	= Source.m_lY;
m_dLat = Source.m_dLat;
m_dLon = Source.m_dLon;
return *this;
}

/************************************************************************
 *  ScMpFixP.cpp    		 			G e t L P						*
 ************************************************************************/
CPoint CMapFixPt::GetLP()
{
CPoint Pt(m_lX, m_lY);
return Pt;
}

/************************************************************************
 *  ScMpFixP.cpp    		 			S e t L P						*
 ************************************************************************/
void CMapFixPt::SetLP(CPoint pMouseLP)
{
m_lX = pMouseLP.x;
m_lY = pMouseLP.y;
}

/************************************************************************
 *  ScMpFixP.cpp    		 	S e t L a t L o n						*
 ************************************************************************/
void CMapFixPt::SetLatLon (double dLat, double dLon)
{
m_dLat = dLat;
m_dLon = dLon;
} 

/************************************************************************
 *  ScMpFixP.cpp    				E r a s e L P						*
 ************************************************************************/
void CMapFixPt::EraseLP()
{
m_lX = NO_POSITION;
m_lY = NO_POSITION;
}

/************************************************************************
 *  ScMpFixP.cpp    	 		I s D e f i n e d L P					*
 ************************************************************************/
BOOL CMapFixPt::IsDefinedLP()
{
BOOL bLPDefined = (m_lX != NO_POSITION && m_lY != NO_POSITION);
return bLPDefined;
}

/************************************************************************
 *  ScMpFixP.cpp    		 		I s D e f i n e d					*
 ************************************************************************/
BOOL CMapFixPt::IsDefined()
{
BOOL bKoordDefined = (m_dLat != NO_KOORD && m_dLon != NO_KOORD);
BOOL bLPDefined = (m_lX != NO_POSITION && m_lY != NO_POSITION);
return bKoordDefined && bLPDefined;
}

/************************************************************************
*  ScMpFixP.cpp    		 		 S e r i a l i z e						*
 ************************************************************************/
void CMapFixPt::Serialize(CArchive& ar)
{ 
if (ar.IsStoring())
	{		// TODO: add storing code here 
	ar << m_lX;
	ar << m_lY;
	ar << m_dLat;	
	ar << m_dLon;	
	}
else{       // TODO: add loading code here    
	ar >> m_lX;
	ar >> m_lY;
	ar >> m_dLat;	
	ar >> m_dLon;	
	}
} 
  
/////////////////////////////////////////////////////////////////////////////
// CMapFixPt commands
