#ifndef __MAPFIXPT__      
#define __MAPFIXPT__

// ScMpFixP.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CMapFixPt : public CObject
{
DECLARE_SERIAL(CMapFixPt)

#define DB180 180.		
#define DB360 360. 
#define NO_KOORD	1000.	/* undefined val of Lat or Lon		*/


// Attributes
private:    

// Operations
protected:
	
	long	m_lX;
	long	m_lY;
	double	m_dLat;
	double	m_dLon;

// Implementation
public:
	CMapFixPt();		
	CMapFixPt(long lX, long lY, double dLat, double dLon);
	CMapFixPt(CMapFixPt& Source);
	~CMapFixPt();        

	const CMapFixPt& operator=(const CMapFixPt& Source);
	CPoint GetLP();
	void EraseLP();
	BOOL IsDefinedLP();
	BOOL IsDefined();

	void Serialize(CArchive& ar);

	long GetLP_X () const { return m_lX; }
	long GetLP_Y () const { return m_lY; }
	void SetLP_X (long lX) { m_lX = lX; }
	void SetLP_Y (long lY) { m_lY = lY; }
	void SetLP(CPoint pMouseLP);

	double GetLat () const { return m_dLat; }
	double GetLon () const { return m_dLon; }
	void SetLat (double dLat) { m_dLat = dLat; }
	void SetLon (double dLon) { m_dLon = dLon; }
	void SetLatLon (double dLat, double dLon);
};

#endif 

