// ScMpView.h : interface of the CScanMapView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "..\CPPTOOLS\TxVwTool.h"

class CInteractiveMap;
class CAirspace;
class CAirspaceSegmentDoc;
class CScanMapView : public CTextViewTool
{								
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont;
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	CPoint	m_pMouseLP;

	CRect	m_rMaxRect;

	CInteractiveMap* m_ptInterMap;
 	CColorDoc* 	m_ptColor;

private:
	short		m_nUpdates;
	BOOL		m_bDrawn;

	BOOL		m_bDrawFixPoint;
	CPoint		m_ActPointLP;
	CImage*		m_pDib;

	BOOL		m_bOnDrawScroll;	// set scroll bar after Update
	BOOL		m_bHorz;
	BOOL		m_bMax;

	CDC*			m_ptDC;			// pointers stored for ScMpCriticalLeg
	CScannedMap*	m_ptMap;

									// for changing size of scanned map
	CSize	m_sOrigImage;
	BOOL	m_bTBMapCenter;
	BOOL	m_bTBMapLarger;
	BOOL	m_bTBMapSmaller;

public: // create from serialization only
	CScanMapView();
	DECLARE_DYNCREATE(CScanMapView)

	void ScrollVertMax (BOOL bMax);
	void ScrollHorzMax (BOOL bMax);
	void ScrollTo (CPoint pScrollLP);

	BOOL DoCenter (double dLat, double dLon, BOOL bRedraw);

	void			SetDCPtr (CDC* ptDC) { m_ptDC = ptDC; }		// for DrawCriticalLeg
	void			SetMapPtr (CScannedMap* ptMap) { m_ptMap = ptMap; }

	// sollte GetDibPtr in GetAbsoluteBmpSizeLP ersetzen, indem SetImagePtr
	// vor Anzeige eines neuen ScanMapViews aufgerufen wird.
	// Dafr wurde aber noch keine passende  Stelle gefunden.
	void			SetImagePtr (CImage* ptImage) { m_pDib = ptImage; }

	CDC*			GetDCPtr () { return m_ptDC; }
	CScannedMap*	GetMapPtr () { return m_ptMap; }
	CColorDoc*		GetColorDocPtr () { return m_ptColor; }


// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CScanMapView();
	void CheckLoaded();
	void FreeMemory();
	void CheckCalibration();

	BOOL	IsDrawn() { return m_bDrawn; }

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, int CharX);
	void PrepareXTabs (CDC* pDC);

	void Circle (CDC* pDC, long nX0, long nY0, short nRadius, BOOL bFilled);
	void DrawFixPoint(CDC* pDC, CPoint pLP);

	void DrawLabel (CDC* pDC, long LPx1, long LPy1, double dAngle, long LineY, 
				BOOL bRightAlign, CString szLoc, short nSizeLP, BOOL bActWpt=FALSE);

	BOOL IsForRoute ();
	long GetScale(CDC* pDC, CScannedMap* ptMap, BOOL bConsiderScrollPos=FALSE);

	void DrawRouteOnMap (CDC* pDC, CScannedMap* ptMap);
	void DrawMvMpRteOnMap (CDC* pDC, CScannedMap* ptMap);
	void DrawTrackOnMap (CDC* pDC, CScannedMap* ptMap);
	void DrawScannedMaps (CDC* pDC, CScannedMap* ptMap, DRECT rLatLon);
	void DrawElevAreas (CDC* pDC, CScannedMap* ptMap);

#ifdef __LATLONTOLP_FOR_DOUBLE__
	long DistanceToLP(CScannedMap* ptMap, double dLat, double dLon, double* LPx, double* LPy,
							double dDist, short nDistDim);
#endif
	
	long DistanceToLP(CScannedMap* ptMap, double dLat, double dLon, long* LPx, long* LPy,
							double dDist, short nDistDim);
	BOOL DrawSegments (CDC* pDC, CScannedMap* ptMap, CAirspace* ptAirspace,
								CAirspaceSegmentDoc* ptSegDoc, long lStartIndex, double dLonOffset);
	void DrawAirspaces (CDC* pDC, CScannedMap* ptMap);

	void UpdateWhiteAreas (CDC* pDC, CScannedMap* ptMap, CRect& rClientDP, CRect& rMapDP);
	BOOL DrawScannedMap (CDC* pDC, BOOL bDraw = TRUE);
 	void PrintPage (CDC* pDC, int nPageToPrint);

private:
	void GetLabelStartLP(long LPx1, long LPy1, double TextAngle, long LineY,
								   long* ptLPx, long* ptLPy);
	void GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax);
	CRect GetUseableRectLP (CDC* pDC = NULL);
	void TextRotate (CDC* pDC, long lX, long lY, double dAngle, CString szText);
	void RectAlignRight (CDC* pDC, int Xright, int Ybot, int LineY,
				short nSizeLP, BOOL bFrame);
	void RectAlignLeft (CDC* pDC, int Xleft, int Ybot, int LineY,
				short nSizeLP, BOOL bFrame);
	void OnUpdateShow (CCmdUI* pCmdUI, short nType);
	void CheckCalibration (CSize sSizeLP);
	void GetClientRectLP (CRect& rClientLP);
	BOOL GetAbsoluteBmpSizeLP (CSize* ptActualBmpLP);

									// for changing size of scanned map
	void ScrollToScaledPos (CRect rView);

	BOOL GetRightScreenLatLon(double* ptLat, double* ptLon);
	BOOL GetLeftScreenLatLon(double* ptLat, double* ptLon);
	BOOL GetTopScreenLatLon(double* ptLat, double* ptLon);
	BOOL GetBottomScreenLatLon(double* ptLat, double* ptLon);
	BOOL GetCenterScreenLatLon(double* ptLat, double* ptLon);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL


// Generated message map functions
protected:
	//{{AFX_MSG(CScanMapView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnMenuAppend();
	afx_msg void OnMenuInsert();
	afx_msg void OnMenuBear();
	afx_msg void OnMenuDelete();
	afx_msg void OnMenuActivate();
	afx_msg void OnMenuPlAlt();
	afx_msg void OnMenuInsMapLoc (UINT nID);
	afx_msg void OnMenuAppMapLoc (UINT nID);
	afx_msg void OnMenuBearMapNav (UINT nID);
	afx_msg void OnMenuDelRteWpt (UINT nID);
	afx_msg void OnMenuActRteWpt (UINT nID);
	afx_msg void OnMenuPlAltRteWpt (UINT nID);
	afx_msg void OnMenuMeEditMapLoc (UINT nID);
	afx_msg void OnMenuMeEditAirspace (UINT nID);
	afx_msg void OnUpdateWyIns(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyApp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyBear(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyDel(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyAct(CCmdUI* pCmdUI);
	afx_msg void OnUpdateWyPlAlt(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnMenuCenter();
	afx_msg void OnMenuLarger();
	afx_msg void OnMenuSmaller();
	afx_msg void OnTBMapCenter();
	afx_msg void OnTBMapLarger();
	afx_msg void OnTBMapSmaller();
	afx_msg void OnShowAirport();
	afx_msg void OnShowReport();
	afx_msg void OnMShowIntersect();
	afx_msg void OnShowNdb();
	afx_msg void OnShowVor();
	afx_msg void OnShowUsr();
	afx_msg void OnShowSail();
	afx_msg void OnShowHeli();
	afx_msg void OnShowMAP();
	afx_msg void OnShowLabel();
	afx_msg void OnShowElev();
	afx_msg void OnShowAirspace();
	afx_msg void OnUpdateAirport(CCmdUI* pCmdUI);
	afx_msg void OnUpdateIntersect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNdb(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateReport(CCmdUI* pCmdUI);
	afx_msg void OnUpdateUsr(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSail(CCmdUI* pCmdUI);
	afx_msg void OnUpdateHeli(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMAP(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLabel(CCmdUI* pCmdUI);
	afx_msg void OnUpdateElev(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAirspace(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wayview.cpp
inline CWayDoc* CScanMapView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
