// ScaledMapList.cpp: Implementierung der Klasse CScaledMapList.
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "stdafx.h"
#include "ScaledMapList.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CScaledMapList::CScaledMapList()
{
	m_nMapIndex		= -1;
	m_lMapScale		= 0;
}

/************************************************************************
 *  ScaledMapList.cpp	  	~ C S c a l e d M a p L i s t	Destructor	*
 ************************************************************************/
CScaledMapList::~CScaledMapList()
{         
	this->DeleteArrayOf(&m_ScaleMaps);
}

/************************************************************************
 *  ScaledMapList.cpp			D e l e t e A r r a y O f 				*
 ************************************************************************/
void CScaledMapList::DeleteArrayOf (CPtrArray* ptArray)
{
	int i, nEntryCnt;	
												
	nEntryCnt = ptArray->GetSize();
	for (i=0; i<nEntryCnt; i++)
	{
		SCALEMAPTYPE* ptEntry;
		if ((ptEntry = (SCALEMAPTYPE*)ptArray->GetAt(i)) != NULL)
		{
			delete ptEntry;				// delete original element
		}
	}
	ptArray->RemoveAll();
}

/************************************************************************
 *  ScaledMapList.cpp			 P r e p a r e N e w L i s t			*
 ************************************************************************/
void CScaledMapList::PrepareNewList(short nActMapInd, long lMapScale)
{
	DeleteArrayOf(&m_ScaleMaps);
	m_nMapIndex		= nActMapInd;
	m_lMapScale		= lMapScale;
}

/************************************************************************
 *  ScaledMapList.cpp			H a s A u t o S e l M a p				*
 *  Returns TRUE, if there is already a map in m_ScaleMaps list,		*
 *  which has the autoSel flat set.										*
 *  This avoids having two overlapping ICAO charts in the list!			*
 ************************************************************************/
BOOL CScaledMapList::HasAutoSelMap()
{
	BOOL bHasAutoSel = FALSE;

	for (int i=0; i<m_ScaleMaps.GetSize() && !bHasAutoSel; i++)
	{
		SCALEMAPTYPE* ptTestMap = (SCALEMAPTYPE*)m_ScaleMaps.GetAt(i);
		if (ptTestMap != NULL)
		{
			bHasAutoSel = ptTestMap->bAutoSel;
		}
	}
	return bHasAutoSel;
}


/************************************************************************
 *  ScaledMapList.cpp   			A d d								*
 *  Purpose: Adds scale map entries, sorted by lMapScale.				*
 *		i			nMapIndex	lMapScale	bAutoSel					*
 *		0			7			    100		FALSE						*
 *		1			2			   2000		FALSE						*
 *		2			1			  10000		TRUE						*
 *		3		    10			1000000		FALSE						*
 ************************************************************************/
BOOL CScaledMapList::Add(CString szName, short nMapIndex, 
							  BOOL bAutoSel, long lMapScale)
{
	BOOL bAdded = FALSE;

	short nIndexToInsert = 0;
	BOOL bStop=FALSE;			// get next index
	for (int i=0; i<m_ScaleMaps.GetSize() && !bStop; i++)
	{
		SCALEMAPTYPE* ptTestMap = (SCALEMAPTYPE*)m_ScaleMaps.GetAt(i);
		if (ptTestMap != NULL)
		{
			bStop = (ptTestMap->lScale >= lMapScale);
			if (!bStop)	nIndexToInsert++;
		}
	}

	SCALEMAPTYPE* ptEntry = new SCALEMAPTYPE;
	if(ptEntry != NULL)
	{
		ptEntry->nMapIndex = nMapIndex;
		ptEntry->lScale = lMapScale;
		ptEntry->bAutoSel = bAutoSel;
		ptEntry->szName = szName;
		m_ScaleMaps.InsertAt(nIndexToInsert, ptEntry);		// new entry added
		bAdded = TRUE;
	}

	return bAdded;
}


/************************************************************************
 *  ScaledMapList.cpp		G e t N e x t M a p I n d e x 				*
 *  Purpose: searches m_ScaleMaps for a map to be used next				*
 ************************************************************************/
short CScaledMapList::GetNextMapIndex(BOOL bLarger)
{
	short nMapIndex = -1;
	BOOL bFound = FALSE;
	short nDefaultMapIndex = -1;

	if (bLarger)
	{			// look for map larger than m_lMapScale
		for (int i=m_ScaleMaps.GetSize()-1; i>=0 && !bFound; i--)
		{			
			SCALEMAPTYPE* ptTestMap = (SCALEMAPTYPE*)m_ScaleMaps.GetAt(i);
			if (ptTestMap != NULL)
			{
				if (ptTestMap->lScale < m_lMapScale)
				{
					bFound = TRUE;
					nMapIndex = ptTestMap->nMapIndex;
				}
				if (i==0)
					nDefaultMapIndex = ptTestMap->nMapIndex;
			}
		}
	}
	else
	{			// look for map smaller than m_lMapScale
		for (int i=0; i<m_ScaleMaps.GetSize() && !bFound; i++)
		{
			SCALEMAPTYPE* ptTestMap = (SCALEMAPTYPE*)m_ScaleMaps.GetAt(i);
			if (ptTestMap != NULL)
			{
				if (ptTestMap->lScale > m_lMapScale)
				{
					bFound = TRUE;
					nMapIndex = ptTestMap->nMapIndex;
				}
				if (i==m_ScaleMaps.GetSize()-1)
					nDefaultMapIndex = ptTestMap->nMapIndex;
			}
		}
	}

	if (bFound)
	{
		m_nMapIndex = nMapIndex;
		m_lMapScale = this->GetScale(nMapIndex);
	}
	else
	{
		m_nMapIndex = nDefaultMapIndex;
		m_lMapScale = this->GetScale(nDefaultMapIndex);
	}
	return m_nMapIndex;
}


/************************************************************************
 *  ScaledMapList.cpp		G e t S c a l e								*
 *  Purpose: returns scale of map of specifeied map index				*
 ************************************************************************/
long CScaledMapList::GetScale(short nMapIndex)
{
	long lScale=0;
	BOOL bFound = FALSE;

	for (int i=0; i<=m_ScaleMaps.GetSize() && !bFound; i++)
	{
		SCALEMAPTYPE* ptTestMap = (SCALEMAPTYPE*)m_ScaleMaps.GetAt(i);
		if (ptTestMap != NULL)
		{
			bFound = (ptTestMap->nMapIndex == nMapIndex);
			if (bFound)
				lScale = ptTestMap->lScale;
		}
	}

	return lScale;
}
