// ScaledMapList.h: Schnittstelle fr die Klasse CScaledMapList.
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCALEDMAPLIST_H__B2FE3975_FBA2_48F4_A6F4_1A18371CE4AE__INCLUDED_)
#define AFX_SCALEDMAPLIST_H__B2FE3975_FBA2_48F4_A6F4_1A18371CE4AE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef struct
	{
	short	nMapIndex;
	long	lScale;	
	BOOL	bAutoSel;
	CString szName;
	} SCALEMAPTYPE;		



class CScaledMapList  
{
public:
	CScaledMapList();
	virtual ~CScaledMapList();

	void PrepareNewList(short nActMapInd, long lMapScale);
	BOOL HasAutoSelMap();
	BOOL Add(CString szName, short nMapIndex, BOOL bAutoSel, long lMapScale);
	short GetNextMapIndex(BOOL bLarger);
	long GetScale(short nMapIndex);

private:
	void DeleteArrayOf (CPtrArray* ptArray);		// array of SCALEMAPTYPE

private:
	CPtrArray m_ScaleMaps;		// array of SCALEMAPTYPE
	short		m_nMapIndex;
	long		m_lMapScale;
	short		m_nIncreaseCnt;
};

#endif // !defined(AFX_SCALEDMAPLIST_H__B2FE3975_FBA2_48F4_A6F4_1A18371CE4AE__INCLUDED_)
