#ifndef __SCANMAP__      
#define __SCANMAP__

// ScanMap.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\CPPTOOLS\Vektor.h"
#include "LatLon.h"					// defines DRECT
#include "MapDoc.h"
#include "ScMpFixP.h"

typedef enum					 // for LAMBERT PROJECTION
	{
	CALPOS_TL,
	CALPOS_TR,
	CALPOS_BR,
	CALPOS_BL
	} CALIBRATEPOS;


typedef enum
	{
	LAMBERT,
	LINEAR,
	MERCATOR,
	POLAR
	} PROJECTION;

class CSymbols;
class CLocation;
class CScannedMap : public CObject
{
DECLARE_SERIAL(CScannedMap)

#define DB180 180.		
#define DB360 360. 

#define ACT_MAP_VERS	1

// Attributes
private:    
	int	 m_nSizeLine;		// size of line to draw leg	  [1/10 mm]
	int	 m_nSizeBear;		// size of line to draw bearing [1/10 mm]

	COLORREF m_ColLine;		// color of line to draw leg
	COLORREF m_ColBear;		// color of line to draw bearing
	COLORREF m_ColLabel;  	// background color of label
	COLORREF m_ColSel;		// color of selected items (leg, label)
	COLORREF m_ColText;		// color of text

	BOOL	m_ptShowFlags[FLAG_CNT];	// show APT, REP, INT, NDB, VOR, USR, LABEL, MAPS
	CPoint	m_pStart;			// offset for map
	double  m_dFaktX;			// X scale faktor for map
	double  m_dFaktY;			// Y scale faktor for map

// Operations
protected:
	CObArray	m_FixPts;			// array of CMapFixPt   
	     	
	CVektor		m_vKegelPol;
	BOOL		m_bCalibrated;
	short		m_nActCalIndex;
	 
	CString		m_szName;
	CLatLon		m_Border[4];		// max. visible lat lon values
	BOOL		m_bAntipod;
	BOOL		m_bAutoSel;
	PROJECTION	m_Type;
	CString		m_szPath;			// path to *.bmp file
	long		m_lSizeX_DP;
	long		m_lSizeY_DP;
	long		m_lBmpSizeX;
	long		m_lBmpSizeY;

									// LINEAR Projection:
	BOOL	m_bRelativ;
	int		m_nCourse;				// relative definition of point 2
	double	m_dDist;
	short	m_nDistDim;

// Implementation
public:
	CScannedMap();		
	CScannedMap(CString szPath);
	CScannedMap(CScannedMap& Source);

	~CScannedMap();        

	const CScannedMap& operator=(const CScannedMap& Source);                                        

	void Reset ();
	void Activate (short nTypeID, BOOL bActivate);
	BOOL IsActivated (short nTypeID);
	void InvertActivateState (short nTypeID);


 	void SetLegColor (COLORREF Col) { m_ColLine = Col; }
	void SetBearColor (COLORREF Col) { m_ColBear = Col; }
	void SetLabelColor (COLORREF Col) { m_ColLabel = Col; }
	void SetSelectedColor (COLORREF Col) { m_ColSel = Col; }
	void SetTextColor (COLORREF Col) { m_ColText = Col; }
	

	COLORREF GetLegColor () { return m_ColLine; }
	COLORREF GetBearColor () { return m_ColBear; }
	COLORREF GetLabelColor () { return m_ColLabel; }
	COLORREF GetSelectedColor () { return m_ColSel; }
	COLORREF GetTextColor () { return m_ColText; }

	CRect GetLPRect ();
	CLatLon GetBorderLatLon (short i);
	DRECT GetLatLonBorder ();
	BOOL IsNearBorder(double dLat, double dLon, int nChangeMapLimit_mm);
	double GetFreeFakt (long lLPx0, long lLPy0, long lLPx1, long lLPy1);
	double GetCenterFakt (long lLPx, long lLPy);
	CLatLon GetCenterLatLon();
	double GetDiagonalDist_NM();
	double GetWidth_NM (CLatLon& llReference);


	void SetStartPoint (CPoint pStart) {m_pStart = pStart;}
	BOOL SetScaleFaktX (double dFaktX);
	BOOL SetScaleFaktY (double dFaktY);

	double GetScaleFaktX () { return m_dFaktX; }
	double GetScaleFaktY () { return m_dFaktY; }

	void DrawLocation (CLocation& Loc, CSymbols& Symbols);
	long GetLambertScale (long lHorzResLPI);									 
	long GetLinearScale (long lHorzResLPI);									 
	long GetMercatorScale (long lHorzResLPI);										 
	long GetPolarScale (long lHorzResLPI);
	long GetScale (long lHorzResLPI);	

	void Clip(CDC* pDC, CRect rClipDP);


	void GetSizeDP (long* ptSizeX, long* ptSizeY);
	void GetSizeLP (long* ptSizeX, long* ptSizeY);
	void GetScaledSizeLP (long* ptSizeX, long* ptSizeY);
 	CString		GetName () { return m_szName; }
	BOOL		IsAntipod () { return m_bAntipod; }
	BOOL		IsAutoSel () { return m_bAutoSel; }
	PROJECTION	GetProjection () { return m_Type; }
	CString		GetPath () { return m_szPath; }
	CString		GetTitle();
	CString		GetActCalInfoText (short nIndex = -2);
	BOOL	IsReadyToCalibrate ();
	void	CheckAntipod();

	BOOL IsLatLonVisible(double dLat, double dLon);
	BOOL IsLatLonInRect (double dLat, double dLon, double* ptMapLon=NULL);
	BOOL IsVisibleLine (double dLat0, double dLon0, double dLat1, double dLon1, 
				double* ptVisLat0, double* ptVisLon0, double* ptVisLat1, double* ptVisLon1);

	BOOL GetLatLonLimit0 (double dLat0, double dLon0, double dLat1, double dLon1, 
								  double* ptVisLat0, double* ptVisLon0);
	BOOL GetLatLonLimit1 (double dLat0, double dLon0, double dLat1, double dLon1, 
								  double* ptVisLat1, double* ptVisLon1);

	BOOL GrossKreisForLon(CVektor A, CVektor B, double dLon, BOOL bLeftBorder, CLatLon* ptLocX);
	BOOL GrossKreisForLat(CVektor A, CVektor B, double dLat, BOOL bTopBorder,  CLatLon* ptLocX);
	BOOL GetLatLonLimit (double dLat0, double dLon0, double dLat1, double dLon1, 
								  double* ptVisLat0, double* ptVisLon0);

	void	SearchNextCalibIndex(short* ptCalIndex);
	BOOL	TryToCalibrate();
	BOOL	SaveMousePos (CPoint pMouse);
	void	SetActCalIndex (short nInd) { m_nActCalIndex = nInd; }
	short	GetActCalIndex () { return m_nActCalIndex; }
	BOOL	IsCalibrated () { return m_bCalibrated; }

	BOOL	IsPt2Relativ() { return m_bRelativ; }
	short GetCourseToPt2 () { return (short)m_nCourse; }
	double GetDistToPt2() { return m_dDist; }
	short GetDistDim(){return m_nDistDim;}

	void SetPt2Relativ (BOOL bRelativ) { m_bRelativ = bRelativ; }
	void SetCourseToPt2 (short nCourse) { m_nCourse = nCourse; }
	void SetDistToPt2(double dDist) { m_dDist = dDist; }
	void SetDistDim(int nDim){m_nDistDim = nDim;}

	void SetSizeDP (CSize SizeDP);
	BOOL SetSizeLP (long lSizeX, long lSizeY);
	void SetName (CString szName) {	m_szName = szName; }
	void SetAntipod (BOOL bSet) { m_bAntipod = bSet; }
	void SetAutoSel (BOOL bSet) { m_bAutoSel = bSet; }
	void SetProjection (PROJECTION Proj) { m_Type = Proj; }
	void SetPath (CString szPath) {	m_szPath = szPath;	}	// path to *.bmp file
	void SetCalibrated (BOOL bCal) { m_bCalibrated = bCal; }

	BOOL Calibrate (); 
	BOOL CheckCalibration (long lSizeX, long lSizeY);
	void LPtoLatLon (long lX_LP, long lY_LP, double* ptLat, double* ptLon); 
	void LatLonToLP	(double dLon, double dLat, long* ptX_LP, long* ptY_LP);

	BOOL CalcBorderPoint(CVektor& V1, CVektor& V2, CVektor& E, double* ptL1, double* ptL2);
	BOOL IsInside(long LPx1, long LPy1);
	BOOL CrossingBorder(long LPx0, long LPy0, long LPx1, long LPy1, 
								 long* ptLPx, long* ptLPy);
	BOOL CrossingBorders(long LPx0, long LPy0, long LPx1, long LPy1, 
								 long* ptLPx0, long* ptLPy0, long* ptLPx1, long* ptLPy1);

	BOOL IsEqual(const CScannedMap& Map);


	BOOL AppendFixPt (CMapFixPt* ptFixPt);
	BOOL ChangeFixPt (short nIndex, CMapFixPt* ptNewFixPt);
	BOOL DeleteFixPt (short nIndex);
	short GetFixPtCnt ();
	CMapFixPt* GetFixPtPtr (short nIndex);
	CALIBRATEPOS FixPtIndexToCalibPos(short nIndex);
	short CalibPosToFixPtIndex (CALIBRATEPOS CalPos);

	void WriteLogFile();
	void Serialize(CArchive& ar);

private:
	BOOL CalibrateLambert ();
	BOOL CalibrateLinear ();
	BOOL CalibrateMercator ();
	BOOL CalibratePolar ();

	void GetLambertLatLon (long lX_LP, long lY_LP, double* ptLat, double* ptLon); 
	void GetLinearLatLon (long lX_LP, long lY_LP, double* ptLat, double* ptLon);
	void GetMercatorLatLon (long lX_LP, long lY_LP, double* ptLat, double* ptLon); 
	void GetPolarLatLon (long lX_LP, long lY_LP, double* ptLat, double* ptLon);

	void GetLambertLP (double dLon, double dLat, long* ptX_LP, long* ptY_LP); 
	void GetLinearLP (double dLon, double dLat, long* ptX_LP, long* ptY_LP);
	void GetMercatorLP (double dLon, double dLat, long* ptX_LP, long* ptY_LP); 
	void GetPolarLP (double dLon, double dLat, long* ptX_LP, long* ptY_LP); 

	void DeleteArrayOf (CObArray* ptArray);

};
#endif 


