// SpeedVw.cpp : implementation of the CSpeedView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  

#include "TrackDoc.h"
#include "SpeedVw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      
extern CTrackDoc*		ptTrackDoc;


extern BOOL bMMText;


/****************************************************************************
 *	SpeedVw.cpp					S p e e d S c a l e T e x t Y 				*
 ****************************************************************************/
short SpeedScaleTextY (double dYval, double dYGrid, CString* ptScale)
{
short	nLen;
char	szScale[32];							
CString	szScaleFormat;
CString	szDim;

szScaleFormat.LoadString (IDF_TRACK_SCALE);
ptDim->GetDimCstring (&szDim, ptDim->DistDimToSpeedDim(ptDim->Distance()));
nLen = sprintf (szScale, szScaleFormat, (long)dYval, (LPCTSTR)szDim);

*ptScale = (CString)szScale;
return nLen;
}

/****************************************************************************
 *	SpeedVw.cpp						S p e e d M a p X 						*
 ****************************************************************************/
double SpeedMapX (double dXval)
{
return dXval;
}

/****************************************************************************
 *	SpeedVw.cpp						S p e e d M a p Y 						*
 ****************************************************************************/
double SpeedMapY (double dYval)
{
return dYval;
}

/////////////////////////////////////////////////////////////////////////////
// CSpeedView

IMPLEMENT_DYNCREATE(CSpeedView, CTextViewTool)

BEGIN_MESSAGE_MAP(CSpeedView, CTextViewTool)
	//{{AFX_MSG_MAP(CSpeedView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpeedView construction/destruction

/************************************************************************
 *  SpeedVw.cpp   		 		C S p e e d V i e w			Constructor	*
 ************************************************************************/
CSpeedView::CSpeedView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);

m_ptColor = ptInit->GetColorPtr();

m_ptSpeedGraph = new CMap (SpeedMapX, SpeedMapY, 
						   SpeedMapX, SpeedMapY,
						TimeScaleTextX, SpeedScaleTextY, 
						ANISOTROPIC);
m_bInitialView = TRUE;
}

/************************************************************************
 *  SpeedVw.cpp   		 		~ C S p e e d V i e w		Destructor	*
 ************************************************************************/
CSpeedView::~CSpeedView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();

delete m_ptSpeedGraph;
}

/************************************************************************
 *  SpeedVw.cpp				U p d a t e F o n t s 						*
 ************************************************************************/
void CSpeedView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 
}

/************************************************************************
 *  SpeedVw.cpp			O n I n i t i a l U p d a t e					*
 ************************************************************************/
void CSpeedView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
pDC->SetMapMode(MM_LOMETRIC);

this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}

/************************************************************************
 *  SpeedVw.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CSpeedView::SetXTabs (CDC* pDC, CTrackDoc* ptTrackDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   

X_TAB = 4*CharX;
m_dX = LogPixXToUse - 2*X_TAB;
m_dY = LogPixYToUse;
m_Xleft  = X_TAB;
m_Xright = m_dX;
}


/************************************************************************
 *  SpeedVw.cpp				P r e p a r e X T a b s						* 
 ************************************************************************/
void CSpeedView::PrepareXTabs (CDC* pDC)
{
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
	this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  SpeedVw.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CSpeedView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CTrackDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    
	this->PrepareXTabs(pDC);
	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}

/************************************************************************
 *  SpeedVw.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CSpeedView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after printing

	this->PrepareXTabs(pDC);
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}

/************************************************************************
 *  SpeedVw.cpp					G e t M a x R e c t L P					*
 ************************************************************************/
void CSpeedView::GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax, BOOL bPrinter)
{
					 //normal: CapsX = 52, LineY = 60
if (bPrinter)
    {
    int Width_pix, Height_lines;
    POINT   Offset, Pixels;

    Width_pix = pDC->GetDeviceCaps (HORZRES);	/* 960 pixels	*/
    Height_lines = pDC->GetDeviceCaps (VERTRES);	/* 841 lines	*/

    Pixels.x = Width_pix;
    Pixels.y = Height_lines;
	
	pDC->DPtoLP((LPPOINT)&Pixels, 1);   /* W=2032, H=-2967	    */
    Offset.x = (int)(0.05* Pixels.x);	    /* start 05% of pagewidth */
    Offset.y = (int)(0.08* Pixels.y);	    /* start 08% of pageheight*/
    Pixels.x = (int)(0.9 * Pixels.x);	    /* use 90% of pagewidth */
    Pixels.y = (int)(0.85* Pixels.y);	    /* use 85% of pageheight*/
    SetRect (lpRectMax, Offset.x, Offset.y, 
						Pixels.x, Pixels.y);
    }
else{					    /* use actual window size*/
    ptWnd->GetClientRect (lpRectMax);
	pDC->DPtoLP((LPPOINT)lpRectMax, 2);
    }
}


/************************************************************************
 *  SpeedVw.cpp				G e t U s e a b l e R e c t L P				*
 ************************************************************************/
CRect CSpeedView::GetUseableRectLP (CDC* pDC)
{
CRect rView, rBorderLP;

if (m_bForPrinter && pDC != NULL)
	{
	this->GetMaxRectLP (pDC, this, rView, m_bForPrinter);
	short nFrameX = (short)((double)(rView.right - rView.left) / 50);
	short nFrameY = (short)((double)(rView.bottom - rView.top) / 70);

	rBorderLP.top	= rView.top		+ 3*nFrameY;
	rBorderLP.left	= rView.left	+ 6*nFrameX;
	rBorderLP.right	= rView.right	- 0*nFrameX;
	rBorderLP.bottom = rView.bottom	- 1*nFrameY;
	}
else{
	CClientDC dc (this);
	dc.SetMapMode (MM_LOMETRIC);

	GetClientRect (rView);
	dc.DPtoLP((LPPOINT)&rView, 2);
	rBorderLP.top	= rView.top		+ 4*m_LineY;
	rBorderLP.left	= rView.left	+ 4*m_CharX;
	rBorderLP.right	= rView.right	- 4*m_CharX;
	rBorderLP.bottom = rView.bottom	- 2*m_LineY;
	}  

return rBorderLP;
}

/****************************************************************************
 *	SpeedVw.cpp					D r a w O n M a p 							*
 ****************************************************************************/
void CSpeedView::DrawOnMap (CDC* pDC, BOOL bAntipod)
{

CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            

if (pDoc != NULL)
	{
	long		LPx1, LPy1;
	short		i, nCnt;
	short		nSpeedDim, nPrefSpeedDim;
	CTrackPoint TrackPt;

	LPx1 = LPy1		= 0;
	nCnt			= pDoc->GetCnt();
	nSpeedDim		= pDoc->GetSpeedDim();
	nPrefSpeedDim	= ptDim->DistDimToSpeedDim(ptDim->Distance());

	m_ptColor->SelectRoutePen (pDC, TRUE);
	m_ptSpeedGraph->Clip(TRUE);			/* draw on map only		*/

	for (i=0; i<nCnt; i++)
		{
		short	nSpeed;
		long	lTime;
		if (pDoc->GetTrackPointPtr (i, &TrackPt))
			{
			if (TrackPt.GetSpeed (&nSpeed))
				{
				lTime = TrackPt.GetSec ();

				nSpeed = (short)ptDim->ConvertSpeed (nSpeed, nSpeedDim, nPrefSpeedDim);
				m_ptSpeedGraph->XYtoLP (lTime, nSpeed, &LPx1, &LPy1);

				if (i==0)	pDC->MoveTo (LPx1, LPy1);
					else	pDC->LineTo (LPx1, LPy1);
				}
			}

		}
	m_ptSpeedGraph->Clip(FALSE);
	m_ptColor->SelectRoutePen (pDC, FALSE);
	}
}

/************************************************************************
 *  SpeedVw.cpp    		 	 D r a w T r a c k S p e e d				*
 ************************************************************************/
BOOL CSpeedView::DrawTrackSpeed (CDC* pDC, CTrackDoc* ptTrackDoc, 
						DWORD* ptIndex,
					    int* ptY, BOOL bDraw)
{
int		X, Y;
CString szText;
CFont* ptOldFont;
CRect	rMapLP;

ActivateDrawing (bDraw);

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
Y = m_LineY;
  
CRect rView = this->GetUseableRectLP (pDC);


long lMinX, lMaxX; 
short nMinY, nMaxY;
short	nGridX, nGridY;

DRECT rMinMap;
ptTrackDoc->GetSpeedMapBorders (&lMinX, &lMaxX, &nMinY, &nMaxY, &nGridX, &nGridY);
rMinMap.top		= nMaxY;
rMinMap.bottom  = nMinY;
rMinMap.left	= lMinX;
rMinMap.right	= lMaxX;

m_rMap = rMinMap;

m_ptSpeedGraph->CalculateGraph (pDC, m_rMap, rView, m_bForPrinter, nGridX, nGridY);


rMapLP = m_ptSpeedGraph->GetGridRect();	// returns m_rGridLP
if (m_bForPrinter)
	{
	m_ptSpeedGraph->SetTitle (ptTrackDoc->GetTitle());
	}

m_ptSpeedGraph->DrawGrid (pDC, m_CharX, m_LineY, &X, &Y);

					// draws altitude or speed with virtual function
this->DrawOnMap (pDC, FALSE);	 // bAntipod = FALSE;

pDC->SelectObject (ptOldFont);

return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CSpeedView drawing


/************************************************************************
 *  SpeedVw.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CSpeedView::PrintPage (CDC* pDC, int nPageToPrint)
{
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	X_TAB;
int	nPage = 1;


DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		X_TAB = 4*m_CharX;
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		m_bMore = DrawTrackSpeed (pDC, pDoc, &dwIndex, &Y, bDraw);
		nPage++;
		} while (!bDraw);
	}    
}                                  

/************************************************************************
 *  SpeedVw.cpp   		 		 O n D r a w							*
 ************************************************************************/
void CSpeedView::OnDraw(CDC* pDC)
{
	CTrackDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            

int	Y = m_LineY;

if (pDoc != NULL)
	{
	BOOL	bMore = FALSE;
	DWORD 	dwIndex = 0;

	bMore = DrawTrackSpeed (pDC, pDoc, &dwIndex, &Y, m_bDraw);
	}	
}


/////////////////////////////////////////////////////////////////////////////
// CSpeedView printing


/************************************************************************
 *  SpeedVw.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CSpeedView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

UINT nMinPage = 1;						// Number of the first page of the document
UINT nMaxPage = 1;						// Number of the last page of the document
pInfo->SetMinPage (nMinPage);
pInfo->SetMaxPage (nMaxPage);

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  SpeedVw.cpp  			O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CSpeedView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CTrackDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  SpeedVw.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CSpeedView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  SpeedVw.cpp  			O n E n d P r i n t i n g					*
 ************************************************************************/
void CSpeedView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CSpeedView diagnostics

#ifdef _DEBUG
void CSpeedView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CSpeedView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}
#endif //_DEBUG

CTrackDoc* CSpeedView::GetDocument() // non-debug version  w a s inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackDoc)));
//	return (CTrackDoc*)m_pDocument;
	return ptTrackDoc;
}

/////////////////////////////////////////////////////////////////////////////
// CSpeedView message handlers

void CSpeedView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
