// StLaDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    
     
#include "PlaneDoc.h"
#include "StLaDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// CStartLandDlg dialog


CStartLandDlg::CStartLandDlg(CWnd* pParent, CPlane* ptPlane)
	: CDlgTool(CStartLandDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStartLandDlg)
	m_lLandMass0 = 0;
	m_lStartMass0 = 0;
	m_nStartRoll0 = 0;
	m_nStartObst0 = 0;
	m_nStartRoll1 = 0;
	m_nStartObst1 = 0;
	m_nLandRoll0 = 0;
	m_nLandObst0 = 0;
	m_nLandRoll1 = 0;
	m_nLandObst1 = 0;
	m_lLandMass1 = 0;
	m_lStartMass1 = 0;
	m_nLenDim = -1;
	m_nMassDim = -1;
	//}}AFX_DATA_INIT

m_ptPlane = ptPlane;

this->SetData(m_ptPlane);
}

CStartLandDlg::~CStartLandDlg()
{

}


/************************************************************************
 *  StLaDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CStartLandDlg::SetData (CPlane* ptPlane)
{  
short nMassDim, nLenDim;
float fMass, fRoll, fObst;

ptPlane->GetStartLandDim(&nMassDim, &nLenDim);
m_nMassDim = ptDim->GetPUIndex (MASS, nMassDim);
m_nLenDim = ptDim->GetPUIndex (RWYLENGTH, nLenDim);

short nIndex = 0;
ptPlane->GetStartData(nIndex, &fMass, &fRoll, &fObst);
m_lStartMass0	= (long)fMass;
m_nStartRoll0	= (short)fRoll;
m_nStartObst0	= (short)fObst;
ptPlane->GetLandData(nIndex, &fMass, &fRoll, &fObst);
m_lLandMass0	= (long)fMass;
m_nLandRoll0	= (short)fRoll;
m_nLandObst0	= (short)fObst;

nIndex = 1;
ptPlane->GetStartData(nIndex, &fMass, &fRoll, &fObst);
m_lStartMass1	= (long)fMass;
m_nStartRoll1	= (short)fRoll;
m_nStartObst1	= (short)fObst;
ptPlane->GetLandData(nIndex, &fMass, &fRoll, &fObst);
m_lLandMass1	= (long)fMass;
m_nLandRoll1	= (short)fRoll;
m_nLandObst1	= (short)fObst;
}	

/************************************************************************
 *  StLaDlg.cpp	  				G e t D a t a  							*
 ************************************************************************/
void CStartLandDlg::GetData (CPlane* ptPlane)
{                            
short nMassDim	= ptDim->GetPUDim (MASS, m_nMassDim);
short nLenDim	= ptDim->GetPUDim (RWYLENGTH, m_nLenDim);

ptPlane->SetStartLandDim(nMassDim, nLenDim);

short nIndex = 0;
ptPlane->SetStartData(nIndex, (float)m_lStartMass0, (float)m_nStartRoll0, (float)m_nStartObst0);
ptPlane->SetLandData(nIndex, (float)m_lLandMass0, (float)m_nLandRoll0, (float)m_nLandObst0);

nIndex = 1;
ptPlane->SetStartData(nIndex, (float)m_lStartMass1, (float)m_nStartRoll1, (float)m_nStartObst1);
ptPlane->SetLandData(nIndex, (float)m_lLandMass1, (float)m_nLandRoll1, (float)m_nLandObst1);
}	


/************************************************************************
 *  StLaDlg.cpp	  				DoDataExchange							*
 ************************************************************************/
void CStartLandDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStartLandDlg)
	DDX_CBIndex(pDX, ID_SLLENDIM, m_nLenDim);
	DDX_CBIndex(pDX, ID_SLMASSDIM, m_nMassDim);
	DDX_Mass(pDX, ID_SLSTMA0, m_lStartMass0);
	DDV_Mass(pDX, m_lStartMass0, 100, 15000);
	DDX_RwyOpt(pDX, ID_SLSTROLL0, m_nStartRoll0);
	DDV_RwyOpt(pDX, m_nStartRoll0, 50, 5000);
	DDX_Rwy(pDX, ID_SLSTOBST0, m_nStartObst0);
	DDV_Rwy(pDX, m_nStartObst0, 50, 5000);
	DDX_MassOpt(pDX, ID_SLSTMA1, m_lStartMass1);
	DDV_MassOpt(pDX, m_lStartMass1, 100, 15000);
	DDX_RwyOpt(pDX, ID_SLSTROLL1, m_nStartRoll1);
	DDV_RwyOpt(pDX, m_nStartRoll1, 50, 5000);
	DDX_RwyOpt(pDX, ID_SLSTOBST1, m_nStartObst1);
	DDV_RwyOpt(pDX, m_nStartObst1, 50, 5000);
	DDX_Mass(pDX, ID_SLLAMA0, m_lLandMass0);
	DDV_Mass(pDX, m_lLandMass0, 100, 15000);
	DDX_RwyOpt(pDX, ID_SLLAROLL0, m_nLandRoll0);
	DDV_RwyOpt(pDX, m_nLandRoll0, 50, 5000);
	DDX_Rwy(pDX, ID_SLLAOBST0, m_nLandObst0);
	DDV_Rwy(pDX, m_nLandObst0, 50, 5000);
	DDX_MassOpt(pDX, ID_SLLAMA1, m_lLandMass1);
	DDV_MassOpt(pDX, m_lLandMass1, 100, 15000);
	DDX_RwyOpt(pDX, ID_SLLAROLL1, m_nLandRoll1);
	DDV_RwyOpt(pDX, m_nLandRoll1, 5, 5000);
	DDX_RwyOpt(pDX, ID_SLLAOBST1, m_nLandObst1);
	DDV_RwyOpt(pDX, m_nLandObst1, 50, 5000);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStartLandDlg, CDlgTool)
	//{{AFX_MSG_MAP(CStartLandDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStartLandDlg message handlers

BOOL CStartLandDlg::OnInitDialog() 
{
this->AddDimGroup (ID_SLSTMA0, ID_SLMASSDIM);
this->AddDimGroup (ID_SLSTMA1, ID_SLMASSDIM);
this->AddDimGroup (ID_SLLAMA0, ID_SLMASSDIM);
this->AddDimGroup (ID_SLLAMA1, ID_SLMASSDIM);

this->AddDimGroup (ID_SLSTROLL0, ID_SLLENDIM);
this->AddDimGroup (ID_SLSTOBST0, ID_SLLENDIM);

this->AddDimGroup (ID_SLSTROLL1, ID_SLLENDIM);
this->AddDimGroup (ID_SLSTOBST1, ID_SLLENDIM);

this->AddDimGroup (ID_SLLAROLL0, ID_SLLENDIM);
this->AddDimGroup (ID_SLLAOBST0, ID_SLLENDIM);

this->AddDimGroup (ID_SLLAROLL1, ID_SLLENDIM);
this->AddDimGroup (ID_SLLAOBST1, ID_SLLENDIM);

this->FillDimPU (ID_SLMASSDIM, MASS);
this->FillDimPU (ID_SLLENDIM, RWYLENGTH);


	// TODO: Add extra initialization here

CDlgTool::OnInitDialog();
return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  StLaDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CStartLandDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
