// Sun.cpp : implementation of the CSun class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

/************************************************************************
 *							S u n . c p p								*
 ************************************************************************/
//#include <string.h>
#include <math.h>				/* for sin, tan		*/
//#include <time.h>
             
#include "SunData.h"			/* Deklination and ZGL		*/
#include "Sun.h"				


/************************************************************************
 *  Sun.cpp						CSun					Constructor		*
 ************************************************************************/
CSun::CSun(time_t time)
{ 		 
m_Time	= time;					/* sec since 1.1.1970	*/
}


/************************************************************************
 *  Sun.cpp					~CSun						Destructor		*
 ************************************************************************/
CSun::~CSun()
{
} 

/************************************************************************
 *  Sun.cpp					G r a d T o T i m e							*
 *  input: Degree value 0...360 					*
 *  output: number of hours and number of minutes			*
 ************************************************************************/
void CSun::GradToTime (double Degree, short* ptHours, short* ptMin, short* ptSec)
{
double	theTime;

theTime  = Degree / 15; 			/* in hours		*/
*ptHours = (short)theTime;
*ptMin	 = (short)(60 * (theTime - *ptHours));
*ptSec	 = (short)(60 * (60 * (theTime - *ptHours) - *ptMin));
}

/************************************************************************
 *  Sun.cpp		D e g r M i n S e c T o D e z			*
 *  Input: 23 degrees, 27 minutes, 8.26 sec				*
 *  Output: corresponding decimal value in degrees			*
 ************************************************************************/
double CSun::DegrMinSecToDez (double Degrees, double Minutes, double Seconds)
{
double DecDegrees;

DecDegrees = Degrees + (Minutes + (Seconds/60))/60;
return DecDegrees;
}

/************************************************************************
 *  Sun.cpp		D e z T o D e g r M i n S e c			*
 *  Input: decimal value in degrees					*
 *  Output: corresponding degrees, minutes and sec			*
 ************************************************************************/
void CSun::DezToDegrMinSec (double dDegr, short* bPositiv,
			short* Degrees, short* Minutes, short* Seconds)
{
double dMin, dSec;
*bPositiv = 1;

if (dDegr < 0)
    {
    *bPositiv = 0;
    dDegr *= -1.;
    }
*Degrees = (short)floor(dDegr);

dMin = (dDegr - *Degrees) * 60;
*Minutes = (short)floor(dMin);

dSec = (dMin - *Minutes) * 60;
*Seconds = (short)floor(dSec + .5);

if (*Seconds == 60)
    {
    (*Minutes)++;
    *Seconds = 0;
    if (*Minutes == 60)
	{
	(*Degrees)++;
	*Minutes = 0;
	}
    }
}

/************************************************************************
 *  Sun.cpp		     G e t D a t e A n d T i m e		*
 *  Input: Any Time value of any day					*
 *  Output: date and time information of that day			*
 ************************************************************************/
void CSun::GetDateAndTime (long Time, struct tm* ptDateTime)
{
time_t	ltime;
struct tm LogTime, *ptHelpTime;

ltime = Time;
ptHelpTime = &LogTime;
ptHelpTime = localtime (&ltime);	/* to get actual date & time	*/
//ptHelpTime = gmtime (&ltime);	/* to get actual date & time	*/

memcpy ((char*)ptDateTime, (char*)ptHelpTime, sizeof (struct tm));
}

/************************************************************************
 *  Sun.cpp						I s L e a p Y e a r						*
 ************************************************************************/
BOOL CSun::IsLeapYear (short nYear)
{	
BOOL bLeapYear=FALSE;					// Schaltjahr ??

bLeapYear = ((float)(nYear/4) == (float)nYear/4);

if (bLeapYear)									// first exception
	{
	if (((float)(nYear/100) == (float)nYear/100))
		bLeapYear = FALSE;
	}

if (!bLeapYear)									// second exception
	bLeapYear = ((float)(nYear/400) == (float)nYear/400);

return bLeapYear;
}

/************************************************************************
 *  Sun.cpp					L e n g t h O f M o n t h					*
 ************************************************************************/
short CSun::LengthOfMonth (short nYear, short nMonth)
{
short	nLen;
int	bSchaltjahr;

nLen = MonthLen[nMonth - 1];
bSchaltjahr = this->IsLeapYear(nYear);

if (bSchaltjahr)
    {
    if (nMonth == 2)
	nLen++;
    }
return nLen;
}

 /************************************************************************
 *  Sun.cpp		G e t T h i s Y e a r s S e c o n d s		*
 ************************************************************************/
double CSun::GetThisYearsSeconds (long Time)		/* sec since 1.1.1970	*/
{						/* 00:00 GMT		*/
short	i;
long	BeginOfYearsSec;
double	ThisYearsSec;
struct tm LogTime;

BeginOfYearsSec = Time;

GetDateAndTime (BeginOfYearsSec, &LogTime);	    /* sub month sec	*/
for (i=0; i<LogTime.tm_mon; i++)
    BeginOfYearsSec -= (long)24 * 3600 * LengthOfMonth(1900 + LogTime.tm_year, i+1);

GetDateAndTime (BeginOfYearsSec, &LogTime);	    /* sub day sec	*/
BeginOfYearsSec -= (long)24 * 3600 * (LogTime.tm_mday-1);

GetDateAndTime (BeginOfYearsSec, &LogTime);	    /* sub hour sec	*/
BeginOfYearsSec -= (long)3600 * LogTime.tm_hour;

GetDateAndTime (BeginOfYearsSec, &LogTime);	    /* sub minute sec	*/
BeginOfYearsSec -= (long)60 * LogTime.tm_min;

GetDateAndTime (BeginOfYearsSec, &LogTime);	    /* sub sec		*/
BeginOfYearsSec -= LogTime.tm_sec;

ThisYearsSec = Time - BeginOfYearsSec;
return ThisYearsSec;
}

/************************************************************************
 *  Sun.cpp		M i n S e c T o S e c				*
 *  input: Min.Sec => 3.15 => 3 Minutes and 14 Seconds! 		*
 *  output: whole time in Seconds => 195 Seconds			*
 ************************************************************************/
short CSun::MinSecToSec (double MinSec)
{
short	bNegativ;
short	Min, Sec;

bNegativ = (MinSec < 0);

if (bNegativ) MinSec *= -1;			/* make time positiv	*/
Min = (short)MinSec;
Sec = 60*Min + (short)(100 * (MinSec - Min) +.5);

if (bNegativ) Sec *= -1;
return Sec;
}

/************************************************************************
 *  Sun.cpp		  G e t H i g h N o o n T i m e			*
 *  Input: Any Time value of any day					*
 *  Output: 12 o'clock time value of that day                           *
 ************************************************************************/
void CSun::GetHighNoonTime (long* ptTime)	      /* sec since 1.1.1970	*/
{					      /* 00:00 GMT		*/
struct tm LogTime;
long	ActDaysSec, NoonSec;

GetDateAndTime (*ptTime, &LogTime);

NoonSec    = (long)12 * 60 * 60;
ActDaysSec = (long)LogTime.tm_sec + (long)60*LogTime.tm_min + (long)60*60*LogTime.tm_hour;
*ptTime   += (NoonSec - ActDaysSec);
}

/************************************************************************
 *  Sun.cpp		  G e t Y e a r T i m e				*
 *  Input: Any Time value of any year					*
 *  Output: 0 o'clock time value of 1. January                          *
 ************************************************************************/
void CSun::GetYearTime (short Year, long* ptTime)	/* sec since 1.1.1970	*/
{						/* 00:00 GMT		*/
struct tm LogTime;
double	ThisYearsSec;
long	dYear;

GetDateAndTime (*ptTime, &LogTime);
dYear = Year - (long)(LogTime.tm_year + 1900);

*ptTime += dYear * TROPYEARS_SEC;
if (*ptTime < 0) *ptTime = 0;

ThisYearsSec = GetThisYearsSeconds (*ptTime);
*ptTime   -= (long)ThisYearsSec;
}

/************************************************************************
 *  Sun.cpp		  G e t D a t e s T i m e			*
 *  Output: Time value for 0 o'clock of specified day                   *
 ************************************************************************/
int CSun::GetDatesTime (short Day, short Month, short Year, long* ptTime)
{
long	DatesSec;
struct tm LogTime;
short	m;

GetYearTime (Year, ptTime);				/* correct year	*/

DatesSec = *ptTime;
GetDateAndTime (DatesSec, &LogTime);			/* correct month*/
for (m = LogTime.tm_mon + 1; m < Month; m++)
    DatesSec += LengthOfMonth(1900+LogTime.tm_year, m) * DAYS_SEC;

GetDateAndTime (DatesSec, &LogTime);			/* correct days */
if (LogTime.tm_mon + 1 == Month-1)		/* 1.3.92 => 29.2.92	*/
    DatesSec += DAYS_SEC;

GetDateAndTime (DatesSec, &LogTime);			/* correct days */
DatesSec += (Day-1) * DAYS_SEC;
*ptTime = DatesSec;

return 1;
}

/************************************************************************
 *  Sun.cpp		G e t T h i s Y e a r s D a y s			*
 ************************************************************************/
short CSun::GetThisYearsDays (long Time)
{
short DayOfYear;
struct tm LogTime;
//double ThisYearsSec;

//ThisYearsSec = GetThisYearsSeconds (Time);	/* sec since 1.1.1970	*/
//DayOfYear = (short)(ThisYearsSec / DAYS_SEC);

GetDateAndTime (Time, &LogTime);	    /* sub month sec	*/
DayOfYear = LogTime.tm_yday;
return DayOfYear;
}

/************************************************************************
 *  Sun.cpp		D i f f T r u e A v e r a g e			*
 *  returns difference btn TrueTime and AverageTime in seconds		*
 ************************************************************************/
short CSun::DiffTrueAverage (long Time)
{
short DayOfYear, ZglSec;

DayOfYear = GetThisYearsDays (Time);
ZglSec = MinSecToSec (Zgl[DayOfYear]);
return ZglSec;
}

/************************************************************************
 *  Sun.cpp		D e c l i n a t i o n				*
 ************************************************************************/
double CSun::Declination (long Time)			/* sec since 1.1.1970	*/
{						/* 00:00 GMT		*/
double	ActDecl;
double	Degrees, Minutes, Seconds;
short	DayOfYear, bPositiv;

DayOfYear = GetThisYearsDays (Time);
ActDecl = Decl[DayOfYear];

bPositiv = 1;					/* check sign		*/
if (ActDecl < 0)
    {
    bPositiv = 0;
    ActDecl *= -1;
    }

Degrees = floor (ActDecl);
Minutes = (ActDecl - Degrees) * 100;
Seconds = 0;
ActDecl = DegrMinSecToDez (Degrees, Minutes, Seconds);

if (!bPositiv) ActDecl *= -1;

return ActDecl;
}


/************************************************************************
 *  Sun.cpp		   S u n S h i n e D e g r e e			*
 *  Input: LatD, LonD, DeclD in Degree;  Zgl in sec			*
 *  Return: Angle of SunRise and SunSet in Degree.			*
 ************************************************************************/
short CSun::SunShineDegree (double LatD, double LonD, double DeclD, double Zgl,
		    double* ptSRdeg, double* ptSSdeg)
{
short	Result;
double	SRrad, SSrad, Lat, Decl;
double HalfArc, Refrakt, RefraktKorr;
double tanLat, sinHA;
double MaxLat = 89.9997;

Refrakt = 51./60;
if (LatD >= 90.)  LatD = MaxLat;	/* convert 90 00 00 to 89 59 59 */
if (LatD <= -90.) LatD = -MaxLat;

Lat	= LatD * pi/180;		/* Latitude in RAD		*/
Decl	= DeclD * pi/180;		/* Declination in RAD		*/
RefraktKorr = Refrakt * pi/180;

//tanLat = tan(Lat);  		for Lat>0, the result is a negative value!!  
tanLat = sin(Lat)/cos(Lat); 	// dont use tan(x) in windows!!

sinHA = (sin (Decl) * tanLat + sin(RefraktKorr) / cos (Lat)) / cos (Decl);

if (sinHA < 1 && sinHA > -1)
    {
    Result = SUN_UPDOWN;
    HalfArc = asin (sinHA);
    SRrad = pi/2 - HalfArc;
    SSrad = 3*pi/2 + HalfArc;
    }
else{
    if (sinHA < 1)
	{
	SRrad = pi;			/* Polar Night	SR = 12:00	*/
	SSrad = pi;			/* Polar Night	SS = 12:00	*/
	Result	= SUN_INVISIBLE;
	}

    if (sinHA > 1)
	{
	SRrad = 0;			/* Polar Day	SR = 00:00	*/
	SSrad = 2*pi;			/* Polar Day	SS = 24:00	*/
	Result	= SUN_CIRCUMPOLAR;
	}
    }

				/* converting SRrad and Zgl into Grad	*/
*ptSRdeg = SRrad*180/pi - LonD - Zgl*360/DAYS_SEC;
if (*ptSRdeg < 0) *ptSRdeg += 360;

				/* converting SSrad and Zgl into Grad	*/
*ptSSdeg = SSrad*180/pi - LonD - Zgl*360/DAYS_SEC;
if (*ptSSdeg > 360) *ptSSdeg -= 360;

return Result;
}

/************************************************************************
 *  Sun.cpp		       G e t S u n S h i n e			*
 ************************************************************************/
void CSun::GetSunShine (double LatDegree, double LonDegree,
							SUNSHINETYPE* ptSunShine)
{
double	DeclDegree;
short	Zgl;
double	DegreeSR, DegreeSS;

memset ((char*)ptSunShine, 0, sizeof (SUNSHINETYPE));

DeclDegree = Declination (m_Time);	/* get Decl from table		*/
Zgl	   = DiffTrueAverage (m_Time);	/* WOZ - MOZ = Zgl in sec	*/

ptSunShine->nMode = SunShineDegree (LatDegree, LonDegree, DeclDegree, Zgl,
					&DegreeSR, &DegreeSS);

GradToTime (DegreeSR, &ptSunShine->Hsr, &ptSunShine->Msr, &ptSunShine->Ssr);
GradToTime (DegreeSS, &ptSunShine->Hss, &ptSunShine->Mss, &ptSunShine->Sss);
}
