#ifndef __SUN__
#define __SUN__

/************************************************************************
 *									S u n . h							*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define pi 3.1415926
#define DAYS_SEC 86400
#define	SPRINGS_SEC ((long)6912000)
#define TROPYEARS_SEC 31556926
//#define	TROPYEARS_SEC  31556925.9747
#define SUN_UPDOWN	1
#define SUN_INVISIBLE	2
#define SUN_CIRCUMPOLAR 3
#define SUN_HALF	4

typedef struct
	{
	short	nMode;			/* SUN_xxx			*/
	short	Hsr;			/* full hour of sunrise 	*/
	short	Msr;			/* full minutes of sunrise	*/
	short	Ssr;			/* full seconds of sunrise	*/
	short	Hss;			/* full hour of sunset		*/
	short	Mss;			/* full minutes of sunset	*/
	short	Sss;			/* full seconds of sunrset	*/
	} SUNSHINETYPE;



class CSun
{

#define DB180 180.		
#define DB360 360. 
#define NO_KOORD	1000.	/* undefined val of Lat or Lon		*/


// Attributes
private:    
	time_t	m_Time;

// Operations
protected:

// Implementation
public:
	CSun(time_t time=0L);		
	~CSun();        

	void GetSunShine (double LatDegree, double LonDegree,
						SUNSHINETYPE* ptSunShine);

private:
	void GradToTime (double Degree, short* ptHours, short* ptMin, short* ptSec);
	double DegrMinSecToDez (double Degrees, double Minutes, double Seconds);
	void DezToDegrMinSec (double dDegr, short* bPositiv,
				short* Degrees, short* Minutes, short* Seconds);
	void GetDateAndTime (long Time, struct tm* ptDateTime);
	BOOL IsLeapYear (short nYear);
	short LengthOfMonth (short nYear, short nMonth);
	double GetThisYearsSeconds (long Time);		/* sec since 1.1.1970	*/
	short MinSecToSec (double MinSec);
	void GetHighNoonTime (long* ptTime);	      /* sec since 1.1.1970	*/
	void GetYearTime (short Year, long* ptTime);	/* sec since 1.1.1970	*/
	int GetDatesTime (short Day, short Month, short Year, long* ptTime);
	short GetThisYearsDays (long Time);
	short DiffTrueAverage (long Time);
	double Declination (long Time);			/* sec since 1.1.1970	*/
	short SunShineDegree (double LatD, double LonD, double DeclD, double Zgl,
				double* ptSRdeg, double* ptSSdeg);

};
#endif 
