// SuppDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "FlPlDoc.h"
#include "SuppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSupplementDlg dialog


CSupplementDlg::CSupplementDlg(CWnd* pParent, CFlightPlanDoc* ptDoc)
	: CDialog(CSupplementDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSupplementDlg)
	m_nEndurance = 0;
	m_nPersonCnt = 0;
	m_bEmRadioUHF = FALSE;
	m_bEmRadioVHF = FALSE;
	m_bEmRadioELBA = FALSE;
	m_bEquipPolar = FALSE;
	m_bEquipDesert = FALSE;
	m_bEquipMaritime = FALSE;
	m_bEquipJungle = FALSE;
	m_bJacketsLight = FALSE;
	m_bJacketsFloures = FALSE;
	m_bJacketsUHF = FALSE;
	m_bJacketsVHF = FALSE;
	m_nDinghiesCnt = 0;
	m_bDinghiesCover = FALSE;
	m_szDinghiesCol = _T("");
	m_szPlaneCol = _T("");
	m_szRemarks = _T("");
	m_szPilot = _T("");
	m_szRem1 = _T("");
	m_szRem2 = _T("");
	m_szRem3 = _T("");
	m_nDinghiesCap = 0;
	m_szSignature = _T("");
	m_nSignMode = -1;
	m_szFileName = _T("");
	//}}AFX_DATA_INIT

m_ptDoc = ptDoc;
m_nPersonCnt = 1;
m_szFileName = "sign.bmp";
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t T e x t							*
 ************************************************************************/
void CSupplementDlg::SetText(short nID, CString szText)
{
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->SetWindowText((LPCTSTR)szText);
}


void CSupplementDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSupplementDlg)
	DDX_Text(pDX, IDC_FSENDURANCE, m_nEndurance);
	DDV_MinMaxUInt(pDX, m_nEndurance, 0, 9959);
	DDX_Text(pDX, IDC_FSPERSONES, m_nPersonCnt);
	DDV_MinMaxUInt(pDX, m_nPersonCnt, 1, 999);
	DDX_Check(pDX, IDC_FS_ER_UHF, m_bEmRadioUHF);
	DDX_Check(pDX, IDC_FS_ER_VHF, m_bEmRadioVHF);
	DDX_Check(pDX, IDC_FS_ER_ELBA, m_bEmRadioELBA);
	DDX_Check(pDX, IDC_FS_SE_POLAR, m_bEquipPolar);
	DDX_Check(pDX, IDC_FS_SE_DESERT, m_bEquipDesert);
	DDX_Check(pDX, IDC_FS_SE_MARITIME, m_bEquipMaritime);
	DDX_Check(pDX, IDC_FS_SE_JUNGLE, m_bEquipJungle);
	DDX_Check(pDX, IDC_FS_SW_LIGHT, m_bJacketsLight);
	DDX_Check(pDX, IDC_FS_SW_FLOURES, m_bJacketsFloures);
	DDX_Check(pDX, IDC_FS_SW_UHF, m_bJacketsUHF);
	DDX_Check(pDX, IDC_FS_SW_VHF, m_bJacketsVHF);
	DDX_Text(pDX, IDC_FS_DI_CNT, m_nDinghiesCnt);
	DDV_MinMaxUInt(pDX, m_nDinghiesCnt, 0, 99);
	DDX_Check(pDX, IDC_FS_DI_COVER, m_bDinghiesCover);
	DDX_Text(pDX, IDC_FS_DI_COLOR, m_szDinghiesCol);
	DDV_MaxChars(pDX, m_szDinghiesCol, 9);
	DDX_Text(pDX, IDC_FS_PLANECOLOR, m_szPlaneCol);
	DDV_MaxChars(pDX, m_szPlaneCol, 128);
	DDX_Text(pDX, IDC_FSREMARKS, m_szRemarks);
	DDV_MaxChars(pDX, m_szRemarks, 128);
	DDX_Text(pDX, IDC_FSPILOT, m_szPilot);
	DDV_MaxChars(pDX, m_szPilot, 32);
	DDX_Text(pDX, IDC_FSREM1, m_szRem1);
	DDV_MaxChars(pDX, m_szRem1, 32);
	DDX_Text(pDX, IDC_FSREM2, m_szRem2);
	DDV_MaxChars(pDX, m_szRem2, 32);
	DDX_Text(pDX, IDC_FSREM3, m_szRem3);
	DDV_MaxChars(pDX, m_szRem3, 32);
	DDX_Text(pDX, IDC_FS_DI_CAP, m_nDinghiesCap);
	DDV_MinMaxUInt(pDX, m_nDinghiesCap, 0, 999);
	DDX_Text(pDX, IDC_FSSIGNATURE, m_szSignature);
	DDV_MaxChars(pDX, m_szSignature, 32);
	DDX_Radio(pDX, IDC_FSSIGNTEXT, m_nSignMode);
	DDX_Text(pDX, IDC_FSFILENAME, m_szFileName);
	DDV_MaxChars(pDX, m_szFileName, 32);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSupplementDlg, CDialog)
	//{{AFX_MSG_MAP(CSupplementDlg)
	ON_BN_CLICKED(IDC_FSBMP, OnGetFileName)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSupplementDlg message handlers

/************************************************************************
 *  SuppDlg.cpp			    O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CSupplementDlg::OnInitDialog() 
{
m_nEndurance	= m_ptDoc->GetEndurance (); 
m_nPersonCnt	= m_ptDoc->GetPersonCnt (); 
m_bEmRadioUHF	= m_ptDoc->IsEmRadioUHF (); 
m_bEmRadioVHF	= m_ptDoc->IsEmRadioVHF (); 
m_bEmRadioELBA	= m_ptDoc->IsEmRadioELBA ();

m_bEquipPolar	= m_ptDoc->IsEquipPolar ();
m_bEquipDesert	= m_ptDoc->IsEquipDesert (); 
m_bEquipMaritime= m_ptDoc->IsEquipMaritime (); 
m_bEquipJungle	= m_ptDoc->IsEquipJungle ();
m_bJacketsLight	= m_ptDoc->IsJacketsLight ();
m_bJacketsFloures= m_ptDoc->IsJacketsFloures ();
m_bJacketsUHF	= m_ptDoc->IsJacketsUHF ();
m_bJacketsVHF	= m_ptDoc->IsJacketsVHF ();

m_nDinghiesCnt	= m_ptDoc->GetDinghiesCnt ();
m_nDinghiesCap	= m_ptDoc->GetDinghiesCap ();
m_bDinghiesCover= m_ptDoc->IsDinghiesCover();
m_szDinghiesCol	= m_ptDoc->GetDinghiesCol ();

m_szPlaneCol	= m_ptDoc->GetPlaneCol ();
m_szRemarks		= m_ptDoc->GetRemarks (); 
m_szPilot		= m_ptDoc->GetPilot (); 
m_nSignMode		= (short)m_ptDoc->GetSignMode();
m_szSignature	= m_ptDoc->GetSignature ();
m_szSignFile	= m_ptDoc->GetSignFile();
m_szRem1		= m_ptDoc->GetRem1 ();
m_szRem2		= m_ptDoc->GetRem2 ();
m_szRem3		= m_ptDoc->GetRem3 ();

short nSlash;		// get file name from full path of sign file
nSlash = m_szSignFile.ReverseFind ('\\');
if (nSlash >= -1)
	 m_szFileName = m_szSignFile.Right (m_szSignFile.GetLength() - nSlash - 1);
else m_szFileName = m_szSignFile;

CDialog::OnInitDialog();
		
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  SuppDlg.cpp				O n G e t F i l e N a m e					*
 ************************************************************************/
void CSupplementDlg::OnGetFileName() 
{
	// TODO: Add your control notification handler code here
static char szFilter[] = "Unterschrift (*.bmp)|*.bmp||"; 

CFileDialog dlg(TRUE, 	  					// File Open dialog
				NULL,						// no default extension
				"*.bmp",					// initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				this);						// parent window

//CString szPath = this->GetActPathName();	// without NameExt
//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	if (m_ptDoc != NULL)
		{
		m_szSignFile = dlg.GetPathName();  
		m_szFileName = dlg.GetFileName();
		this->SetText (IDC_FSFILENAME, m_szFileName);
		}
	}
}


/************************************************************************
 *  SuppDlg.cpp					I s C h a n g e d						*
 ************************************************************************/
BOOL CSupplementDlg::IsChanged() 
{
if (m_nEndurance	!= m_ptDoc->GetEndurance ()) return TRUE; 
if (m_nPersonCnt	!= m_ptDoc->GetPersonCnt ()) return TRUE; 
if (m_bEmRadioUHF	!= m_ptDoc->IsEmRadioUHF ()) return TRUE; 
if (m_bEmRadioVHF	!= m_ptDoc->IsEmRadioVHF ()) return TRUE; 
if (m_bEmRadioELBA	!= m_ptDoc->IsEmRadioELBA ()) return TRUE;

if (m_bEquipPolar	!= m_ptDoc->IsEquipPolar ()) return TRUE;
if (m_bEquipDesert	!= m_ptDoc->IsEquipDesert ()) return TRUE; 
if (m_bEquipMaritime!= m_ptDoc->IsEquipMaritime ()) return TRUE; 
if (m_bEquipJungle	!= m_ptDoc->IsEquipJungle ()) return TRUE;
if (m_bJacketsLight	!= m_ptDoc->IsJacketsLight ()) return TRUE;
if (m_bJacketsFloures!= m_ptDoc->IsJacketsFloures ()) return TRUE;
if (m_bJacketsUHF	!= m_ptDoc->IsJacketsUHF ()) return TRUE;
if (m_bJacketsVHF	!= m_ptDoc->IsJacketsVHF ()) return TRUE;

if (m_nDinghiesCnt	!= m_ptDoc->GetDinghiesCnt ()) return TRUE;
if (m_nDinghiesCap	!= m_ptDoc->GetDinghiesCap ()) return TRUE;
if (m_bDinghiesCover!= m_ptDoc->IsDinghiesCover()) return TRUE;
if (m_szDinghiesCol.Compare (m_ptDoc->GetDinghiesCol ()) != 0) return TRUE;

if (m_szPlaneCol.Compare (m_ptDoc->GetPlaneCol ()) != 0) return TRUE;
if (m_szRemarks.Compare (m_ptDoc->GetRemarks ()) != 0) return TRUE; 
if (m_szPilot.Compare (m_ptDoc->GetPilot ()) != 0) return TRUE; 
if (m_nSignMode		!= (short)m_ptDoc->GetSignMode()) return TRUE;
if (m_szSignature.Compare (m_ptDoc->GetSignature ()) != 0) return TRUE;
if (m_szSignFile.Compare (m_ptDoc->GetSignFile()) != 0) return TRUE;
if (m_szRem1.Compare (m_ptDoc->GetRem1 ()) != 0) return TRUE;
if (m_szRem2.Compare (m_ptDoc->GetRem2 ()) != 0) return TRUE;
if (m_szRem3.Compare (m_ptDoc->GetRem3 ()) != 0) return TRUE;


return FALSE;
}

/************************************************************************
 *  SuppDlg.cpp						O n O K								*
 ************************************************************************/
void CSupplementDlg::OnOK() 
{
	// TODO: Add extra validation here

if (this->UpdateData (TRUE))
	{
	if (this->IsChanged())
		{
		m_ptDoc->SetEndurance (m_nEndurance);
		m_ptDoc->SetPersonCnt (m_nPersonCnt);
		m_ptDoc->SetEmRadioUHF (m_bEmRadioUHF);
		m_ptDoc->SetEmRadioVHF (m_bEmRadioVHF);
		m_ptDoc->SetEmRadioELBA (m_bEmRadioELBA);

		m_ptDoc->SetEquipPolar (m_bEquipPolar);
		m_ptDoc->SetEquipDesert (m_bEquipDesert);
		m_ptDoc->SetEquipMaritime (m_bEquipMaritime);
		m_ptDoc->SetEquipJungle (m_bEquipJungle);
		m_ptDoc->SetJacketsLight (m_bJacketsLight);
		m_ptDoc->SetJacketsFloures (m_bJacketsFloures);
		m_ptDoc->SetJacketsUHF (m_bJacketsUHF);
		m_ptDoc->SetJacketsVHF (m_bJacketsVHF);

		m_ptDoc->SetDinghiesCnt (m_nDinghiesCnt);
		m_ptDoc->SetDinghiesCap (m_nDinghiesCap);
		m_ptDoc->SetDinghiesCover (m_bDinghiesCover);
		m_ptDoc->SetDinghiesCol (m_szDinghiesCol);

		m_ptDoc->SetPlaneCol (m_szPlaneCol);
		m_ptDoc->SetRemarks (m_szRemarks);
		m_ptDoc->SetPilot (m_szPilot);

		m_ptDoc->SetSignMode ((SIGNMODE)m_nSignMode);
		m_ptDoc->SetSignature (m_szSignature);
		m_ptDoc->SetSignFile (m_szSignFile);

		m_ptDoc->SetRem1 (m_szRem1);
		m_ptDoc->SetRem2 (m_szRem2);
		m_ptDoc->SetRem3 (m_szRem3);

		CDialog::OnOK();
		}
	else{
		CDialog::OnCancel();
		}
	}
}

/************************************************************************
 *  SuppDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CSupplementDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
