/****************************************************************************
 *							S y m b o l s . c p p							*
 ****************************************************************************/										 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"
#include "pf.h"

#include "DimDoc.h"
#include "..\CPPTOOLS\Vektor.h"
#include "Symbols.h"

extern BOOL bMMText;



/////////////////////////////////////////////////////////////////////////////
// CSymbols

/////////////////////////////////////////////////////////////////////////////
// CSymbols construction/destruction

CSymbols::CSymbols(CDC* pDC, BOOL bPrinter, short nCharX, long lScale, COLORREF TextCol)
{
	// TODO: add one-time construction code here  
m_pDC = pDC;
m_bPrinter = bPrinter;
m_ptBlueBrush = new	CBrush (RGB (0,0,255));
m_ptBluePen = new CPen (PS_SOLID, 1, RGB (0, 0, 255));
m_ptRedPen = new CPen (PS_SOLID, 1, RGB (255, 0, 0));

m_OldTextCol = m_pDC->GetTextColor();
m_pDC->SetTextColor(TextCol);

m_Quality = VQ_NONE;						  
if (lScale < 20000000) m_Quality = VQ_LOW;     
if (lScale <  4000000) m_Quality = VQ_MEDIUM;	
if (lScale <  2000000) m_Quality = VQ_MAXIMUM;	

this->SymbolsInit (nCharX); 

}

CSymbols::~CSymbols()
{   
this->SymbolsDispose();
delete m_ptRedPen;
delete m_ptBluePen;
delete m_ptBlueBrush;

m_pDC->SetTextColor (m_OldTextCol);
}

/************************************************************************
 *  TxVwTool.cpp    	    C r e a t e F o n t							*
 ************************************************************************/
BOOL CSymbols::CreateFont (CFont* ptFont, char* szName, long lHeight, BOOL bBold)
{    
BOOL	bOK = FALSE;
LOGFONT lfNewFont;

memset (&lfNewFont, 0, sizeof (LOGFONT));
lfNewFont.lfHeight = lHeight;
if (bBold) lfNewFont.lfWeight = FW_BOLD;
lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, szName);

bOK = ptFont->CreateFontIndirect ((LOGFONT FAR*)&lfNewFont);    
return bOK;
}


/****************************************************************************
 *	Symbols.cpp						E l l i p s e  							*
 ****************************************************************************/
void CSymbols::Ellipse (CDC* pDC, int left, int top, int right, int bottom, BOOL bFilled)
{
CRect rEllipse;

rEllipse.SetRect (left, top, right, bottom);

if (bFilled)
	{	 
	if (!pDC->IsPrinting())
		{
		CPoint pOrig(0,0);
		CBrush brRed (RGB (255,0,0));
		pDC->SelectObject (&brRed);
		pDC->Ellipse(rEllipse);
		pDC->SelectStockObject (WHITE_BRUSH);
		}
	else{										/* use black color			*/
		pDC->Ellipse(rEllipse);
		}

	}
else{
	CBrush* ptOldBrush = (CBrush*)pDC->SelectStockObject (NULL_BRUSH);
	pDC->Ellipse(rEllipse);
	pDC->SelectObject (ptOldBrush);
	}
}

/****************************************************************************
 *	Symbols.cpp						C i r c l e								*
 ****************************************************************************/
void CSymbols::Circle (long nX0, long nY0, short nRadius, BOOL bFilled)
{
this->Ellipse (m_pDC, nX0-nRadius, nY0-nRadius, nX0+nRadius, nY0+nRadius, bFilled);
}

/****************************************************************************
 *	Symbols.cpp						CreatePoly								*
 ****************************************************************************/
CPolygon* CSymbols::CreatePoly (short nCnt)
{
return (CPolygon*) new CPolygon (nCnt);
}


/****************************************************************************
 *	Symbols.cpp					A P T _ I n i t		  						*
 ****************************************************************************/
void CSymbols::APT_Init (short nRadius) 
{
CVektor	vRwyLeft, vRwyRight, vFix;
short i, nRadius3, nHalfRwyWidth;

if (m_Quality == VQ_LOW)
	{
	}
if (m_Quality == VQ_MEDIUM)
	{
	}

m_APT.nRadius1 = nRadius;
m_APT.nRadius2 = 2*nRadius/3;
nRadius3 = 7*m_APT.nRadius2/10;
m_APT.nThick = m_APT.nRadius2 - nRadius3 + 1;

nHalfRwyWidth = m_APT.nThick/2;

vRwyLeft.Set (-nHalfRwyWidth, -m_APT.nRadius1);
vRwyRight.Set (nHalfRwyWidth, -m_APT.nRadius1);

if (m_Quality >= VQ_MEDIUM)
	{
	vFix.Set (0, 0);

	for (i=0; i<9; i++)
		{					// calculate only first quarter:
		float fAngle;

		fAngle = (float)(i*10*3.1415926/180);
		m_APT.vL[i] = vRwyLeft.RotateXY (vFix, fAngle);
		m_APT.vR[i] = vRwyRight.RotateXY (vFix, fAngle);

		if (!bMMText)
			{
			m_APT.vL[i].y = -m_APT.vL[i].y;
			m_APT.vR[i].y = -m_APT.vR[i].y;
			}
		}
	}
}

/****************************************************************************
 *	Symbols.cpp					R E P _ I n i t		  						*
 ****************************************************************************/
void CSymbols::REP_Init (short nRadius) 
{
short i, nX, nY;
CVektor	vR[3];

m_REP.nRadius = nRadius;

nX = nRadius / 3;
nY = nRadius / 3;
vR[0].Set (0, -nY);
vR[1].Set (nX, nY);
vR[2].Set (-nX, nY);

if (!bMMText)
	{
	vR[0].y = -vR[0].y;
	vR[1].y = -vR[1].y;
	vR[2].y = -vR[2].y;
	}

m_REP.hPoly = CreatePoly(3);		// top right
for (i=0; i<3; i++)
	{
	m_REP.hPoly->Set ((short)(vR[i].x),
				 	  (short)(vR[i].y));
	}
}

/****************************************************************************
 *	Symbols.cpp					R E P _ D i s p o s e  						*
 ****************************************************************************/
void CSymbols::REP_Dispose () 
{
delete m_REP.hPoly;
}

/****************************************************************************
 *	Symbols.cpp					I N T _ I n i t		  						*
 ****************************************************************************/
void CSymbols::INT_Init (short nRadius) 
{
short nX, nY, i;
CVektor	vI[3];

m_INT.nRadius = nRadius;

nX = nRadius / 3;
nY = 2 * nRadius / 3;
vI[0].Set (0, 0);
vI[1].Set (nX, nY);
vI[2].Set (-nX, nY);

if (!bMMText)
	{
	vI[0].y = -vI[0].y;
	vI[1].y = -vI[1].y;
	vI[2].y = -vI[2].y;
	}

m_INT.hPoly = CreatePoly(3);		// top right
for (i=0; i<3; i++)
	{
	m_INT.hPoly->Set ((short)(vI[i].x),
				 	  (short)(vI[i].y));
	}
}

/****************************************************************************
 *	Symbols.cpp					I N T _ D i s p o s e  						*
 ****************************************************************************/
void CSymbols::INT_Dispose () 
{
delete m_INT.hPoly;
}

/****************************************************************************
 *	Symbols.cpp					N D B _ I n i t		  						*
 ****************************************************************************/
void CSymbols::NDB_Init (short nRadius) 
{
m_NDB.nRadius1 = nRadius; 
m_NDB.nRadius2 = 3*nRadius/4; 
m_NDB.nRadius3 = 2*nRadius/4; 
}

/****************************************************************************
 *	Symbols.cpp					V O R _ I n i t		  						*
 ****************************************************************************/
void CSymbols::VOR_Init (short nScaleRadius) 
{
double dVx, dVy, dTacX, dTacY, dTacY0;
short nLineWidth = 1;


m_VOR.nScaleRadius = nScaleRadius;
m_VOR.nRadius = nScaleRadius/4;

dVx = m_VOR.nRadius * COS_60;
dVy = m_VOR.nRadius * SIN_60;
if (bMMText) dVy = -dVy;			// negative for Mac

m_VOR.V[0].Set (dVx, dVy);
m_VOR.V[1].Set (m_VOR.nRadius, 0);
m_VOR.V[2].Set (dVx, -dVy);
m_VOR.V[3].Set (-dVx-nLineWidth, -dVy);
m_VOR.V[4].Set (-m_VOR.nRadius-nLineWidth, 0);
m_VOR.V[5].Set (-dVx-nLineWidth, dVy);
      
m_VOR.D[0].Set (m_VOR.nRadius, dVy);
m_VOR.D[1].Set (m_VOR.nRadius, -dVy);
m_VOR.D[2].Set (-m_VOR.nRadius-nLineWidth, -dVy);
m_VOR.D[3].Set (-m_VOR.nRadius-nLineWidth, dVy);


//dTacY0 = 8*m_VOR.nRadius/10;
dTacY0 = -m_VOR.nRadius;
dTacX = m_VOR.nRadius* COS_30;
dTacY = m_VOR.nRadius * SIN_30;		
if (bMMText) 
	{
	dTacY0 = -dTacY0;
	dTacY  = -dTacY;	 // negative for Mac
	}

m_VOR.T[0].Set (dTacX 	+ m_VOR.V[0].x, dTacY	+ m_VOR.V[0].y);
m_VOR.T[1].Set (dTacX 	+ m_VOR.V[1].x, dTacY	+ m_VOR.V[1].y);
m_VOR.T[2].Set (0   	+ m_VOR.V[2].x, dTacY0	+ m_VOR.V[2].y);
m_VOR.T[3].Set (0   	+ m_VOR.V[3].x, dTacY0	+ m_VOR.V[3].y);
m_VOR.T[4].Set (-dTacX	+ m_VOR.V[4].x, dTacY 	+ m_VOR.V[4].y);
m_VOR.T[5].Set (-dTacX	+ m_VOR.V[5].x, dTacY 	+ m_VOR.V[5].y);


m_VOR.hTacPoly[0] = CreatePoly(4);		// top right
m_VOR.hTacPoly[0]->Set ((long)m_VOR.V[0].x, (long)m_VOR.V[0].y);	
m_VOR.hTacPoly[0]->Set ((long)m_VOR.T[0].x, (long)m_VOR.T[0].y);
m_VOR.hTacPoly[0]->Set ((long)m_VOR.T[1].x, (long)m_VOR.T[1].y);
m_VOR.hTacPoly[0]->Set ((long)m_VOR.V[1].x, (long)m_VOR.V[1].y);

m_VOR.hTacPoly[1] = CreatePoly(4);		// bottom
m_VOR.hTacPoly[1]->Set ((long)m_VOR.V[2].x, (long)m_VOR.V[2].y);	
m_VOR.hTacPoly[1]->Set ((long)m_VOR.T[2].x, (long)m_VOR.T[2].y);
m_VOR.hTacPoly[1]->Set ((long)m_VOR.T[3].x, (long)m_VOR.T[3].y);
m_VOR.hTacPoly[1]->Set ((long)m_VOR.V[3].x, (long)m_VOR.V[3].y);

m_VOR.hTacPoly[2] = CreatePoly(4);		// top left
m_VOR.hTacPoly[2]->Set ((long)m_VOR.V[4].x, (long)m_VOR.V[4].y);	
m_VOR.hTacPoly[2]->Set ((long)m_VOR.T[4].x, (long)m_VOR.T[4].y);
m_VOR.hTacPoly[2]->Set ((long)m_VOR.T[5].x, (long)m_VOR.T[5].y);
m_VOR.hTacPoly[2]->Set ((long)m_VOR.V[5].x, (long)m_VOR.V[5].y);
}

/****************************************************************************
 *	Symbols.cpp					V O R _ D i s p o s e  						*
 ****************************************************************************/
void CSymbols::VOR_Dispose () 
{
delete m_VOR.hTacPoly[0];
delete m_VOR.hTacPoly[1];
delete m_VOR.hTacPoly[2];
}

/****************************************************************************
 *	Symbols.cpp					S A I L _ D i s p o s e  					*
 ****************************************************************************/
void CSymbols::SAIL_Dispose () 
{
delete m_SAIL.hPoly;
}


/****************************************************************************
 *	Symbols.cpp					H E L I _ D i s p o s e  					*
 ****************************************************************************/
void CSymbols::HELI_Dispose () 
{
//delete m_HELI.hPoly;
}




/****************************************************************************
 *	Symbols.cpp					U S R _ I n i t		  						*
 ****************************************************************************/
void CSymbols::USR_Init (short nRadius) 
{
m_USR.nRadius = nRadius; 
}

/****************************************************************************
 *	Symbols.cpp					S A I L _ I n i t		  					*
 ****************************************************************************/
void CSymbols::SAIL_Init (short nRadius) 
{
short nRadius3;

m_SAIL.nRadius1 = nRadius;
m_SAIL.nRadius2 = 2*nRadius/3;
nRadius3 = 8*m_SAIL.nRadius2/10;
m_SAIL.nThick = m_SAIL.nRadius2 - nRadius3 + 1;

double dX = nRadius/8;
double dY = nRadius/8;

m_SAIL.hPoly = CreatePoly(14);	
m_SAIL.hPoly->Set ((long)( 0*dX), (long)(-3*dY));	//1	
m_SAIL.hPoly->Set ((long)( 3*dX), (long)( 0*dY));	//2
m_SAIL.hPoly->Set ((long)( 8*dX), (long)(-3*dY));	//3
m_SAIL.hPoly->Set ((long)( 9*dX), (long)(-1*dY));	//4
m_SAIL.hPoly->Set ((long)( 3*dX), (long)( 2*dY));	//5
m_SAIL.hPoly->Set ((long)( 0*dX), (long)( 0*dY));	//6
m_SAIL.hPoly->Set ((long)(-3*dX), (long)( 2*dY));	//7
m_SAIL.hPoly->Set ((long)(-9*dX), (long)(-1*dY));	//8
m_SAIL.hPoly->Set ((long)(-8*dX), (long)(-3*dY));	//9
m_SAIL.hPoly->Set ((long)(-3*dX), (long)( 0*dY));	//10
m_SAIL.hPoly->Set ((long)(-2*dX), (long)(-1*dY));	//11
m_SAIL.hPoly->Set ((long)(-3*dX), (long)(-2*dY));	//12
m_SAIL.hPoly->Set ((long)(-2*dX), (long)(-3*dY));	//13
m_SAIL.hPoly->Set ((long)(-1*dX), (long)(-2*dY));	//14

}

/****************************************************************************
 *	Symbols.cpp					H E L I _ I n i t		  					*
 ****************************************************************************/
void CSymbols::HELI_Init (short nRadius) 
{
m_HELI.nRadius = 2*nRadius/3; 
}


/****************************************************************************
 *	Symbols.cpp					S y m b o l s I n i t  						*
 ****************************************************************************/
void CSymbols::SymbolsInit (short nCapsX) 
{
short	CapsX;
short	nRadiusAPT, nRadiusREP, nRadiusVOR, nRadiusNDB, nRadiusUSR;
short	nRadiusSAIL, nRadiusHELI;

if (m_Quality == VQ_NONE)	
	{							// required to draw grid, scale and route
	CapsX = 1*nCapsX/3;
	}

if (m_Quality == VQ_LOW)
	{
	CapsX = 1*nCapsX/3;
	}

if (m_Quality == VQ_MEDIUM)
	{
	CapsX = 2*nCapsX/3;
	}

if (m_Quality == VQ_MAXIMUM)
	{
	CapsX = nCapsX;
	}

nRadiusAPT = CapsX;
nRadiusREP = 2*CapsX/3;
nRadiusVOR = 2*CapsX;
nRadiusNDB = CapsX;
nRadiusUSR = CapsX/3;
nRadiusSAIL= CapsX;
nRadiusHELI= CapsX;

APT_Init (nRadiusAPT);
REP_Init (nRadiusREP);
INT_Init (nRadiusNDB);
NDB_Init (nRadiusNDB);
VOR_Init (nRadiusVOR);
USR_Init (nRadiusUSR);
SAIL_Init(nRadiusSAIL);
HELI_Init(nRadiusHELI);
}

/****************************************************************************
 *	Symbols.cpp					S y m b o l s D i s p o s e					*
 ****************************************************************************/
void CSymbols::SymbolsDispose () 
{
//APT_Dispose ();
REP_Dispose ();
INT_Dispose ();
//NDB_Dispose ();
VOR_Dispose ();
//USR_Dispose ();
SAIL_Dispose();
HELI_Dispose();
}

/****************************************************************************
 *	Symbols.cpp					StringContains								*
 ****************************************************************************/
BOOL CSymbols::StringContains (CString szText, char* szSearchFor)
{
BOOL bFound;
int nIndex = szText.Find((LPCTSTR)szSearchFor);
bFound = (nIndex > -1);
return bFound;
}

/************************************************************************
 *  Symbols.cpp			T e x t A l i g n C e n t e r					*
 ************************************************************************/
void CSymbols::TextAlignCenter (long nX, long nY, CString szText)
{ 
m_pDC->SetTextAlign (TA_CENTER | TA_TOP);
m_pDC->TextOut (nX, nY, szText);
}

/************************************************************************
 *  Symbols.cpp			T e x t A l i g n R i g h t						*
 ***********e*************************************************************/
void CSymbols::TextAlignRight (long nX, long nY, CString szText)
{ 
m_pDC->SetTextAlign (TA_RIGHT | TA_TOP);
m_pDC->TextOut (nX, nY, szText);
}

/****************************************************************************
 *	Symbols.cpp					A P T _ D r a w 							*
 ****************************************************************************/
void CSymbols::APT_Draw (long nX0, long nY0, CString ptLoc,
				short nVar, short nRwyDir, BOOL bGrass) 
{
short nY, nRwyAngle;
short	nLineWidth = 1;

m_pDC->MoveTo (nX0, nY0);
if (bMMText) nY = (short)(nY0 + m_APT.nRadius1);			
	else	 nY = (short)(nY0 - m_APT.nRadius1);			
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX0, nY, ptLoc);
m_pDC->SetBkMode (OldBkMode);

CPen ThickBluePen (PS_SOLID, m_APT.nThick, RGB(0,0,255));
CPen NormalBluePen (PS_SOLID, 1, RGB(0,0,255));

CPen* ptOldPen = m_pDC->SelectObject (&ThickBluePen);
this->Circle (nX0, nY0, m_APT.nRadius2, FALSE);


if (m_Quality >= VQ_MEDIUM)
	{
	m_pDC->SelectObject (&NormalBluePen);
	if (nRwyDir != NO_RWYDIR)
		{						// draw runway symbol
		CPolygon* hPoly;
		short i;
		
		nRwyAngle = 10*nRwyDir;
		nRwyAngle += nVar;
		nRwyAngle = (short)((float)nRwyAngle/10 + 0.5) * 10;

		if (nRwyAngle < 0)
			nRwyAngle += 360;
			
		if (nRwyAngle >= 180) 
			nRwyAngle-=180;
			
		hPoly = CreatePoly(4);
		
		if (nRwyAngle < 90)
			{
			i = nRwyAngle/10;
			
			hPoly->Set ((long)(nX0 + m_APT.vL[i].x), 			// top left
					(long)(nY0 + m_APT.vL[i].y));
			hPoly->Set ((long)(nX0 + m_APT.vR[i].x), 			// top right
					(long)(nY0 + m_APT.vR[i].y));

			hPoly->Set ((long)(nX0 - m_APT.vL[i].x), 			// bottom right
					(long)(nY0 - m_APT.vL[i].y));
			hPoly->Set ((long)(nX0 - m_APT.vR[i].x), 			// bottom left
					(long)(nY0 - m_APT.vR[i].y));
			}
		else{
			i = (nRwyAngle-90)/10;	
													// exchanged x <-> y
			hPoly->Set ((long)(nX0 + m_APT.vL[i].y), 
					(long)(nY0 - m_APT.vL[i].x));
			hPoly->Set ((long)(nX0 + m_APT.vR[i].y), 
					(long)(nY0 - m_APT.vR[i].x));

			hPoly->Set ((long)(nX0 - m_APT.vL[i].y), 	
					(long)(nY0 + m_APT.vL[i].x));
			hPoly->Set ((long)(nX0 - m_APT.vR[i].y), 			
					(long)(nY0 + m_APT.vR[i].x));
					
			hPoly->Set ((long)(nX0 + m_APT.vL[i].y), 				
					(long)(nY0 - m_APT.vL[i].x));
			}
				
		if (bGrass) hPoly->Draw(m_pDC);				//FramePoly (hPoly);
			else	hPoly->Draw(m_pDC, m_ptBlueBrush);//PaintPoly (hPoly);
		delete hPoly;
		}
	}

m_pDC->SelectObject (ptOldPen);

}

/****************************************************************************
 *	Symbols.cpp					R E P _ D r a w 							*
 ****************************************************************************/
void CSymbols::REP_Draw (long nX0, long nY0, CString ptLoc) 
{
BOOL	bFilled=TRUE;
short	nY;
CString szName;

CBrush* ptOldBrush = (CBrush*)m_pDC->SelectStockObject (WHITE_BRUSH);
CPen* ptOldPen = m_pDC->SelectObject (m_ptBluePen);

this->Circle (nX0, nY0, m_REP.nRadius, FALSE);
m_pDC->SelectObject (ptOldBrush);

								// Name like XXXX-D...
								// we use only the part after "-"
szName = ptLoc.Right(ptLoc.GetLength()-5);

m_pDC->MoveTo (nX0, nY0);
if (bMMText)	nY = (short)(nY0 + 4*m_REP.nRadius/3);
	else		nY = (short)(nY0 - 4*m_REP.nRadius/3);
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX0, nY, szName);
m_pDC->SetBkMode (OldBkMode);

m_REP.hPoly->Offset (nX0, nY0);
if (bFilled)	m_REP.hPoly->Draw(m_pDC, m_ptBlueBrush);
	else		m_REP.hPoly->Draw(m_pDC);
m_REP.hPoly->Offset (-nX0, -nY0);

m_pDC->SelectObject (ptOldPen);
}

/****************************************************************************
 *	Symbols.cpp						INT_Draw								*
 ****************************************************************************/
void CSymbols::INT_Draw (long nX0, long nY0, CString ptIndic) 
{
BOOL	bFilled = TRUE;
long	nX, nY;

m_pDC->MoveTo (nX0, nY0);
nX = nX0;
if (bMMText)	nY = nY0 + 4*m_INT.nRadius/3;
	else		nY = nY0 - 4*m_INT.nRadius/3;
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX, nY, ptIndic);
m_pDC->SetBkMode (OldBkMode);

m_INT.hPoly->Offset (nX0, nY0);
if (bFilled)	m_INT.hPoly->Draw(m_pDC, m_ptBlueBrush);
	else		m_INT.hPoly->Draw(m_pDC);
m_INT.hPoly->Offset (-nX0, -nY0);
}

/****************************************************************************
 *	Symbols.cpp					N D B _ D r a w 							*
 ****************************************************************************/
void CSymbols::NDB_Draw (long nX0, long nY0, CString ptIndic) 
{
short	nX, nY;
short	nRadiusDot = 1;

m_pDC->MoveTo (nX0, nY0);
nX = (short)(nX0 - m_NDB.nRadius1);
if (bMMText)	nY = (short)(nY0 + m_NDB.nRadius1/2);
	else		nY = (short)(nY0 - m_NDB.nRadius1/2);
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignRight (nX, nY, ptIndic);
m_pDC->SetBkMode (OldBkMode);

this->Circle (nX0, nY0, nRadiusDot, FALSE);

CPen BlueDotPen (PS_DOT, 1, RGB (0, 0, 255));
CPen* ptOldPen = (CPen*)m_pDC->SelectObject (&BlueDotPen);
this->Circle (nX0, nY0, m_NDB.nRadius1, FALSE);
this->Circle (nX0, nY0, m_NDB.nRadius2, FALSE);
this->Circle (nX0, nY0, m_NDB.nRadius3, FALSE);
m_pDC->SelectObject (ptOldPen);
}

/****************************************************************************
 *	Symbols.cpp					V O R _ D r a w P o l y						*
 *  Draws Scale with polygon				// unused.						*
 ****************************************************************************/
void CSymbols::VOR_DrawPoly (long nX0, long nY0, CString ptLoc, CString ptIndic, short nVar) 
{
BOOL	bVOR;
long	nX, nY;
short	i, j;
short	nRadiusDot = 1;

m_pDC->MoveTo (nX0, nY0);

nX = nX0;
if (bMMText) nY = nY0 + 3*m_VOR.nScaleRadius/3;
	else	 nY = nY0 - 3*m_VOR.nScaleRadius/3;
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX, nY, ptIndic);
m_pDC->SetBkMode (OldBkMode);

this->Circle (nX0, nY0, nRadiusDot, FALSE);

bVOR = StringContains (ptLoc, "VOR");
if (bVOR)
	{
	for (i=0; i<7; i++)
		{
		j = (i<6)? i : 0;
		nX = (short)(nX0 + m_VOR.V[j].x);
		nY = (short)(nY0 + m_VOR.V[j].y);
		if (i==0)	m_pDC->MoveTo (nX, nY);
			else	m_pDC->LineTo (nX, nY);
		}
	}


if (StringContains (ptLoc, "TAC"))
	{
	for (i=0; i<3; i++)
		{
		m_VOR.hTacPoly[i]->Offset (nX0, nY0);
		if (bVOR)	m_VOR.hTacPoly[i]->Draw(m_pDC, m_ptBlueBrush);
			else	m_VOR.hTacPoly[i]->Draw(m_pDC);
		m_VOR.hTacPoly[i]->Offset (-nX0, -nY0);
		}
	}

	
if (StringContains (ptLoc, "DME"))
	{
	for (i=0; i<5; i++)
		{
		j = (i<4)? i : 0;
		nX = (short)(nX0 + m_VOR.D[j].x);
		nY = (short)(nY0 + m_VOR.D[j].y);
		if (i==0)	m_pDC->MoveTo (nX, nY);
			else	m_pDC->LineTo (nX, nY);
		}
	}
	

CPen* ptOldPen = m_pDC->SelectObject (m_ptBluePen);

if (m_Quality < VQ_MEDIUM)
	this->Circle (nX0, nY0, m_VOR.nScaleRadius, FALSE);

if (m_Quality >= VQ_MEDIUM)
	{
	BOOL	bLast = FALSE;
	short nTR_X0, nTR_Y0, nTL_X0, nTL_Y0;
	short nBL_X0, nBL_Y0, nBR_X0, nBR_Y0;

	for (i=0; i<=90 && !bLast; i+=10)
		{					// calculate only first quarter:
		BOOL bScale30;
		float fAngle;
		CVektor vScale;
		short dXmax, dYmax, dXmin, dYmin;
		
		if (i==90)
			{
			bLast = TRUE;
			i = 0;
			}
		
		fAngle = (float)((nVar + i)*3.1415926/180);
		if (bMMText)
			{
			vScale.Set (sin (fAngle), -cos (fAngle)); 	// y-Koord negative!!
			}
		else{
			vScale.Set (sin (fAngle), cos (fAngle)); 	// y-Koord positive!!
			}
		
		dXmax = (short)(vScale.x * m_VOR.nScaleRadius);
		dYmax = (short)(vScale.y * m_VOR.nScaleRadius);
		bScale30 = ((float)i/30 == (float)(i/30));
		if (bScale30)
			{
			dXmin = (short)(vScale.x * m_VOR.nScaleRadius * 0.8);
			dYmin = (short)(vScale.y * m_VOR.nScaleRadius * 0.8);
			}
		else{
			dXmin = (short)(vScale.x * m_VOR.nScaleRadius * 0.9);
			dYmin = (short)(vScale.y * m_VOR.nScaleRadius * 0.9);
			}


												// top right quarter
		if (i==0 && !bLast)
			{
			nTR_X0 = (short)(nX0 + dXmax);
			nTR_Y0 = (short)(nY0 + dYmax);
			}
		else{
			if (bLast)	m_pDC->MoveTo (nTL_X0, nTL_Y0);
				else	m_pDC->MoveTo (nTR_X0, nTR_Y0);

			if (!bLast)
				{
				nTR_X0 = (short)(nX0 + dXmax);
				nTR_Y0 = (short)(nY0 + dYmax);
				}
			m_pDC->LineTo ((short)(nX0 + dXmax), (short)(nY0 + dYmax));

			if (bLast)
				m_pDC->LineTo ((short)(nX0), (short)(nY0));
			else
				m_pDC->LineTo ((short)(nX0 + dXmin), (short)(nY0 + dYmin));
			}	




												// bottom right quarter
		if (i==0 && !bLast)
			{
			nBR_X0 = (short)(nX0 + dYmax); 			// exchanged x <-> y
			nBR_Y0 = (short)(nY0 - dXmax);
			}
		else{
			if (bLast)	m_pDC->MoveTo (nTR_X0, nTR_Y0);
				else	m_pDC->MoveTo (nBR_X0, nBR_Y0);

			if (!bLast)
				{
				nBR_X0 = (short)(nX0 + dYmax); 			// exchanged x <-> y
				nBR_Y0 = (short)(nY0 - dXmax);
				}
			m_pDC->LineTo ((short)(nX0 + dYmax), (short)(nY0 - dXmax));

			m_pDC->LineTo ((short)(nX0 + dYmin), (short)(nY0 - dXmin));
			}
				  
												// bottom left quarter
		if (i==0 && !bLast)
			{
			nBL_X0 = (short)(nX0 - dXmax);
			nBL_Y0 = (short)(nY0 - dYmax);
			}
		else{
			if (bLast)	m_pDC->MoveTo (nBR_X0, nBR_Y0);
				else	m_pDC->MoveTo (nBL_X0, nBL_Y0);

			if (!bLast)
				{
				nBL_X0 = (short)(nX0 - dXmax);
				nBL_Y0 = (short)(nY0 - dYmax);
				}
			m_pDC->LineTo ((short)(nX0 - dXmax), (short)(nY0 - dYmax));
			m_pDC->LineTo ((short)(nX0 - dXmin), (short)(nY0 - dYmin));
			} 
			   


												// top left quarter
		if (i==0 && !bLast)
			{
			nTL_X0 = (short)(nX0 - dYmax);	 	// exchanged x <-> y
			nTL_Y0 = (short)(nY0 + dXmax);
			}
		else{
			if (bLast)	m_pDC->MoveTo (nBL_X0, nBL_Y0);
				else	m_pDC->MoveTo (nTL_X0, nTL_Y0);

			if (!bLast)
				{
				nTL_X0 = (short)(nX0 - dYmax);			// exchanged x <-> y
				nTL_Y0 = (short)(nY0 + dXmax);
				}
			m_pDC->LineTo ((short)(nX0 - dYmax), (short)(nY0 + dXmax));
			m_pDC->LineTo ((short)(nX0 - dYmin), (short)(nY0 + dXmin));
			}	
		} 
	}
m_pDC->SelectObject (ptOldPen);
}


/****************************************************************************
 *	Symbols.cpp					V O R _ D r a w								*
 *  Uses inverted drawing direction for botton left and bottom right scale	*
 ****************************************************************************/
void CSymbols::VOR_Draw (long nX0, long nY0, CString ptLoc, CString ptIndic, short nVar) 
{
BOOL	bVOR;
long	nX, nY;
short	i, j;
short	nRadiusDot = 1;

m_pDC->MoveTo (nX0, nY0);

nX = nX0;
if (bMMText) nY = nY0 + 3*m_VOR.nScaleRadius/3;
	else	 nY = nY0 - 3*m_VOR.nScaleRadius/3;
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX, nY, ptIndic);
m_pDC->SetBkMode (OldBkMode);

this->Circle (nX0, nY0, nRadiusDot, FALSE);

bVOR = StringContains (ptLoc, "VOR");
if (bVOR)
	{
	for (i=0; i<7; i++)
		{
		j = (i<6)? i : 0;
		nX = (short)(nX0 + m_VOR.V[j].x);
		nY = (short)(nY0 + m_VOR.V[j].y);
		if (i==0)	m_pDC->MoveTo (nX, nY);
			else	m_pDC->LineTo (nX, nY);
		}
	}


if (StringContains (ptLoc, "TAC"))
	{
	for (i=0; i<3; i++)
		{
		m_VOR.hTacPoly[i]->Offset (nX0, nY0);
		if (bVOR)	m_VOR.hTacPoly[i]->Draw(m_pDC, m_ptBlueBrush);
			else	m_VOR.hTacPoly[i]->Draw(m_pDC);
		m_VOR.hTacPoly[i]->Offset (-nX0, -nY0);
		}
	}

	
if (StringContains (ptLoc, "DME"))
	{
	for (i=0; i<5; i++)
		{
		j = (i<4)? i : 0;
		nX = (short)(nX0 + m_VOR.D[j].x);
		nY = (short)(nY0 + m_VOR.D[j].y);
		if (i==0)	m_pDC->MoveTo (nX, nY);
			else	m_pDC->LineTo (nX, nY);
		}
	}
	

CPen* ptOldPen = m_pDC->SelectObject (m_ptBluePen);

this->Circle (nX0, nY0, m_VOR.nScaleRadius, FALSE);

if (m_Quality >= VQ_MEDIUM)
	{
	for (i=0; i<90; i+=10)
		{					// calculate only first quarter:
		BOOL bScale30;
		float fAngle;
		CVektor vScale;
		short dXmax, dYmax, dXmin, dYmin;
		
		fAngle = (float)((nVar + i)*3.1415926/180);
		if (bMMText)
			{
			vScale.Set (sin (fAngle), -cos (fAngle)); 	// y-Koord negative!!
			}
		else{
			vScale.Set (sin (fAngle), cos (fAngle)); 	// y-Koord positive!!
			}
		
		dXmax = (short)(vScale.x * m_VOR.nScaleRadius);
		dYmax = (short)(vScale.y * m_VOR.nScaleRadius);
		bScale30 = ((float)i/30 == (float)(i/30));
		if (bScale30)
			{
			dXmin = (short)(vScale.x * m_VOR.nScaleRadius * 0.8);
			dYmin = (short)(vScale.y * m_VOR.nScaleRadius * 0.8);
			}
		else{
			dXmin = (short)(vScale.x * m_VOR.nScaleRadius * 0.9);
			dYmin = (short)(vScale.y * m_VOR.nScaleRadius * 0.9);
			}
												// top right quarter
		m_pDC->MoveTo ((short)(nX0 + dXmax), 			
				(short)(nY0 + dYmax));
		if (i>0)
			m_pDC->LineTo ((short)(nX0 + dXmin), 
					(short)(nY0 + dYmin));
		else
			m_pDC->LineTo ((short)(nX0), 
					(short)(nY0));
												// bottom right quarter
		m_pDC->MoveTo ((short)(nX0 + dYmin), 	// inverted drawing direction
				(short)(nY0 - dXmin));
		m_pDC->LineTo ((short)(nX0 + dYmax),	// exchanged x <-> y
				(short)(nY0 - dXmax));
												// bottom left quarter
		m_pDC->MoveTo ((short)(nX0 - dXmin), 	// inverted drawing direction
				(short)(nY0 - dYmin));
		m_pDC->LineTo ((short)(nX0 - dXmax), 
				(short)(nY0 - dYmax));
												// top left quarter
		m_pDC->MoveTo ((short)(nX0 - dYmax), 	// exchanged x <-> y
				(short)(nY0 + dXmax));
		m_pDC->LineTo ((short)(nX0 - dYmin), 
				(short)(nY0 + dXmin));
		}
	}
m_pDC->SelectObject (ptOldPen);
}


/****************************************************************************
 *	Symbols.cpp					U S R _ D r a w								*
 ****************************************************************************/
void CSymbols::USR_Draw (long nX0, long nY0, CString ptLoc) 
{
short	nY;

m_pDC->MoveTo (nX0, nY0);
nY = (short)(nY0 + 6*m_USR.nRadius);
int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);
TextAlignCenter (nX0, nY, ptLoc);
m_pDC->SetBkMode (OldBkMode);

this->Circle (nX0, nY0, m_USR.nRadius, FALSE);
}

/****************************************************************************
 *	Symbols.cpp					S A I L _ D r a w 							*
 ****************************************************************************/
void CSymbols::SAIL_Draw (long nX0, long nY0, CString ptLoc, BOOL bGrass) 
{
short	nY_Name;
CPen*	ptOldPen;

m_pDC->MoveTo (nX0, nY0);
nY_Name = (short)(nY0 - m_SAIL.nRadius1);

int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);

CPen ThickBluePen (PS_SOLID, m_SAIL.nThick, RGB(0,0,255));

ptOldPen = m_pDC->SelectObject (&ThickBluePen);
this->Circle (nX0, nY0, m_SAIL.nRadius2, FALSE);
m_pDC->SelectObject (ptOldPen);			// reset pen


CPen PolyPen (PS_SOLID, bGrass? 2:3, bGrass? RGB(0,0,255) : RGB(255,255,255));
ptOldPen = m_pDC->SelectObject (&PolyPen);

m_SAIL.hPoly->Offset (nX0, nY0);
if (bGrass)	m_SAIL.hPoly->Draw(m_pDC);
	else	m_SAIL.hPoly->Draw(m_pDC, m_ptBlueBrush);
m_SAIL.hPoly->Offset (-nX0, -nY0);

m_pDC->SelectObject (ptOldPen);			// reset pen


TextAlignCenter (nX0, nY_Name, ptLoc);
m_pDC->SetBkMode (OldBkMode);			// reset background mode

}

/****************************************************************************
 *	Symbols.cpp					H E L I _ D r a w 							*
 ****************************************************************************/
void CSymbols::HELI_Draw (long nX0, long nY0, CString ptLoc, BOOL bGrass) 
{
short	nY_H, nY_Name;

m_pDC->MoveTo (nX0, nY0);
nY_H 	= (short)(nY0 + 4*m_HELI.nRadius/5);
nY_Name = (short)(nY0 - m_HELI.nRadius);


CRect rEllipse;
rEllipse.SetRect (nX0-m_HELI.nRadius, nY0-m_HELI.nRadius, 
				  nX0+m_HELI.nRadius, nY0+m_HELI.nRadius);

int OldBkMode = m_pDC->SetBkMode (TRANSPARENT);		// transparent "H"
				  
CPen* ptOldPen = m_pDC->SelectObject (m_ptBluePen);		// blue pen

COLORREF OldTextCol = m_pDC->GetTextColor();

CFont BoldFont;
this->CreateFont (&BoldFont, "Arial", (long)(1.8 * m_HELI.nRadius), TRUE);	// bBold=TRUE
CFont* ptOldFont = (CFont*)m_pDC->SelectObject (&BoldFont);

if (bGrass)
	{	
	m_pDC->Ellipse(rEllipse);						// white circle
	
	m_pDC->SetTextColor(RGB(0,0,255));
	TextAlignCenter (nX0+1, nY_H, (CString)"H");		// blue bold "H"
	}
else{
	CBrush brBackGround (RGB(0,0,255));
	CBrush* ptOldBrush = (CBrush*)m_pDC->SelectObject (&brBackGround);
	m_pDC->Ellipse(rEllipse);						// blue circle
	m_pDC->SelectObject (ptOldBrush);
	

	m_pDC->SetTextColor(RGB(255,255,255));
	TextAlignCenter (nX0+1, nY_H, (CString)"H");		// white bold "H"
	}

m_pDC->SelectObject (ptOldFont);
BoldFont.DeleteObject ();


m_pDC->SetTextColor(OldTextCol);		// reset old text color
m_pDC->SelectObject (ptOldPen);			// reset pen


TextAlignCenter (nX0, nY_Name, ptLoc);
		

m_pDC->SetBkMode (OldBkMode);			// reset background mode
}
