#ifndef __PF_SYMBOLS__
#define __PF_SYMBOLS__
/****************************************************************************
 *								S y m b o l s . h							*
 ****************************************************************************/	
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
 
#include "..\CPPTOOLS\Polygon.h"

 
#define	SIN_30	0.5
#define	SIN_60	0.8660254
#define	COS_30	0.8660254
#define	COS_60	0.5


typedef struct
	{
	short	nRadius1;
	short	nRadius2;
	short	nThick;
	CVektor	vL[9];
	CVektor	vR[9];
	} APT_TYPE;

	
typedef struct
	{
	short		nRadius;
	CPolygon*	hPoly;
	} REPTYPE;
	
typedef struct
	{
	short		nRadius;
	CPolygon*	hPoly;
	} INTTYPE;
	
typedef struct
	{
	short	nRadius1;
	short	nRadius2;
	short	nRadius3;
	} NDBTYPE;

typedef struct
	{
	short	nScaleRadius;
	short	nRadius;
	CVektor	V[6];
	CVektor	T[6];
	CVektor	D[4];
	CPolygon*	hTacPoly[3];
	} VORTYPE;

typedef struct
	{
	short	nRadius;
	} USRTYPE;

typedef struct
	{
	short		nRadius1;
	short		nRadius2;
	short		nThick;
	CPolygon*	hPoly;
	} SAILTYPE;

typedef struct
	{
	short		nRadius;
	} HELITYPE;

typedef enum
	{
	VQ_NONE,
	VQ_LOW,
	VQ_MEDIUM,
	VQ_MAXIMUM
	} VIEWQUALITY;

class CSymbols : public CObject
{         
private:
	CDC*		m_pDC;
	BOOL		m_bPrinter;
	CPen*		m_ptRedPen;    
	CPen*		m_ptBluePen;   
	CBrush*		m_ptBlueBrush;
	COLORREF	m_OldTextCol;

	VIEWQUALITY	m_Quality;

	APT_TYPE m_APT;
	REPTYPE m_REP;
	INTTYPE m_INT;
	NDBTYPE m_NDB;
	VORTYPE m_VOR;
	USRTYPE m_USR;
	SAILTYPE m_SAIL;
	HELITYPE m_HELI;

// Operations
public:           
	CSymbols(CDC* pDC=NULL, BOOL bPrinter=FALSE, short CharX=10, 
				long lScale=100000, COLORREF TextCol=RGB(0,0,0));
	virtual ~CSymbols();  

	BOOL CreateFont (CFont* ptFont, char* szName, long lHeight, BOOL bBold);
	VIEWQUALITY	Quality() { return m_Quality; }
	BOOL IsForPrinter () { return m_bPrinter; }
	static void Ellipse (CDC* pDC, int left, int top, int right, int bottom, BOOL bFilled);
	void Circle (long nX0, long nY0, short nRadius, BOOL bFilled);
	CPolygon* CreatePoly (short nCnt);
	void APT_Init (short nRadius); 
	void REP_Init (short nRadius); 
	void INT_Init (short nRadius); 
	void NDB_Init (short nRadius); 
	void VOR_Init (short nScaleRadius); 
	void USR_Init (short nRadius); 
	void SAIL_Init (short nRadius);
	void HELI_Init (short nRadius);

	void REP_Dispose (); 
	void INT_Dispose (); 
	void VOR_Dispose (); 
	void SAIL_Dispose ();
	void HELI_Dispose ();

	void APT_Draw (long nX0, long nY0, CString ptLoc,
					short nVar, short nRwyAngle, BOOL bGrass); 
	void REP_Draw (long nX0, long nY0, CString ptLoc); 
	void INT_Draw (long nX0, long nY0, CString ptIndic); 
	void NDB_Draw (long nX0, long nY0, CString ptIndic); 
	void VOR_DrawPoly (long nX0, long nY0, CString ptLoc, CString ptIndic, short nVar); 
	void VOR_Draw (long nX0, long nY0, CString ptLoc, CString ptIndic, short nVar); 
	void USR_Draw (long nX0, long nY0, CString ptLoc); 
	void SAIL_Draw (long nX0, long nY0, CString ptLoc, BOOL bGrass); 
	void HELI_Draw (long nX0, long nY0, CString ptLoc, BOOL bGrass); 

private:
	void SymbolsInit (short CapsX); 
	void SymbolsDispose (); 
	BOOL StringContains (CString szText, char* szSearchFor);
	void TextAlignCenter (long nX, long nY, CString szText);
	void TextAlignRight (long nX, long nY, CString szText);

};

#endif		// __PF_SYMBOLS__