// TankDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    
     
#include "PlaneDoc.h"
#include "TankDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// CTankDlg dialog


CTankDlg::CTankDlg(CWnd* pParent, CPlane* ptPlane)
	: CDlgTool(CTankDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTankDlg)
	m_lUse0 = 0;
	m_lUnuse0 = 0;
	m_lUse1 = 0;
	m_lUnuse1 = 0;
	m_lUse2 = 0;
	m_lUnuse2 = 0;
	m_nArmDim = -1;
	m_nVolDim = -1;
	//}}AFX_DATA_INIT

m_ptPlane = ptPlane;
m_bChanged = FALSE;           

this->SetData(m_ptPlane);
}

CTankDlg::~CTankDlg()
{

}


/************************************************************************
 *  TankDlg.cpp	  		 	S e t D a t a  							*
 ************************************************************************/
void CTankDlg::SetData (CPlane* ptPlane)
{  
short nVolDim, nArmDim;
float fUse, fUnuse, fArm;

ptPlane->GetTankDim(&nVolDim, &nArmDim);
m_nVolDim = ptDim->GetPUIndex (VOLUME, nVolDim);
m_nArmDim = ptDim->GetPUIndex (ARM, nArmDim);

short nIndex = 0;
ptPlane->GetTankData(nIndex, &fUse, &fUnuse, &fArm);
m_lUse0		= (long)fUse;
m_lUnuse0	= (long)fUnuse;
m_fArm0		= fArm;

nIndex = 1;
ptPlane->GetTankData(nIndex, &fUse, &fUnuse, &fArm);
m_lUse1		= (long)fUse;
m_lUnuse1	= (long)fUnuse;
m_fArm1		= fArm;

nIndex = 2;
ptPlane->GetTankData(nIndex, &fUse, &fUnuse, &fArm);
m_lUse2		= (long)fUse;
m_lUnuse2	= (long)fUnuse;
m_fArm2		= fArm;
}	

/************************************************************************
 *  TankDlg.cpp	  				G e t D a t a  							*
 ************************************************************************/
void CTankDlg::GetData (CPlane* ptPlane)
{    
short nCnt = 0;                        
short nVolDim	= ptDim->GetPUDim (VOLUME, m_nVolDim);
short nArmDim	= ptDim->GetPUDim (ARM, m_nArmDim);

ptPlane->SetTankDim(nVolDim, nArmDim);

short nIndex = 0;
ptPlane->SetTankData(nIndex, (float)m_lUse0, (float)m_lUnuse0, m_fArm0);

nIndex = 1;
ptPlane->SetTankData(nIndex, (float)m_lUse1, (float)m_lUnuse1, m_fArm1);

nIndex = 2;
ptPlane->SetTankData(nIndex, (float)m_lUse2, (float)m_lUnuse2, m_fArm2);

if (m_lUse0 > 0 && m_fArm0 > 0) nCnt++;
if (m_lUse1 > 0 && m_fArm1 > 0) nCnt++;
if (m_lUse2 > 0 && m_fArm2 > 0) nCnt++;
ptPlane->SetTankCnt (nCnt);
}	


/************************************************************************
 *  TankDlg.cpp	  				DoDataExchange							*
 ************************************************************************/
void CTankDlg::DoDataExchange(CDataExchange* pDX)
{
this->ActivateDimGroups();

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTankDlg)
	DDX_CBIndexArmDim(pDX, ID_FCARMDIM, m_nArmDim);
	DDX_CBIndex(pDX, ID_FCFUELDIM, m_nVolDim);
	DDX_VolumeOpt(pDX, ID_FCUSE0, m_lUse0);
	DDV_VolumeOpt(pDX, m_lUse0, 0, 5000);
	DDX_VolumeOpt(pDX, ID_FCUNUSE0, m_lUnuse0);
	DDV_VolumeOpt(pDX, m_lUnuse0, 0, 5000);
	DDX_ArmOpt(pDX, ID_FCARM0, m_fArm0);
	DDV_ArmOpt(pDX, m_fArm0, -5.f, 10.f);
	DDX_VolumeOpt(pDX, ID_FCUSE1, m_lUse1);
	DDV_VolumeOpt(pDX, m_lUse1, 0, 5000);
	DDX_VolumeOpt(pDX, ID_FCUNUSE1, m_lUnuse1);
	DDV_VolumeOpt(pDX, m_lUnuse1, 0, 5000);
	DDX_ArmOpt(pDX, ID_FCARM1, m_fArm1);
	DDV_ArmOpt(pDX, m_fArm1, -5.f, 10.f);
	DDX_VolumeOpt(pDX, ID_FCUSE2, m_lUse2);
	DDV_VolumeOpt(pDX, m_lUse2, 0, 5000);
	DDX_VolumeOpt(pDX, ID_FCUNUSE2, m_lUnuse2);
	DDV_VolumeOpt(pDX, m_lUnuse2, 0, 5000);
	DDX_ArmOpt(pDX, ID_FCARM2, m_fArm2);
	DDV_ArmOpt(pDX, m_fArm2, -5.f, 10.f);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTankDlg, CDlgTool)
	//{{AFX_MSG_MAP(CTankDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTankDlg message handlers

BOOL CTankDlg::OnInitDialog() 
{
this->AddDimGroup (ID_FCUSE0,   ID_FCFUELDIM);
this->AddDimGroup (ID_FCUNUSE0, ID_FCFUELDIM);
this->AddDimGroup (ID_FCARM0,   ID_FCARMDIM);

this->AddDimGroup (ID_FCUSE1,   ID_FCFUELDIM);
this->AddDimGroup (ID_FCUNUSE1, ID_FCFUELDIM);
this->AddDimGroup (ID_FCARM1,   ID_FCARMDIM);

this->AddDimGroup (ID_FCUSE2,   ID_FCFUELDIM);
this->AddDimGroup (ID_FCUNUSE2, ID_FCFUELDIM);
this->AddDimGroup (ID_FCARM2,   ID_FCARMDIM);

this->FillDimPU (ID_FCFUELDIM, VOLUME);
this->FillDimPU (ID_FCARMDIM, ARM);

	// TODO: Add extra initialization here

CDlgTool::OnInitDialog();
return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  TankDlg.cpp	  			 O n H e l p I n f o						*
 ************************************************************************/
BOOL CTankDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
