// TrackDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"    

#include "TrackDoc.h"  
#include "TrackDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

     
extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;
extern BOOL	bDemo;

/////////////////////////////////////////////////////////////////////////////
// CTrackDlg dialog


CTrackDlg::CTrackDlg(CWnd* pParent, CTrackDoc* ptDoc, CGpsDoc* ptGpsDoc)
	: CDlgTool(CTrackDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTrackDlg)
	m_szTitle = _T("");
	m_szLat = _T("");
	m_szLon = _T("");
	m_szAltDim = _T("");
	m_szTime = _T("");
	m_szSpeedDim = _T("");
	m_szCnt = _T("");
	m_lAltitude = 0;
	m_lSpeed = 0;
	m_szDistDim = _T("");
	m_lDist = 0;
	//}}AFX_DATA_INIT
m_ptDoc		= ptDoc;   
m_ptGpsDoc	= ptGpsDoc;	
m_bTimeOut	= FALSE;

m_ptNmea	= NULL;
m_uTimer	= 0;
m_ptLogFile	= NULL;

m_bUpdate = FALSE;
m_bRecording = FALSE;
m_nPosIndex = 0;
m_nPgRange = 0;
m_nStartTrackCnt = 0;
}

/************************************************************************
 *  TrackDlg.cpp				~ C T r a c k D l g 		DESTRUCTOR	*
 ************************************************************************/
CTrackDlg::~CTrackDlg()
{
if (m_ptNmea != NULL)
	{
	m_ptNmea->Close();
	delete m_ptNmea;
	m_ptNmea = NULL;
	}

if (m_ptLogFile != NULL)
	{
	m_ptLogFile->Close();
	delete m_ptLogFile;
	m_ptLogFile = NULL;
	}
}

void CTrackDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrackDlg)
	DDX_Text(pDX, ID_TRNAME, m_szTitle);
	DDX_Text(pDX, ID_TRLAT, m_szLat);
	DDX_Text(pDX, ID_TRLON, m_szLon);
	DDX_Text(pDX, ID_TRALTDIM, m_szAltDim);
	DDX_Text(pDX, ID_TRTIME, m_szTime);
	DDX_Text(pDX, ID_TRSPEEDDIM, m_szSpeedDim);
	DDX_Text(pDX, ID_TRDISTDIM, m_szDistDim);
	DDX_Text(pDX, ID_TRCNT, m_szCnt);
	DDX_Alt(pDX, ID_TRALT, m_lAltitude);
	DDV_AltOptional(pDX, m_lAltitude, -100, 50000);
	DDX_Dist(pDX, ID_TRSPEED, m_lSpeed);
	DDV_DistOptional(pDX, m_lSpeed, 0, 3000);
	DDX_Dist(pDX, ID_TRDIST, m_lDist);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTrackDlg, CDlgTool)
	//{{AFX_MSG_MAP(CTrackDlg)
	ON_BN_CLICKED(ID_TROPEN, OnTrackOpen)
	ON_BN_CLICKED(ID_TRNEW, OnTrackNew)
	ON_BN_CLICKED(ID_TRSAVEAS, OnTrackSaveAs)
	ON_BN_CLICKED(ID_TRSTOP, OnTrackStop)
	ON_BN_CLICKED(ID_TRSTART, OnTrackStart)
	ON_BN_CLICKED(ID_TRPGDOWN, OnPageDown)
	ON_BN_CLICKED(ID_TRDOWN, OnLineDown)
	ON_BN_CLICKED(ID_TRUP, OnLineUp)
	ON_BN_CLICKED(ID_TRPGUP, OnPageUp)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/****************************************************************************
 *	TrackDlg.cpp			S e t D i m e n s i o n s	 					*
 ****************************************************************************/
void CTrackDlg::SetDimensions ()
{
ptDim->GetDimCstring (&m_szSpeedDim, ptDim->DistDimToSpeedDim (ptDim->Distance()));
ptDim->GetDimCstring (&m_szAltDim, ptDim->Altitude());
ptDim->GetDimCstring (&m_szDistDim, ptDim->Distance());
}

/****************************************************************************
 *	wGPS.c				D i s a b l e P g U p D o w n C t r l				*
 ****************************************************************************/
BOOL CTrackDlg::DisablePgUpDownCtrl (short* ptPosIndex)
{
BOOL bUpdate = FALSE;
short nCnt = m_ptDoc->GetCnt();

this->DisableControl (ID_TRPGUP, (nCnt - 1 - *ptPosIndex <= 0));
this->DisableControl (ID_TRPGDOWN, (*ptPosIndex <= 0));

if (*ptPosIndex >= nCnt)
	{
	*ptPosIndex = nCnt - 1;
	bUpdate = TRUE;
	}
	
if (*ptPosIndex < 0)
	{
	*ptPosIndex = 0;
	bUpdate = TRUE;
	}
return bUpdate;
}

/****************************************************************************
 *	TrackDlg.cpp					S e t D a t a							*
 ****************************************************************************/
void CTrackDlg::SetData (short i)
{
double fConvert;
CString	szDim;

if (i==-1)
	{					// reset display
	m_szTitle.LoadString (IDS_NO_TITLE);
	m_szCnt = this->Format (IDF_I_OF_N, 0, 0);
	m_szTime.Empty();
	m_szLat.Empty();
	m_szLon.Empty();
	m_lSpeed = NO_LONG;
	m_lDist = NO_LONG;
	m_lAltitude = NO_ALT;
	}
else{
	short nCnt = m_ptDoc->GetCnt();
	if (i>=0 && i<nCnt)
		{
		CTrackPoint	Track;
		if (m_ptDoc->GetTrackPointPtr (i, &Track))
			{
			long	lAlt, lDist;
			short nDegr, nMin, nSec, nSign, nSpeed, nHour;
			
			m_szCnt = this->Format (IDF_I_OF_N, i+1, nCnt);
		
			Track.GetTime (&nHour, &nMin, &nSec);
			m_szTime = this->Format (IDF_TRACKTIME, nHour, nMin, nSec);
			
			Track.GetLat (&nDegr, &nMin, &nSec, &nSign);
			m_szLat = this->Format (IDF_TRACKLAT,
						nDegr, nMin, nSec, (nSign>0)? 'S' : 'N');


			Track.GetLon (&nDegr, &nMin, &nSec, &nSign);
			m_szLon = this->Format (IDF_TRACKLON,
						nDegr, nMin, nSec, (nSign>0)? 'W' : 'E');
			
			if (Track.GetSpeed (&nSpeed))
				{
				fConvert = ptDim->ConvertSpeed (nSpeed, m_ptDoc->GetSpeedDim(),  
									ptDim->DistDimToSpeedDim (ptDim->Distance()));
				m_lSpeed = (long)(fConvert+0.5);
				}
			else{
				m_lSpeed = NO_LONG;
				}
				
			if (Track.GetAlt (&lAlt))
				{
				fConvert = ptDim->ConvertDist (lAlt, m_ptDoc->GetAltDim(), 
									ptDim->Altitude());
				m_lAltitude = (long)(fConvert+0.5);
				}
			else{
				m_lAltitude = NO_ALT;
				}

			if (Track.GetDist(&lDist))
				{
				fConvert = ptDim->ConvertDist (lDist, m_ptDoc->GetDistDim(), 
									ptDim->Distance());
				m_lDist = (long)(fConvert+0.5);
				}
			else{
				m_lDist = NO_LONG;
				}

			ptDim->GetDimCstring (&m_szSpeedDim, ptDim->DistDimToSpeedDim (ptDim->Distance()));
			ptDim->GetDimCstring (&m_szAltDim, ptDim->Altitude());
			ptDim->GetDimCstring (&m_szDistDim, ptDim->Distance());
			}
		}
	}
this->UpdateData (FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// CTrackDlg message handlers

BOOL CTrackDlg::OnInitDialog() 
{
	CDlgTool::OnInitDialog();
	// TODO: Add extra initialization here

m_ptNmea = (CNmea*)new CNmea (4800, 8, (float)1, NO);

this->SetDimensions ();
short nCnt = m_ptDoc->GetCnt();

if (nCnt > 1)
	{
	m_nPgRange = nCnt/10;
	m_szTitle = m_ptDoc->GetTitle();

	this->SetData (m_nPosIndex);	
	this->DisableControl (ID_TRSTOP, TRUE);	
	this->DisablePgUpDownCtrl (&m_nPosIndex);
	}
else{
	this->SetData (-1);				// -1: clear input
	
//	m_ptDoc->SetTitle(m_szTitle); 
	m_ptDoc->SetPathName(m_szTitle, FALSE);		// add to MRU = false

	this->DisableControl (ID_TRNEW, TRUE);
	this->DisableControl (ID_TRSTOP, TRUE);
	this->DisableControl (ID_TRPGDOWN, TRUE);
	this->DisableControl (ID_TRDOWN, TRUE);
	this->DisableControl (ID_TRUP, TRUE);
	this->DisableControl (ID_TRPGUP, TRUE);
	}

BOOL bDisabled = !m_ptDoc->IsModified();
this->DisableControl (ID_TRSAVEAS, bDisabled);

m_bUpdate = FALSE;
return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}


/************************************************************************
 *  TrackDlg.cpp			I n i t R e a d N M E A 					*
 ************************************************************************/
BOOL CTrackDlg::InitReadNMEA (short nInpLen, short nOutLen)
{
BOOL	bInit = FALSE;

if (m_ptNmea != NULL)
	{
	m_ptNmea->BinMode();
	bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

return bInit;
}



/************************************************************************
 *  TrackDlg.cpp				O n T r a c k N e w						*
 ************************************************************************/
void CTrackDlg::OnTrackNew() 
{
	// TODO: Add your control notification handler code here

m_ptDoc->OnNewDocument();

this->SetData (-1);						// -1: clear input
				
m_nPosIndex=0;
m_nPgRange = m_ptDoc->GetCnt()/10;
m_nStartTrackCnt = 0;

this->DisableControl (ID_TRSAVEAS, TRUE);
this->DisableControl (ID_TRPGDOWN, TRUE);
this->DisableControl (ID_TRDOWN, TRUE);
this->DisableControl (ID_TRUP, TRUE);
this->DisableControl (ID_TRPGUP, TRUE);
}

/************************************************************************
 *  TrackDlg.cpp				O n T r a c k O p e n					*
 ************************************************************************/
void CTrackDlg::OnTrackOpen() 
{
	// TODO: Add your control notification handler code here
	if (m_ptDoc->Open(this))
	{
		m_nPosIndex=0;
		m_nPgRange = m_ptDoc->GetCnt()/10;
		m_szTitle = m_ptDoc->GetTitle();
		m_nStartTrackCnt = m_ptDoc->GetCnt();

		this->SetData (m_nPosIndex);
		
		if (m_ptDoc->GetCnt() > 1)
		{
			this->DisableControl (ID_TRNEW, FALSE);
			this->DisableControl (ID_TRDOWN, FALSE);
			this->DisableControl (ID_TRUP, FALSE);
			m_bUpdate = TRUE;
		}
		this->DisablePgUpDownCtrl (&m_nPosIndex);
	}
}

/************************************************************************
 *  TrackDlg.cpp				O n T r a c k S a v e A s				*
 ************************************************************************/
void CTrackDlg::OnTrackSaveAs() 
{
	// TODO: Add your control notification handler code here
							// ask for new file name
//static char szFilter[] = "DeltaDoc (*.ddc) | *.ddc | Text Files (*.txt) | *.txt | All Files (*.*) | *.* ||"; 
static char szFilter[] = "Aufzeichnung (*.trk)|*.trk||"; 

CFileDialog dlg(FALSE, 	  					// File SaveAs dialog
				(LPCTSTR)"trk",				// default extension "*.trk"
				NULL,						// no initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				this);						// parent window

//CString szPath = ptInit->GetActualPath();	// without NameExt
//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	if (m_ptDoc != NULL)
		{
		CString szPath = dlg.GetPathName();  
		m_ptDoc->SetPathName (szPath);

		if (m_ptDoc->OnSaveDocument (szPath))
			{	
			CString szTitle = m_ptDoc->GetTitle();
			this->SetText (ID_TRNAME, szTitle);
			this->DisableControl (ID_TRSAVEAS, TRUE);
			m_nStartTrackCnt = m_ptDoc->GetCnt();
			}
		}
	}
}

/************************************************************************
 *  TrackDlg.cpp				O n T r a c k S t a r t					*
 ************************************************************************/
void CTrackDlg::OnTrackStart() 
{
	// TODO: Add your control notification handler code here
	BOOL bDoStart = TRUE;
	BOOL bAppend = FALSE;
	
	if (m_ptDoc->GetCnt() > 0)
	{								// old track in memory
		CString szText;	
		szText.Format(IDF_APPEND_TRACK, (LPCTSTR)m_ptDoc->GetTitle());
		if (AfxMessageBox (szText, MB_YESNO) == IDYES)
		{
			bAppend = TRUE;
		}
		else
		{								// don`t append 
			BOOL bNewDoc = TRUE;

			if (m_ptDoc->IsModified())
				bNewDoc = m_ptDoc->SaveAs(this, TRUE); // bConfirm=TRUE

			if (bNewDoc || bDemo)
			{							// old track is saved
				m_ptDoc->OnNewDocument();			// delete actual track
			}
			else
			{
				bDoStart = FALSE;
			}
		}
	}

	if (!bAppend)
	{
		CString szTitle;
		szTitle.LoadString(IDS_NO_TITLE);
		BOOL bAddToMRU = FALSE;			
		m_ptDoc->SetPathName(szTitle, bAddToMRU);	// rename actual track
	}


if (bDoStart)
	{		
	BOOL bDebug = FALSE;

	CString szTestGPS;	// debug gps data transfer if track title starts with TestGPS
	szTestGPS.LoadString(IDS_TESTGPS);
	bDebug = (m_ptDoc->GetTitle().Find((LPCTSTR)szTestGPS) == 0);

	if (bDebug)
		{
		CString szFileTitle;
		szFileTitle = SaveAsTextBox (this, "Tracking Route", "ReadNMEA");

		if (szFileTitle.GetLength() > 0)
			{
			m_ptLogFile = new CFile ();
			m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
			}
		}	
	
		    // nInputLen = 2560
	if (this->InitReadNMEA (2560, 256))
		{			
		this->SetData (-1);				// -1: clear input

		m_nPosIndex=0;
		m_nPgRange = m_ptDoc->GetCnt()/10;
		
		this->DisableControl (ID_TRNEW, TRUE);
		this->DisableControl (ID_TROPEN, TRUE);
		this->DisableControl (ID_TRSAVEAS, TRUE);
		this->DisableControl (ID_TRSTART, TRUE);
		this->DisableControl (ID_TRPGDOWN, TRUE);
		this->DisableControl (ID_TRDOWN, TRUE);
		this->DisableControl (ID_TRUP, TRUE);
		this->DisableControl (ID_TRPGUP, TRUE);
		this->DisableControl (IDCANCEL, TRUE);
		
		this->DisableControl (ID_TRSTOP, FALSE);


		m_uTimer = SetTimer (GPS_TIMER, 1000, NULL);
		if (m_uTimer == 0)
			{									/* 1 sec Timer	*/
			AfxMessageBox ("Bad Timer");
			this->PostMessage (WM_COMMAND, (WPARAM)IDCANCEL, (LPARAM)0);
			}
		else{
			m_bRecording = TRUE;  
			}

		m_bUpdate = TRUE;
		}	
	}	
}

/************************************************************************
 *  TrackDlg.cpp				O n T r a c k S t o p					*
 ************************************************************************/
void CTrackDlg::OnTrackStop() 
{
	// TODO: Add your control notification handler code here
m_bRecording = FALSE;

if (m_ptNmea->Close ())
	{
	m_nPgRange = m_ptDoc->GetCnt()/10;
	this->DisableControl (ID_TRNEW, FALSE);
	this->DisableControl (ID_TROPEN, FALSE);
	this->DisableControl (ID_TRSTART, FALSE);
	this->DisableControl (IDCANCEL, FALSE);
	if (m_ptDoc->GetCnt() > m_nStartTrackCnt)
		{
		if (!bDemo)
			this->DisableControl (ID_TRSAVEAS, FALSE);
		this->DisableControl (ID_TRDOWN, FALSE);
		this->DisableControl (ID_TRPGUP, FALSE);
		m_bUpdate = TRUE;
		m_ptDoc->SetModifiedFlag(TRUE);
		}
	this->DisableControl (ID_TRSTOP, TRUE);

	m_ptDoc->Filter();
	m_ptDoc->InLegalArea();

	if(this->DisablePgUpDownCtrl (&m_nPosIndex))
		this->SetData (m_nPosIndex);
	}

if (m_ptLogFile != NULL)
	{
	m_ptLogFile->Close();
	delete m_ptLogFile;
	m_ptLogFile = NULL;
	}
}

/************************************************************************
 *  TrackDlg.cpp				O n P a g e U p							*
 ************************************************************************/
void CTrackDlg::OnPageUp() 
{
	// TODO: Add your control notification handler code here
	
m_nPosIndex += m_nPgRange;
this->DisablePgUpDownCtrl (&m_nPosIndex);
this->SetData (m_nPosIndex);
}


/************************************************************************
 *  TrackDlg.cpp				O n L i n e U p							*
 ************************************************************************/
void CTrackDlg::OnLineUp() 
{
	// TODO: Add your control notification handler code here
if (m_nPosIndex < m_ptDoc->GetCnt()-1)
	{
	m_nPosIndex++;
	this->DisablePgUpDownCtrl (&m_nPosIndex);
	this->SetData (m_nPosIndex);
	}
}

/************************************************************************
 *  TrackDlg.cpp				O n L i n e D o w n						*
 ************************************************************************/
void CTrackDlg::OnLineDown() 
{
	// TODO: Add your control notification handler code here
if (m_nPosIndex > 0)
	{
	m_nPosIndex--;
	this->DisablePgUpDownCtrl (&m_nPosIndex);
	this->SetData (m_nPosIndex);
	}
}


/************************************************************************
 *  TrackDlg.cpp				O n P a g e D o w n						*
 ************************************************************************/
void CTrackDlg::OnPageDown() 
{
	// TODO: Add your control notification handler code here

m_nPosIndex -= m_nPgRange;
this->DisablePgUpDownCtrl (&m_nPosIndex);
this->SetData (m_nPosIndex);
}

/************************************************************************
 *  TrackDlg.cpp				O n T i m e r							*
 ************************************************************************/
void CTrackDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
switch (nIDEvent)
	{
	case GPS_TIMER:
		this->KillTimer (m_uTimer);

		if (m_bRecording)
			{	
			BOOL bValid;				// loops while (!bStop && !bStored)
			m_bTimeOut = m_ptDoc->ReceiveNMEA (m_ptNmea, &m_ActTrackPt, &bValid, m_ptLogFile);

			if (bDemo)
				m_bTimeOut = (m_ptDoc->GetCnt() > MAX_DEMO_TRK_CNT);	// to abort demo after 50 steps

			if (m_bTimeOut)
				{
				if (m_ptNmea->Close())
					{ 
					CString szBuffer;
					short nStrID;

					if (bDemo)	nStrID = IDS_DEMO_MOVING_MAP;
						else	nStrID = (m_bTimeOut)? IDS_GPSTIMEOUT : IDS_GPSOK;

					szBuffer.LoadString (nStrID);
					AfxMessageBox (szBuffer);
					m_bRecording = FALSE;
		
					m_nPgRange = m_ptDoc->GetCnt()/10;
					this->DisableControl (ID_TRNEW, FALSE);
					this->DisableControl (ID_TROPEN, FALSE);
					this->DisableControl (ID_TRSTART, FALSE);
					this->DisableControl (IDCANCEL, FALSE);
					if (m_ptDoc->GetCnt() > m_nStartTrackCnt)
						{
						if (!bDemo)
							this->DisableControl (ID_TRSAVEAS, FALSE);
						this->DisableControl (ID_TRDOWN, FALSE);
						this->DisableControl (ID_TRPGUP, FALSE);
						m_bUpdate = TRUE;
						m_ptDoc->SetModifiedFlag(TRUE);
						}
					this->DisablePgUpDownCtrl (&m_nPosIndex);
					this->DisableControl (ID_TRSTOP, TRUE);
					}   
				
				if (m_ptNmea->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
				}
			else{  				// no time out
				if (bValid)
					{	     	// and data are valid
					m_nPosIndex = m_ptDoc->GetCnt() - 1;
					this->SetData (m_nPosIndex++); 
					}
                   					// timer start
				m_uTimer = SetTimer (GPS_TIMER, 1000, NULL);
				if (m_uTimer == 0)
					{   // 1 sec Timer  
					AfxMessageBox ("Bad Timer");
					this->PostMessage (WM_COMMAND, (WPARAM)IDCANCEL, (LPARAM)0);
					}
				}
			}				
		break;
	default:
		AfxMessageBox ("Unknown Timer in OnTimer");
		break;
	}
		
CDlgTool::OnTimer(nIDEvent);
}


/************************************************************************
 *  TrackDlg.cpp	 			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CTrackDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
