#if !defined(AFX_TRACKDLG_H__6F59B641_21A0_11D2_BFB4_C0BB368AEBD5__INCLUDED_)
#define AFX_TRACKDLG_H__6F59B641_21A0_11D2_BFB4_C0BB368AEBD5__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// TrackDlg.h : header file
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"
#include "TrackPt.h"
#include "Nmea.h"

/////////////////////////////////////////////////////////////////////////////
// CTrackDlg dialog

class CTrackDoc;
class CTrackDlg : public CDlgTool
{

// Construction
public:
	#define GPS_TIMER	2

	CTrackDlg(CWnd* pParent = NULL, CTrackDoc* ptDoc=NULL, CGpsDoc* ptGpsDoc=NULL);   // standard constructor
	CTrackDlg::~CTrackDlg();

// Dialog Data
	//{{AFX_DATA(CTrackDlg)
	enum { IDD = IDD_NMEATRACKREADBOX };
	CString	m_szTitle;
	CString	m_szLat;
	CString	m_szLon;
	CString	m_szAltDim;
	CString	m_szTime;
	CString	m_szSpeedDim;
	CString	m_szCnt;
	long	m_lAltitude;
	long	m_lSpeed;
	CString	m_szDistDim;
	long	m_lDist;
	//}}AFX_DATA


private:
	CTrackDoc*	m_ptDoc;
	CGpsDoc*	m_ptGpsDoc; 
	CNmea*		m_ptNmea;
	CTrackPoint	m_ActTrackPt;
 	BOOL		m_bTimeOut;
 
 	UINT		m_uTimer;
	CFile*		m_ptLogFile;

	BOOL m_bUpdate;
	BOOL m_bRecording;
	short m_nPosIndex;
	short m_nPgRange;
	short m_nStartTrackCnt;


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTrackDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

private:
	void SetDimensions ();
	BOOL DisablePgUpDownCtrl (short* ptPosIndex);
	void SetData (short i);
	BOOL InitReadNMEA (short nInpLen, short nOutLen);


// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CTrackDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnTrackOpen();
	afx_msg void OnTrackNew();
	afx_msg void OnTrackSaveAs();
	afx_msg void OnTrackStop();
	afx_msg void OnTrackStart();
	afx_msg void OnPageDown();
	afx_msg void OnLineDown();
	afx_msg void OnLineUp();
	afx_msg void OnPageUp();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKDLG_H__6F59B641_21A0_11D2_BFB4_C0BB368AEBD5__INCLUDED_)
