#if !defined(__TrackKmlDoc__)
#define __TrackKmlDoc__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceDoc.h : Header-Datei
//


#include "LatLon.h"						// DRECT
#include "TrackDoc.h"

#include "..\CPPTOOLS\XmlDocument.h"

/////////////////////////////////////////////////////////////////////////////
// Dokument CTrackKmlDoc 


class CTrackKmlDoc : public CXmlDocument
{
public:
	CTrackKmlDoc();


protected:
	           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CTrackKmlDoc)



// Attribute
private:	
	CString			m_szTrackName;

// Operationen
public:
	static CString GetExt();

	virtual void DeleteContents();
	BOOL ConvertToTrackDoc(CString szXMLSourceFile);
	BOOL ConvertFromTrackDoc(CTrackDoc* ptTrackDoc, CString szXMLDestFile);




// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CTrackKmlDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
	virtual void Serialize(CArchive& ar);   // berschrieben fr Dokument-Ein-/Ausgabe
	protected:
	//}}AFX_VIRTUAL

private:
	BOOL FileExists (CString szFileName);
	
	// to read *.klm
	BOOL CreateTrackPoint(CString szPosition, CTrackPoint* ptTrkPt, BOOL bStart);
	void ReadLineStyleNode(CXmlTag* ptNode);
	void ReadStyleNode(CXmlTag* ptNode);
	void ReadCoordinates(CXmlTag* ptNode, BOOL bStart, CTrackDoc* ptTrackDoc);
	void ReadLineStringNode(CXmlTag* ptNode, BOOL bStart, CTrackDoc* ptTrackDoc);
	void ReadPlacemarkNode(CXmlTag* ptNode);

	void GetFolderNodes(CXmlTag* ptParentNode);
	// called from ConvertToTrackDoc

	// to write *.klm

	CString CreateTrackpointTag(CTrackPoint* ptTrack);
	void CreateCoordinatesTag(CTrackDoc* ptTrackDoc, CXmlTag* ptCourseElem);
	unsigned int TrackDocumentToDOM(CTrackDoc* ptTrackDoc);
	// called from ConvertFromTrackDoc


// Implementierung
public:
	virtual ~CTrackKmlDoc();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


private:

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CTrackKmlDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Member-Funktionen ein und entfernt diese.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // __TrackKmlDoc__
