/************************************************************************
 *  						T r a c k P t . c p p	  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"  

#include "TrackPt.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CTrackPoint
IMPLEMENT_SERIAL(CTrackPoint, CObject, 0 /* schema number*/ )


/************************************************************************
 *  TrackPt.cpp    				C T r a c k P t			Constructor		*
 ************************************************************************/
CTrackPoint::CTrackPoint(LPTRACKPT lpTrackPt)
{ 
if (lpTrackPt == NULL)
	{       
	this->FirstInit();
	} 
else{
    this->ReadFromPtr (lpTrackPt);  
    }


}

/************************************************************************
 *  TrackPt.cpp    				C T r a c k P t			Copy-Constructor*
 ************************************************************************/
CTrackPoint::CTrackPoint(CTrackPoint& Source)
{ 
	_fmemcpy (&m_Lat, &Source.m_Lat, sizeof (TRACKKOORD));  
	_fmemcpy (&m_Lon, &Source.m_Lon, sizeof (TRACKKOORD));  
	m_lAlt		= Source.m_lAlt;
	m_lSpeed	= Source.m_lSpeed;
	m_lDist		= Source.m_lDist;
	_fmemcpy (&m_Time, &Source.m_Time, sizeof (TRACKTIME));  
	m_nTemp_C	= Source.m_nTemp_C;	
	m_cCadence	= Source.m_cCadence;	
	m_cHeartRate= Source.m_cHeartRate;
	m_cFlag		= Source.m_cFlag;
	m_cDummy	= Source.m_cDummy;
}

/************************************************************************
 *  TrackPt.cpp    		 	~ C T r a c k P t			Destructor		*
 ************************************************************************/
CTrackPoint::~CTrackPoint()
{
} 

/************************************************************************
 *  TrackPt.cpp					operator=								*
 ************************************************************************/
const CTrackPoint& CTrackPoint::operator=(const CTrackPoint& Source)
{
	_fmemcpy (&m_Lat, &Source.m_Lat, sizeof (TRACKKOORD));  
	_fmemcpy (&m_Lon, &Source.m_Lon, sizeof (TRACKKOORD));  
	m_lAlt		= Source.m_lAlt;
	m_lSpeed	= Source.m_lSpeed;
	m_lDist		= Source.m_lDist;
	_fmemcpy (&m_Time, &Source.m_Time, sizeof (TRACKTIME));  
	m_nTemp_C	= Source.m_nTemp_C;	
	m_cCadence	= Source.m_cCadence;	
	m_cHeartRate= Source.m_cHeartRate;
	m_cFlag		= Source.m_cFlag;
	m_cDummy	= Source.m_cDummy;
	
	return *this;
}

/************************************************************************
 *  TrackPt.cpp					F i r s t I n i t						*
 ************************************************************************/
void CTrackPoint::FirstInit ()
{
	_fmemset (&m_Lat, 0, sizeof (TRACKKOORD));  
	_fmemset (&m_Lon, 0, sizeof (TRACKKOORD));  
	m_Lat.uDegr = INVAL_DEGREE;
	m_Lon.uDegr = INVAL_DEGREE;

	m_lAlt		= INVAL_ALT;
	m_lSpeed	= INVAL_SPEED;
	m_lDist		= INVAL_DIST;
	_fmemset (&m_Time, 0, sizeof (TRACKTIME));  
	m_nTemp_C	= INVAL_TEMP;	
	m_cCadence	= INVAL_CADENCE;	
	m_cHeartRate= INVAL_HEARTRATE;
	m_cFlag		= 0;
	m_cDummy	= 0;
}

/************************************************************************
 *  TrackPt.cpp				R e a d F r o m P t r						*
 ************************************************************************/
void CTrackPoint::ReadFromPtr (LPTRACKPT lpTrackPt)
{
_fmemcpy (&m_Lat, &lpTrackPt->m_Lat, sizeof (TRACKKOORD));  
_fmemcpy (&m_Lon, &lpTrackPt->m_Lon, sizeof (TRACKKOORD));  
m_lAlt		= lpTrackPt->m_lAlt;
m_lSpeed	= lpTrackPt->m_lSpeed;
m_lDist		= lpTrackPt->m_lDist;
_fmemcpy (&m_Time, &lpTrackPt->m_Time, sizeof (TRACKTIME));  
m_nTemp_C	= lpTrackPt->m_nTemp_C;	
m_cCadence	= lpTrackPt->m_cCadence;	
m_cHeartRate= lpTrackPt->m_cHeartRate;
m_cFlag		= lpTrackPt->m_cFlag;
m_cDummy	= lpTrackPt->m_cDummy;
}

/************************************************************************
 *  TrackPt.cpp				W r i t e T o P t r 						*
 ************************************************************************/
void CTrackPoint::WriteToPtr (LPTRACKPT lpTrackPt) const
{
_fmemcpy (&lpTrackPt->m_Lat, &m_Lat, sizeof (TRACKKOORD));  
_fmemcpy (&lpTrackPt->m_Lon, &m_Lon, sizeof (TRACKKOORD));  
lpTrackPt->m_lAlt	= m_lAlt;
lpTrackPt->m_lSpeed	= m_lSpeed;
lpTrackPt->m_lDist	= m_lDist;
_fmemcpy (&lpTrackPt->m_Time, &m_Time, sizeof (TRACKTIME));  
lpTrackPt->m_nTemp_C	= m_nTemp_C;	
lpTrackPt->m_cCadence	= m_cCadence;	
lpTrackPt->m_cHeartRate = m_cHeartRate;
lpTrackPt->m_cFlag		= m_cFlag;
lpTrackPt->m_cDummy		= m_cDummy;
}

/************************************************************************
 *  TrackPt.cpp					G e t P t r 							*
 ************************************************************************/
void CTrackPoint::GetPtr(LPTRACKPT lpTrack)
{
this->WriteToPtr (lpTrack);
}  

/************************************************************************
 *  TrackPt.cpp					S e t P t r 							*
 ************************************************************************/
void CTrackPoint::SetPtr (LPTRACKPT lpTrack)
{
this->ReadFromPtr(lpTrack);
}  


/****************************************************************************
 *	TrackPt.cpp					D e g r e e T o D M S						*
 ****************************************************************************/
void CTrackPoint::DegreeToDMS (double fDegree, unsigned char* ptDegr, unsigned char* ptMin,
								unsigned char* ptSec, unsigned char* ptSign)
{
*ptSign = (unsigned char)((fDegree < 0)? 1 : 0);
if (*ptSign == 1) fDegree *= -1;

*ptDegr = (unsigned char)(int)fDegree;
*ptMin  = (unsigned char)(int)(60 * (fDegree - *ptDegr));
*ptSec  = (unsigned char)(int)(60 * ((60 * (fDegree - *ptDegr) - *ptMin)));
}

/****************************************************************************
 *	TrackPt.cpp					S e t L a t L o n							*
 ****************************************************************************/
void CTrackPoint::SetLatLon (double fLat, double fLon, BOOL bValid)
{
if (bValid)
	{
	this->DegreeToDMS (fLat,	&m_Lat.uDegr, 
								&m_Lat.uMin,
								&m_Lat.uSec,
								&m_Lat.uSign);
	
	this->DegreeToDMS (fLon,	&m_Lon.uDegr, 
								&m_Lon.uMin,
								&m_Lon.uSec,
								&m_Lon.uSign);
	}
else{
	m_Lat.uDegr = INVAL_DEGREE;
	m_Lon.uDegr = INVAL_DEGREE;
	}
}


/****************************************************************************
 *	TrackPt.cpp						S e t S p e e d							*
 ****************************************************************************/
void CTrackPoint::SetSpeed (double fGndSpeed, BOOL bValid)
{
if (bValid)
		m_lSpeed = (long)(fGndSpeed);
else	m_lSpeed = INVAL_SPEED;
}

/****************************************************************************
 *	TrackPt.cpp						S e t T i m e							*
 ****************************************************************************/
void CTrackPoint::SetTime (short nHour, short nMin, double fSec)
{
m_Time.uHour 	= (unsigned char)nHour;
m_Time.uMin		= (unsigned char)nMin;
m_Time.uSec		= (unsigned char)fSec;
m_Time.uDummy	= 0;
}

/****************************************************************************
 *	TrackPt.cpp						S e t T i m e							*
 ****************************************************************************/
void CTrackPoint::SetTime (unsigned long lSystemTime)
{
time_t	ltime;
struct	tm LogTime, *ptLogTime;

ltime = lSystemTime;
ptLogTime = &LogTime;
//ptLogTime = localtime (&ltime);		/* get actual date		*/
ptLogTime = gmtime(&ltime);

m_Time.uHour 	= (unsigned char)ptLogTime->tm_hour;
m_Time.uMin		= (unsigned char)ptLogTime->tm_min;
m_Time.uSec		= (unsigned char)ptLogTime->tm_sec;
m_Time.uDummy	= 0;
}


/****************************************************************************
 *	TrackPt.cpp						S e t A l t								*
 ****************************************************************************/
void CTrackPoint::SetAlt (long lAlt, BOOL bValid)
{
if (bValid)
		m_lAlt = lAlt;
else 	m_lAlt = INVAL_ALT;
}

/****************************************************************************
 *	TrackPt.cpp						S e t D i s t							*
 ****************************************************************************/
void CTrackPoint::SetDist (long lDist, BOOL bValid)
{
if (bValid)
		m_lDist = lDist;
else 	m_lDist = INVAL_DIST;
}

/****************************************************************************
 *	TrackPt.cpp						S e t T e m p _ C						*
 ****************************************************************************/
void CTrackPoint::SetTemp_C (double dTemp, BOOL bValid)
{
if (bValid)
		m_nTemp_C = (short)(dTemp*10);
else 	m_nTemp_C = INVAL_TEMP;
}

/****************************************************************************
 *	TrackPt.cpp						G e t T i m e							*
 ****************************************************************************/
void CTrackPoint::GetTime (short* ptHour, short* ptMin, short* ptSec)
{
*ptHour = m_Time.uHour;
*ptMin  = m_Time.uMin;
*ptSec  = m_Time.uSec;
}

/****************************************************************************
 *	TrackPt.cpp						G e t L a t								*
 ****************************************************************************/
BOOL CTrackPoint::GetLat (short* ptDegr, short* ptMin, short* ptSec, short* ptSign)
{
if (m_Lat.uDegr == INVAL_DEGREE)
	return FALSE;
	
*ptDegr = m_Lat.uDegr; 
*ptMin  = m_Lat.uMin;
*ptSec  = m_Lat.uSec;
*ptSign = m_Lat.uSign;

return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp						G e t L o n								*
 ****************************************************************************/
BOOL CTrackPoint::GetLon (short* ptDegr, short* ptMin, short* ptSec, short* ptSign)
{
if (m_Lon.uDegr == INVAL_DEGREE)
	return FALSE;

*ptDegr = m_Lon.uDegr; 
*ptMin  = m_Lon.uMin;
*ptSec  = m_Lon.uSec;
*ptSign = m_Lon.uSign;

return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp					G e t L a t L o n							*
 ****************************************************************************/
BOOL CTrackPoint::GetLatLon (double* ptLat, double* ptLon)
{
if ((m_Lat.uDegr == INVAL_DEGREE) ||
	(m_Lon.uDegr == INVAL_DEGREE) )
	return FALSE;
	
*ptLat = m_Lat.uDegr +
		(double)m_Lat.uMin/60 +
		(double)m_Lat.uSec/3600;
if  (m_Lat.uSign == 1)
	*ptLat *= -1;


*ptLon = m_Lon.uDegr +
		(double)m_Lon.uMin/60 +
		(double)m_Lon.uSec/3600;
if (m_Lon.uSign == 1)
	*ptLon *= -1;
	
return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp						G e t S e c								*
 ****************************************************************************/
long CTrackPoint::GetSec()
{
long	lSec;
short	nHour, nMin, nSec;

nHour = m_Time.uHour;
nMin  = m_Time.uMin;
nSec  = m_Time.uSec;
lSec = (long)nHour*3600 + nMin*60 + nSec;
return lSec;
}

/****************************************************************************
 *	TrackPt.cpp						G e t S p e e d							*
 ****************************************************************************/
BOOL CTrackPoint::GetSpeed (short* ptSpeed)
{
if (m_lSpeed == INVAL_SPEED)
	return FALSE;
	
*ptSpeed = (short)m_lSpeed;

return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp						G e t A l t								*
 ****************************************************************************/
BOOL CTrackPoint::GetAlt (long* ptAlt)
{
	if (m_lAlt == INVAL_ALT)
		return FALSE;
		
	*ptAlt = m_lAlt;

	return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp						G e t D i s t 							*
 ****************************************************************************/
BOOL CTrackPoint::GetDist (long* ptAlt)
{
	if (m_lDist == INVAL_ALT)
		return FALSE;
		
	*ptAlt = m_lDist;

	return TRUE;
}

/****************************************************************************
 *	TrackPt.cpp						G e t T e m p _ C						*
 ****************************************************************************/
BOOL CTrackPoint::GetTemp_C (double* ptTemp_C)
{
	if (m_nTemp_C == INVAL_TEMP)
		return FALSE;
		
	*ptTemp_C = (m_nTemp_C+5)/10;

	return TRUE;
}

/************************************************************************
 *  TrackPt.cpp    	 		S e t F l a g B i t							*
 ************************************************************************/
void CTrackPoint::SetFlagBit (unsigned char FAR* lpFlag, short BitMask, BOOL bSet)
{					/* BitMask: 1, 2, 4, 8, 16, ...	*/
	if (bSet)   *lpFlag = *lpFlag | (unsigned char)BitMask;
		else    *lpFlag = *lpFlag & (unsigned char)(~BitMask);	/* ALT 126: ~	*/
}

/************************************************************************
 *  TrackPt.cpp    		 	S e t S t a r t				 				*
 ************************************************************************/
void CTrackPoint::SetStart(BOOL bStart)
{   
	SetFlagBit (&m_cFlag, TKP_START, bStart);
}

/************************************************************************
 *  TrackPt.cpp    		 	I s S t a r t								*
 ************************************************************************/
BOOL CTrackPoint::IsStart(void)
{ 
	BOOL bStart = ((m_cFlag & TKP_START) == TKP_START);
	return bStart;
}

/************************************************************************
 *  TrackPt.cpp    		 		C r e a t e P t r 						*
 ************************************************************************/
LPTRACKPT CTrackPoint::CreatePtr ()
{
LPTRACKPT lpTrackPt = new TRACKTYPE;

_fmemset (lpTrackPt, 0, sizeof (TRACKTYPE));

this->WriteToPtr (lpTrackPt);

return lpTrackPt;
}


/************************************************************************
 *  TrackPt.cpp    		 		 S e r i a l i z e						*
 ************************************************************************/
void CTrackPoint::Serialize(CArchive& ar, short nVersion)
{ 
	if (ar.IsStoring())
	{		// TODO: add storing code here 
		ar.Write (&m_Lat, sizeof (TRACKKOORD)); 
		ar.Write (&m_Lon, sizeof (TRACKKOORD)); 
		ar << m_lAlt;	
		ar << m_lSpeed;	
		ar << m_lDist;
		ar.Write (&m_Time, sizeof (TRACKTIME)); 
		ar << m_nTemp_C;
	    ar << (BYTE)m_cCadence;
	    ar << (BYTE)m_cHeartRate;
		ar << (BYTE)m_cFlag;  		
		ar << (BYTE)m_cDummy;  		
	}
	else
	{       // TODO: add loading code here    
		BYTE Byte;

		if (nVersion == 1)
		{
			short nAlt, nSpeed;

			ar.Read (&m_Lat, sizeof (TRACKKOORD)); 
			ar.Read (&m_Lon, sizeof (TRACKKOORD)); 
			ar >> nAlt;	
			ar >> nSpeed;	
			ar.Read (&m_Time, sizeof (TRACKTIME)); 

			// convert to version 2:

			m_lAlt		= INVAL_ALT;
			m_lSpeed	= INVAL_SPEED;
			m_lDist		= INVAL_DIST;
			m_nTemp_C	= INVAL_TEMP;	
			m_cCadence	= INVAL_CADENCE;	
			m_cHeartRate= INVAL_HEARTRATE;
			m_cFlag		= 0;
			m_cDummy	= 0;

			if (nAlt != INVAL_ALT)
				m_lAlt = (long)nAlt;
			
			if (nSpeed != INVAL_SPEED)
				m_lSpeed = (long)(nSpeed+5)/10;
		}

		if (nVersion == 2)
		{
			ar.Read (&m_Lat, sizeof (TRACKKOORD)); 
			ar.Read (&m_Lon, sizeof (TRACKKOORD)); 
			ar >> m_lAlt;	
			ar >> m_lSpeed;	
			ar >> m_lDist;	
			ar.Read (&m_Time, sizeof (TRACKTIME)); 
			ar >> m_nTemp_C;	
			ar >> Byte;		m_cCadence = (unsigned char)Byte; 
			ar >> Byte;		m_cHeartRate = (unsigned char)Byte;
			ar >> Byte;		m_cFlag = (unsigned char)Byte;
			ar >> Byte;		m_cDummy = (unsigned char)Byte;
		}
	}
} 
  
/////////////////////////////////////////////////////////////////////////////
// CTrackPoint commands
