#ifndef __TRACKPT__      
#define __TRACKPT__

// TrackPt.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define INVAL_DEGREE	200
#define INVAL_ALT		(-30000)
#define INVAL_SPEED		(-30000)
#define INVAL_DIST		(-1)
#define INVAL_TEMP		1000
#define INVAL_CADENCE	255
#define INVAL_HEARTRATE	0

//#define VERS_SIZE		12


typedef struct 
		{
		unsigned char	uDegr;		
		unsigned char	uMin;
		unsigned char	uSec;
		unsigned char	uSign;			// 1: for negative value: South Lat, West Lon
		} TRACKKOORD;

typedef struct 
		{
		unsigned char	uHour;			// 0 ... 23	UTC
		unsigned char 	uMin;			// 0 ... 59
		unsigned char	uSec;			// 0 ... 59
		unsigned char	uDummy;
		} TRACKTIME;


typedef struct 
		{
		TRACKKOORD	m_Lat;
		TRACKKOORD	m_Lon;
		short		m_nAlt;			// altitude in TRACKHEADER.nAltDim
		short		m_nSpeed;		// ground speed TRACKHEADER.nSpdDim
		TRACKTIME	m_Time;
		} TRACKTYPE1;
typedef TRACKTYPE1 FAR* LPTRACKPT1;


typedef struct 
		{
		TRACKKOORD	m_Lat;
		TRACKKOORD	m_Lon;
		long		m_lAlt;			// altitude in TRACKHEADER.nAltDim
		long		m_lSpeed;		// ground speed in TRACKHEADER.nSpdDim
		long		m_lDist;		// distance travelled from first point in TRACKHEADER.nDistDim
		TRACKTIME	m_Time;
		short		m_nTemp_C;		// temp in degrees C
		BYTE		m_cCadence;		// revolutions per minute
		BYTE		m_cHeartRate;	// beats per minute
		BYTE		m_cFlag;		// TKP_START:1 
		BYTE		m_cDummy;
		} TRACKTYPE;
typedef TRACKTYPE FAR* LPTRACKPT;


#define TKP_START	 	1
#define TKP_XXX2		2
#define TKP_XXX4		4

#define ACT_TRACK_VERS	2  


class CTrackPoint : public CObject
{
DECLARE_SERIAL(CTrackPoint)

// Attributes
private:    


// Operations
protected:
	TRACKKOORD	m_Lat;
	TRACKKOORD	m_Lon;
	long		m_lAlt;		// altitude in TRACKHEADER.nAltDim
	long		m_lSpeed;	// ground speed TRACKHEADER.nSpdDim
	long		m_lDist;	// distance to previous point in TRACKHEADER.nDistDim
	TRACKTIME	m_Time;
	short		m_nTemp_C;	
	BYTE		m_cCadence;	
	BYTE		m_cHeartRate;
	BYTE		m_cFlag;		/* TKP_START:1 */
	BYTE		m_cDummy;


// Implementation
public:
	CTrackPoint(LPTRACKPT lpTrackPt=NULL);		
	CTrackPoint(CTrackPoint& Source);
	~CTrackPoint();        

	const CTrackPoint& operator=(const CTrackPoint& Source);                                        
	LPTRACKPT CreatePtr ();

	void FirstInit ();
	void GetPtr(LPTRACKPT lpTrack);
	void SetPtr (LPTRACKPT lpTrack);

	void DegreeToDMS (double fDegree, unsigned char* ptDegr, unsigned char* ptMin,
								unsigned char* ptSec, unsigned char* ptSign);
	void SetLatLon (double fLat, double fLon, BOOL bValid);
	void SetSpeed (double fGndSpeed, BOOL bValid);
	void SetTime (unsigned long lWindowsTime);
	void SetTime (short nHour, short nMin, double fSec);
	void SetAlt (long lAlt, BOOL bValid);
	void SetDist (long lDist, BOOL bValid);
	void SetHours (unsigned char uHour) { m_Time.uHour = uHour; }
	void SetTemp_C (double dTemp, BOOL bValid);
	void SetCadence(BYTE nCadence) { m_cCadence = nCadence; }	
	void SetHeartRate(BYTE nHeartRate) { m_cHeartRate = nHeartRate; }	

	void GetTime (short* ptHour, short* ptMin, short* ptSec);
	BOOL GetLat (short* ptDegr, short* ptMin, short* ptSec, short* ptSign);
	BOOL GetLon (short* ptDegr, short* ptMin, short* ptSec, short* ptSign);
	BOOL GetLatLon (double* ptLat, double* ptLon);
	BOOL GetSpeed (short* ptSpeed);
	BOOL GetAlt (long* ptAlt);
	BOOL GetDist (long* ptDist);
	BOOL GetTemp_C (double* ptTemp_C);
	void SetStart(BOOL bStart);
	BOOL IsStart(void);

	unsigned char GetHours() { return m_Time.uHour; }
	long GetSec();

	short GetTemp_C() { return m_nTemp_C; }	
	BYTE GetCadence() { return m_cCadence;}
	BYTE GetHeartRate() { return m_cHeartRate; }

	void Serialize(CArchive& ar, short nVersion);


private:
	void SetFlagBit (unsigned char FAR* lpFlag, short BitMask, BOOL bSet);
	void ReadFromPtr (LPTRACKPT lpTrackPt);
	void WriteToPtr (LPTRACKPT lpTrackPt) const;


};
#endif 

