#ifndef __TRACKDOC__
#define __TRACKDOC__

// TrackDoc.h : interface of the CTrackDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "TrackPt.h"
#include "Nmea.h"

#define MAX_DEMO_TRK_CNT	50

#define VERS_SIZE		12
typedef struct 
		{
		char	szVersion[VERS_SIZE];	// nAltDim:	#define DIM_FEET    1
		short	nDummy;					// 			#define DIM_METER   3
		short	nDistDim;				//			#define DIM_KM	    4
		short	nAltDim;				// nSpdDim: #define DIM_KMH     9
		short	nSpdDim;				// 			#define DIM_MPH     10
		} TRACKHEADER;				



short TimeScaleTextX (double dXval, double dXGrid, CString* ptScale);
short GetTextWidth(CDC* pDC, CString szText);


class CBorder;
class CTrackDoc : public CDocument
{
private:
	#define MAX_HEADER_SIZE 20
    
    TRACKHEADER		m_Header;     

	CPtrArray		m_TrackPts;
	BOOL			m_bConverted;

	short			m_nSimulateCnt;
	BOOL			m_bDebug;

protected: // create from serialization only
	DECLARE_DYNCREATE(CTrackDoc)

// Attributes
public:
// Operations
public:
	CTrackDoc& operator =(const CTrackDoc& doc);

	void SetDimensions (short nAltDim, short nSpdDim, short nDistDim = DIM_METER);
	void GetTimeRange (short* ptGridX, long* ptMinX, long* ptMaxX);
	void SetName (CString szName);
	void SetName (unsigned long lSystemTime);
	void GetMapBorder (CBorder* ptBorder);
	void GetAltMapBorders (long* ptMinX, long* ptMaxX, 
					long* ptMinY, long* ptMaxY, 
					short* ptGridX, short* ptGridY);									 
	void GetSpeedMapBorders (long* ptMinX, long* ptMaxX, 
					short* ptMinY, short* ptMaxY, 
					short* ptGridX, short* ptGridY);

	CString GetSpeedString (short nIndex, short nDestSpeedDim);
	BOOL GetAltitude (short nIndex, short nDestAltDim, long* ptAlt);
	CString GetAltitudeString (short nIndex, short nDestAltDim);

	double AverageAngle (double Angle1, double Angle2);
	BOOL TrackNeedsLabel(short i, short nTimeGrid, long* ptLabelTime);
	BOOL GetCourse (double* ptCourse);
	double LabelDirection (short i, BOOL* ptRightAlign);

	void Filter ();

	short GetTimedIndex (short nMaxMinutes);
	void SetSimulateCnt(short nCnt);
	short GetCnt ();
	LPTRACKPT GetTrackPointPtr (short nIndex);
	BOOL GetTrackPointPtr (short nIndex, CTrackPoint* ptTrackPt);

	short GetSpeedDim (){return m_Header.nSpdDim;}
	short GetAltDim (){return m_Header.nAltDim;}
	short GetDistDim (){return m_Header.nDistDim;}

	void SetDebug(BOOL bDebug) { m_bDebug = bDebug; }
	BOOL IsDebug() { return m_bDebug; }

	BOOL ReceiveNMEA (CNmea* ptNmea, CTrackPoint* ptActTrackPt, BOOL* ptValid, CFile* ptFile);
	BOOL Change(CWnd* ptWnd);
	BOOL Open(CWnd* ptWnd);
	BOOL SaveAs(CWnd* ptWnd, BOOL bConfirm = FALSE);
	BOOL ReadFromGPS(CWnd* ptWnd);

// Implementation
public:
	CTrackDoc();
	virtual ~CTrackDoc();
	BOOL AppendWpt (CTrackPoint TrackPt);
	BOOL ChangeWpt (short nIndex, CTrackPoint TrackPt);
	BOOL DeleteWpt (short nIndex);
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o


private:
	void Init();
	void DeleteArrayOf (CPtrArray* ptArray);
	void VersToHeader (char* ptHeader, short nVersion);
	short HeaderToVers (char* ptHeader);
	BOOL CalcTotalDist(CTrackPoint& actTrkPt, CLatLon& llPrev, double* ptLastDist);



#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

public:
	BOOL InLegalArea();
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName);

	BOOL WriteToKML(CWnd* ptWnd);

// Generated message map functions
protected:
	//{{AFX_MSG(CTrackDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
