// TrackVw.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"			// fabs
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"

#include "WayDoc.h"		// for GetWayDocument in DrawMvMpRteOnMap
#include "TrackDoc.h"
#include "TrackVw.h"    

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CMetDoc*			ptMet;
extern CPlaneDoc*		ptPlaneDoc;

extern CTrackDoc*		ptTrackDoc;

/////////////////////////////////////////////////////////////////////////////
// CTrackView

IMPLEMENT_DYNCREATE(CTrackView, CMapView)

BEGIN_MESSAGE_MAP(CTrackView, CMapView)
	//{{AFX_MSG_MAP(CTrackView)
	ON_COMMAND(ID_MP_ROUTE          , OnMenuRoute)
	ON_COMMAND(ID_MP_FOTO           , OnMenuFoto)
	ON_COMMAND(ID_ME_LABEL		    , OnMenuLABEL)
	ON_UPDATE_COMMAND_UI(ID_ME_LABEL, OnUpdateLabel)
	//}}AFX_MSG_MAP
	// Standard printing commands
END_MESSAGE_MAP()


CTrackView::CTrackView()
{
m_ptColor = ptInit->GetColorPtr();
m_ptMapDoc = ptInit->GetMapDocPtr();
}

CTrackView::~CTrackView()
{
}

/************************************************************************
 *  TrackVw.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CTrackView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CTrackDoc* ptTrackDoc = GetDocument();

if (ptTrackDoc != NULL)
	{	        		 
	ptTrackDoc->GetMapBorder (&m_Border);
	this->ResetScroll ();

	CMapView::SetMapTitle (ptTrackDoc->GetTitle());
	CMapView::OnUpdate (pSender, lHint, pHint);
	}
}


void CTrackView::OnSize(UINT nType, int cx, int cy) 
{
CMapView::OnSize(nType, cx, cy);

	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen

}


/////////////////////////////////////////////////////////////////////////////
// Zeichnung CTrackView 


/****************************************************************************
 *	CTrackView.c			C h a n g e M a p S i d e  						*
 ****************************************************************************/
void CTrackView::ChangeMapSide (CDC* pDC, long LPx0, long LPy0, 
									double dWptLat, double dWptLon)
{
if (fabs (dWptLon) > 180.)
	{								/* world surrounded				*/
	long LPx1, LPy1;
	int X1_Border, X2_Border, Y_Border;
	float Stg;
	
									/* get LP of next locus			*/
	m_ptMercator->XYtoLP (dWptLon, dWptLat, &LPx1, &LPy1);

						// get LP of virtual map border
	long lRightLP, lLeftLP, lDummy;
	m_ptMercator->XYtoLP (-180, 0., &lLeftLP, &lDummy);
	m_ptMercator->XYtoLP ( 180, 0., &lRightLP, &lDummy);
	X1_Border = (dWptLon > 180.)? lRightLP : lLeftLP;
	X2_Border = (dWptLon > 180.)? lLeftLP : lRightLP;

	if (LPx0 == LPx1) Stg = (float)0;		/* Y_Border = LPy0		*/
		else	Stg = (float)(LPy1-LPy0) / (LPx1-LPx0);
		
	Y_Border = (int)(Stg * (X1_Border-LPx0) + LPy0);
	pDC->LineTo (X1_Border, Y_Border);	/* zum Rand				*/
	pDC->MoveTo (X2_Border, Y_Border);	/* Seitenwechsel		*/
	}
}

/****************************************************************************
 *	CRouteView.c				D r a w M v M p R t e O n M a p				*
 ****************************************************************************/
void CTrackView::DrawMvMpRteOnMap (CDC* pDC, BOOL bAntipod)
{
	CWayDoc* ptWayDoc = GetWayDocument();
	ASSERT_VALID(ptWayDoc);

	// TODO: add draw code for native data here            
int	CharX, LineY;

CFont NewFont; 
CreateNewFont(&NewFont);
CFont* ptOldFont = this->ChangeFont (pDC, &NewFont, &CharX, &LineY); 

if (ptWayDoc != NULL)
	{
	short i;
	long LPx0, LPy0, LPx1, LPy1;				
	double dLon0, dLon1, Way0Lon;

	dLon0 = Way0Lon = 0.;

	m_ptMercator->Clip(TRUE);			/* draw on map only		*/

	for (i=0; i<ptWayDoc->GetWayPointCnt(); i++)
		{
		CWayPoint WayPt;
		if (ptWayDoc->GetWayPointPtr (i, &WayPt))
			{
			CLatLon LLact(WayPt.GetLat(), WayPt.GetLon());	// for RteCriticalLeg

			if (i==0)
				{
				dLon1 = WayPt.GetLon();		
				}
			else{
				dLon1 = dLon0 + m_Border.FlightAngle (Way0Lon, WayPt.GetLon());
				if (bAntipod)
					{
					if (fabs (dLon1) > 180.)
						{				/* world surrounded			*/
						CPoint pLeaveSideLP, pEnterSideLP;
										// use CMapView::ChangeMapSide for Rte 
						CMapView::ChangeMapSide (pDC, LPx1, LPy1, 
									WayPt.GetLat(), dLon1, 	 // wpt outside
									&pLeaveSideLP, &pEnterSideLP);

						m_ptColor->DrawMvMpLeg (pDC, LPx1, LPy1, 
								pLeaveSideLP.x, pLeaveSideLP.y);

						LPx0 = pEnterSideLP.x;
						LPy0 = pEnterSideLP.y;
						}
					dLon1 = WayPt.GetLon();
					}
				}
				
			m_ptMercator->XYtoLP (dLon1, WayPt.GetLat(), &LPx1, &LPy1);
			
			if (i==0)
				{
				pDC->MoveTo (LPx1, LPy1);  // for DrawLabel
				}
			else{
				m_ptColor->DrawMvMpLeg (pDC, LPx0, LPy0, LPx1, LPy1); 
				}


			Way0Lon = WayPt.GetLon();
			dLon0 = dLon1;					

			LPx0 = LPx1;
			LPy0 = LPy1;
			}
		}

	m_ptMercator->Clip(FALSE);
	}	

pDC->SelectObject (ptOldFont);
NewFont.DeleteObject ();
}



/****************************************************************************
 *	TrackVw.c					D r a w O n M a p	 						*
 ****************************************************************************/
void CTrackView::DrawOnMap (CDC* pDC, BOOL bAntipod)
{
	CTrackDoc* ptTrackDoc = GetDocument();
	ASSERT_VALID(ptTrackDoc);

	// TODO: add draw code for native data here            
int	CharX, LineY;
short	nNameSizeLP, nTimeGrid;
long	lTimeMin, lTimeMax, lLabelTime;
CString	szTime;

CFont NewFont; 
CreateNewFont(&NewFont);
CFont* ptOldFont = this->ChangeFont (pDC, &NewFont, &CharX, &LineY); 

ptTrackDoc->GetTimeRange (&nTimeGrid, &lTimeMin, &lTimeMax);
TimeScaleTextX ((double)0, (double)nTimeGrid, &szTime);  
nNameSizeLP = GetTextWidth(pDC, szTime);
  
lLabelTime = lTimeMin;

this->DrawMvMpRteOnMap (pDC, bAntipod);

if (ptTrackDoc != NULL)
	{
	short i;
	long LPx1, LPy1;
	double fTrackLat, fTrackLon;				
	double dLon0, dLon1, Track0Lon;
	short	nStartIndex = 0;

	dLon0 = Track0Lon = 0.;

			 
	if (m_ptMapDoc->IsActivated (SHOW_MAP))	  // use disabled color
		 m_ptColor->SelectDisabledRoutePen (pDC, TRUE);
	else m_ptColor->SelectRoutePen (pDC, TRUE);


	CMovingMapDoc* ptMovingMap = ptInit->GetMovingMapDocPtr();
	if (ptMovingMap != NULL)
		{					// get first track index to draw
		TrackSymbol Symbol = TRACK_LINE;
		
		if (ptMovingMap->IsOnView())
			Symbol = ptMovingMap->GetTrackSymbol();

		switch (Symbol)
			{
			case TRACK_OFF:	 nStartIndex=ptTrackDoc->GetCnt()-1; break;
			case TRACK_LINE: nStartIndex=0; break;
			case TRACK_TAIL: nStartIndex=ptTrackDoc->GetTimedIndex (5); break;
			}
		}


	for (i=nStartIndex; i<ptTrackDoc->GetCnt(); i++)
		{
		BOOL bFirst = (i==nStartIndex);

		CTrackPoint TrackPt;
		if (ptTrackDoc->GetTrackPointPtr (i, &TrackPt))
			{
			m_ptMercator->Clip(TRUE);			/* draw on map only		*/
			
			TrackPt.GetLatLon (&fTrackLat, &fTrackLon);
			if (TrackPt.IsStart())
				bFirst = TRUE;

			if (bFirst)
				{
				dLon1 = fTrackLon;		
				}
			else{
				dLon1 = dLon0 + m_Border.FlightAngle (Track0Lon, fTrackLon);
				if (bAntipod)
					{
					ChangeMapSide (pDC, LPx1, LPy1, fTrackLat, dLon1);
					dLon1 = fTrackLon;
					}
				}
				
			m_ptMercator->XYtoLP (dLon1, fTrackLat, &LPx1, &LPy1);
			
			if (bFirst)	pDC->MoveTo (LPx1, LPy1);
				else	pDC->LineTo (LPx1, LPy1);

			Track0Lon = fTrackLon;
			dLon0 = dLon1;									/* Kartenpunkt			*/

			m_ptMercator->Clip(FALSE);
			}


		if (m_ptMapDoc->IsActivated(SHOW_LABEL))
			{												/* name of waypoint		*/
			if (ptTrackDoc->TrackNeedsLabel(i, nTimeGrid, &lLabelTime))		
				{
				double TextAngle;
				CTrackPoint TrackPt;
				BOOL	 bRightAlign;  
 				long	lSec;
				
				TextAngle = ptTrackDoc->LabelDirection (i, &bRightAlign);
				
				if (ptTrackDoc->GetTrackPointPtr (i, &TrackPt))
					{
					lSec = TrackPt.GetSec();
					TimeScaleTextX ((double)lSec, (double)nTimeGrid, &szTime);
					m_ptMercator->DrawLabel (LPx1, LPy1, TextAngle,
						LineY, bRightAlign, szTime, nNameSizeLP);
					}
				}
			}
		}


	if (ptMovingMap != NULL && i>0)	// LPx1 and LPy1 should be defined!!
		ptMovingMap->DrawActPosSymbol(pDC, LPx1, LPy1);

	m_ptColor->SelectRoutePen (pDC, FALSE);

	}	
pDC->SelectObject (ptOldFont);
NewFont.DeleteObject ();
}

/****************************************************************************
 *	CTrackView.c				S h o w F u l l R o u t e 					*
 ****************************************************************************/
void CTrackView::ShowFullRoute ()
{
this->OnMenuRoute();
}


/****************************************************************************
 *	CTrackView.c			O n M e n u R o u t e 							*
 ****************************************************************************/
void CTrackView::OnMenuRoute() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
CTrackDoc* ptTrackDoc = GetDocument();
ASSERT_VALID(ptTrackDoc);  

if (ptTrackDoc != NULL)
	{	        
	ptTrackDoc->GetMapBorder (&m_Border);
	this->ResetScroll ();

	this->Invalidate(FALSE);
	}
}



/****************************************************************************
 *	TrackVw.cpp				O n M e n u F o t o 							*
 ****************************************************************************/
void CTrackView::OnMenuFoto() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	CImage* ptImage = this->GetImagePtr();
	if (ptImage != NULL)
	{								// set name to save generated image
		CString szFileName;
		szFileName = ptImage->SaveAsDlg (this, "Aufzeichnung", "Track");	
		if (szFileName.GetLength() > 0)
			this->SaveImage();
	}
}


/****************************************************************************
 *	CTrackView.c			O n M e n u L A B E L 							*
 ****************************************************************************/
void CTrackView::OnMenuLABEL() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
m_ptMapDoc->InvertActivateState(SHOW_LABEL);
this->Invalidate(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// Diagnose CTrackView

#ifdef _DEBUG
void CTrackView::AssertValid() const
{
	CMapView::AssertValid();
}

void CTrackView::Dump(CDumpContext& dc) const
{
	CMapView::Dump(dc);
}

CWayDoc* CTrackView::GetWayDocument() // non-debug version is inline
{									// for DrawMvMpRteOnMap
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}

#endif //_DEBUG

CTrackDoc* CTrackView::GetDocument() // non-debug version is inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackDoc)));
//	return (CTrackDoc*)m_pDocument;
return ptTrackDoc;
}

void CTrackView::OnUpdateLabel(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
pCmdUI->SetCheck (m_ptMapDoc->IsActivated(SHOW_LABEL));	
}
