#ifndef __TRACKVIEW__
#define __TRACKVIEW__

// TrackVw.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "MapView.h"

class CTrackDoc;
class CTrackView : public CMapView
{
public:
	CTrackView();           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CTrackView)

	CColorDoc* 	m_ptColor;
	CMapDoc*	m_ptMapDoc;
// Attribute

public:
	void ShowFullRoute ();

// Operationen
protected:
	void DrawOnMap (CDC* pDC, BOOL bAntipod);

	CTrackDoc* GetDocument();
	CWayDoc* GetWayDocument();

private:
	void DrawMvMpRteOnMap (CDC* pDC, BOOL bAntipod);
	void ChangeMapSide (CDC* pDC, long LPx0, long LPy0, double dWptLat, double dWptLon);

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CTrackView)
	public:
	//}}AFX_VIRTUAL

// Implementierung
protected:
	virtual ~CTrackView();
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CTrackView)
	afx_msg void OnMenuRoute();
	afx_msg void OnMenuFoto();
	afx_msg void OnMenuLABEL();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnUpdateLabel(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#ifndef _DEBUG  // debug version in TrackVw.cpp
inline CWayDoc* CTrackView::GetWayDocument()		// for DrawMvMpRteOnMap
   { return (CWayDoc*)m_pDocument; }
#endif


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // __TRACKVIEW__
