// USB_Test.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include "USB_Test.h"

#include "USB.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Das einzige Anwendungsobjekt
// http://www.alanmacek.com/usb/index.html
// http://www.alanmacek.com/usb/hostcode.html
// http://www.lvr.com/usb.htm
// http://www.lvr.com/hidpage.htm

CWinApp theApp;

using namespace std;

// for testing USB

//    #include <windows.h>
//#include <setupapi.h>
//#include "inc\setupapi.h"

extern "C" {
#include "inc\hidsdi.h"
#include "inc\setupapi.h"
}

// to use C-Function of HID.DLL:
//	extern "C" { void __stdcall HidD_GetHidGuid(GUID* ptGuid); }
//  HidD_GetHidGuid (&HidGuid);		// ergibt: {4D1E55B2-F16F-11CF-88CB-001111000030}

// to read from USB:
#include <winioctl.h>

#define IOCTL_ASYNC_IN        CTL_CODE (FILE_DEVICE_UNKNOWN, 0x850, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_USB_PACKET_SIZE CTL_CODE (FILE_DEVICE_UNKNOWN, 0x851, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define MAX_BUFFER_SIZE 4096
#define ASYNC_DATA_SIZE 64
DWORD gUSBPacketSize;

//-----------------------------------------------------------------------------
#pragma pack( push, 1)
typedef struct
    {
    unsigned char  mPacketType;
    unsigned char  mReserved1;
    unsigned short mReserved2;
    unsigned short mPacketId;
    unsigned short mReserved3;
    unsigned long  mDataSize;
    BYTE           mData[1];
    } Packet_t;
#pragma pack( pop)



HANDLE ReadHandle;
HANDLE WriteHandle;
char Buffer[2000];						// A screen full of characters
int BufferIndex;						// A pointer into Buffer


	void CheckError(DWORD dwError)
	{
	  if( dwError != 0 )
	  {
		char msg[256];
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError, 0, msg, 256, NULL );
		cout << msg;
	  }

	}

	void CheckWin32Error()
	{
	  DWORD errCode = GetLastError(); 
	  CheckError(errCode);
	}



// HKEY_LOCAL_MACHINE\System\CurrentControlSet\control\DeviceClasses

/********************************************************************************************
 *								E n u m e r a t e A l l D e v i c e s						*
 ********************************************************************************************/
void EnumerateAllDevices()
{
        HDEVINFO hDeviceInfoSet;
        
		cout << endl << endl << "EnumerateAllDevices" << endl;
//HKEY_LOCAL_MACHINE\System\CurrentControlSet\control\DeviceClasses\{}
//CString szTestGuid("{6994ad05-93ef-11d0-a3cc-00a0c9223196}");
CString szTestGuid("{65E8773D-8F56-11D0-A3B9-00A0C9223196}");

//CString szTestGuid("{4D1E55B2-F16F-11CF-88CB-001111000030}");		// funktioniert mit JoyStick!!
GUID testGuid;
CUsb::GetHidGuid(szTestGuid, &testGuid);

		DWORD dwFlags = DIGCF_ALLCLASSES;
		dwFlags = DIGCF_DEVICEINTERFACE;
//        hDeviceInfoSet = SetupDiGetClassDevs(&testGuid,"MEDIA",0,dwFlags);		// funktioniert mit JoyStick
        hDeviceInfoSet = SetupDiGetClassDevs(&testGuid,"Image",0,dwFlags);
        
        if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
        {
			CheckWin32Error();
            cout << "Unable to enumerate USB device" << endl;
            return ;
        }
    
        for (DWORD idx=0;;idx++)
        {
            SP_DEVINFO_DATA  devinfo;
            devinfo.cbSize = sizeof(devinfo);
        
            if (!SetupDiEnumDeviceInfo(hDeviceInfoSet,idx,&devinfo))
            {
                if (GetLastError() != ERROR_NO_MORE_ITEMS)
                {
                    cout << "Error while enumerating USB devices" << endl;
                }
                break;
            }
    
			CUsbDevice* ptDevice = new CUsbDevice();
			if (ptDevice != NULL)
			{
				cout << "--------------- " << idx << " --------------------" << endl;
				ptDevice->SetProperties(hDeviceInfoSet, &devinfo);
				delete ptDevice;
			}

            //    and here goes the code that lits the usb device found in the box
        }
    
        SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
    }    




/********************************************************************************************
 *								E n u m e r a t e U S B D e v i c e s						*
 ********************************************************************************************/
short EnumerateUSBDevices(BOOL bPresentOnly)
{
		short nDeviceCnt = 0;

		HDEVINFO hDeviceInfoSet;
 
		cout << endl << endl << "EnumerateUSBDevices" << endl;

		DWORD dwFlags = DIGCF_ALLCLASSES;
		if (bPresentOnly)
			dwFlags |= DIGCF_PRESENT;

        hDeviceInfoSet = SetupDiGetClassDevs(0,"USB",0,dwFlags);
        
        if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
        {
            cout << "Unable to enumerate USB device" << endl;
            return nDeviceCnt;
        }
    

        for (DWORD idx=0;;idx++)
        {
            SP_DEVINFO_DATA  devinfo;
            devinfo.cbSize = sizeof(devinfo);
 
            if (!SetupDiEnumDeviceInfo(hDeviceInfoSet,idx,&devinfo))
            {
                if (GetLastError() != ERROR_NO_MORE_ITEMS)
                {
                    cout << "Error while enumerating USB devices" << endl;
                }
                break;
            }
    

			nDeviceCnt++;

			CUsbDevice* ptDevice = new CUsbDevice();
			if (ptDevice != NULL)
			{
				cout << "--------------- " << idx << " --------------------" << endl;
				ptDevice->SetProperties(hDeviceInfoSet,&devinfo);
				delete ptDevice;
			}


	        //    and here goes the code that lits the usb device found in the box


        }
    
        SetupDiDestroyDeviceInfoList(hDeviceInfoSet);

		return nDeviceCnt;
	}

/********************************************************************************************
 *						E n u m e r a t e A l l P r e s e n t D e v i c e s					*
 ********************************************************************************************/
short EnumerateAllPresentDevices()
{
		short nDeviceCnt = 0;

		HDEVINFO hDeviceInfoSet;
        
		cout << endl << endl << "EnumerateAllPresentDevices" << endl;

/*
WINSETUPAPI
HDEVINFO
WINAPI
SetupDiGetClassDevsA(
    IN LPGUID ClassGuid,  OPTIONAL
    IN PCSTR  Enumerator, OPTIONAL
    IN HWND   hwndParent, OPTIONAL
    IN DWORD  Flags
    );
*/
		DWORD dwFlags = DIGCF_PRESENT | DIGCF_ALLCLASSES;
        hDeviceInfoSet = SetupDiGetClassDevs(0,NULL,0,dwFlags);
        
        if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
        {
            cout << "Unable to enumerate USB device" << endl;
            return nDeviceCnt;
        }


        for (DWORD idx=0;;idx++)
        {
            SP_DEVINFO_DATA  devinfo;
            devinfo.cbSize = sizeof(devinfo);
        
            if (!SetupDiEnumDeviceInfo(hDeviceInfoSet,idx,&devinfo))
            {
                if (GetLastError() != ERROR_NO_MORE_ITEMS)
                {
                    cout << "Error while enumerating USB devices" << endl;
                }
                break;
            }
    
			
			nDeviceCnt++;

			CUsbDevice* ptDevice = new CUsbDevice();
			if (ptDevice != NULL)
			{
				cout << "--------------- " << idx << " --------------------" << endl;
				ptDevice->SetProperties(hDeviceInfoSet,&devinfo);
				delete ptDevice;
			}
    
            //    and here goes the code that lits the usb device found in the box
        }
    
        SetupDiDestroyDeviceInfoList(hDeviceInfoSet);

		return nDeviceCnt;
	}


/********************************************************************************************
 *								GetPacket													*
 *	Gets a single packet. Since packets may come simultaneously through						*
 *	asynchrous reads and normal (ReadFile) reads, a full implementation						*
 *	may require a packet queue and multiple threads.										*
 ********************************************************************************************/
Packet_t* GetPacket (HANDLE gHandle)
{
	Packet_t* thePacket = 0;
	DWORD theBufferSize = 0;
	BYTE* theBuffer = 0;

	for( ; ; )
    {
		// Read async data until the driver returns less than the
		// max async data size, which signifies the end of a packet
		BYTE theTempBuffer[ASYNC_DATA_SIZE];
		BYTE* theNewBuffer = 0;
		DWORD theBytesReturned = 0;

		DeviceIoControl( gHandle,
                     IOCTL_ASYNC_IN,
                     0,
                     0,
                     theTempBuffer,
                     sizeof( theTempBuffer ),
                     &theBytesReturned,
                     NULL );

		theBufferSize += ASYNC_DATA_SIZE;
		theNewBuffer = (BYTE*) malloc( theBufferSize );
		memcpy( theNewBuffer, theBuffer, theBufferSize - ASYNC_DATA_SIZE );
		memcpy( theNewBuffer + theBufferSize - ASYNC_DATA_SIZE, theTempBuffer, ASYNC_DATA_SIZE );

		free( theBuffer );

		theBuffer = theNewBuffer;

		if( theBytesReturned != ASYNC_DATA_SIZE )
        {
			thePacket = (Packet_t*) theBuffer;
			break;
        }
    }

	// If this was a small "signal" packet, read a real
	// packet using ReadFile
	if( thePacket->mPacketType == 0 &&
		thePacket->mPacketId == 2 )
    {
		BYTE* theNewBuffer = (BYTE*) malloc( MAX_BUFFER_SIZE );
		DWORD theBytesReturned = 0;

		free( thePacket );

		// A full implementation would keep reading (and queueing)
		// packets until the driver returns a 0 size buffer.
		ReadFile( gHandle,
              theNewBuffer,
              MAX_BUFFER_SIZE,
              &theBytesReturned,
              NULL );

		return (Packet_t*) theNewBuffer;
    }
	else
    {
		return thePacket;
    }
}

/********************************************************************************************
 *								C r e a t e D e v i c e H a n d l e							*
 *	Gets Class Guid and HDEVINFO for specified szDescription								*
 ********************************************************************************************/
HDEVINFO CreateDeviceHandle(CString szDescription, CString* ptHardwareID, CString* ptGuidText, GUID* ptClassGuid)
{
	BOOL bFound = FALSE;

	HDEVINFO hDeviceInfoSet=NULL;

	cout << endl << endl << "EnumerateUSBDevices" << endl;

    hDeviceInfoSet = SetupDiGetClassDevs(0,NULL,0,DIGCF_PRESENT | DIGCF_ALLCLASSES);
    
    if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
    {
        cout << "Unable to enumerate USB device" << endl;
        return hDeviceInfoSet;
    }

	/*
	typedef struct _SP_DEVINFO_DATA {
DWORD cbSize;
GUID  ClassGuid;
DWORD DevInst;    // DEVINST handle
DWORD Reserved;
} SP_DEVINFO_DATA, *PSP_DEVINFO_DATA;
*/

    for (DWORD idx=0; !bFound; idx++)
    {
        SP_DEVINFO_DATA  devinfo;
        devinfo.cbSize = sizeof(devinfo);

        if (!SetupDiEnumDeviceInfo(hDeviceInfoSet,idx,&devinfo))
        {
            if (GetLastError() != ERROR_NO_MORE_ITEMS)
            {
                cout << "Error while enumerating USB devices" << endl;
            }
            break;
        }


									// check if specified device
        BYTE    ByteBuffer[200];
        DWORD    BufferSize = 0;
        DWORD    DataType;

        if (SetupDiGetDeviceRegistryProperty(hDeviceInfoSet,&devinfo,SPDRP_DEVICEDESC, 
            &DataType, ByteBuffer,sizeof(ByteBuffer),&BufferSize))
        {			// Description = ""
			bFound = (szDescription.CompareNoCase((LPCTSTR)ByteBuffer) == 0);
        }


		if (bFound)
		{
			CUsbDevice* ptDevice = new CUsbDevice();
			if (ptDevice != NULL)
			{
				cout << "--------------- " << idx << " --------------------" << endl;
				ptDevice->SetProperties(hDeviceInfoSet,&devinfo);
				delete ptDevice;
			}


			cout << endl;

		} // bFound
    }


	return hDeviceInfoSet;
}

void DestroyDeviceHandle(HDEVINFO hDeviceInfoSet)
{
    SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
}







/********************************************************************************************
 *								OpenUSBdeviceInterface					*
 ********************************************************************************************/
BOOL OpenUSBdeviceInterface(CString szClassGuid) 
{
// Search devices for specified class GUID
	
// Declare the local data structures used
	struct _GUID ClassGuid;
	int nMemberIndex;
	BOOL bSuccess;
	HANDLE HidHandle;
    HDEVINFO hDeviceInfoSet;

	BOOL bOpened;
	BOOL bMoreItems;

							// First, get my class identifier
	CUsb::GetHidGuid(szClassGuid, &ClassGuid);	// {745A17A0-74D3-11D0-B6FE-00A0C90F57DA}

	//HidD_GetHidGuid (&ClassGuid);		// ergibt: {4D1E55B2-F16F-11CF-88CB-001111000030} fr HID MEDIA, funktioniert

							/*		#define DIGCF_PRESENT           0x00000002
									#define DIGCF_ALLCLASSES        0x00000004
									#define DIGCF_PROFILE           0x00000008
									#define DIGCF_DEVICEINTERFACE   0x00000010
							*/

//CString szGarminGuid ("{2C9C45C2-8E7D-4C08-A12D-816BBAE722C0}");		// aus Garmin SDK

//CString szTestGuid("{4D1E55B2-F16F-11CF-88CB-001111000030}");	// Side Winder funktioniert


// Unter XP: GUID ermittelt aus:
// HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB\Vid_091e&Pid_0003\5&b114931&0&1\Device Parameters
// Unter ME: GUID ermittelt aus:
// HKEY_LOCAL_MACHINE\System\CurrentControlSet\Control\DeviceClasses

 // CString szTestGuid("{a5dcbf10-6530-11d2-901f-00c04fb951ed}"); // Forerunner 205 funktioniert!!
  CString szTestGuid("{a5dcbf10-6530-11d2-901f-00c04fb951ed}"); // Packard Bell Massenspeichergert funktioniert!!
CUsb::GetHidGuid(szTestGuid, &ClassGuid);

	DWORD dwMode = DIGCF_PRESENT | DIGCF_DEVICEINTERFACE;		// if dwMode sets DIGCF_DEVICEINTERFACE: 
	hDeviceInfoSet = SetupDiGetClassDevs(&ClassGuid,			// GUID of an interface class
							"USB",		// PCTSTR enumerator 
							NULL,		// hwndParent
							dwMode);	// flags
    if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
	{	
		cout << "Could not attach to PnP node" << endl; 
		SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
		return FALSE; 
	}

	bOpened = false;
	bMoreItems = TRUE;
	nMemberIndex = 0;


	do
	{
							// Give the user some feedback
		Buffer[BufferIndex++] = 45;  // "-"

		SP_DEVICE_INTERFACE_DATA DeviceInterfaceData;

									 // Length of data structure in bytes
		memset (&DeviceInterfaceData, 0, sizeof(SP_DEVICE_INTERFACE_DATA));
		DeviceInterfaceData.cbSize = sizeof(DeviceInterfaceData);
	
							// Is there a HID device at this table entry
		bSuccess = SetupDiEnumInterfaceDevice(hDeviceInfoSet, // returned by SetupDiGetClassVev
					NULL,		// DeviceInfoData, to constrain the search 
					(LPGUID)&ClassGuid,	// to specify device interface class for requested interface
					nMemberIndex, 
					&DeviceInterfaceData);	// pointer to receive info for the device interface
		if (bSuccess) 
		{
			DWORD needed;			// get the required length
			bSuccess = SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet,
					&DeviceInterfaceData,	// created from SetupDiEnumInterfaceDevice
					NULL, 0,		// no device interface detail data pointer !!
					&needed,		// required size includes fix part of struct
					NULL);


			/*
			SetupDiGetDeviceInterfaceDetailA(
    IN  HDEVINFO                           DeviceInfoSet,
    IN  PSP_DEVICE_INTERFACE_DATA          DeviceInterfaceData,
    OUT PSP_DEVICE_INTERFACE_DETAIL_DATA_A DeviceInterfaceDetailData,     OPTIONAL
    IN  DWORD                              DeviceInterfaceDetailDataSize,
    OUT PDWORD                             RequiredSize,                  OPTIONAL
    OUT PSP_DEVINFO_DATA                   DeviceInfoData                 OPTIONAL
    );
			*/



			PSP_DEVICE_INTERFACE_DETAIL_DATA ptDetail =
				(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(needed);
			if (ptDetail != NULL)
			{						// good data for detail info
				memset (ptDetail, 0, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA));
									// cbSize for fix part of struct only
				ptDetail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
				ptDetail->cbSize = offsetof(SP_DEVICE_INTERFACE_DETAIL_DATA, DevicePath) + sizeof(TCHAR);


				SP_DEVINFO_DATA  devinfo;
				devinfo.cbSize = sizeof(devinfo);

				bSuccess = SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet, &DeviceInterfaceData, 
					ptDetail, needed, 
					NULL,			// no pointer to get required size (already known)
					&devinfo);		// pointer for SP_DEVINFO_DATA
//					NULL);			// no pointer for SP_DEVINFO_DATA
				if (!bSuccess ) 
				{	
					CheckWin32Error();

					cout << "Could not find the system name for this USB device" << endl; 
					SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
					return FALSE; 
				}


				CUsbDevice* ptDevice = new CUsbDevice();
				if (ptDevice != NULL)
				{
					cout << "--------------- " << nMemberIndex << " --------------------" << endl;
					ptDevice->SetProperties(hDeviceInfoSet,&devinfo);
					delete ptDevice;
				}

				CString szDevicePath (ptDetail->DevicePath);
				cout << endl << "Found driver path: " << endl;
				cout << (LPCTSTR)szDevicePath << endl;
										// Can now open this HID device
				HidHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
				if (HidHandle != INVALID_HANDLE_VALUE)
				{
							// We have found our device. Open two handles to it (one for each thread)
				//	ReadHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
				//	WriteHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
					cout << "Driver successfully opened!";
					

					// Get the USB packet size, which we need for sending packets
					DWORD theBytesReturned = 0;
					DeviceIoControl( HidHandle,
									 IOCTL_USB_PACKET_SIZE,
									 0,
									 0,
									 &gUSBPacketSize,				// need for writing to USB
									 sizeof( gUSBPacketSize ),		
									 &theBytesReturned,
									 NULL );

					
/*
					Packet_t* ptPacket = GetPacket (HidHandle);
					if (ptPacket != NULL)
					{

						free (ptPacket);
					}
*/
					CloseHandle(HidHandle);
				}
				else 
				{ 
					CheckWin32Error();
				}


				free((LPVOID) ptDetail);
			}	// ptDetail
		} // if (SetupDiEnumDeviceInterfaces . .
		else
		{		// bad SetupDiEnumDeviceInterfaces
			DWORD dwError = GetLastError();

			bMoreItems = (dwError != ERROR_NO_MORE_ITEMS);
			if (!bMoreItems)
				cout << endl;
			CheckError(dwError);
		}
		nMemberIndex++;
	} while (!bOpened && bMoreItems);

	SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
	return bOpened;
}


BOOL OpenUSBdevice(CString szClassGuid) 
{
// Search devices for specified class GUID
	
// Declare the local data structures used
	struct _GUID ClassGuid;
	int nMemberIndex;
	BOOL bSuccess;
    HDEVINFO hDeviceInfoSet;

	BOOL bOpened;
	BOOL bMoreItems;

							// First, get my class identifier
	CUsb::GetHidGuid(szClassGuid, &ClassGuid);	// {745A17A0-74D3-11D0-B6FE-00A0C90F57DA}

	//HidD_GetHidGuid (&ClassGuid);		// ergibt: {4D1E55B2-F16F-11CF-88CB-001111000030} fr HID MEDIA, funktioniert

							/*		#define DIGCF_PRESENT           0x00000002
									#define DIGCF_ALLCLASSES        0x00000004
									#define DIGCF_PROFILE           0x00000008
									#define DIGCF_DEVICEINTERFACE   0x00000010
							*/

//CString szGarminGuid ("{2C9C45C2-8E7D-4C08-A12D-816BBAE722C0}");		// aus Garmin SDK

//CString szTestGuid("{4D1E55B2-F16F-11CF-88CB-001111000030}");	// Side Winder funktioniert
//CString szTestGuid("{6994ad05-93ef-11d0-a3cc-00a0c9223196}");	// bad Image Aiptec
//CString szTestGuid("{65E8773D-8F56-11D0-A3B9-00A0C9223196}");	// bad Image Aiptec
//CString szTestGuid("{4D36E978-E325-11CE-BFC1-08002BE10318}");	// bad USB-GPS
//CString szTestGuid("{36FC9E60-C465-11CF-8056-444553540000}");	// PackardBell USB Stick
//CString szTestGuid("{A12A4C5A-E1A3-4151-9927-7F724CA5DC92}"); // Forerunner 205

//CUsb::GetHidGuid(szTestGuid, &ClassGuid);

	DWORD dwMode = DIGCF_PRESENT | DIGCF_ALLCLASSES;	
	hDeviceInfoSet = SetupDiGetClassDevs(&ClassGuid,		
							NULL,		// PCTSTR enumerator 
							NULL,		// hwndParent
							dwMode);	// flags
    if (hDeviceInfoSet == INVALID_HANDLE_VALUE )
	{	
		cout << "Could not attach to PnP node" << endl; 
		SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
		return FALSE; 
	}

	bOpened = false;
	bMoreItems = TRUE;
	nMemberIndex = 0;


	do
	{
							// Give the user some feedback
		Buffer[BufferIndex++] = 45;  // "-"

		SP_DEVINFO_DATA DeviceInfoData;

									 // Length of data structure in bytes
		memset (&DeviceInfoData, 0, sizeof(PSP_DEVINFO_DATA));
		DeviceInfoData.cbSize = sizeof(DeviceInfoData);
		bSuccess = SetupDiEnumDeviceInfo(hDeviceInfoSet, // returned by SetupDiGetClassDevs
					nMemberIndex, 
					&DeviceInfoData);	// pointer to receive info for the device

		HANDLE hDevInst = (HANDLE)DeviceInfoData.DevInst;


		if (bSuccess) 
		{
			/*
			SetupDiGetDeviceInterfaceDetailA(
    IN  HDEVINFO                           DeviceInfoSet,
    IN  PSP_DEVICE_INTERFACE_DATA          DeviceInterfaceData,
    OUT PSP_DEVICE_INTERFACE_DETAIL_DATA_A DeviceInterfaceDetailData,     OPTIONAL
    IN  DWORD                              DeviceInterfaceDetailDataSize,
    OUT PDWORD                             RequiredSize,                  OPTIONAL
    OUT PSP_DEVINFO_DATA                   DeviceInfoData                 OPTIONAL
    );
			*/

			
			/*
			DWORD needed;			// get the required length
			bSuccess = SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet,
					&DeviceInfoData,	// created from SetupDiEnumInterfaceDevice
					NULL, 0,		// no device interface detail data pointer !!
					&needed,		// required size includes fix part of struct
					NULL);

			PSP_DEVICE_INTERFACE_DETAIL_DATA ptDetail =
				(PSP_DEVICE_INTERFACE_DETAIL_DATA)malloc(needed);
			if (ptDetail != NULL)
			{						// good data for detail info
				memset (ptDetail, 0, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA));
									// cbSize for fix part of struct only
				ptDetail->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
				ptDetail->cbSize = offsetof(SP_DEVICE_INTERFACE_DETAIL_DATA, DevicePath) + sizeof(TCHAR);



				bSuccess = SetupDiGetDeviceInterfaceDetail(hDeviceInfoSet, &DeviceInfoData, 
					ptDetail, needed, 
					NULL,			// no pointer to get required size (already known)
					NULL);			// no pointer for SP_DEVINFO_DATA
				if (!bSuccess ) 
				{	
					CheckWin32Error();

					cout << "Could not find the system name for this USB device" << endl; 
					SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
					return FALSE; 
				}
				CString szDevicePath (ptDetail->DevicePath);
				cout << endl << "Found driver path: " << endl;
				cout << (LPCTSTR)szDevicePath << endl;
										// Can now open this HID device
				HidHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
				if (HidHandle != INVALID_HANDLE_VALUE)
				{
							// We have found our device. Open two handles to it (one for each thread)
				//	ReadHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
				//	WriteHandle = CreateFile(szDevicePath, 0xC0000000, 3, NULL, 3, 0, NULL);
					cout << "Driver successfully opened!";
					

					// Get the USB packet size, which we need for sending packets
					DWORD theBytesReturned = 0;
					DeviceIoControl( HidHandle,
									 IOCTL_USB_PACKET_SIZE,
									 0,
									 0,
									 &gUSBPacketSize,				// need for writing to USB
									 sizeof( gUSBPacketSize ),		
									 &theBytesReturned,
									 NULL );

					Packet_t* ptPacket = GetPacket (HidHandle);
					if (ptPacket != NULL)
					{

						free (ptPacket);
					}

					CloseHandle(HidHandle);
				}
				else 
				{ 
					CheckWin32Error();
				}


				free((LPVOID) ptDetail);
			}	// ptDetail

  */
		} // if (SetupDiEnumDeviceInterfaces . .
		else
		{		// bad SetupDiEnumDeviceInterfaces
			DWORD dwError = GetLastError();

			bMoreItems = (dwError != ERROR_NO_MORE_ITEMS);
			if (!bMoreItems)
				cout << endl;
			CheckError(dwError);
		}
		nMemberIndex++;
	} while (!bOpened && bMoreItems);

	SetupDiDestroyDeviceInfoList(hDeviceInfoSet);
	return bOpened;
}


DWORD WINAPI ListenToUSB(LPVOID Param) {
// Collect characters from the USB device and send them to the display
	char ReadBuffer[2];
	BOOL bSuccess;
	unsigned long BytesReturned;

	while (1) 
	{	
		bSuccess = ReadFile(ReadHandle, ReadBuffer, 2, &BytesReturned, NULL);
		if (ReadBuffer[1] != 0) 
		{ 
			Buffer[BufferIndex++] = ReadBuffer[1]; 
		}
	};
	return 0;
}	

	/*
DeviceDesc: EPSON-Drucker mit USB-Schnittstelle(EPUSB1:)
HardwareID: USB\VID_04B8&PID_0001&REV_0100
CompatibleIDs: USB\CLASS_07&SUBCLASS_01&PROT_02
Class (R--tied to ClassGUID): EpsonUSBPrinter
Driver: EpsonUSBPrinter\0001
ConfigFlags: 
Mfg: EPSON
Capabilities: .


  DeviceDesc: Garmin USB GPS
HardwareID: USB\VID_091E&PID_0003&REV_0001
aus regedit: USB\VID_091E&PID_0003&REV_0001,USB\VID_091E&PID_0003
CompatibleIDs: USB\CLASS_FF&SUBCLASS_FF&PROT_FF
aus regedit: USB\CLASS_FF&SUBCLASS_FF&PROT_FF,USB\CLASS_FF&SUBCLASS_FF,USB\CLASS_FF

Class (R--tied to ClassGUID): GARMIN Devices
ClassGUID: {A12A4C5A-E1A3-4151-9927-7F724CA5DC92}
Driver: GARMIN Devices\0000
ConfigFlags: 00 00 00 00
Mfg: Garmin
FriendlyName: Garmin USB GPS
aus regedit:

HKEY_LOCAL_MACHINE\Enum\USB\VID_091E&PID_0003

	Capabilities: 84 00 00 00
	FailReasonID: 0

  */

void TestCreateFile(CString szPath)
{
	HANDLE deviceHandle = INVALID_HANDLE_VALUE;

	CString szDevicePath("\\\\.\\");
	szDevicePath += szPath;

	deviceHandle = CreateFile (szDevicePath,
                               GENERIC_READ | GENERIC_WRITE,
                               0,
                               NULL,        // no SECURITY_ATTRIBUTES structure
                               OPEN_EXISTING, // No special create flags
                               0, 
                               NULL);       // No template file
	if (deviceHandle == INVALID_HANDLE_VALUE)
	{
		CheckWin32Error();
	}
	else 
	{
		cout << szPath << " OK !!" << endl;
	}
}


int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// MFC initialisieren, Ausgabe und Fehlermeldung bei Fehlern
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// ZU ERLEDIGEN: Fehlercode gem Ihren Anforderungen ndern
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		// ZU ERLEDIGEN: Anwendungsverhalten hier festlegen.
		CString strHello;
		strHello.LoadString(IDS_HELLO);
		cout << (const TCHAR*)strHello << endl;

		BufferIndex = 0;

					// call USB functions here...

		//EnumerateAllDevices();
		//EnumerateUSBDevices(TRUE);
		//EnumerateAllPresentDevices();

		CUsb USB;
//		USB.EnumerateUSBDevices(TRUE);
		USB.EnumInterfaceDevices();

		cout << "Available USB devices:" << endl << endl;

		for (int i=0; i<USB.GetDeviceCnt(); i++)
		{
			CUsbDevice* ptData = USB.GetDevicePtr(i);
			if (ptData != NULL)
			{
				cout << i << ". Desc: " << (LPCTSTR)ptData->GetDescription() << endl;
				cout << i << ". Clas: " << (LPCTSTR)ptData->GetClass() << endl;
				cout << i << ". HWid: " << (LPCTSTR)ptData->GetHardwareID() << endl;
				cout << i << ". Guid: " << (LPCTSTR)ptData->GetClassGuid() << endl;
				cout << "-----------------------" << endl;
			}
		}

		cout << endl << "Select one of the devices (0, ... " << i-1 << "):" << endl;
		short nSelectedIndex=1;
		cin >> nSelectedIndex;

		if (nSelectedIndex >= 0 && nSelectedIndex < USB.GetDeviceCnt())
		{		// try to find path of driver and open it
			CUsbDevice* ptDevice = USB.GetDevicePtr(nSelectedIndex);
			if (ptDevice != NULL)
			{
	//USB\Vid_091e&Pid_0003\5&b114931&0&1
	//				{A12A4C5A-E1A3-4151-9927-7F724CA5DC92}
	//HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB\Vid_091e&Pid_0003\5&b114931&0&1


	// Quelle aus Registry:
	// HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB\Vid_091e&Pid_0003\5&b114931&0&1\Device Parameters
    // CString test = "USB#Vid_091e&Pid_0003#5&b114931&0&1#{a5dcbf10-6530-11d2-901f-00c04fb951ed}"; //OK

				HANDLE deviceHandle = ptDevice->Open(ptDevice->GetDevicePath());
				if (deviceHandle != INVALID_HANDLE_VALUE)
				{




					ptDevice->Close(deviceHandle);
				}
			}
		}
	}
	return nRetCode;
}


/*
DeviceHandle = CreateFile("\\.\ezusb-0", GENERIC_WRITE, _
                            FILE_SHARE_WRITE, Security, OPEN_EXISTING, 0, 0)
  bResult = DeviceIoControl(DeviceHandle, &H222014, MyRequest, Len(MyRequest), _
                            ByteArray(0), ArraySize, nBytes, gOverlaped)
  ' Treiber schlieen
  Dummy = CloseHandle(DeviceHandle)
  */


/*
DeviceDesc: USB Root Hub
HardwareID: USB\ROOT_HUB
Class (R--tied to ClassGUID): USB
ClassGUID: {36FC9E60-C465-11CF-8056-444553540000}
Driver: USB\0001
ConfigFlags: 
Mfg: (Standard USB Host Controller)
Capabilities: 

--------------------------------Camcorder----------------------------------------

  DeviceDesc: MEDION Digital Camcorder
HardwareID: USB\VID_04E8&PID_1201&REV_0100
CompatibleIDs: USB\CLASS_FF&SUBCLASS_FF&PROT_FF
Class (R--tied to ClassGUID): Image
ClassGUID: {6bdd1fc6-810f-11d0-bec7-08002be2092f}
Driver: Image\0003
ConfigFlags: 
Mfg: MEDION
Capabilities: .

----------------------------------WebCam--------------------------------------

DeviceDesc: HyperVcam Mobile Plus
HardwareID: USB\VID_05A9&PID_A511&REV_0100
CompatibleIDs: USB\CLASS_FF&SUBCLASS_00&PROT_00
Class (R--tied to ClassGUID): Image
ClassGUID: {6bdd1fc6-810f-11d0-bec7-08002be2092f}
Driver: Image\0000
ConfigFlags: 
Mfg: OVT
Capabilities: .


HKEY_LOCAL_MACHINE\Enum\USB\
VID_05A9&PID_A511\1USB&ROOT_HUB&PCI&VEN_8086&DEV_7112&SUBSYS_00000000&REV_01&BUS_00&DEV_07&FUNC_02
Serial: 12 00 00 00 00 00 00 00

-------------------------------JoyStick-----------------------------------------
DeviceDesc: USB HID (Human Interface Device)
HardwareID: USB\VID_045E&PID_003C&REV_0101
CompatibleIDs: USB\CLASS_03&SUBCLASS_00&PROT_00
Class (R--tied to ClassGUID): HID
ClassGUID: {745a17a0-74d3-11d0-b6fe-00a0c90f57da}
Driver: HID\0000
ConfigFlags: 
Mfg: (Standardgert)
Capabilities: .


  HKEY_LOCAL_MACHINE\Enum\USB\VID_045E&PID_003C\2USB&ROOT_HUB&PCI&VEN_8086&DEV_7112&SUBSYS_00000000&REV_01&BUS_00&DEV_07&FUNC_02
HardwareID  = USB\VID_045E&PID_003C&REV_0101,USB\VID_045E&PID_003C

HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\Class\HID\0000
InfPath = HIDDEV.INF
InfSection = USBHIDDevice
MatchingDeviceID = USB\Class_03
NTMPDriver = hidusb.sys

----------------------------Smart Card Reader--------------------------------------------


DeviceDesc: USB Smart Card Reader
HardwareID: USB\Vid_08e6&Pid_3437&Rev_0100
CompatibleIDs: USB\Class_0b&SubClass_00&Prot_00
Service: GTwinUSB
Class (R--tied to ClassGUID): SmartCardReader
ClassGUID: {50DD5230-BA8A-11D1-BF5D-0000F805F530}
Driver: {50DD5230-BA8A-11D1-BF5D-0000F805F530}\0000
ConfigFlags: 
Mfg: Gemplus
LocationInformation: USB SmartCard Reader
PhysicalDeviceObjectName: \Device\USBPDO-1
Capabilities: 
UiNumber: 
Upper bound on ordinals: }].

-------------------------------------------------------------------


  HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\Class\GARMIN Devices
  HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\Class\Image\0000

*/