// UpdatDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include <direct.h>

#include "pf.h"

#include "InitDoc.h" 
#include "LocDoc.h"   
#include "AirspaceDoc.h"   
#include "UpdatDlg.h"
#include "..\Cpptools\DirBrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CLocUpdateDlg 
// updates locations and airspaces
// expects: for each location region, there is an airspace and an arispace segment doc
// so m_nEnumFileCnt is both, the number of loc regions and the number of airspaces
// expects locations AND airspaces in selected dir
// copies locations to m_szLocPath
// copies airspaces to m_szAspPath

extern CInitDoc* 	ptInit;  


CLocUpdateDlg::CLocUpdateDlg(CWnd* pParent, CInitDoc* ptInit, CLocDoc* ptLocDoc)
	: CDlgTool(CLocUpdateDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLocUpdateDlg)
	m_szState = _T("");
	//}}AFX_DATA_INIT
m_ptInit			= ptInit;
m_ptLocDoc			= ptLocDoc;
m_bChanged			= FALSE; 
m_bDataBasesUpdated	= FALSE; 
m_bRemovableDisk = FALSE;
m_bLocFound		= FALSE;
m_uTimer			= 0;
m_nEnumFileCnt		= 0;
m_nEnumFileIndex	= 0;
m_bCancel			= FALSE;
m_Mode = CLocUpdateDlg::INIT;


}


void CLocUpdateDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLocUpdateDlg)
	DDX_Text(pDX, ID_UPSTATE, m_szState);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLocUpdateDlg, CDlgTool)
	//{{AFX_MSG_MAP(CLocUpdateDlg)
	ON_BN_CLICKED(ID_UPOK, OnUpdate)
	ON_BN_CLICKED(IDCANCEL, OnCancel)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  UpdatDlg.cpp				S e a r c h N e w D a t a				*
 ************************************************************************/
BOOL CLocUpdateDlg::SearchNewData (CString* szDiskPath)
{ 
BOOL bFound = FALSE;
short	nStatusID;
BOOL	bDisable;

*szDiskPath = "A:\\Update";

bFound = (_chdir ((LPCTSTR)*szDiskPath)==0);

if (!bFound)
	{
	*szDiskPath = "B:\\Update";
	bFound = (chdir ((LPCTSTR)*szDiskPath)==0);
	}

if (bFound)
	{
	*szDiskPath += "\\";
	nStatusID	= IDS_READY;
	bDisable	= FALSE;
	}
else{	
	nStatusID	= IDS_NONEWDATA;
	bDisable	= TRUE;
	} 

m_szState.LoadString (nStatusID);
this->SetText (ID_UPSTATE, m_szState); 	
this->DisableControl (ID_UPOK, bDisable);
return bFound;			
} 

/************************************************************************
 *  UpdatDlg.cpp			S e l e c t U p d a t e F o l d e r			*
 ************************************************************************/
BOOL CLocUpdateDlg::SelectUpdateFolder (CString* ptDiskPath)
{ 
BOOL bFound = FALSE;
short	nStatusID;
BOOL	bDisable;

CString szMsg;
CDirSelectDlg dlg;
szMsg.LoadString (IDS_SELLOCPATH);
dlg.SetTitle(szMsg);
if(dlg.DoModal())				// get destination on PC
	{
	CString szSelectedPath;

	dlg.GetDirectory(szSelectedPath);// C:\...
	CInitDoc::AddBackslashIfMissing(&szSelectedPath);

	*ptDiskPath = szSelectedPath;
	bFound = (ptDiskPath->GetLength() > 0);
	}

if (bFound)
	{
	nStatusID	= IDS_READY;
	bDisable	= FALSE;
	}
else{	
	nStatusID	= IDS_NONEWDATA;
	bDisable	= TRUE;
	} 

m_szState.LoadString (nStatusID);
this->SetText (ID_UPSTATE, m_szState); 	
this->DisableControl (ID_UPOK, bDisable);
return bFound;			
} 

/****************************************************************************
 *	UpdatDlg.cpp			W a i t S e c o n d s		 					*
 ****************************************************************************/
void CLocUpdateDlg::WaitSeconds (short nSeconds)
{
SleepEx (nSeconds * 1000, FALSE);
}




/************************************************************************
 *  UpdatDlg.cpp			D o E n u m R e g i o n s					*
 ************************************************************************/
BOOL CLocUpdateDlg::DoEnumRegions (CString szActualPath)		        
{  
											// store old koord path
	m_szActLocPath = m_ptLocDoc->GetPathName();
	m_nActRegIndex = m_ptLocDoc->GetRegionIndex();

	CString szPath = m_szDiskPath + (CString)"*.krd";             
	m_nEnumFileCnt = CQuickFind::EnumFiles (&m_Regions, szPath);   
	m_bLocFound = (m_nEnumFileCnt > 0);   
	m_nEnumFileIndex = 0;

	return m_bLocFound;
}

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CLocUpdateDlg 

/****************************************************************************
 *	UpdatDlg.cpp					O n U p d a t e							*
 ****************************************************************************/
void CLocUpdateDlg::OnUpdate() 
{
	// TODO: Zustzliche Prfung hier einfgen
	DisableControl (ID_UPOK, TRUE);
//	DisableControl (IDCANCEL, TRUE);

		          					// get destination path name for koord database
	m_szLocPath = m_ptInit->GetActualPath ();
	m_szAspPath = m_ptInit->GetAirspaceDocPath();

	if (this->DoEnumRegions (m_szLocPath))
	{
		if (!m_bCancel)
		{
			m_Mode = CLocUpdateDlg::PREPARELOC;
			m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
			if (m_uTimer == 0)
			{									/* 1/2 sec Timer	*/
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
			}
		}
	}
	else
	{					// no loc data found in selected directory
		m_szState.LoadString (IDS_NONEWDATA);
		this->SetText (ID_UPSTATE, m_szState); 	
		this->DisableControl (IDCANCEL, FALSE);
	}
}



/****************************************************************************
 *	UpdatDlg.cpp					O n C a n c e l							*
 ****************************************************************************/
void CLocUpdateDlg::OnCancel()
{
	m_bCancel = TRUE;
	this->DisableControl (IDCANCEL, TRUE);


	WaitSeconds (1);			// give time to finish last action

	CString szMsg;
	switch (m_Mode)
	{
		case CLocUpdateDlg::INIT:
			// nothing is running
			break;
		case CLocUpdateDlg::PREPARELOC:
			// OnPrepareLocUpdate() was running...
			szMsg.Format(IDF_UPD_CANCEL_CPY, (LPCTSTR)m_szActRegionName);
			AfxMessageBox(szMsg);
			OnLocUpdate();
			OnFinishUpdate();
			break;
		case CLocUpdateDlg::COPYUSERLOC:
			//OnLocUpdate() was running...
			szMsg.Format(IDF_UPD_CANCEL_USR, (LPCTSTR)m_szActRegionName);
			AfxMessageBox(szMsg);
			OnFinishUpdate();
			break;
		case CLocUpdateDlg::PREPAREASP:
			// OnPrepareAspUpdate() was running...
			szMsg.Format(IDF_UPD_CANCEL_CPY, (LPCTSTR)m_szActRegionName);
			AfxMessageBox(szMsg);
			OnLocUpdate();
			OnFinishUpdate();
			break;
		case CLocUpdateDlg::COPYUSERASP:
			//OnAspUpdate() was running...
			szMsg.Format(IDF_UPD_CANCEL_USR, (LPCTSTR)m_szActRegionName);
			AfxMessageBox(szMsg);
			OnFinishUpdate();
			break;
		case CLocUpdateDlg::FINISH:
			//OnFinishUpdate() was running...
			AfxMessageBox(IDS_UPD_CANCEL_FIN);
			break;
	}

	this->DisableControl (IDCANCEL, FALSE);

	CDlgTool::OnCancel();
}

/*
	IDF_UPD_CANCEL_CPY		"Die Berichtigung wurde beim Kopieren von %s abgebrochen!"
	IDF_UPD_CANCEL_USR		"Die Berichtigung wurde beim bertragen der Benutzerwegpunkte fr %s abgebrochen"
	IDS_UPD_CANCEL_FIN		"Ein Abbruch ist nicht mehr mglich, weil die Berichtigung gerade abgeschlossen wurde!"	
*/

//--------------------------------- Location Update -----------------------//

/****************************************************************************
 *	UpdatDlg.cpp			O n P r e p a r e L o c U p d a t e 			*
 *  Timer handler for mode PREPARELOC										*
 ****************************************************************************/
void CLocUpdateDlg::OnPrepareLocUpdate()
{
	if (m_nEnumFileIndex < m_nEnumFileCnt)
	{					  
		if (this->DoPrepareLocUpdate ())
		{
			if (!m_bCancel)
			{
				m_Mode = CLocUpdateDlg::COPYUSERLOC;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}		
	}
}

/****************************************************************************
 *	UpdatDlg.cpp			D o P r e p a r e L o c U p d a t e  			*
 *  defines: m_szActRegionName, m_bOldAvail, m_szOldDocPath					*
 ****************************************************************************/
BOOL CLocUpdateDlg::DoPrepareLocUpdate ()
{   
	BOOL bCopy = FALSE;
	
							// remove extension from filenames
	m_szActRegionName = m_Regions.GetAt (m_nEnumFileIndex);
	short nDotIndex = m_szActRegionName.ReverseFind ('.');
	if (nDotIndex > 0)		 // at least one char remains for name
	{						// open file, ...
		CString szName;                        
		CString	szPathNew;
		CString	szPathOld;

		m_bOldAvail = FALSE;

									// get pure region name
		if (nDotIndex >= 0) szName = m_szActRegionName.Left (nDotIndex);
			else	   szName = m_szActRegionName;

		m_szState.Format(IDF_COPYDATABASE, (LPCTSTR)szName);
		this->SetText (ID_UPSTATE, m_szState);


									// try to delete old *.old file
		szPathOld = m_szLocPath + szName + ".old";

		TRY
			{
			CFile::Remove (szPathOld); 
			}
		CATCH( CFileException, e )
			{
			#ifdef _DEBUG
				afxDump << "File " << szPathOld << " not found, cause = "
					<< e->m_cause << "\n";
			#endif
			}
		END_CATCH			
					
					
									// rename actual *.krd into *.old   
		szPathOld = m_szLocPath + szName + ".krd";
		szPathNew = m_szLocPath + szName + ".old";	// Mac needs name and ext only!

		TRY
			{
			CFile::Rename(szPathOld, szPathNew);
			m_bOldAvail = TRUE;
			m_szOldDocPath = m_szLocPath + szName + ".old";
			}
		CATCH( CFileException, e )
			{
			m_bOldAvail = FALSE;
			#ifdef _DEBUG
				afxDump << "File " << szPathOld << " not found, cause = "
					<< e->m_cause << "\n";
			#endif
			}
		END_CATCH

		bCopy = TRUE;
	}

	return bCopy;
}


/****************************************************************************
 *	UpdatDlg.cpp				O n L o c U p d a t e 						*
 *  Timer handler for mode COPYUSERLOC										*
 ****************************************************************************/
void CLocUpdateDlg::OnLocUpdate()
{
	if (m_nEnumFileIndex < m_nEnumFileCnt)
	{					   	
		if (this->DoLocUpdate ())
		{				// more updates: call OnPrepareLocUpdate again
			if (!m_bCancel)
			{
				m_Mode = CLocUpdateDlg::PREPARELOC;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
		else
		{				// no more loc updates: start with airspace updates
			if (!m_bCancel)
			{
				m_nEnumFileIndex = 0;	// reset current file index

				m_Mode = CLocUpdateDlg::PREPAREASP;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
	}
}

/****************************************************************************
 *	UpdatDlg.cpp					D o L o c U p d a t e					*
 *  Opens new doc for m_szActRegionName	on source path						*
 *  if m_bOldAvail, old doc will be opened to copy user data to new doc		*
 *  finally writes new doc on m_szLocPath path								*
 ****************************************************************************/
BOOL CLocUpdateDlg::DoLocUpdate()
{
	CString szPathNew;
	BOOL	bNewLoaded = FALSE;
											// read new *.krd from floppy
	CLocDoc* ptNewKoords = new CLocDoc;	
	if (ptNewKoords != NULL)
	{
		szPathNew = m_szDiskPath + m_szActRegionName;			// "A:\Update\PORTUGAL.KRD"  
		ptNewKoords->SetAutoConvert(TRUE);		// don't ask user to convert
		bNewLoaded = ptNewKoords->OnOpenDocument (szPathNew);
	}

	if (bNewLoaded)	
	{     
//		WaitSeconds (1);			// give time to see actual state message in dlg

		if (m_bOldAvail)
		{
			BOOL bOldLoaded = FALSE;
			m_ptLocDoc->OnNewDocument(); 			// deletes old structures
			bOldLoaded = m_ptLocDoc->OnOpenDocument (m_szOldDocPath);	// load old koords
			if (bOldLoaded)		
			{
				short	nCopied = 0;   
				m_szState.LoadString (IDS_COPYUSR);  
	 			this->SetText (ID_UPSTATE, m_szState);
									// copy WP_USER from m_ptLocDoc to ptNewKoords
				nCopied = ptNewKoords->CopyUserWpts (m_ptLocDoc);	
//				WaitSeconds (1);
	  		}            
		}                          
												// change path of ptNewKoords
		szPathNew = m_szLocPath + m_szActRegionName;
		ptNewKoords->SetPathName (szPathNew);

		ptNewKoords->SetModifiedFlag(TRUE);			// force saving new data on hard disk

		BOOL bConfirm = FALSE;
		if (ptNewKoords->OnSaveDocument (szPathNew, bConfirm))	// write new data on hard disk
		{					// delete: saves if modified and frees!!
			m_bDataBasesUpdated = TRUE;
		}
	
	delete ptNewKoords;						// free new memory
	}	

	BOOL bMoreUpdates = (++m_nEnumFileIndex < m_nEnumFileCnt);
	return bMoreUpdates;
}


//--------------------------------- Airspace Update -----------------------//

/****************************************************************************
 *	UpdatDlg.cpp			O n P r e p a r e A s p U p d a t e 			*
 *  Timer handler for mode PREPAREASP										*
 ****************************************************************************/
void CLocUpdateDlg::OnPrepareAspUpdate()
{
	if (m_nEnumFileIndex < m_nEnumFileCnt)
	{					  
		if (this->DoPrepareAspUpdate ())
		{
			if (!m_bCancel)
			{
				m_Mode = CLocUpdateDlg::COPYUSERASP;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
		else
		{		// no airspace found to copy
			m_Mode = CLocUpdateDlg::FINISH;

			m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
			if (m_uTimer == 0)
			{									/* 1/2 sec Timer	*/
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
			}
		}
	}
}

/****************************************************************************
 *	UpdatDlg.cpp			D o P r e p a r e A s p U p d a t e  			*
 *  defines: m_szActRegionName, m_bOldAvail, m_szOldDocPath					*
 *  enumerates all krd-files and tries to find approppriate airspaces		*
 *  returns TRUE, if an airspace was found,									*
 *  returns FALSE, there is no more airspace								*
 ****************************************************************************/
BOOL CLocUpdateDlg::DoPrepareAspUpdate ()
{   
	BOOL bCopy = FALSE;
	BOOL bMoreUpdates = TRUE;

							// remove extension from filenames
	do
	{
		m_szActRegionName = m_Regions.GetAt (m_nEnumFileIndex);
		short nDotIndex = m_szActRegionName.ReverseFind ('.');
		if (nDotIndex > 0)		 // at least one char remains for name
		{						// open file, ...
			CString szName;                        
			CString	szPathOld;

			m_bOldAvail = FALSE;

										// get pure region name
			if (nDotIndex >= 0) szName = m_szActRegionName.Left (nDotIndex);
					else	   szName = m_szActRegionName;		// Germany.krd (!)


			CString szExt;						// now change extension
			szExt = CAirspaceDoc::GetExt();
			m_szActRegionName = szName + szExt;					// "Germany.spa"
			CString szPathNew = m_szDiskPath + m_szActRegionName;	// "A:\Update\Germany.spa"  

							// check if there is a new *.spa file on the source dir   
			if (CInitDoc::FileExists(szPathNew))
			{
				m_szState.Format(IDF_COPYAIRSPACES, (LPCTSTR)szName);
				this->SetText (ID_UPSTATE, m_szState);					
						

								// check if there is an old *.spa file on the dest dir   
				szPathOld = m_szAspPath + szName + szExt;
				if (CInitDoc::FileExists(szPathOld))
				{
					m_bOldAvail = TRUE;
					m_szOldDocPath = szPathOld;
				}

				bCopy = TRUE;
			}
		}

		// if bCopy ==TRUE, m_nEnumFileIndex will be increased at the end of DoAspUpdate!
		if (!bCopy)	
			m_nEnumFileIndex++;

		bMoreUpdates = (m_nEnumFileIndex < m_nEnumFileCnt);

	} while (!bCopy && bMoreUpdates);

	return bCopy;
}


/****************************************************************************
 *	UpdatDlg.cpp				O n A s p U p d a t e 						*
 *  Timer handler for mode COPYUSERLOC										*
 ****************************************************************************/
void CLocUpdateDlg::OnAspUpdate()
{
	if (m_nEnumFileIndex < m_nEnumFileCnt)
	{					   	
		if (this->DoAspUpdate ())
		{				// more updates: call OnPrepareAspUpdate again
			if (!m_bCancel)
			{
				m_Mode = CLocUpdateDlg::PREPAREASP;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
		else
		{				// no more airspace updates: stop process
			if (!m_bCancel)
			{
				m_Mode = CLocUpdateDlg::FINISH;
				m_uTimer = SetTimer (UPDATE_TIMER, 500, NULL);
				if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
					AfxMessageBox ("Bad Timer");
					CDlgTool::OnCancel();
				}
			}
		}
	}
}

/****************************************************************************
 *	UpdatDlg.cpp					D o A s p U p d a t e					*
 *  Opens new doc for m_szActRegionName	on source path						*
 *  if m_bOldAvail, old doc will be opened to copy user data to new doc		*
 *  finally writes new doc on m_szAspPath path								*
 ****************************************************************************/
BOOL CLocUpdateDlg::DoAspUpdate()
{
	CString szPathNew;
	BOOL	bNewLoaded = FALSE;
											// read new *.spa from floppy
	CAirspaceDoc* ptNewAirspaceDoc = new CAirspaceDoc;	
	if (ptNewAirspaceDoc != NULL)
	{
		szPathNew = m_szDiskPath + m_szActRegionName;	// "A:\Update\Portugal.spa"  
//		ptNewAirspaceDoc->SetAutoConvert(TRUE);		// don't ask user to convert
		bNewLoaded = ptNewAirspaceDoc->OnOpenDocument (szPathNew);
	}

	if (bNewLoaded)	
	{     
//		WaitSeconds (1);			// give time to see actual state message in dlg

		if (m_bOldAvail)
		{
			BOOL bOldLoaded = FALSE;
			CAirspaceDoc* ptOldAirspaceDoc = new CAirspaceDoc;	
			if (ptOldAirspaceDoc != NULL)
			{
				ptOldAirspaceDoc->OnNewDocument(); 			// deletes old structures
				bOldLoaded = ptOldAirspaceDoc->OnOpenDocument (m_szOldDocPath);	// load old airspaces
				if (bOldLoaded)		
				{
					short	nCopied = 0;   
					m_szState.LoadString (IDS_COPYUSRASP);  
	 				this->SetText (ID_UPSTATE, m_szState);
										// copy WP_USER from ptOldAirspaceDoc to ptNewAirspaceDoc
					nCopied = ptNewAirspaceDoc->CopyUserAirspaces (ptOldAirspaceDoc);	
	//				WaitSeconds (1);
	  			}    
				delete ptOldAirspaceDoc;
			}
		}                          
													// change path of ptNewAirspaceDoc
		szPathNew = m_szAspPath + m_szActRegionName;
		ptNewAirspaceDoc->SetPathName (szPathNew);

		ptNewAirspaceDoc->SetModifiedFlag(TRUE);	// force saving new data on hard disk
		CAirspaceSegmentDoc* ptSegDoc = ptNewAirspaceDoc->GetSegmentDocPtr();
		ptSegDoc->SetModifiedFlag(TRUE);			// force saving new segments on hard disk

		BOOL bConfirm = FALSE;
		if (ptNewAirspaceDoc->OnSaveDocument (szPathNew, bConfirm))	// write new data on hard disk
		{					// delete: saves if modified and frees!!
			m_bDataBasesUpdated = TRUE;
		}
	
	delete ptNewAirspaceDoc;						// free new memory
	}	

	BOOL bMoreUpdates = (++m_nEnumFileIndex < m_nEnumFileCnt);
	return bMoreUpdates;
}

//--------------------------------- Finish Update -----------------------//

/****************************************************************************
 *	UpdatDlg.cpp				O n F i n i s h U p d a t e					*
 *  Timer handler for mode FINISH											*
 ****************************************************************************/
BOOL CLocUpdateDlg::OnFinishUpdate()
{
	BOOL bDone = FALSE;

	if (m_bLocFound)
	{
		if (m_bDataBasesUpdated)
		{
			CQuickFind* ptQuickFind = m_ptInit->GetQuickFindPtr();
			m_nActRegIndex = ptQuickFind->CheckRegionNames(&m_Regions, m_ptInit->GetLocDocPath());
			ptQuickFind->Update(m_nActRegIndex);	 // opens doc and sets region index

									// actualize airspace regions here, same like in InitDoc
			CAirspaceRegionsDoc* ptAirspaceRegionsDoc = ptInit->GetAirspaceRegionsDocPtr();
			if (ptAirspaceRegionsDoc != NULL)
			{				// for each activated loc region, activate the airspace
				CObArray*  ptLocRegions = ptQuickFind->GetRegionsPtr();
				if (ptLocRegions != NULL)
				{				// actualize airspace regions
					CString szPath = ptInit->GetAirspaceDocPath ();
					ptAirspaceRegionsDoc->ReadBordersFrom(szPath);
					ptAirspaceRegionsDoc->ActivateFor(ptLocRegions);
					ptAirspaceRegionsDoc->CheckAirspacePath(szPath);
				}
			}

			bDone = TRUE;
		}
		else
		{
			m_ptLocDoc->OnNewDocument(); 			// deletes old structures   
			m_ptLocDoc->OnOpenDocument (m_szActLocPath);
			m_ptLocDoc->SetRegionIndex (m_nActRegIndex); 
			bDone = FALSE;
		}

		m_szState.LoadString (IDS_COPYFINISHED);
		this->SetText (ID_UPSTATE, m_szState);
		this->DisableControl (ID_UPOK, FALSE);
		this->DisableControl (IDCANCEL, FALSE);

		WaitSeconds (2);
	}
	else
	{
		m_szState.Format(IDF_NOLOCFOUND, m_szDiskPath);
		this->SetText (ID_UPSTATE, m_szState);
		this->DisableControl (ID_UPOK, TRUE);
		this->DisableControl (IDCANCEL, FALSE);
	}

	m_Mode = CLocUpdateDlg::INIT;

	return bDone;
}

/****************************************************************************
 *	UpdatDlg.cpp				O n I n i t D i a l o g						*
 ****************************************************************************/
BOOL CLocUpdateDlg::OnInitDialog() 
{
	CDlgTool::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	m_bRemovableDisk = this->SearchNewData (&m_szDiskPath);
	if (!m_bRemovableDisk)
		this->SelectUpdateFolder (&m_szDiskPath);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  UpdatDlg.cpp					O n T i m e r						*
 ************************************************************************/
void CLocUpdateDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

switch (nIDEvent)
	{
	case UPDATE_TIMER:
		this->KillTimer (m_uTimer);

		switch (m_Mode)
		{
			case CLocUpdateDlg::INIT:
				break;
			case CLocUpdateDlg::PREPARELOC:
				OnPrepareLocUpdate();
				break;
			case CLocUpdateDlg::COPYUSERLOC:
				OnLocUpdate();
				break;
			case CLocUpdateDlg::PREPAREASP:
				OnPrepareAspUpdate();
				break;
			case CLocUpdateDlg::COPYUSERASP:
				OnAspUpdate();
				break;
			case CLocUpdateDlg::FINISH:
				OnFinishUpdate();
				CDlgTool::OnOK();
				break;
	
		}
		break;
	default:
		AfxMessageBox ("Unknown Timer in OnTimer");
		break;
	}
		
CDlgTool::OnTimer(nIDEvent);
}


/************************************************************************
 *  UpdatDlg.cpp	 			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CLocUpdateDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
