#ifndef AFX_UPDATDLG_H__0FC1EB31_9ED6_11D1_9622_0060978B146F__INCLUDED_
#define AFX_UPDATDLG_H__0FC1EB31_9ED6_11D1_9622_0060978B146F__INCLUDED_

// UpdatDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CLocUpdateDlg 

class CInitDoc;
class CLocDoc;
class CAirspaceDoc;
class CLocUpdateDlg : public CDlgTool
{
// Konstruktion
public:
	#define UPDATE_TIMER	3
	typedef enum { INIT, PREPARELOC, COPYUSERLOC, PREPAREASP, COPYUSERASP, FINISH } UPDATEMODE;


	CLocUpdateDlg(CWnd* pParent = NULL, CInitDoc* ptInit = NULL, 
					CLocDoc* ptLocDoc=NULL);   // Standardkonstruktor



// Dialogfelddaten
	//{{AFX_DATA(CLocUpdateDlg)
	enum { IDD = IDD_UPDATEBOX };
	CString	m_szState;
	//}}AFX_DATA


// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CLocUpdateDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL
private:
	BOOL SearchNewData (CString* szDiskPath);
	BOOL SelectUpdateFolder (CString* ptDiskPath);
	void WaitSeconds (short nSeconds);

	BOOL DoEnumRegions (CString szActualPath);	
	
	BOOL DoPrepareLocUpdate();
	BOOL DoLocUpdate();
	void OnPrepareLocUpdate();
	void OnLocUpdate();

	BOOL DoPrepareAspUpdate();
	BOOL DoAspUpdate();
	void OnPrepareAspUpdate();
	void OnAspUpdate();

	BOOL OnFinishUpdate();

// Implementierung
private:
	UINT		m_uTimer;
	UPDATEMODE	m_Mode;
	CString		m_szActLocPath;
	short		m_nActRegIndex;
	CStringArray m_Regions;
	short		m_nEnumFileCnt;
	short		m_nEnumFileIndex;
	CString		m_szActRegionName;	// i.e. Germany.krd
	BOOL		m_bOldAvail;
	CString		m_szOldDocPath;		// old koord file, renamed with .old
									// or old asp file
	CString		m_szLocPath;
	CString		m_szAspPath;

protected:
	CInitDoc*		m_ptInit;
	CLocDoc* 		m_ptLocDoc;
	BOOL		m_bChanged;
	BOOL		m_bDataBasesUpdated;  
	CString		m_szDiskPath;
	BOOL		m_bRemovableDisk;
	BOOL		m_bLocFound;
	BOOL		m_bCancel;

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CLocUpdateDlg)
	virtual BOOL OnInitDialog();
   	afx_msg void OnUpdate();
   	afx_msg void OnCancel();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // AFX_UPDATDLG_H__0FC1EB31_9ED6_11D1_9622_0060978B146F__INCLUDED_
