// WayDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"			// cos
#include "pf.h"  

#include "InitDoc.h"
#include "DimDoc.h"    
#include "ElevArrayDoc.h"
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h

#include "WayDoc.h"
#include "WayDlg.h"
 
#include "AuKoDlg.h"    
#include "MaKoDlg.h"
#include "RelKoDlg.h"
#include "BearDlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  
extern CElevArrayDoc*	ptElevArrayDoc;
extern BOOL			bDemo;

/////////////////////////////////////////////////////////////////////////////
// CWayDlg dialog


CWayDlg::CWayDlg(CWnd* pParent, CWayDoc* ptDoc)
	: CDlgTool(CWayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWayDlg)
	m_lPlannedAlt = 0;
	m_szName = _T("");
	m_nAltDim = -1;
	m_nListIndex = -1;
	m_szCC = _T("");
	m_nAlternate = -1;
	//}}AFX_DATA_INIT
	
m_ptDoc = ptDoc;
m_bChanged = FALSE;           
m_bInsert = FALSE;
m_bWptDeleted = FALSE;
m_ptQuickFind = ptInit->GetQuickFindPtr();
m_ptNameList = m_ptQuickFind->GetNameListPtr();
m_nLastTypedLen = 0;

this->ReadRouteFromDoc ();

m_ptLaLoList = ptInit->GetLaLoListPtr();

}

/************************************************************************
 *  WayDlg.cpp					~ C W a y D l g							*
 ************************************************************************/
CWayDlg::~CWayDlg()
{
this->DeleteArrayOf(&m_ActList);
}

/************************************************************************
 *  WayDlg.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CWayDlg::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CWayPoint* ptEntry;
	if ((ptEntry = (CWayPoint*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("WayDlg Deleting WayPoint %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}

/************************************************************************
 *  WayDlg.cpp	  		R e a d R o u t e	F r o m D o c				*
 ************************************************************************/
void CWayDlg::ReadRouteFromDoc()
{                   					// copy route from Doc to Dlg
	short i;
	for (i=0; i<m_ptDoc->GetWayPointCnt(); i++)
	{
		LPWAY lpWay = m_ptDoc->GetWayPointPtr (i);
		CWayPoint* ptWayPt = new CWayPoint(lpWay);
		TRACE ("WayDlg ReadRouteFromDoc   new CWayPoint %d\n", i);

											// don't allow edit UpDown points
		if (ptWayPt->IsUp() || ptWayPt->IsDown())
			delete ptWayPt;
		else
			m_ActList.Add (ptWayPt);
	}

	if (m_ptDoc->HasAlternates())
	{			// add alternates to m_ActList and set AlternatesPU
		short nCnt = m_ptDoc->GetAlternateCnt();

		for (int i=1; i<=nCnt; i++)
		{	// for each alternate
			CWayPoint Alternate;
			if (m_ptDoc->GetAlternateWayPointPtr(i, &Alternate))
			{
				CWayPoint* ptWayPt = new CWayPoint(Alternate);
				if (ptWayPt != NULL)
					m_ActList.Add(ptWayPt);
			}
		}
	}

	m_bChanged = FALSE;
	m_ptDoc->SetModifiedFlag(FALSE);
}

/************************************************************************
 *  WayDlg.cpp			W r i t e R o u t e I n t o D o c				*
 ************************************************************************/
BOOL CWayDlg::WriteRouteIntoDoc()
{ 				
	BOOL	bWritten = FALSE;		
	BOOL bAlternatePUChanged = (m_bInitialAlternatePUIndex != m_nAlternate);
	
	if (m_bChanged || m_ptDoc->WasConverted() || bAlternatePUChanged)
	{                                   // copy route from Dlg to Doc
		short i;

		m_ptDoc->DeleteRoute();				// delete old route in doc

		short nWptCnt = m_ActList.GetSize();
		short nAlternateCnt = m_nAlternate;

		m_ptDoc->SetAlternates(nAlternateCnt > 0);

		for (i=0; i<nWptCnt; i++)
		{								// copy dlg waypoints to doc
			CWayPoint* ptWpt = (CWayPoint*)m_ActList.GetAt(i);
			if (ptWpt != NULL)
			{
				if (i < (nWptCnt - nAlternateCnt))
				{		// standard way point of route
					m_ptDoc->AppendWpt (*ptWpt);
				}
				else
				{		// alternate waypoint
					if (i == nWptCnt - nAlternateCnt)
					{
						m_ptDoc->SetAlternateWayPointPtr(1, *ptWpt);
						m_ptDoc->SetAlternate(ptWpt->GetIndicator(), 1);
					}

					if (i == nWptCnt - nAlternateCnt + 1)
					{
						m_ptDoc->SetAlternateWayPointPtr(2, *ptWpt);
						m_ptDoc->SetAlternate(ptWpt->GetIndicator(), 2);
					}
				}
			}
		}

	CCalculate* ptCalc = m_ptDoc->GetCalculationPtr();
	if (ptCalc != NULL)
		{								// add up down points
		if (m_ptDoc->IsUpDown())
			m_ptDoc->InsertUpDown();
		if (m_ptDoc->IsOrtho())			// add orthodrome
			m_ptDoc->InsertOrtho();
		}

	if (!bDemo) m_ptDoc->SetModifiedFlag(TRUE);  
	bWritten = TRUE;
	}               
return bWritten;
}



/************************************************************************
 *  WayDlg.cpp	  				S e t W p t  							*
 ************************************************************************/
void CWayDlg::SetWpt (CWayPoint* ptWayPt)
{  
m_nAltDim = ptDim->GetPUIndex (ALTITUDE, ptWayPt->GetAltDim());

m_szCC			= ptWayPt->GetCountryName();
m_szName 		= ptWayPt->GetNameForRte();
m_nLastTypedLen = m_szName.GetLength();
m_lPlannedAlt	= ptWayPt->GetPlannedAlt();
}	


/************************************************************************
 *  WayDlg.cpp	  		 	SearchInDataBase 							*
 ************************************************************************/
BOOL CWayDlg::SearchInDataBase (CString szName, CWayPoint* ptWayPt)
{
BOOL	bFound = FALSE;
long lFirstIndex, lLastIndex;
BOOL	bMultNames = FALSE;

if (m_ptNameList->GetSortedIndexRange ((LPCTSTR)szName, &lFirstIndex, &lLastIndex))
	{
	bMultNames = (lFirstIndex != lLastIndex);

	if (!bMultNames)
		{
		short j, nLen;
		BOOL	bSeparator = FALSE;
		nLen = szName.GetLength();
		for (j=m_nLastTypedLen; j<nLen && !bSeparator; j++)
			bSeparator = (	szName.GetAt(j) == ' ' || 
							szName.GetAt(j) == '-');
			
		if (bSeparator)		// ' ' or '-' after last caret position
			{
			nLen = j-1;			// -1 for last for-loop, -1 for separator char
			bMultNames = m_ptNameList->IndexToRangeN (nLen, &lFirstIndex, lFirstIndex, &lLastIndex);	
			}
		}	                                                       


	if (bMultNames)
		{				// show auto koord dialog  here!!!
		short	nRegIndex;
		CLocation Loc = ptWayPt->GetLoc();
		CAutoKoordDlg AutoKoord(this, &Loc, m_ptQuickFind, m_ptNameList);

		int RetVal = AutoKoord.DoModal();
		switch (RetVal)
			{
			case IDOK:   
				AutoKoord.GetLoc(&Loc, &nRegIndex);
				ptWayPt->SetLoc (Loc);
				bFound = TRUE;
				this->SelectItem (ID_WYNAME);
				break;
			case IDCANCEL:
				this->SelPartName (m_nLastTypedLen, ptWayPt->GetName());
				break;
			}

		}
	else{				// try to use params from data base
		short	nRegIndex;
		CLocation Loc = ptWayPt->GetLoc();
		CLocation FoundLoc;
		if (m_ptNameList->GetLoc (&FoundLoc, lFirstIndex, &nRegIndex))
			{
			if (!m_bInsert && Loc.IsValid())
				{
				if (!FoundLoc.IsEqual (Loc))
					{
					int		iRet;

					CString szText;
					szText.Format(IDF_WHICH_KOORD, (LPCTSTR)FoundLoc.GetName());
					iRet = AfxMessageBox ((LPCTSTR)szText, MB_YESNO);
					if (iRet == IDYES)
						{
						ptWayPt->SetLoc (FoundLoc);
						bFound = TRUE;
						}
					}
				}
			else{
				ptWayPt->SetLoc (FoundLoc);
				bFound = TRUE;
				}
			}
		}


	}
return bFound;
}

/************************************************************************
 *  WayDlg.cpp	  		 	G e t L o c u s 							*
 ************************************************************************/
BOOL CWayDlg::GetLocus (CWayPoint* ptWayPt)
{
BOOL bOK = FALSE;

if (m_szName.GetLength() > 0)
	{								// name received, check koords	
	if (this->SearchInDataBase(m_szName, ptWayPt))
		{
		bOK = TRUE;
		}
	else{				// in Insert Mode. try to fine waypt in route			
		if (m_bInsert)
			bOK = m_ptDoc->SearchInRoute(m_szName, ptWayPt);
		}

	if (!bOK)
		{				// no koords found in data bases and route
		if (m_bInsert)
			{
			if (!m_bKoordOK)
				{
				ptWayPt->Reset(m_szName, ptWayPt->GetVariation(), Country,
									ptWayPt->GetPlannedAlt());
				this->OnManu();
				}
			bOK = m_bKoordOK;
			}
		else{
			if (ptWayPt->IsValid())
				{					// legal values already there
				bOK = TRUE;
				}
			else{					// ask user to input values	
				ptWayPt->Reset(m_szName, ptWayPt->GetVariation(), Country,
					ptWayPt->GetPlannedAlt());

				if (ptWayPt->IsRelativ())
						this->OnRel();
				else	this->OnManu();

				bOK = m_bKoordOK;
				}
			}

		}

	}
else{						// no waypoint name available
	// auto koord dlg

	// if bad: return FALSE;
	}

if (bOK)
	ptWayPt->MarkNameForRte (m_szName);

return bOK;
}


/************************************************************************
 *  WayDlg.cpp	  				G e t W p t	 							*
 ************************************************************************/
BOOL CWayDlg::GetWpt (CWayPoint* ptWayPt)
{  
	BOOL	bOK = FALSE;
	CLatLon OldLatLon = (CLatLon)*ptWayPt;
                          
	bOK = GetLocus (ptWayPt);		// Mac: NewWayPointOK calls GetLocus here

	// SameLocus is called after GetWpt in DoDataExchange

	if (bOK)
	{
		short nElevFrGrid_m;
		if (ptElevArrayDoc->GetElev_m((CLatLon)*ptWayPt, &nElevFrGrid_m))
		{							// get elevation from 1km grid

			long lElevFromLoc;		// try to get elevation from location
			if (!((CLocation)*ptWayPt).GetAltitude(&lElevFromLoc))
			{						// no elevation specified for location

				long lElevFrGrid;	// convert elevation to dimension of waypoint
				short nElevDim = ((CLocation)*ptWayPt).GetElevDim();
				double fConvert;				
				fConvert = ptDim->ConvertDist((double)nElevFrGrid_m, DIM_METER, nElevDim);
				lElevFrGrid = (long)(fConvert + 0.5);	

									// use 1km-grid elevation for location
				ptWayPt->SetAltitude(lElevFrGrid);

				// "Diesem Wegpunkt wurde die Hhe von %ld %s aus dem 1km-Raster zugeordnet!"

				CString szMsg;
				CString szDim;
				ptDim->GetDimCstring(&szDim, nElevDim);
				szMsg.Format(IDF_USE_ELEVARRAY, lElevFrGrid, (LPCTSTR)szDim);
				AfxMessageBox (szMsg);
			}

		}	// end if (ptElevArrayDoc->GetElev_m...


								// store specified planned altitude 
		short nAltDim = ptDim->GetPUDim (ALTITUDE, m_nAltDim);
		ptWayPt->SetAltDim(nAltDim);
		ptWayPt->SetPlannedAlt (m_lPlannedAlt);


		if (!OldLatLon.IsEqual ((CLatLon)*ptWayPt) || !m_bBearingOK)
		{					// koords changed: reset bearing
			ptWayPt->DeleteBearing(0);
			ptWayPt->DeleteBearing(1);
			m_bBearingOK = FALSE;
		}
	}
					// wozu??
//CLocation Loc = ptWayPt->GetLoc();
//m_ptNameList->SetActRegIndex (Loc);	// activates region for this wpt

return bOK;
}	

/************************************************************************
 *  WayDlg.cpp				 F i l l A l t e r n a t e P U 				*
 ************************************************************************/
void CWayDlg::FillAlternatePU ()
{      
	CComboBox* ptAlternate = (CComboBox*)GetDlgItem (ID_WYALTERNATES);

	CString szText;
	short i;

	for (i=IDS_ALTERNATE00; i<=IDS_ALTERNATE02; i++)
	{
		szText.LoadString (i);  
		ptAlternate->AddString((LPCTSTR)szText);  
	}
} 


/************************************************************************
 *  WayDlg.cpp				 S e t A l t e r n a t e P U 				*
 ************************************************************************/
short CWayDlg::SetAlternatePU()
{
	short nIndex = -1;

	short nWptCnt = m_ActList.GetSize();
	BOOL bData = (nWptCnt > 0);

	return nIndex;
}

/************************************************************************
 *  WayDlg.cpp	  			 F i l l W a y L i s t 						*
 ************************************************************************/
void CWayDlg::FillWayList (CObArray* ptWayPts)
{
CListBox* ptList = (CListBox*)GetDlgItem (ID_WYLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<ptWayPts->GetSize(); i++)
	{      
	CWayPoint* ptWayPt = (CWayPoint*)ptWayPts->GetAt(i);
	szText = ptWayPt->GetNameForRte();
	ptList->AddString((LPCTSTR)szText);  
	}              
}                             

/************************************************************************
 *  WayDlg.cpp	  		 	O n N e w L i s t			 				*
 ************************************************************************/
short CWayDlg::OnNewList (CObArray* ptWayPts)
{
short	nWptCnt;
this->FillWayList(ptWayPts);  

nWptCnt = ptWayPts->GetSize();
BOOL bData = (nWptCnt > 0);
short nListIndex = bData? nWptCnt-1 : -1; 
return nListIndex;
}

/************************************************************************
 *  WayDlg.cpp	  				S a m e L o c u s						*
 ************************************************************************/
BOOL CWayDlg::SameLocus()
{   
#define EPS_KOORD 0.001
BOOL bNearWpt = FALSE;
CString szNearLoc;		
				
if (m_nListIndex >= 0)
	{						// check distance to previous wpt
	CWayPoint* lpPrevWpt = (CWayPoint*)m_ActList.GetAt(m_nListIndex); 
	if ( fabs (lpPrevWpt->GetLat() - m_ActWpt.GetLat()) < EPS_KOORD &&
		 fabs (lpPrevWpt->GetLon() - m_ActWpt.GetLon()) < EPS_KOORD	)
		{
		bNearWpt = TRUE;
		szNearLoc = lpPrevWpt->GetName();
		}
	}
	
if (m_nListIndex+1 < m_ActList.GetSize())
	{						// check distance to next wpt  
	CWayPoint* lpNextWpt = (CWayPoint*)m_ActList.GetAt(m_nListIndex+1); 
	if ( fabs (lpNextWpt->GetLat() - m_ActWpt.GetLat()) < EPS_KOORD &&
		 fabs (lpNextWpt->GetLon() - m_ActWpt.GetLon()) < EPS_KOORD	)
		{
		bNearWpt = TRUE;
		szNearLoc = lpNextWpt->GetName();
		}
	}  

if (bNearWpt)
	{
	CString szMsg;
	szMsg = this->Format (IDF_SAME_POS, (LPCTSTR)m_ActWpt.GetName(), (LPCTSTR)szNearLoc);
	AfxMessageBox (szMsg);
	}

return bNearWpt;
}

/************************************************************************
 *  WayDlg.cpp	  		 D o D a t a E x c h a n g e 					*
 ************************************************************************/
void CWayDlg::DoDataExchange(CDataExchange* pDX)
{   
this->ActivateDimGroups();

if (pDX->m_bSaveAndValidate)
	{  
	m_nOldIndex 	= m_nListIndex;	  
	}
    
CDlgTool::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CWayDlg)
	DDX_Alt(pDX, ID_WYPLALT, m_lPlannedAlt);
	DDX_Text(pDX, ID_WYNAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 17);
	DDX_CBIndex(pDX, ID_WYALTDIM, m_nAltDim);
	DDX_LBIndex(pDX, ID_WYLIST, m_nListIndex);
	DDX_Text(pDX, ID_WYREGION, m_szCC);
	DDX_CBIndex(pDX, ID_WYALTERNATES, m_nAlternate);
	//}}AFX_DATA_MAP
	
if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{  
		if (this->GetWpt (&m_ActWpt))
			{  
			if (SameLocus ())	pDX->Fail();
					else		this->InsertAfter (m_ActWpt); 
			}    
		}
	else{
		if (m_nOldIndex>=0 && m_nOldIndex<m_ActList.GetSize())
			{
			CWayPoint* lpOldWay = (CWayPoint*)m_ActList.GetAt(m_nOldIndex);   
			
			if (this->GetWpt (&m_ActWpt))
				{ 
				CheckFirstPlannedAlt (m_ActWpt);

				if (!lpOldWay->IsEqual (m_ActWpt)) 
					{  									// data has been changed !!
					this->InsertAfter (m_ActWpt);  	// save new data     
					delete lpOldWay;                  // free old data
					TRACE ("WayDlg DoDataExchange   delete CWayPoint %d\n", m_nOldIndex);
					}
				}
         	} 
     // else list was empty
		}
    }
}


BEGIN_MESSAGE_MAP(CWayDlg, CDlgTool)
	//{{AFX_MSG_MAP(CWayDlg)
	ON_LBN_SELCHANGE(ID_WYLIST, OnSelchangeList)
	ON_BN_CLICKED(ID_WYINS, OnInsert)
	ON_BN_CLICKED(ID_WYDEL, OnDelete)
	ON_BN_CLICKED(ID_WYCHANGE, OnChange)
	ON_CBN_SELCHANGE(ID_WYALTDIM, OnSelChangeAltDim)
	ON_CBN_SELCHANGE(ID_WYALTERNATES, OnSelChangeAlternates)
	ON_BN_CLICKED(ID_WYAUTO, OnAuto)
	ON_BN_CLICKED(ID_WYREL, OnRel)
	ON_BN_CLICKED(ID_WYMANU, OnManu)
	ON_BN_CLICKED(ID_WYREGIONS, OnRegionDlg)
	ON_EN_CHANGE(ID_WYNAME, OnChangeLocName)
	ON_BN_CLICKED(ID_WYINDIC, OnExchangeWayName)
	ON_LBN_DBLCLK(ID_WYLIST, OnDblclkWayList)
	ON_BN_CLICKED(ID_WYBEARING, OnBearing)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/************************************************************************
 *  wKoord.c			F a c i l i t y I n R a n g e					*
 ************************************************************************/
BOOL CWayDlg::FacilityInRange (CLocation& ActLoc)
{
BOOL	bFound = FALSE;
CLocation Loc;
short nActRegIndex = 0;
double	dDist;			// dummy


DRECT rLatLon = ActLoc.RadiusToDRECT (ActLoc.GetLat(), ActLoc.GetLon(), 2);		
																// degrees

if (m_ptLaLoList->PrepareGetLoc (rLatLon))
	{
	while (m_ptLaLoList->GetLocationInRect (&Loc, rLatLon, &nActRegIndex) &&
			!bFound)
		{		// is Loc a facility near to ActLoc?
		bFound = Loc.IsFacilityInRange(ActLoc, &dDist);
		}
	}

return bFound;
}

/************************************************************************
 *  WayDlg.cpp	  		 P r e p a r e B u t t o n s	 				*
 ************************************************************************/
void CWayDlg::PrepareButtons()
{      
BOOL	bDisable;
short	nWptCnt = m_ActList.GetSize();

bDisable = (m_nLastTypedLen == 0);

this->DisableControl (ID_WYINDIC, bDisable);  
this->DisableControl (ID_WYMANU, bDisable);  

if (m_bTypeMode)	bDisable = TRUE;
			else	bDisable = !FacilityInRange((CLocation)m_ActWpt);
this->DisableControl (ID_WYBEARING, bDisable);  

if (m_bKoordOK)
		 bDisable = (nWptCnt == 0);		// change mode
	else bDisable = (nWptCnt == 0);		// insert mode	
this->DisableControl (ID_WYREL, bDisable); 

bDisable = (nWptCnt == 0); 
this->DisableControl (ID_WYCHANGE, bDisable);  
this->DisableControl (ID_WYDEL, bDisable);  

if (m_bChangeMode)
		bDisable = (m_nLastTypedLen == 0) || !m_bTypeMode;
else	bDisable = FALSE;
this->DisableControl (ID_WYINS, bDisable);
}

/////////////////////////////////////////////////////////////////////////////
// CWayDlg message handlers

/************************************************************************
 *  WayDlg.cpp	  			O n I n i t D i a l o g	 					*
 ************************************************************************/
BOOL CWayDlg::OnInitDialog()
{      
//CComboBox* ptRegionPU = (CComboBox*)GetDlgItem (ID_WYREGION);	// ist kein PU!!
//m_ptQuickFind->FillRegionPU (ptRegionPU);

           // value DlgID,	dim DlgID
this->AddDimGroup (ID_WYPLALT, ID_WYALTDIM);

this->FillDimPU (ID_WYALTDIM, ALTITUDE);

this->FillAlternatePU(); 
m_nAlternate = m_ptDoc->GetAlternateCnt();

m_bInitialAlternatePUIndex = m_nAlternate;

m_bKoordOK	= FALSE;
m_bTypeMode	= FALSE;
							
m_nListIndex = this->OnNewList (&m_ActList);
if (m_nListIndex >=0)
	{	
	CWayPoint* ptWayPt = (CWayPoint*)m_ActList.GetAt(m_nListIndex);   
	if (ptWayPt != NULL)
		{
		m_ActWpt		= *ptWayPt;
		m_bKoordOK		= TRUE;
		m_bBearingOK	= TRUE;
		m_bChangeMode	= TRUE;
		this->SetWpt(&m_ActWpt);
		}
	}

if (!m_bKoordOK)
	{
	m_ActWpt.Reset("", 0, Country, 0L);
	m_bBearingOK	= FALSE;
	m_bChangeMode	= FALSE;
	}

// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();

this->PrepareButtons ();

return TRUE;  // return TRUE  unless you set the focus to a control
}


/************************************************************************
 *  WayDlg.cpp	  		 I n s e r t A f t e r							*
 ************************************************************************/
void CWayDlg::InsertAfter(CWayPoint WayPt)	
{		
CWayPoint* ptNewWayPt = new CWayPoint(WayPt);
TRACE ("WayDlg InsertAfter   new CWayPoint\n");
			
short nNewIndex;
if (m_bInsert)
	{
	nNewIndex = m_nListIndex+1; 
	m_ActList.InsertAt (nNewIndex, ptNewWayPt);	// insert new  
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ActList.SetAt (m_nOldIndex, ptNewWayPt);	// change wpt
	}
		
m_bChanged = TRUE;           
if (ptInit->IsSaveSignal())
	MessageBeep(MB_OK);	
	              			// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (ID_WYLIST);    
CString szNewName = ptNewWayPt->GetNameForRte();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);    
	m_nListIndex = nNewIndex;		 
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.Compare((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(m_nOldIndex, (LPCTSTR)szNewName);  
		}   
	}
this->SetWpt(ptNewWayPt);
}

/************************************************************************
 *  WayDlg.cpp	  		 O n S e l c h a n g e L i s t					*
 ************************************************************************/
void CWayDlg::OnSelchangeList()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (ID_WYLIST);    
short nNewIndex = ptList->GetCurSel ();

m_bTypeMode = FALSE;
m_bChangeMode = TRUE;

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{  
										// get new region index
		CWayPoint* ptWayPt = (CWayPoint*)m_ActList.GetAt(m_nListIndex);   
		if (ptWayPt != NULL)
			{					// get actual waypoint
			m_ActWpt = *ptWayPt;
			m_bKoordOK		= TRUE;
			m_bBearingOK	= TRUE;
			this->SetWpt(&m_ActWpt);
			}

		this->UpdateData(FALSE);
		this->PrepareButtons ();
		this->SelectItem (ID_WYNAME);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetCurSel (m_nListIndex);		  
		}
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	this->SelectItem (ID_WYNAME);
	}
}

/************************************************************************
 *  WayDlg.cpp					OnDblclkWayList							*
 ************************************************************************/
void CWayDlg::OnDblclkWayList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
CListBox* ptList = (CListBox*)GetDlgItem (ID_WYLIST);    
short nNewIndex = ptList->GetCurSel ();

if (nNewIndex >= 0)
	{	
	this->OnManu();
	}
}


/************************************************************************
 *  WayDlg.cpp	  			 O n I n s e r t 							*
 ************************************************************************/
void CWayDlg::OnInsert()
{
	// TODO: Add your control notification handler code here  
m_bTypeMode = FALSE;
m_bInsert	= TRUE;
if (this->UpdateData(TRUE))
	{
	this->UpdateData(FALSE);

	this->SelectItem (ID_WYNAME);
 	m_bChangeMode = TRUE;
	this->PrepareButtons();
	}
m_bInsert = FALSE;	
}

/************************************************************************
 *  WayDlg.cpp	  				 O n C h a n g e		 				*
 ************************************************************************/
void CWayDlg::OnChange()
{
	// TODO: Add your control notification handler code here
m_bTypeMode = FALSE;

if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	this->SelectItem (ID_WYNAME);
	}
}
	
/************************************************************************
 *  WayDlg.cpp	  				O n D e l e t e							*
 ************************************************************************/
void CWayDlg::OnDelete()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (ID_WYLIST);    
short nDeleteIndex = ptList->GetCurSel (); 
CWayPoint* ptWayPt = (CWayPoint*)m_ActList.GetAt(nDeleteIndex); 
m_ActList.RemoveAt (nDeleteIndex); 
delete ptWayPt;

m_bChanged = TRUE;           
m_bWptDeleted = TRUE;
m_bTypeMode = FALSE;

ptList->DeleteString (nDeleteIndex);

if (m_ActList.GetSize() > 0)
	{ 
	m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 

	ptWayPt = (CWayPoint*)m_ActList.GetAt(m_nListIndex);   
	if (ptWayPt != NULL)
		{					// get actual waypoint
		m_ActWpt = *ptWayPt;
		m_bKoordOK		= TRUE;
		m_bBearingOK	= TRUE;
		this->SetWpt(&m_ActWpt);
		}

	this->UpdateData(FALSE);
	this->SelectItem (ID_WYNAME);
	}
else{
	m_bChangeMode = FALSE;
	this->PrepareButtons();
	m_nListIndex = -1;  
	}	
}


/************************************************************************
 *  WayDlg.cpp	  			OnSelChangeAltDim							*
 ************************************************************************/
void CWayDlg::OnSelChangeAltDim() 
{
	// TODO: Add your control notification handler code here
CComboBox* ptList = (CComboBox*)GetDlgItem (ID_WYALTDIM);    
m_nAltDim = ptList->GetCurSel ();
}

/************************************************************************
 *  WayDlg.cpp	  			OnSelChangeAlternates						*
 ************************************************************************/
void CWayDlg::OnSelChangeAlternates() 
{
	// TODO: Add your control notification handler code here
CComboBox* ptAlternates = (CComboBox*)GetDlgItem (ID_WYALTERNATES);    
m_nAlternate = ptAlternates->GetCurSel ();
}

/****************************************************************************
 *  WayDlg.cpp	  			CheckFirstPlannedAlt							*
 * Purpose: if actual planned alt < elevation: set planned alt = elevation	*
 ****************************************************************************/
void CWayDlg::CheckFirstPlannedAlt (CWayPoint& Wpt)
{
if (m_nOldIndex == 0)			// set in DoDataExchange before reading new (changed) dlg list index
	{							// for start airport: set PlAlt = Elev
	long lElev;
	if (Wpt.GetAltitude(&lElev))
		{
		short nElevDim = ((CLocation)Wpt).GetElevDim();

		long lPlAlt = Wpt.GetPlannedAlt();
		short nPlAltDim = Wpt.GetAltDim ();

		if (nPlAltDim != nElevDim)
		{
			double fConvert;
			fConvert = ptDim->ConvertDist((double)lPlAlt, nPlAltDim, nElevDim);
			lPlAlt = (long)(fConvert + 0.5);
		}

		if (lPlAlt < lElev)
			{
			//CWnd* ptWnd = this->GetDlgItem (ID_WYPLALT);
			//SetLong(ptWnd->GetSafeHwnd(), lElev, NO_LONG);

			//m_lPlannedAlt = lElev;
			//m_nAltDim = ptDim->GetPUIndex (ALTITUDE, nElevDim);

			Wpt.SetPlannedAlt(lElev);
			Wpt.SetAltDim(nElevDim);
			}
		}
	}
}



/************************************************************************
 *  WayDlg.cpp	  			OnAuto					*
 ************************************************************************/
void CWayDlg::OnAuto() 
{
	// TODO: Add your control notification handler code here

CString szName;
short	nRegIndex;

this->TryToReadLatLon (&m_ActWpt);

CLatLon OldLatLon = (CLatLon)m_ActWpt;

CLocation Loc = m_ActWpt.GetLoc();
CAutoKoordDlg AutoKoord(this, &Loc, m_ptQuickFind, m_ptNameList);

int RetVal = AutoKoord.DoModal();
switch (RetVal)
	{
	case IDOK:   
		if (m_bKoordOK)				// actual koord already ok
			m_bChangeMode = FALSE;	// switch to insert mode


		AutoKoord.GetLoc(&Loc, &nRegIndex);
		m_ActWpt.SetLoc (Loc);


		if (!OldLatLon.IsEqual ((CLatLon)m_ActWpt))
		{					// koords changed: reset bearing
		m_ActWpt.DeleteBearing(0);
		m_ActWpt.DeleteBearing(1);
		m_bBearingOK = FALSE;
		}

		m_bTypeMode = FALSE;
		m_bKoordOK	= TRUE;

		m_szName = m_ActWpt.GetNameForRte ();
		m_szCC = m_ActWpt.GetCountryName();
		m_nLastTypedLen = m_szName.GetLength();

		this->UpdateData(FALSE);
		this->PrepareButtons();
		this->SelectItem (ID_WYNAME);
		break;
	case IDCANCEL:
		this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
		break;
	}
}

/************************************************************************
 *  WayDlg.cpp	  				O n R e l								*
 *  enabled if:  (ptWayPts->GetSize() > 1);
 ************************************************************************/
void CWayDlg::OnRel() 
{
	// TODO: Add your control notification handler code here

short nRelDlgListIndex;

if (m_bKoordOK)
	{						// change mode
	if (m_nListIndex > 0)	
		{
		nRelDlgListIndex = m_nListIndex - 1;
		}
	else{					// m_nListIndex = 0
		if (m_ActList.GetSize() > 1)
				nRelDlgListIndex = m_nListIndex + 1;
		else	nRelDlgListIndex = m_nListIndex;
		}
	}
else{						// insert mode
	this->TryToReadLatLon (&m_ActWpt);
	m_ActWpt.Reset(m_ActWpt.GetName(), m_ActWpt.GetVariation(), Country,
						m_ActWpt.GetPlannedAlt());
	nRelDlgListIndex = m_nListIndex;
	}


CLatLon OldLatLon((CLatLon)m_ActWpt);		// store actual lat lon

CRelKoordDlg RelKoord(this, &m_ActWpt, &m_ActList, nRelDlgListIndex);

int RetVal = RelKoord.DoModal();
switch (RetVal)
	{
	case IDOK:   
  		if (!OldLatLon.IsEqual ((CLatLon)m_ActWpt))
			{					// koords changed: reset bearing
			m_ActWpt.DeleteBearing(0);
			m_ActWpt.DeleteBearing(1);
			m_bBearingOK = FALSE;
			}

		m_bTypeMode = FALSE;
		m_bKoordOK = TRUE;

		m_szName = m_ActWpt.GetNameForRte ();
		m_szCC = m_ActWpt.GetCountryName();
		m_nLastTypedLen = m_szName.GetLength();

		this->SetText(ID_WYNAME, m_szName);	// show actual name and CC
		this->SetText(ID_WYREGION, m_szCC);

		this->PrepareButtons();
		this->SelectItem (ID_WYNAME);
		break;
	case IDCANCEL:
		this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
		break;
	}
}

/************************************************************************
 *  WayDlg.cpp	  				O n M a n u								*
 ************************************************************************/
void CWayDlg::OnManu() 
{
	// TODO: Add your control notification handler code here

CLatLon OldLatLon((CLatLon)m_ActWpt);		// store actual lat lon

if (!m_bKoordOK)
{
	m_bChangeMode = FALSE;
	m_ActWpt.Reset(m_ActWpt.GetNameForRte(), m_ActWpt.GetVariation(), Country,
									m_ActWpt.GetPlannedAlt());
}

CManuKoordDlg ManuKoord(this, &m_ActWpt);
int RetVal = ManuKoord.DoModal();
switch (RetVal)
	{
	case IDOK:   
  		if (!OldLatLon.IsEqual ((CLatLon)m_ActWpt))
			{					// koords changed: reset bearing
			m_ActWpt.DeleteBearing(0);
			m_ActWpt.DeleteBearing(1);
			m_bBearingOK = FALSE;
			}

		m_bTypeMode = FALSE;
		m_bKoordOK = TRUE;

		m_szName = m_ActWpt.GetNameForRte ();
		m_szCC = m_ActWpt.GetCountryName();
		m_nLastTypedLen = m_szName.GetLength();

		this->SetText(ID_WYNAME, m_szName);	// show actual name and CC
		this->SetText(ID_WYREGION, m_szCC);

		this->PrepareButtons();
		this->SelectItem (ID_WYNAME);
		break;
	case IDCANCEL:
		this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
		break;
	}
}

/************************************************************************
 *  WayDlg.cpp	  			O n B e a r i n g							*
 ************************************************************************/
void CWayDlg::OnBearing() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->TryToReadLatLon (&m_ActWpt);

CBearDlg BearingDlg(this, &m_ActWpt);
int RetVal = BearingDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
		m_bBearingOK = (m_ActWpt.HasBearing(0) || m_ActWpt.HasBearing(1));
		this->PrepareButtons();
		if (m_bChangeMode)
			OnChange();

		this->SelectItem (ID_WYNAME);
		break;
	case IDCANCEL:
		this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
		break;
	}
	
}

/************************************************************************
 *  WayDlg.cpp	  			OnRegionDlg					*
 ************************************************************************/
void CWayDlg::OnRegionDlg() 
{
	// TODO: Add your control notification handler code here
if (m_ptQuickFind->Change (this))
	{
	if (!m_bKoordOK && m_nLastTypedLen>1)
		{				 // to activate "EM_GETMODIFY" in OnChangeLocName
		CWnd* ptWnd = this->GetDlgItem (ID_WYNAME);	
	//	wParam = (WPARAM) (UINT) fModified;    // modification flag 
	//	lParam = 0;                            // not used; must be zero 
		ptWnd->SendMessage (EM_SETMODIFY, (WPARAM)(UINT)TRUE, 0); 

		m_nLastTypedLen--;	// to force a new "FindBestName" call
		this->OnChangeLocName();
	//	this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
		}
	else{
		this->SelectItem (ID_WYNAME);
		}
	}	
else{			// Region dialog canceled
	this->SelPartName (m_nLastTypedLen, m_ActWpt.GetName());
	}
}

/************************************************************************
 *  WayDlg.cpp	  			SelPartName					*
 ************************************************************************/
void CWayDlg::SelPartName (short nTypedLen, CString szName)
{
short nEndSel;
CWnd* ptWnd = this->GetDlgItem (ID_WYNAME);	
ptWnd->SetFocus ();

nEndSel = szName.GetLength();

if (nTypedLen == nEndSel)
	nTypedLen = 0;				// select whole name

#ifdef WIN_NT
		    ptWnd->SendMessage (EM_SETSEL, nTypedLen, nEndSel); 
#else
		    ptWnd->SendMessage (EM_SETSEL, 0, MAKELONG(nTypedLen, nEndSel)); 
#endif
}

/************************************************************************
 *  WayDlg.cpp	  			O n C h a n g e L o c N a m e 				*
 ************************************************************************/
void CWayDlg::OnChangeLocName() 
{
	// TODO: Add your control notification handler code here
char	szName[SIZEOF_ORT];
short	TypedLen = 0;

BOOL	bModified;
BOOL	bNameSet = FALSE;

CWnd* ptWnd = this->GetDlgItem (ID_WYNAME);	

bModified = ptWnd->SendMessage (EM_GETMODIFY, 0, 0); 
if (!bModified) return;

if (ptWnd->GetWindowText(szName, SIZEOF_ORT) > 0)
    {
    TypedLen = strlen (szName);

    if (TypedLen > m_nLastTypedLen)
		{
		char	szFoundName[SIZEOF_ORT];
		strcpy (szFoundName, szName);
		if (m_ptNameList->FindBestName (szFoundName, TypedLen) ||
			(!m_bWptDeleted && // sonst kennt FindBestName zuvor gelschte Wegpunkte, was Probleme in OnRel gibt
			m_ptDoc->FindBestName (szFoundName, TypedLen)))  
		    {			/* Koords, VAR, Frq found in file	*/
		    short   nEndSel;
	
			m_ActWpt.SetName (szFoundName);
			 
			strcpy (szName + TypedLen, szFoundName + TypedLen);

		    ptWnd->SetWindowText (szName);

		    nEndSel = strlen (szName);
#ifdef WIN_NT
		    ptWnd->SendMessage (EM_SETSEL, TypedLen, nEndSel); 
#else
		    ptWnd->SendMessage (EM_SETSEL, 0, MAKELONG(TypedLen, nEndSel)); 
#endif
			bNameSet = TRUE;
		    }
		}

	if (m_ActWpt.IndicatorUsed())
			m_ActWpt.SetIndicator (szName);
	else	m_ActWpt.SetName (szName);

		  
	if (bNameSet)
		{
		m_bKoordOK = TRUE;
		}
	else{
		m_bKoordOK = FALSE;
		}
    }
m_nLastTypedLen = TypedLen;  

m_bTypeMode = TRUE;
this->PrepareButtons();
}

/************************************************************************
 *  WayDlg.cpp				T r y T o R e a d L a t L o n				*
 ************************************************************************/
void CWayDlg::TryToReadLatLon (CWayPoint* ptWayPt)
{
CLatLon OldLatLon;

OldLatLon = (CLatLon)*ptWayPt;
                          
if (m_bKoordOK)					// but name known in data base
	{							// see OnChangeLocName	
	CString szNameForRte;
	long lIndex;

	szNameForRte = ptWayPt->GetNameForRte();
	if (m_ptNameList->GetSortedInd ((LPCTSTR)szNameForRte, &lIndex))
		{
		short	nRegIndex;
		CLocation Loc;
		m_ptNameList->GetLoc (&Loc, lIndex, &nRegIndex);
		ptWayPt->SetLoc (Loc);

		if (!OldLatLon.IsEqual ((CLatLon)*ptWayPt))
			{					// koords changed: reset bearing
			ptWayPt->DeleteBearing(0);
			ptWayPt->DeleteBearing(1);
			m_bBearingOK = FALSE;
			m_bChangeMode = FALSE;	// allow insert
			}
		}
	}
else{
	m_bChangeMode = FALSE;	// allow insert
	}	
}	
	

/************************************************************************
 *  WayDlg.cpp				D o E x c h a n g e N a m e 				*
 ************************************************************************/
BOOL CWayDlg::DoExchangeName (CLocation* ptLoc, CString szActName)
{      
BOOL	bExchanged = FALSE;
CString	szName = ptLoc->GetName();
CString szIndic= ptLoc->GetIndicator();

BOOL bOrtToInd = (szActName.CompareNoCase (szName) == 0);
					
if (bOrtToInd)
	{
	if (szIndic.GetLength() > 0)   
		{
		this->SetText(ID_WYNAME, szIndic);
		ptLoc->MarkNameForRte(szIndic);
		bExchanged = TRUE;
		}   
	else{            
		CString szMsg;
		szMsg.LoadString (IDS_NO_INDICATOR);
		AfxMessageBox (szMsg);    
		}
	}
else{	
	this->SetText(ID_WYNAME, szName);
	ptLoc->MarkNameForRte(szName);
	bExchanged = TRUE;
	}			
return bExchanged;  
}

/************************************************************************
 *  WayDlg.cpp				D o E x c h a n g e W a y N a m e 			*
 ************************************************************************/
void CWayDlg::OnExchangeWayName() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
BOOL bNameOK = FALSE;

this->GetText(ID_WYNAME, m_szName);		

if (m_szName.GetLength() > 0)
	{
	CLocation Loc = m_ActWpt.GetLoc();

	long lIndex;
	BOOL	bCaseSensitive=TRUE;
	if (m_ptNameList->GetSortedInd ((LPCTSTR)m_szName, &lIndex, bCaseSensitive))
		{
		short	nRegIndex;
		bNameOK = m_ptNameList->GetLoc (&Loc, lIndex, &nRegIndex);
		}
	else{			   //  does actual name belongs to act wpt?
		bNameOK = ((m_szName.Compare (Loc.GetName()) == 0) ||
				(m_szName.Compare (Loc.GetIndicator()) == 0) );
		}

	if (bNameOK)
		{
//		m_szCC = Loc.GetCountryName();
		this->DoExchangeName (&Loc, m_szName);
//		m_ActWpt.SetLoc (Loc);
		}
	else{
		CString szMsg = this->Format (IDF_UNKNOWN_LOC, m_szName);
   		AfxMessageBox (szMsg);
		}
	}
this->SelectItem (ID_WYNAME);
}

/************************************************************************
 *  WayDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CWayDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

