#ifndef __WAYDOC__
#define __WAYDOC__

// waydoc.h : interface of the CWayDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "WayPoint.h"


#define WY_REVERSE		1
#define WY_UPDOWN		2
#define WY_SEMI			4
#define WY_ORTHO		8
#define WY_AUTO			16
#define WY_ELEV			32
#define WY_ALTERNATES	64

typedef struct
{
	char	szName[SIZEOF_ORT];
	short	nCategory;			// WP_NDB or WP_VOR
} FACILITY;

typedef struct
{
	short		nWptIndex;		// index of waypoint, having following bearings:
	FACILITY	Facility[2];	// name and category of nav facilities
} BEARINGUPDATE;
	
typedef struct 
	{
	char szVersion[14];
	unsigned char cFlags;			// WY_REVERSE, WY_UPDOWN, ...
	unsigned char cDummy;
	short	nWptCnt;
	short	nDummy2;
	} WAYHEADER; 


#define	LEVEL_SIZE		6
#define	ROUTE_SIZE		256
#define	ALTERNATE_SIZE	5
#define	OTHER_INFO_SIZE	256

typedef struct
	{
	BOOL	bManual;
	char	szLevel[LEVEL_SIZE];
	char	szRoute[ROUTE_SIZE];
	char	szAlternate1[ALTERNATE_SIZE];
	char	szAlternate2[ALTERNATE_SIZE];
	char	szOtherInfo[OTHER_INFO_SIZE];
	} FLPLINFO;
 

class CBorder;
class CCalculate;
class CWayDoc : public CDocument
{
private:
	#define MAX_HEADER_SIZE 20
    
    WAYHEADER		m_Header;     
	CPtrArray		m_WayPts;
	FLPLINFO		m_FlPlInfo;
	CWayPoint		m_Alternate1;
	CWayPoint		m_Alternate2;

	short			m_nActIndex;
 	BOOL			m_bConverted; 
	BOOL			m_bAddHomeBase;
	CCalculate*		m_ptCalculation;

protected: // create from serialization only
	DECLARE_DYNCREATE(CWayDoc)

// Attributes
public:
// Operations
public:

// Implementation
public:
	CWayDoc();
	virtual ~CWayDoc();

	CWayDoc& operator =(const CWayDoc& doc);

	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = FALSE);

	BOOL InLegalArea();
	void CheckPlannedAlt();
	BOOL CheckAltOnWpts();
	BOOL CheckAltOnRte(BOOL bForAutoRoute);
	BOOL OptimizePlannedAlt();


	BOOL Update();
	void InvertRoute ();
	void CopyWpts (CPtrArray* ptDest, CPtrArray* ptSource);
	void DeleteArrayOf (CPtrArray* ptArray);

	void GetTimeRange (short* ptGridX, long* ptMinX, long* ptMaxX);
	void GetElevMapBorders (long* ptMinX, long* ptMaxX, 
					long* ptMinY, long* ptMaxY, 
					short* ptGridX, short* ptGridY);

	BOOL InsertOrtho ();
	void InsertSemi ();
	BOOL InsertUpDown ();
	void DeleteUpDown();
	void DeleteOrtho();
	void UpdateUpDown();
	void UpdateOrtho();


	void GetRoute (CPtrArray* ptWayList);
	void SetRoute (CPtrArray* ptWayList);
	BOOL GetMaxLocNameLen (CDC* pDC, BOOL bPair = FALSE);
	void GetMapBorder (CBorder* ptBorder, BOOL bShowNav);

	short GetWayPointCnt ();
	LPWAY GetWayPointPtr (short nIndex);
	BOOL GetWayPointPtr (short nIndex, CWayPoint* ptWayPt);
	BOOL GetAlternateWayPointPtr (short nID, CWayPoint* ptWayPt);
	void SetAlternateWayPointPtr (short nID, CWayPoint& WayPt);
	short GetAlternateCnt();

	BOOL GetActWayPointPtr (CWayPoint* ptWayPt);
	BOOL GetActLocationPtr (CLocation* ptLoc);
	BOOL GetActLatLonPtr (CLatLon* ptLatLon);

	void DeleteRoute ();

	BOOL SearchInRoute (CString szNameForRte, CWayPoint* ptWpt);
	BOOL FindBestName (char* ptName, short CmpLen);

	BOOL SameLocAround (short nIndex, CLocation Loc);
 	BOOL AppendWpt (CWayPoint WayPt);
	BOOL InsertWpt (short nIndex, CWayPoint WayPt);
	BOOL ChangeWpt (short nIndex, CWayPoint WayPt);
	BOOL DeleteWpt (short nIndex);

//	void SetActInd (short nIndex) { m_nActIndex = nIndex; }
	void SetActInd (short nIndex);
	short GetActInd () { return m_nActIndex; }


	BOOL WasConverted(){return m_bConverted;}     

	BOOL Change(CWnd* ptWnd);
	BOOL ReadFromGPS(CWnd* ptWnd);
	BOOL WriteToGPS(CWnd* ptWnd);
	CString CreateName();
	BOOL CategoryToGCAStype (short nCategory, CString* ptType);
	BOOL WriteToGCAS(CWnd* ptWnd);
	BOOL WriteToKML(CWnd* ptWnd);
	BOOL AutoRoute();
	void DeleteAutoRoute ();
	void DoCalcElev ();

	void SetWayName ();

	void DrawVariation (CDC* pDC, int X, int Y, int CharX, short nVar);
	double AverageAngle (double Angle1, double Angle2);
	double LabelDirection (short i, BOOL* ptRightAlign);

	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);
	void InitHeader ();
	void SetFlagBit (unsigned char* lpFlag, short BitMask, BOOL bSet);
	void SetHeaderFlag (short nBit, BOOL bState);
	BOOL GetHeaderFlag (short nBit);
	void NoHomeBase () { m_bAddHomeBase = FALSE; }

	BOOL SetPlAltToActAlt();
	BOOL SetActAltToPlAlt();

	void SetReverse (BOOL bActiv);
	void SetUpDown (BOOL bActiv); 
	void SetSemi (BOOL bActiv);
	void SetElev (BOOL bActiv);
	void SetOrtho (BOOL bActiv);
	BOOL SetAutoRoute (BOOL bActiv);
	void SetAlternates (BOOL bActiv);

	BOOL IsReverse ();
	BOOL IsUpDown ();
	BOOL IsSemi ();
	BOOL IsElev ();
	BOOL IsOrtho ();
	BOOL IsAutoRoute ();
	BOOL HasAlternates();


	CCalculate* GetCalculationPtr () { return m_ptCalculation; }

									// flight plan info for this route
	void SetFlPlManual(BOOL bSet) { m_FlPlInfo.bManual = bSet; }

	void SetFlightPlanParams (BOOL bManual, CString szLevel, CString szRoute,
						CString szAlternate1, CString szAlternate2, CString szOtherInfo);
	void SetLevel(CString szLevel);
	void SetRoute(CString szRoute);
	void SetAlternate(CString szAlternate, short nID);
	void SetOtherInfo(CString szOtherInfo);

	BOOL IsFlPlManual () { return m_FlPlInfo.bManual; }
	CString GetLevel();
	CString GetRoute();
	CString GetAlternate(short nID);
	CString GetOtherInfo();
	BOOL FlPlInfoChanged (BOOL		bManual,
						   CString szLevel,
						   CString szRoute,
						   CString szAlternate1,  
						   CString szAlternate2,  
						   CString szOtherInfo);


private:
	short GetWptCnt () { return m_Header.nWptCnt; }
	void SetWptCnt (short nCnt) { m_Header.nWptCnt = nCnt; }

	BOOL GetNearestFacility (CLocation ActLoc, CLocation* ptNavLoc, double* ptMinDist);
	void GetNewIndex (CLatLon NavLatLon, short Ind0, short* ptInd);
	BOOL GetNewPoint (CLocation Loc0, CLocation* ptLocX, CLocation Loc1, short Ind0);
	void AddNav (CLocation Loc0, CLocation LocX, CLocation Loc1, short Ind0);

	BOOL CreateAndGetBearList(CPtrArray* ptList);
	BOOL SetAndRemoveBearList(CPtrArray* ptList);

	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// Generated message map functions
protected:
	//{{AFX_MSG(CWayDoc)
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
