// WayKmlDoc.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"
#include "InitDoc.h"
#include "ColorDoc.h"
#include "WayKmlDoc.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CWayKmlDoc

IMPLEMENT_DYNCREATE(CWayKmlDoc, CXmlDocument)

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;

CWayKmlDoc::CWayKmlDoc()
{
	m_bConverted = FALSE;
	m_szExt = GetExt();
}


BOOL CWayKmlDoc::OnNewDocument()
{
	if (!CXmlDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}



CWayKmlDoc::~CWayKmlDoc()
{
	if (this->IsModified())  
	{
		CString szPath = this->GetPathName(); 
		this->OnSaveDocument (szPath);
	}
}

CString CWayKmlDoc::GetExt()
{
	CString szExt(".kml");
	return szExt;
}


BEGIN_MESSAGE_MAP(CWayKmlDoc, CXmlDocument)
	//{{AFX_MSG_MAP(CWayKmlDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Zuordnungsmakros ein und entfernt diese.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Diagnose CWayKmlDoc

#ifdef _DEBUG
void CWayKmlDoc::AssertValid() const
{
	CXmlDocument::AssertValid();
}

void CWayKmlDoc::Dump(CDumpContext& dc) const
{
	CXmlDocument::Dump(dc);
}
#endif //_DEBUG



/************************************************************************
 *  WayKmlDoc.cpp		D e l e t e C o n t e n t s						*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CWayKmlDoc::DeleteContents()
{

}

/************************************************************************
 *  WayKmlDoc.cpp					F i l e E x i s t s					*
 ************************************************************************/
BOOL CWayKmlDoc::FileExists (CString szFileName)
{
	BOOL	bFileOK = FALSE;
	CFileStatus status;

	if( CFile::GetStatus(szFileName, status ) )   // static function
		{
		bFileOK = TRUE;
		}

	return bFileOK;
}



/************************************************************************
 *  WayKmlDoc.cpp			C r e a t e W a y p o i n t T a g			*
 ************************************************************************/
CString CWayKmlDoc::CreateWaypointTag(CWayPoint* ptWay)
{
	CString LonLatAlt = "";

	if (ptWay != NULL)
	{
		double dLat, dLon;
		long	lAlt;
		
		dLat = ptWay->GetLat();
		dLon = ptWay->GetLon();
		ptWay->GetAltitude(&lAlt);

		LonLatAlt.Format("%3.16f,%2.16f,%5.16f\r\n", dLon, dLat, (double)lAlt);
	}
	

/*        8.6743927001953120,49.8083022079494600,0.0000000000000000
*/
	return LonLatAlt;
}
	
	
/************************************************************************
 *  WayKmlDoc.cpp			C r e a t e C o o r d i n a t e s T a g		*
 ************************************************************************/
void CWayKmlDoc::CreateCoordinatesTag(CWayDoc* ptWayDoc, CXmlTag* ptLineStringElem)
{
	CString wayPoints = "";
	short nCnt = ptWayDoc->GetWayPointCnt();
	for (int i=0; i<nCnt; i++)
	{
		CWayPoint	Way;
		if (ptWayDoc->GetWayPointPtr (i, &Way))
		{
			wayPoints += CreateWaypointTag(&Way);
		}
	}


	CXmlTag* ptCoordinatesElem=NULL;
	ptCoordinatesElem = AppendChildTag(ptLineStringElem, "coordinates", wayPoints);
	


   /*
	<coordinates>
				8.668212890625,49.81229016526223,0 
				8.674392700195312,49.80830220794946,0 
				8.661003112792969,49.806972815826086,0		
				8.665809631347656,49.81295479286886,0 
			</coordinates>
	*/
}


/************************************************************************
 *  WayKmlDoc.cpp			W a y D o c u m e n t T o D O M 			*
 *  uses a Way document to generate a DOM document						*
 ************************************************************************/
unsigned int CWayKmlDoc::WayDocumentToDOM(CWayDoc* ptWayDoc)
{
	CString szName = ptWayDoc->GetTitle();
					// cut .trk from name
	short nDot = szName.Find('.');
	if (nDot > 0)
		szName = szName.Left(nDot);
	else szName = "Unnamed";


	CString szNamespaceURI = "http://www.opengis.net/kml/2.2";
	this->CreateDOM("kml", szNamespaceURI);		// root - Tag: <kml>
	
//<?xml version="1.0" encoding="UTF-8" ?>

	this->SetVersion("1.0");
	this->SetEncoding("UTF-8");
//	this->SetStandalone(FALSE);
//<?xml version="1.0" encoding="UTF-8" standalone="no" ?>


	CXmlTag* ptRootElem=NULL;
	ptRootElem = this->GetRootTag();		// created in CreateDOM
	if (ptRootElem != NULL)
	{
		AppendAttribute(ptRootElem, "xmlns:gx", "http://www.google.com/kml/ext/2.2");
		AppendAttribute(ptRootElem, "xmlns:kml", "http://www.opengis.net/kml/2.2");
		AppendAttribute(ptRootElem, "xmlns:atom", "http://www.w3.org/2005/Atom");


		CXmlTag* ptDocumentElem=NULL;
		ptDocumentElem = AppendChildTag(ptRootElem, "Document");
		if (ptDocumentElem != NULL)
		{
			CXmlTag* ptTitleElem=NULL;
			ptTitleElem = AppendChildTag(ptDocumentElem, "name", szName);

			CXmlTag* ptPlacemarkElem=NULL;
			ptPlacemarkElem = AppendChildTag(ptDocumentElem, "Placemark");
			if (ptPlacemarkElem != NULL)
			{
				CXmlTag* ptNameElem=NULL;
				ptNameElem = AppendChildTag(ptPlacemarkElem, "name", szName);


				CXmlTag* ptStyleElem=NULL;
				ptStyleElem = AppendChildTag(ptPlacemarkElem, "Style");
				if (ptStyleElem != NULL)
				{
					CXmlTag* ptLineStyleElem=NULL;
					ptLineStyleElem = AppendChildTag(ptStyleElem, "LineStyle");
					if (ptLineStyleElem != NULL)
					{
												// get line parameters from Color Pref Dialog
						CColorDoc* ptColor = ptInit->GetColorPtr();				
						// kml:Color = OOBBGGRR,where OO = 0-255 opaque

						CXmlTag* ptColorElem=NULL;
						ptColorElem = AppendChildTag(ptLineStyleElem, "color", ptColor->GetKmlLineColor());

						CXmlTag* ptWidthElem=NULL;
						ptWidthElem = AppendChildTag(ptLineStyleElem, "width", ptColor->GetKmlLineWidth());


						//<Document>
						//	<Name>5KM_Runde</Name>
						//  <Placemark>
						//		<Name>5KM_Runde</Name>
						//		<Style>
						//			<LineStyle>
						//				<color>
						//				<width>       
					}
			
				}


				CXmlTag* ptLineStringElem=NULL;
				ptLineStringElem = AppendChildTag(ptPlacemarkElem, "LineString");
				if (ptLineStringElem != NULL)
				{
					CXmlTag* ptTessellateElem=NULL;
					ptTessellateElem = AppendChildTag(ptLineStringElem, "tessellate", "1");

						//<Document>
						//	<Name>5KM_Runde</Name>
						//  <Placemark>
						//		<Name>5KM_Runde</Name>
						//		<Style>
						//			<color>
						//			<width> 
						//		</Style>
						//		<LineString>
					CreateCoordinatesTag(ptWayDoc, ptLineStringElem);
				}
			}
		}
	}


    // Now count the number of elements in the above DOM tree.
    unsigned int elementCount = GetElementCnt();

	if (elementCount > 0)
	{
		this->SetModifiedFlag(TRUE);

	//	CString szMsg;
	//	szMsg.Format("Anzahl der Elemente im DOM = %d", elementCount);
	//	AfxMessageBox(szMsg);
	}


	return elementCount;
}


/************************************************************************
 *  WayKmlDoc.cpp			C o n v e r t F r o m W a y D o c	 		*
 *  uses a Way document to generate a XML file							*
 ************************************************************************/
BOOL CWayKmlDoc::ConvertFromWayDoc(CWayDoc* ptWayDoc, CString szXMLDestFile)
{
	BOOL errorOccurred = FALSE;
	this->SetPathName(szXMLDestFile);

	unsigned int elementCnt = WayDocumentToDOM(ptWayDoc);
	errorOccurred = (elementCnt == 0);

    return (errorOccurred)? FALSE : TRUE;
}


/************************************************************************
 *  WayKmlDoc.cpp			C r e a t e W a y P o i n t					*
 ************************************************************************/
BOOL CWayKmlDoc::CreateWayPoint(CString szPosition, CWayPoint* ptWayPt, 
									BOOL bStart)
{
	BOOL bPositionCreated	= FALSE;
	BOOL bAltCreated		= FALSE;

	double	dLat	= NO_KOORD;
	double	dLon	= NO_KOORD;
	long	lAlt_m	= NO_ALT;


	// szPosition = "8.668212890625,49.81229016526223,0"
	float fLat, fLon;
	int nAlt;
	
	int ret = sscanf((LPCTSTR)szPosition, "%f,%f,%d", &fLon, &fLat, &nAlt);
	if (ret == 3)
	{
		// store waypoint position here...
		dLat = fLat;
		dLon = fLon;
		bPositionCreated = TRUE;

		lAlt_m = nAlt;
		bAltCreated = TRUE;
	}

			// set params of WayPoint here...
	ptWayPt->SetLatLon(dLat, dLon);
	ptWayPt->SetAltitude (lAlt_m);			// in DIM_METER
	ptWayPt->SetAltDim(DIM_METER);

	return bPositionCreated;
}


/************************************************************************
 *  WayKmlDoc.cpp			R e a d L i n e S t y l e N o d e 		 	*
 ************************************************************************/
void CWayKmlDoc::ReadLineStyleNode(CXmlTag* ptNode)
{
/*
		<LineStyle>
			<color>ffdf967a</color>
			<width>3</width>
		</LineStyle>
*/
	CString szColor="";
	int		nWidth=0;

	CPtrArray ChildNodes; 
	GetChildNodes(ptNode, "*", &ChildNodes);
	for(int c=0; c<ChildNodes.GetSize(); c++)
	{
		CXmlTag* ptChildNode;
		ptChildNode = (CXmlTag*)ChildNodes.GetAt(c);
		if (ptChildNode != NULL) 
		{
			CString szNodeName = GetNodeName(ptChildNode);
			if (szNodeName.Compare("color")==0)
				szColor = GetNodeText(ptChildNode);
			if (szNodeName.Compare("width")==0)
				nWidth = atoi((LPCTSTR)GetNodeText(ptChildNode));
		}
	}

}

/************************************************************************
 *  WayKmlDoc.cpp			R e a d S t y l e N o d e 		 			*
 ************************************************************************/
void CWayKmlDoc::ReadStyleNode(CXmlTag* ptNode)
{
/*
	<Style id="roadStyle">
		<LineStyle>
			<color>ffdf967a</color>
			<width>3</width>
		</LineStyle>
	</Style>
*/

	CString StyleId = GetAttrText(ptNode, "id");

	CPtrArray ChildNodes; 
	GetChildNodes(ptNode, "*", &ChildNodes);
	for(int c=0; c<ChildNodes.GetSize(); c++)
	{
		CXmlTag* ptChildNode;
		ptChildNode = (CXmlTag*)ChildNodes.GetAt(c);
		if (ptChildNode != NULL) 
		{
			CString szNodeName = GetNodeName(ptChildNode);
			if (szNodeName.Compare("LineStyle") == 0)
				ReadLineStyleNode(ptChildNode);
		}
	}
}



/************************************************************************
 *  WayKmlDoc.cpp			R e a d R e a d C o o r d i n a t e s		 *
 ************************************************************************/
void CWayKmlDoc::ReadCoordinates(CXmlTag* ptNode, BOOL bStart, CWayDoc* ptWayDoc)
{
/*
	
			<coordinates>8.668212890625,49.81229016526223,0 8.674392700195312,49.80830220794946,0 8.685035705566406,49.80431392204892,0 8.683662414550781,49.80187647445901,0 
				8.6846923828125,49.798774090950495,0 8.681602478027344,49.796557981024336,0 8.676795959472656,49.791238903393086,0 8.677139282226562,49.78747086993506,0 8.67919921875,49.783259191537525,0 
				8.678512573242188,49.78015561525539,0 8.682289123535156,49.775056451193535,0 8.682289123535156,49.77017848780969,0 8.683662414550781,49.7655217920384,0 8.690872192382812,49.75975573936961,0 
				8.696022033691406,49.757981431353606,0 8.696022033691406,49.75531984759418,0 8.699798583984375,49.75376718960535,0 8.69842529296875,49.7515490205328,0 8.698081970214844,49.74866524907081,0 
				8.701515197753906,49.74777790028142,0 8.707008361816406,49.742675329731235,0 8.701171875,49.742675329731235,0 8.695335388183594,49.742675329731235,0 8.694305419921875,49.740678525595406,0 
				8.688125610351562,49.74023478018285,0 8.685379028320312,49.73757222248364,0 8.680229187011719,49.7366846707841,0 8.670616149902344,49.73047135434793,0 8.663749694824219,49.73135901968289,0 
				8.658943176269531,49.73135901968289,0 8.657569885253906,49.73335620733158,0 8.658256530761719,49.73557520833146,0 8.655853271484375,49.73979103071204,0 8.652420043945312,49.74134413610505,0 
				8.652420043945312,49.74533760741243,0 8.644523620605469,49.74955258162795,0 8.644180297851562,49.7508835500284,0 8.640403747558594,49.75132719804583,0 8.63800048828125,49.75354537726328,0 
				8.634567260742188,49.75620705841216,0 8.644523620605469,49.763082391907595,0 8.644180297851562,49.766630569702954,0 8.646240234375,49.77306098005909,0 8.648643493652344,49.78237247574327,0 
				8.647613525390625,49.79722282465156,0 8.645210266113281,49.79988210788039,0 8.648300170898438,49.80298442039457,0 8.656196594238281,49.80209806567449,0 8.661003112792969,49.806972815826086,0 
				8.665809631347656,49.81295479286886,0 
			</coordinates>
*/

	CString szNodeText = GetNodeText(ptNode);

	int nStartPos = 0;
	int nEndPos = 0;
	BOOL bContinue = TRUE;
	int nPositionCnt = 0;
	do
	{
		nEndPos = szNodeText.Find((TCHAR)' ', nStartPos);	// get end of current position

		if (nEndPos > -1)
		{
			if (nEndPos <= nStartPos+2)
			{
				// more than one space between positions
				int s=2;
			}
			else
			{		// should be good endPos
				CString szPosition = szNodeText.Mid(nStartPos, nEndPos - nStartPos);


				CWayPoint WayPt;
				if (CreateWayPoint(szPosition, &WayPt, bStart))
				{
					bStart = FALSE;
					if (ptWayDoc->AppendWpt (WayPt))
						nPositionCnt++;

				}
			}

			nStartPos = nEndPos+1;
		}
		else
		{
			bContinue = FALSE;

			CString szMsg;
			szMsg.Format("%d Positionen gefunden", nPositionCnt);
			AfxMessageBox (szMsg);
		}

	} while (bContinue);
}

/************************************************************************
 *  WayKmlDoc.cpp			R e a d L i n e S t r i n g N o d e 		 *
 ************************************************************************/
void CWayKmlDoc::ReadLineStringNode(CXmlTag* ptNode, BOOL bStart, CWayDoc* ptWayDoc)
{
/*
		<LineString>
			<coordinates>8.668212890625,49.81229016526223,0 8.674392700195312,49.80830220794946,0 8.685035705566406,49.80431392204892,0 8.683662414550781,49.80187647445901,0 
				8.6846923828125,49.798774090950495,0 8.681602478027344,49.796557981024336,0 8.676795959472656,49.791238903393086,0 8.677139282226562,49.78747086993506,0 8.67919921875,49.783259191537525,0 
				8.678512573242188,49.78015561525539,0 8.682289123535156,49.775056451193535,0 8.682289123535156,49.77017848780969,0 8.683662414550781,49.7655217920384,0 8.690872192382812,49.75975573936961,0 
				8.696022033691406,49.757981431353606,0 8.696022033691406,49.75531984759418,0 8.699798583984375,49.75376718960535,0 8.69842529296875,49.7515490205328,0 8.698081970214844,49.74866524907081,0 
				8.701515197753906,49.74777790028142,0 8.707008361816406,49.742675329731235,0 8.701171875,49.742675329731235,0 8.695335388183594,49.742675329731235,0 8.694305419921875,49.740678525595406,0 
				8.688125610351562,49.74023478018285,0 8.685379028320312,49.73757222248364,0 8.680229187011719,49.7366846707841,0 8.670616149902344,49.73047135434793,0 8.663749694824219,49.73135901968289,0 
				8.658943176269531,49.73135901968289,0 8.657569885253906,49.73335620733158,0 8.658256530761719,49.73557520833146,0 8.655853271484375,49.73979103071204,0 8.652420043945312,49.74134413610505,0 
				8.652420043945312,49.74533760741243,0 8.644523620605469,49.74955258162795,0 8.644180297851562,49.7508835500284,0 8.640403747558594,49.75132719804583,0 8.63800048828125,49.75354537726328,0 
				8.634567260742188,49.75620705841216,0 8.644523620605469,49.763082391907595,0 8.644180297851562,49.766630569702954,0 8.646240234375,49.77306098005909,0 8.648643493652344,49.78237247574327,0 
				8.647613525390625,49.79722282465156,0 8.645210266113281,49.79988210788039,0 8.648300170898438,49.80298442039457,0 8.656196594238281,49.80209806567449,0 8.661003112792969,49.806972815826086,0 
				8.665809631347656,49.81295479286886,0 
			</coordinates>
		</LineString>
*/

	CPtrArray ChildNodes; 
	GetChildNodes(ptNode, "*", &ChildNodes);
	for(int c=0; c<ChildNodes.GetSize(); c++)
	{
		CXmlTag* ptChildNode;
		ptChildNode = (CXmlTag*)ChildNodes.GetAt(c);
		if (ptChildNode != NULL) 
		{
			CString szNodeName = GetNodeName(ptChildNode);
			if (szNodeName.Compare("coordinates") == 0)
				ReadCoordinates(ptChildNode, bStart, ptWayDoc);
		}
	}
}

/************************************************************************
 *  WayKmlDoc.cpp			R e a d P l a c e m a r k N o d e 		 	*
 ************************************************************************/
void CWayKmlDoc::ReadPlacemarkNode(CXmlTag* ptNode)
{
/*
	<Placemark>
		<name>Route</name>
		<visibility>1</visibility>
		<description>
						Distance: 24.8 km
						&lt;br/&gt;Total Time:
						0h
						59min
						34s
						&lt;br/&gt;Avg. Speed: 25 km/h
						
						&lt;br/&gt;&lt;br/&gt;Gourse generated 2007-09-20 06:53:33 GMT by http://www.guideserv.com/ClickRoute
		</description>
		<styleUrl>#redLine</styleUrl>
		<LineString>
			<coordinates>8.668212890625,49.81229016526223,0 8.674392700195312,49.80830220794946,0 8.685035705566406,49.80431392204892,0 8.683662414550781,49.80187647445901,0 
				8.6846923828125,49.798774090950495,0 8.681602478027344,49.796557981024336,0 8.676795959472656,49.791238903393086,0 8.677139282226562,49.78747086993506,0 8.67919921875,49.783259191537525,0 
				8.678512573242188,49.78015561525539,0 8.682289123535156,49.775056451193535,0 8.682289123535156,49.77017848780969,0 8.683662414550781,49.7655217920384,0 8.690872192382812,49.75975573936961,0 
				8.696022033691406,49.757981431353606,0 8.696022033691406,49.75531984759418,0 8.699798583984375,49.75376718960535,0 8.69842529296875,49.7515490205328,0 8.698081970214844,49.74866524907081,0 
				8.701515197753906,49.74777790028142,0 8.707008361816406,49.742675329731235,0 8.701171875,49.742675329731235,0 8.695335388183594,49.742675329731235,0 8.694305419921875,49.740678525595406,0 
				8.688125610351562,49.74023478018285,0 8.685379028320312,49.73757222248364,0 8.680229187011719,49.7366846707841,0 8.670616149902344,49.73047135434793,0 8.663749694824219,49.73135901968289,0 
				8.658943176269531,49.73135901968289,0 8.657569885253906,49.73335620733158,0 8.658256530761719,49.73557520833146,0 8.655853271484375,49.73979103071204,0 8.652420043945312,49.74134413610505,0 
				8.652420043945312,49.74533760741243,0 8.644523620605469,49.74955258162795,0 8.644180297851562,49.7508835500284,0 8.640403747558594,49.75132719804583,0 8.63800048828125,49.75354537726328,0 
				8.634567260742188,49.75620705841216,0 8.644523620605469,49.763082391907595,0 8.644180297851562,49.766630569702954,0 8.646240234375,49.77306098005909,0 8.648643493652344,49.78237247574327,0 
				8.647613525390625,49.79722282465156,0 8.645210266113281,49.79988210788039,0 8.648300170898438,49.80298442039457,0 8.656196594238281,49.80209806567449,0 8.661003112792969,49.806972815826086,0 
				8.665809631347656,49.81295479286886,0 
			</coordinates>
		</LineString>
	</Placemark>
*/


	CWayDoc* ptWayDoc = new CWayDoc();
	if (ptWayDoc != NULL)
	{
		ptWayDoc->SetTitle(m_szWayName);

		BOOL	bStart = TRUE;

		CString szName;
		int	nVisibility;
		CString szDescription;
		CString szStyleURL;

		CPtrArray ChildNodes; 
		GetChildNodes(ptNode, "*", &ChildNodes);
		for(int c=0; c<ChildNodes.GetSize(); c++)
		{
			CXmlTag* ptChildNode;
			ptChildNode = (CXmlTag*)ChildNodes.GetAt(c);
			if (ptChildNode != NULL) 
			{
				CString szNodeName = GetNodeName(ptChildNode);

				if (szNodeName.Compare("name") == 0)
					szName = GetNodeText(ptChildNode);
				if (szNodeName.Compare("visibility")==0)
					nVisibility = atoi((LPCTSTR)GetNodeText(ptChildNode));

				if (szNodeName.Compare("description")==0)
					szDescription = GetNodeText(ptChildNode);
				if (szNodeName.Compare("styleUrl")==0)
					szStyleURL = GetNodeText(ptChildNode);

				if (szNodeName.Compare("LineString") == 0)
					ReadLineStringNode(ptChildNode, bStart, ptWayDoc);
			}
		}


		ptWayDoc->SetModifiedFlag (TRUE);
		if (ptWayDoc->GetWayPointCnt() > 0)
		{
									// first try to use date to get name
			CString szFullPath  = ptWayDoc->GetPathName();
			if (ptWayDoc->OnSaveDocument(szFullPath))
				AfxMessageBox (szFullPath + " gespeichert!");
		}

		delete ptWayDoc;
	} // ptWayDoc
}


/************************************************************************
 *  WayKmlDoc.cpp			G e t F o l d e r N o d e s		 			*
 ************************************************************************/
void CWayKmlDoc::GetFolderNodes(CXmlTag* ptParentNode)
{
	int nCnt = 0;
	CPtrArray FolderNodes;
	int cnt = GetChildNodes(ptParentNode, 
						"Folder", &FolderNodes);
	CXmlTag* ptNode;
	for(int j=0; j<FolderNodes.GetSize(); j++)
	{
		ptNode = (CXmlTag*)FolderNodes.GetAt(j);
		if (ptNode != NULL) 
		{
			CString szWayName;

			CPtrArray ChildNodes; 
			GetChildNodes(ptNode, "*", &ChildNodes);
			for(int c=0; c<ChildNodes.GetSize(); c++)
			{
				CXmlTag* ptChildNode;
				ptChildNode = (CXmlTag*)ChildNodes.GetAt(c);
				if (ptChildNode != NULL) 
				{
					CString szNodeName = GetNodeName(ptChildNode);

					if (szNodeName.Compare("name") == 0)
						szWayName = GetNodeText(ptChildNode);

					if (szNodeName.Compare("open") == 0)
					{
						CString szOpen = GetNodeText(ptChildNode);
						if (szOpen.Compare("1") == 0)
						{  // convert to WayDoc

						}
						else if (szOpen.Compare("false") == 0)
						{	// no further actions required in this folder

						}
						else
						{	// unknown open value
							CString szWarning;
							szWarning.Format("Unknown open value: %s",
								(LPCTSTR)szOpen);
							AfxMessageBox(szWarning);
						}
					}

					if (szNodeName.Compare("Style") == 0)
						ReadStyleNode(ptChildNode);

					if (szNodeName.Compare("Placemark") == 0)
						ReadPlacemarkNode(ptChildNode);

					if (szNodeName.Compare("Folder") == 0)
					{		// subfolder found, will be handled by GetFolderNodes
					}		// see function after childNode loop
				}
			}	// for ChildNodes

				// look for further folder nodes and handle their content
			GetFolderNodes(ptNode);
		} // ptNode
	} // for FolderNodes
}


/************************************************************************
 *  WayKmlDoc.cpp			C o n v e r t T o T r a c k D o c 			*
 *  uses DOMBuilder
 *  creates a DOM document												*
 ************************************************************************/
BOOL CWayKmlDoc::ConvertToWayDoc(CString szXMLSourceFile)
{
	BOOL errorOccurred = FALSE;

	    // And create our error handler

	CXmlTag* ptDoc = ParseXML(szXMLSourceFile);
	if (ptDoc != NULL)
	{
			int nFirst = 0;
			int nLast = szXMLSourceFile.GetLength();

			int nSlash = szXMLSourceFile.ReverseFind((TCHAR)'\\');
			if (nSlash > -1)
			{
				nFirst = nSlash+1;

				int nDot = szXMLSourceFile.ReverseFind((TCHAR)'.');
				if (nDot > nFirst)	nLast = nDot;
			}

			m_szWayName = szXMLSourceFile.Mid(nFirst, nLast-nFirst);

			GetFolderNodes(ptDoc);
    
		delete ptDoc;
	} // ptDoc != NULL

    return (errorOccurred)? FALSE : TRUE;
}

/************************************************************************
 *  WayKmlDoc.cpp		O n O p e n D o c u m e n t						*
 ************************************************************************/
BOOL CWayKmlDoc::OnOpenDocument(LPCTSTR pszPathName)
{
	BOOL bOpened = FALSE;

	if (FileExists(pszPathName))
		bOpened = CXmlDocument::OnOpenDocument(pszPathName); 

	if (bOpened)
	{
		if (m_bConverted)
		{
			if (this->OnSaveDocument (pszPathName, FALSE))		// don't confirm
			{
			m_bConverted = FALSE;
//			if (ptInit->IsSaveSignal())
//				MessageBeep(MB_OK);	
			}
		}
	}

	// even if main document isn't present at the moment, create new child doc!!

						// separate path from fullPath
	CString szFullPath = this->GetPathName();
	short	nNameIndex = szFullPath.ReverseFind('\\') + 1;
	CString szPath = szFullPath.Left (nNameIndex);  /* "D:\Code\Cpp_Win\PF40\"	*/


/*
	m_ptSegmentDoc->OnNewDocument(); 			// deletes old structures   
	m_ptSegmentDoc->SetTitle(szRegionName + m_ptSegmentDoc->GetExt());
	m_ptSegmentDoc->SetPathName(szPath + m_ptSegmentDoc->GetTitle());
	m_ptSegmentDoc->OnOpenDocument (m_ptSegmentDoc->GetPathName());
*/
	return bOpened;
}


/************************************************************************
 *  WayKmlDoc.cpp			O n S a v e D o c u m e n t					*
 ************************************************************************/
BOOL CWayKmlDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
	BOOL bSaved = FALSE;
	BOOL bDoSave;

	if (bConfirm)
	{
		CString szText;
		CString szFileExt = this->GetTitle();
		szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
		bDoSave = (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES);
	}
	else
	{
		bDoSave = TRUE;
	}

	if (bDoSave)
	{
		bSaved = CXmlDocument::OnSaveDocument(pszPathName); 
		this->SetModifiedFlag (FALSE);
	}        
	else
	{   
		this->SetModifiedFlag (FALSE);
	}

	return bSaved;
}


/************************************************************************
 *  WayKmlDoc.cpp  	 		S e r i a l i z e		 				*
 ************************************************************************/
void CWayKmlDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// ZU ERLEDIGEN: Code zum Speichern hier einfgen
		CXmlDocument::Serialize(ar);
		m_bConverted = FALSE;
	}
	else
	{
		m_bConverted = FALSE;

		// ZU ERLEDIGEN: Code zum Laden hier einfgen
		CXmlDocument::Serialize(ar);
	}
}

/////////////////////////////////////////////////////////////////////////////
// Befehle CWayKmlDoc 
