#if !defined(__WayKmlDoc__)
#define __WayKmlDoc__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AirspaceDoc.h : Header-Datei
//


#include "LatLon.h"						// DRECT
#include "WayDoc.h"

#include "..\CPPTOOLS\XmlDocument.h"

/////////////////////////////////////////////////////////////////////////////
// Dokument CWayKmlDoc 


class CWayKmlDoc : public CXmlDocument
{
public:
	CWayKmlDoc();


protected:
	           // Dynamische Erstellung verwendet geschtzten Konstruktor
	DECLARE_DYNCREATE(CWayKmlDoc)



// Attribute
private:	
	CString			m_szWayName;

// Operationen
public:
	static CString GetExt();

	virtual void DeleteContents();
	BOOL ConvertToWayDoc(CString szXMLSourceFile);
	BOOL ConvertFromWayDoc(CWayDoc* ptWayDoc, CString szXMLDestFile);




// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CWayKmlDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
	virtual void Serialize(CArchive& ar);   // berschrieben fr Dokument-Ein-/Ausgabe
	protected:
	//}}AFX_VIRTUAL

private:
	BOOL FileExists (CString szFileName);
	
	// to read *.klm
	BOOL CreateWayPoint(CString szPosition, CWayPoint* ptTrkPt, BOOL bStart);
	void ReadLineStyleNode(CXmlTag* ptNode);
	void ReadStyleNode(CXmlTag* ptNode);
	void ReadCoordinates(CXmlTag* ptNode, BOOL bStart, CWayDoc* ptWayDoc);
	void ReadLineStringNode(CXmlTag* ptNode, BOOL bStart, CWayDoc* ptWayDoc);
	void ReadPlacemarkNode(CXmlTag* ptNode);

	void GetFolderNodes(CXmlTag* ptParentNode);
	// called from ConvertToWayDoc

	// to write *.klm

	CString CreateWaypointTag(CWayPoint* ptWay);
	void CreateCoordinatesTag(CWayDoc* ptWayDoc, CXmlTag* ptCourseElem);
	unsigned int WayDocumentToDOM(CWayDoc* ptWayDoc);
	// called from ConvertFromWayDoc


// Implementierung
public:
	virtual ~CWayKmlDoc();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


private:

	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	//{{AFX_MSG(CWayKmlDoc)
		// HINWEIS - Der Klassen-Assistent fgt hier Member-Funktionen ein und entfernt diese.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // __WayKmlDoc__
