/************************************************************************
 *  						W a y P o i n t . c p p	  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"
#include "InitDoc.h"
#include "WayPoint.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;
extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// CWayPoint

IMPLEMENT_SERIAL(CWayPoint, CLocation, 0 /* schema number*/ )

/************************************************************************
 *  WayPoint.cpp			 	C W a y P o i n t		Constructor		*
 ************************************************************************/
CWayPoint::CWayPoint(LPWAY lpWayPt) :
		CLocation ((lpWayPt == NULL)? NULL : &lpWayPt->Loc)
{ 
if (lpWayPt == NULL)
	{       
	this->FirstInit ();
	} 
else{
    this->ReadFromPtr (lpWayPt);  
    }
}

/************************************************************************
 *  WayPoint.cpp			 	C W a y P o i n t		Constructor		*
 ************************************************************************/
CWayPoint::CWayPoint(CWayPoint& SourceWpt)
{ 
*this = SourceWpt;
}

/************************************************************************
 *  WayPoint.cpp			 ~ C W a y P o i n t 		Destructor		*
 ************************************************************************/
CWayPoint::~CWayPoint()
{
} 


void CWayPoint::GetPtr(LPWAY lpWpt)
{
_fmemset (lpWpt, 0, sizeof (WAYTYPE));
CLocation::WriteToPtr (&lpWpt->Loc);
this->WriteToPtr (lpWpt);
}  

void CWayPoint::SetPtr (LPWAY lpWpt)
{
CLocation::ReadFromPtr (&lpWpt->Loc);
this->ReadFromPtr(lpWpt);
}  

/************************************************************************
 *  WayPoint.cpp				operator=								*
 ************************************************************************/
const CWayPoint& CWayPoint::operator=(const CWayPoint& Wpt)
{
//*((CLocation*)this) = (CLocation)Wpt;

										// begin copy of base class CLocation
_fmemcpy (m_szOrt, Wpt.m_szOrt, SIZEOF_ORT); 
((CLatLon*)this)->SetLat (Wpt.m_dLat);
((CLatLon*)this)->SetLon (Wpt.m_dLon); 
m_lMinAlt	= Wpt.m_lMinAlt;  
m_nVAR		= Wpt.m_nVAR;        
m_lFrq		= Wpt.m_lFrq;
m_nRwyLen	= Wpt.m_nRwyLen;      
m_nElevDiff	= Wpt.m_nElevDiff;
m_cRange	= Wpt.m_cRange;	
m_cFlag		= Wpt.m_cFlag;
			
_fmemcpy (m_szIndicator, Wpt.m_szIndicator, INDICATOR_SIZE);  

m_nElevDim	= Wpt.m_nElevDim;     
m_nDistDim	= Wpt.m_nDistDim;    
m_nLenDim	= Wpt.m_nLenDim;     
	           
m_nCountryCode	= Wpt.m_nCountryCode;
m_cType		= Wpt.m_cType;	
m_cDummy	= Wpt.m_cDummy;
m_nDiffDim  = Wpt.m_nDiffDim;    
m_lDummy	= Wpt.m_lDummy;
									// end copying CLocation





m_PlAlt		= Wpt.m_PlAlt;
m_ActAlt	= Wpt.m_ActAlt;
m_nAltDim	= Wpt.m_nAltDim;
m_dummy1	= Wpt.m_dummy1;	
m_ActIAS_kt	= Wpt.m_ActIAS_kt;
m_W_Dir		= Wpt.m_W_Dir;	
m_W_Speed	= Wpt.m_W_Speed;	
m_uFlags	= Wpt.m_uFlags;
m_uDummy2	= Wpt.m_uDummy2;

this->BearCopy (&m_Bearing1, Wpt.m_Bearing1);
this->BearCopy (&m_Bearing2, Wpt.m_Bearing2);

return *this;
}

/************************************************************************
 *  WayPoint.cpp				F i r s t I n i t						*
 ************************************************************************/
void CWayPoint::FirstInit ()
{
m_PlAlt		= NO_ALT;
m_ActAlt	= 0L;
m_nAltDim	= ptDim->Altitude();
m_dummy1	= 0L;
m_ActIAS_kt	= 0;
m_W_Dir		= 0;
m_W_Speed	= 0;
m_uFlags	= 0;			/* WT_ORTHO, WT_UPDOWN			*/
m_uDummy2	= 0;			/* Reserve						*/

this->DeleteBearing(0);		/* no bearing					*/
this->DeleteBearing(1);
}


/************************************************************************
 *  WayPoint.cpp				R e s e t								*
 ************************************************************************/
void CWayPoint::Reset (CString szName, short nVar, BYTE btFlag, long lPlAlt)
{
CLocation::Reset(szName, nVar, btFlag);
this->FirstInit();
this->SetPlannedAlt (lPlAlt);
}

/************************************************************************
 *  WayPoint.cpp				R e a d F r o m P t r 					*
 ************************************************************************/
void CWayPoint::ReadFromPtr (LPWAY lpWayPt)
{
m_PlAlt		= lpWayPt->PlAlt;
m_ActAlt	= lpWayPt->ActAlt;
m_nAltDim	= lpWayPt->nAltDim;
m_dummy1	= lpWayPt->dummy1;	
m_ActIAS_kt	= lpWayPt->ActIAS_kt;
m_W_Dir		= lpWayPt->W_Dir;	
m_W_Speed	= lpWayPt->W_Speed;	
m_uFlags	= lpWayPt->uFlags;
m_uDummy2	= lpWayPt->uDummy2;

this->BearCopy (&m_Bearing1, lpWayPt->Bearing1);
this->BearCopy (&m_Bearing2, lpWayPt->Bearing2);
}

/************************************************************************
 *  WayPoint.cpp				W r i t e T o P t r						*
 ************************************************************************/
void CWayPoint::WriteToPtr (LPWAY lpWayPt) const
{

lpWayPt->PlAlt	= m_PlAlt;
lpWayPt->ActAlt	= m_ActAlt;
lpWayPt->nAltDim= m_nAltDim;
lpWayPt->dummy1	= m_dummy1;
lpWayPt->ActIAS_kt = m_ActIAS_kt;
lpWayPt->W_Dir	= m_W_Dir;
lpWayPt->W_Speed= m_W_Speed; 
lpWayPt->uFlags	= m_uFlags;
lpWayPt->uDummy2= m_uDummy2;

this->BearCopy (&lpWayPt->Bearing1, m_Bearing1);
this->BearCopy (&lpWayPt->Bearing2, m_Bearing2);
}


/************************************************************************
 *  WayPoint.cpp				S e t L o c								*
 ************************************************************************/
void CWayPoint::SetLoc (CLocation& Loc)
{						   // 
*((CLocation*)this) = Loc;
}

/************************************************************************
 *  WayPoint.cpp				G e t L o c								*
 ************************************************************************/
void CWayPoint::GetLoc (CLocation* ptLoc)
{
*ptLoc = *((CLocation*)this);
}


/************************************************************************
 *  WayPoint.cpp				G e t L o c								*
 ************************************************************************/
CLocation CWayPoint::GetLoc ()
{
return *((CLocation*)this);
}


/************************************************************************
 *  WayPoint.cpp			G e t P l a n n e d A l t 					*
 ************************************************************************/
long CWayPoint::GetPlannedAlt(short nAltDim)
{
	return (long)(ptDim->ConvertDist(m_PlAlt, m_nAltDim, nAltDim) + 0.5);
}

/************************************************************************
 *  WayPoint.cpp		      B e a r C o p y							*
 ************************************************************************/
void CWayPoint::BearCopy (BEARTYPE* dest, const BEARTYPE& source)	const
{
_fstrcpy ((LPSTR)dest->Ort, (LPSTR)source.Ort);
dest->MC = (short)source.MC;
dest->Dist = (short)source.Dist;
dest->Frq = (long)source.Frq;
}


/************************************************************************
 *  WayPoint.cpp		      D e l e t e B e a r i n g 				*
 ************************************************************************/
void CWayPoint::DeleteBearing (short nIndex)
{
BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;

_fmemset ((LPSTR)ptBear->Ort, 0, SIZEOF_ORT);
ptBear->MC		= 0;
ptBear->Dist	= 0;
ptBear->Frq		= (long)NO_FREQ;
}

/************************************************************************
 *  WayPoint.cpp		      H a s B e a r i n g 						*
 ************************************************************************/
BOOL CWayPoint::HasBearing (short nIndex)
{
BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;

return (*(ptBear->Ort) != 0);
}


/************************************************************************
 *  WayPoint.cpp		      CalculateBearing 							*
 ************************************************************************/
void CWayPoint::CalculateBearing (short nIndex, CLocation& NavLoc)
{
BOOL bOK = FALSE;
float	fFreq;
double	Dist, Kurs;

BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;

Dist = NavLoc.LoxoDist (*this, &Kurs);

_fstrcpy ((LPSTR)ptBear->Ort, (LPCTSTR)NavLoc.GetName());
NavLoc.GetFrequency(&fFreq);
ptBear->Frq		= (long)(fFreq*1000 + 0.5);
ptBear->Dist	= (short)(Dist*10 + 0.5);
ptBear->MC		= (short)(Kurs - NavLoc.GetVariation());
if (ptBear->MC < 0)
	ptBear->MC += 360;
if (ptBear->MC > 360)
	ptBear->MC -= 360;
}


/************************************************************************
 *  WayPoint.cpp		      GetBearingName 							*
 ************************************************************************/
CString CWayPoint::GetBearingName (short nIndex)
{
BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;

return (CString)(ptBear->Ort);
}

/************************************************************************
 *	WayPoint.cpp	G e t B e a r N a m e A n d C a t					*
 ************************************************************************/										 
BOOL CWayPoint::GetBearNameAndCat (short nIndex, CString* ptName, short* ptCat)
{
BOOL bFound = FALSE;

if (nIndex==0 && *(m_Bearing1.Ort) > 0)
	{
	*ptName = (CString)(m_Bearing1.Ort);
	*ptCat = this->NavFreqToCat (m_Bearing1.Frq);
	bFound = TRUE;
	}

if (nIndex==1 && *(m_Bearing2.Ort) > 0)	
	{
	*ptName = (CString)(m_Bearing2.Ort);
	*ptCat = this->NavFreqToCat (m_Bearing2.Frq);
	bFound = TRUE;
	}
		
return bFound;
}

/************************************************************************
 *  WayPoint.cpp		      BearingIsEqual							*
 ************************************************************************/
BOOL CWayPoint::BearingIsEqual (const CWayPoint& Wpt, short nIndex)
{
BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;
BEARTYPE Bear = (nIndex==0)? Wpt.m_Bearing1 : Wpt.m_Bearing2;

if (_fstrcmp ((LPSTR)ptBear->Ort, (LPSTR)&Bear.Ort) != 0) 
								return FALSE;

if (ptBear->MC != Bear.MC)		return FALSE;
if (ptBear->Dist != Bear.Dist)	return FALSE;
if (ptBear->Frq != Bear.Frq)	return FALSE;

return TRUE;
}  


/************************************************************************
 *  WayPoint.cpp		      G e t B e a r S t r i n g					*
 ************************************************************************/
BOOL CWayPoint::GetBearString (short nIndex, CString* ptBearString)
{
	double	fConvert;
	CString	szFormat, szDimension;
	char	szBuffer[128];
	char	szForm[64];
	char	szDim[16];
	char	szOrt[SIZEOF_ORT];
	CString szQDM;

	BEARTYPE* ptBear = (nIndex==0)? &m_Bearing1 : &m_Bearing2;

	ptBearString->Empty();
	if (*(ptBear->Ort)==0) return FALSE;

	if (ptBear->Frq >= 108000 && ptBear->Frq <= 117970) /* VOR 1/1000 MHz	*/
		szFormat.LoadString (IDF_VOR_BEAR);

	if (ptBear->Frq >= 190000 && ptBear->Frq <= 1750000)/* NDB 1/1000 kHz	*/
	{
		szFormat.LoadString (IDF_NDB_BEAR);

		short nQDM = (short)ptBear->MC + 180;		// calculate QDM for NDBs
		if (nQDM >= 360) nQDM -= 360;
		szQDM.Format(" QDM: %03d", nQDM);
	}

	ptDim->GetDimCstring (&szDimension, ptDim->Distance());
	fConvert = ptDim->ConvertDist (ptBear->Dist, DIM_NM, ptDim->Distance());

							// avoid FAR pointers for sprintf
	_fstrcpy ((LPSTR)szForm, (LPCTSTR)szFormat);
	_fstrcpy ((LPSTR)szDim, (LPCTSTR)szDimension);
	_fstrcpy ((LPSTR)szOrt, (LPCTSTR)ptBear->Ort);

	sprintf (szBuffer, szForm,
						(short)ptBear->MC,
						(float)fConvert/10,
						szDim,
						szOrt,
						(float)ptBear->Frq/1000);

	*ptBearString = (CString)szBuffer; 
	(*ptBearString) += szQDM;		// szQDM is defines for NDBs only

	return TRUE;
}

/************************************************************************
 *  WayPoint.cpp    		 		S e t O r t h o						*
 ************************************************************************/
void CWayPoint::SetOrtho(BOOL bOrtho)
{   
SetFlagBit (&m_uFlags, WT_ORTHO, bOrtho);
}

				
/************************************************************************
 *  WayPoint.cpp    		 		S e t U p							*
 ************************************************************************/
void CWayPoint::SetUp(BOOL bUp)
{   
SetFlagBit (&m_uFlags, WT_UP, bUp);
}

/************************************************************************
 *  WayPoint.cpp    		 		S e t D o w n						*
 ************************************************************************/
void CWayPoint::SetDown(BOOL bDown)
{   
SetFlagBit (&m_uFlags, WT_DOWN, bDown);
}

/************************************************************************
 *  WayPoint.cpp    		 	S e t A u t o R o u t e					*
 ************************************************************************/
void CWayPoint::SetAutoRoute(BOOL bAutoRouting)
{   
SetFlagBit (&m_uFlags, WT_AUTO, bAutoRouting);
}

/************************************************************************
 *  WayPoint.cpp    		 	S e t E l e v							*
 ************************************************************************/
void CWayPoint::SetElev(BOOL bElev)
{   
SetFlagBit (&m_uFlags, WT_ELEV, bElev);
}


/************************************************************************
 *  WayPoint.cpp    		 		I s O r t h o						*
 ************************************************************************/
BOOL CWayPoint::IsOrtho()
{
BOOL bOrtho = ((m_uFlags & WT_ORTHO) == WT_ORTHO);
return bOrtho;
}

/************************************************************************
 *  WayPoint.cpp    		 		I s U p								*
 ************************************************************************/
BOOL CWayPoint::IsUp()
{
BOOL bUp = ((m_uFlags & WT_UP) == WT_UP);
return bUp;
}

/************************************************************************
 *  WayPoint.cpp    		 		I s D o w n							*
 ************************************************************************/
BOOL CWayPoint::IsDown()
{
BOOL bDown = ((m_uFlags & WT_DOWN) == WT_DOWN);
return bDown;
}

/************************************************************************
 *  WayPoint.cpp    		 		I s U p D o w n						*
 ************************************************************************/
BOOL CWayPoint::IsUpDown()
{
BOOL bUpDown = (((m_uFlags & WT_UP  ) == WT_UP  ) ||
				((m_uFlags & WT_DOWN) == WT_DOWN));
return bUpDown;
}


/************************************************************************
 *  WayPoint.cpp    		 	I s A u t o R o u t e					*
 ************************************************************************/
BOOL CWayPoint::IsAutoRoute()
{
BOOL bAutoRouting = ((m_uFlags & WT_AUTO) == WT_AUTO);
return bAutoRouting;
}

/************************************************************************
 *  WayPoint.cpp    		 	I s E l e v								*
 ************************************************************************/
BOOL CWayPoint::IsElev()
{
BOOL bElev = ((m_uFlags & WT_ELEV) == WT_ELEV);
return bElev;
}

/************************************************************************
 *  WayPoint.cpp    		 	S e r i a l i z e						*
 ************************************************************************/
void CWayPoint::Serialize(CArchive& ar, short nReadWayVers)
{ 
if (ar.IsStoring())
	{
		// TODO: add storing code here 
	CLocation::Serialize(ar);

	ar << m_PlAlt;	
    ar << (WORD)m_nAltDim;
	ar << m_ActAlt;	
	ar << m_dummy1;	
    ar << (WORD)m_ActIAS_kt;
    ar << (WORD)m_W_Dir;
    ar << (WORD)m_W_Speed;
	ar << (BYTE)m_uFlags;
	ar << (BYTE)m_uDummy2;
	ar.Write (&m_Bearing1, sizeof(BEARTYPE)); 
	ar.Write (&m_Bearing2, sizeof(BEARTYPE)); 
	}
else{ 					// TODO: add loading code here    
	BYTE	Byte;
	WORD	Word;
	short	nCC, nLocVers;
	nCC = 0;

	switch (nReadWayVers)
		{
		case 1:	nLocVers = 1; break;	// PreFlight 1.10, 2.00
		case 2:	nLocVers = 3; break;	// PF 2.1: WAYTYPE21 KOORDTYPE21
		case 3:	nLocVers = 3; break;	// PF 2.2: WAYTYPE21 KOORDTYPE21
		case 4:	nLocVers = 4; break;	// PF 2.23
		case 5:	nLocVers = 4; break;	// PF 3.0  (nLocVers=4)
		case 6:	nLocVers = ACT_KOORD_VERS; break; // PF 4.1  (nLocVers=5)
		}
		 
	CLocation::Serialize(ar, nLocVers, nCC);
	
	if (nReadWayVers == 1)    
		{ 						// loading version 1 database   (WAYTYPE1)
		ar >> m_PlAlt;					/* geplante Flughoehe					*/
		ar >> m_ActAlt;					/* aktuelle Flughoehe aus InsertUpDown	*/
		ar >> m_dummy1;					/* 4 Bytes reserviert					*/
		ar >> Word;		m_ActIAS_kt = (short)Word;
		ar >> Word;		m_W_Dir = (short)Word;		// Wind direction
		ar >> Word;		m_W_Speed = (short)Word;	// Wind Speed
		ar >> Word;		m_uDummy2 = (unsigned char)Word;
	    ar.Read (&m_Bearing1, sizeof(BEARTYPE));   
 		ar.Read (&m_Bearing2, sizeof(BEARTYPE)); 

		m_nAltDim   = DIM_FEET;
		m_uFlags	= 0;						/* WT_ORTHO, WT_UPDOWN	*/
		m_uDummy2	= 0;
 	    }  
	    
	if (nReadWayVers <= 2)
		{
		CString szOldName = this->GetName();
		short nCategory = this->GetCategory ();
		this->NameCatToLoc (szOldName, nCategory, (CLocation*)this);
		}


 	if ((nReadWayVers == 2) || (nReadWayVers == 3) || (nReadWayVers == 4) || (nReadWayVers == 5) ||
		(nReadWayVers == ACT_WAY_VERS))
	    {     
		ar >> m_PlAlt;					/* geplante Flughoehe					*/
		ar >> Word;		m_nAltDim = (short)Word;
		ar >> m_ActAlt;					/* aktuelle Flughoehe aus InsertUpDown	*/
		ar >> m_dummy1;					/* 4 Bytes reserviert					*/
										/* aktuelle Geschw. aus InsertUpDown	*/
		ar >> Word;		m_ActIAS_kt = (short)Word;
		ar >> Word;		m_W_Dir = (short)Word;		// Wind direction
		ar >> Word;		m_W_Speed = (short)Word;	// Wind Speed
		ar >> Byte;		m_uFlags = (unsigned char)Byte;
		ar >> Byte;		m_uDummy2 = (unsigned char)Byte;

	    ar.Read (&m_Bearing1, sizeof(BEARTYPE));   
 		ar.Read (&m_Bearing2, sizeof(BEARTYPE)); 
	    }

	if (nReadWayVers <=5)
		{
			if (this->HasBearing (0))
				CLocation::AddDigitToFreq(&(m_Bearing1.Frq));
			if (this->HasBearing (1))
				CLocation::AddDigitToFreq(&(m_Bearing2.Frq));
		}
	}
} 

/************************************************************************
 *  WayPoint.cpp    		 	C r e a t e P t r 						*
 ************************************************************************/
LPWAY CWayPoint::CreatePtr ()
{
LPWAY lpWayPt = new WAYTYPE;

_fmemset (lpWayPt, 0, sizeof (WAYTYPE));

CLocation::WriteToPtr (&lpWayPt->Loc);
this->WriteToPtr (lpWayPt);

return lpWayPt;
}

/************************************************************************
 *  WayPoint.cpp    		 	I s E q u a l							*
 ************************************************************************/
BOOL CWayPoint::IsEqual(LPWAY lpWayPt)
{
CWayPoint TestWpt (lpWayPt);
return (this->IsEqual (TestWpt));
}      
				  
/************************************************************************
 *  WayPoint.cpp    		 		I s E q u a l						*
 ************************************************************************/
BOOL CWayPoint::IsEqual(const CWayPoint& TestWpt)
{
if (!CLocation::IsEqual(TestWpt)) return FALSE;
if (ptDim->CompareDist (m_PlAlt, m_nAltDim, 
			TestWpt.m_PlAlt, TestWpt.m_nAltDim, NO_ALT) != 0) return FALSE;
if (CLocation::IndicatorUsed() != TestWpt.IndicatorUsed()) return FALSE;

if (!BearingIsEqual (TestWpt, 0))	return FALSE;
if (!BearingIsEqual (TestWpt, 1))	return FALSE;

return TRUE;
}

/************************************************************************
 *  WayPoint.cpp    		 		I s E q u a l						*
 ************************************************************************/
BOOL CWayPoint::IsEqual(const CWayPoint* ptTestWpt)
{
return (this->IsEqual (*ptTestWpt));
}

/************************************************************************
 *  WayPoint.cpp		    N a m e C a t T o L o c						*
 ************************************************************************/
BOOL CWayPoint::NameCatToLoc (CString szName, short nCategory, CLocation* ptNavLoc)
{
BOOL	bIndex;
BOOL	bFound = FALSE;
long i, lFirstIndex, lLastIndex;

CNameList* ptNL = ptInit->GetNameListPtr();

											// 1. check with szName = "MTR VOR"
bIndex = ptNL->GetSortedIndexRange ((LPCTSTR)szName, &lFirstIndex, &lLastIndex);

if (!bIndex)								// name MTR may be renamed to Metro...
	{										// 2. check with first part: "MTR" only
	short nSpace = szName.Find(' ');		// nSpace = 3
	if (nSpace > 0)
		{									// find indicator "MTR"
		CString szFirstPart = szName.Left (nSpace);	
		bIndex = ptNL->GetSortedIndexRange ((LPCTSTR)szFirstPart, &lFirstIndex, &lLastIndex);
		}
	}

if (bIndex)
	{
	for (i=lFirstIndex; i<=lLastIndex && !bFound; i++)
		{
		short nRegIndex;
		ptNL->GetLoc (ptNavLoc, i, &nRegIndex);

		if (ptNavLoc->GetCategory() == nCategory)
			{
			bFound = this->IsNear(*ptNavLoc);

			if (bFound)
				{
				BOOL bMultNames = (lFirstIndex != lLastIndex);
				NAMEINDEXTYPE* ptNLEntry = ptNL->GetEntryPtr (i);

				if (bMultNames)							// use full name instead!
					ptNavLoc->SetName (ptNLEntry->szName);	
				
				ptNavLoc->MarkNameForRte (ptNLEntry->szName);
				}
			}
		}
	}

return bFound;
}

/************************************************************************
 *	WayPoint.cpp			G e t B e a r L o c							*
 ************************************************************************/										 
BOOL CWayPoint::GetBearLoc (short nIndex, double* ptLat, double* ptLon)
{
BOOL bFound = FALSE;
CString szNameForRte;
short	nCat;

if (this->GetBearNameAndCat (nIndex, &szNameForRte, &nCat))
	{
	CLocation Loc;
	bFound = this->NameCatToLoc (szNameForRte, nCat, &Loc);
	*ptLat = Loc.GetLat();
	*ptLon = Loc.GetLon();
	}
			
return bFound;
}


/************************************************************************
 *  WayPoint.cpp			G e t L o c N a m e P a i r					*
 ************************************************************************/
CString CWayPoint::GetLocNamePair ()
{
CString szNamePair;

if (IndicatorUsed())
	{
	szNamePair = (CString)m_szIndicator;
	if (strcmp (m_szIndicator, m_szOrt) != 0)
		{
		szNamePair += " (";
		szNamePair += (CString)m_szOrt;
		szNamePair += ")";  
		}
	}
else{
	szNamePair = (CString)m_szOrt;           
	if (*m_szIndicator > 0)
		{
		if (strcmp (m_szIndicator, m_szOrt) != 0)
			{
			szNamePair += " (";
			szNamePair += (CString)m_szIndicator;
			szNamePair += ")";   
			}
		}
	}
return szNamePair;
}
  
/************************************************************************
 *  WayPoint.cpp				G e t R t e N a m e P a r t				*
 *  Purpose: Gets part of route Name: Indicator OR beginn of name		*
 ************************************************************************/
CString CWayPoint::GetRteNamePart()
{
	CString szNamePart;

	CString szIndicator = this->GetIndicator();
	if (szIndicator.GetLength() == 4)
	{									// ICAO indicator available, use it
		szNamePart = szIndicator;
	}
	else 
	{									// no indicateor: use name
		CString szName = this->GetName();
		if (szName.GetLength() > 4)	szNamePart = szName.Left(4);
					else			szNamePart = szName;
	}


	return szNamePart;
}

/////////////////////////////////////////////////////////////////////////////
// CWayPoint commands
