#ifndef __WAYPOINT__      
#define __WAYPOINT__

// WayPoint.h : interface of the CWayPoint class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "Location.h"

typedef struct
	{
	char	Ort[SIZEOF_ORT];
	short	MC;
	short	Dist;
	long	Frq;
	} BEARTYPE;

typedef struct
	{
	KOORDTYPE1 Loc;		/* alle Ortsdaten			*/
	long	PlAlt;		/* geplante Flughoehe			*/
	long	ActAlt;		/* aktuelle Flughoehe aus InsertUpDown	*/
	long	dummy1;		/* 4 Bytes reserviert			*/
	short	ActIAS;		/* aktuelle Geschw. aus InsertUpDown	*/
	short	W_Dir;		/* Windrichtung				*/
	short	W_Speed;	/* Windgeschwindigkeit			*/
	short	dummy2;		/* Reserve				*/
	BEARTYPE Bearing1;	/* Daten zur 1. Funkpeilung		*/
	BEARTYPE Bearing2;	/* Daten zur 2. Funkpeilung		*/
	} WAYTYPE1;
typedef WAYTYPE1 FAR* LPWAY1;


/* WT_ORTHO, WT_UPDOWN					*/
#define WT_ORTHO 	1
#define WT_UP		2
#define WT_DOWN	 	4
#define WT_AUTO		8
#define WT_ELEV		16 
#define WT_xxxxxx	32 			

typedef struct
	{
	KOORDTYPE Loc;			/* alle Ortsdaten						*/
	long	PlAlt;			/* geplante Flughoehe					*/
	short	nAltDim;
	long	ActAlt;			/* aktuelle Flughoehe aus InsertUpDown	*/
	long	dummy1;			/* 4 Bytes reserviert					*/
	short	ActIAS_kt;		/* aktuelle Geschw. aus InsertUpDown	*/
	short	W_Dir;			/* Windrichtung							*/
	short	W_Speed;		/* Windgeschwindigkeit					*/
	unsigned char uFlags; 	/* WT_ORTHO, WT_UP, WT_DOWN, WT_AUTO, WT_ELEV	*/
	unsigned char uDummy2;	/* Reserve								*/
	BEARTYPE Bearing1;		/* Daten zur 1. Funkpeilung				*/
	BEARTYPE Bearing2;		/* Daten zur 2. Funkpeilung				*/
	} WAYTYPE;
typedef WAYTYPE FAR* LPWAY;
//#pragma pack(2)
//#pragma pack() 


#define ACT_WAY_VERS	6   
           



class CWayPoint : public CLocation
{
	DECLARE_SERIAL(CWayPoint)
// Attributes
private:    
	long	m_PlAlt;		/* geplante Flughoehe					*/
	short	m_nAltDim;
	long	m_ActAlt;		/* aktuelle Flughoehe aus InsertUpDown	*/
	long	m_dummy1;		/* 4 Bytes reserviert					*/
	short	m_ActIAS_kt;	/* aktuelle Geschw. aus InsertUpDown	*/
	short	m_W_Dir;		/* Windrichtung							*/
	short	m_W_Speed;		/* Windgeschwindigkeit					*/
	unsigned char m_uFlags;	/* WT_ORTHO, WT_UPDOWN					*/
	unsigned char m_uDummy2;/* Reserve								*/
	BEARTYPE m_Bearing1;	/* Daten zur 1. Funkpeilung				*/
	BEARTYPE m_Bearing2;	/* Daten zur 2. Funkpeilung				*/


// Operations
protected:
	void ReadFromPtr (LPWAY lpWayPt);
	void WriteToPtr (LPWAY lpWayPt) const;

// Implementation
public:
	CWayPoint(LPWAY lpWayPt = NULL);		
	CWayPoint(CWayPoint& SourceWpt);
	~CWayPoint();
	const CWayPoint& operator=(const CWayPoint& Wpt);
 	void GetPtr(LPWAY lpWpt);
	void SetPtr (LPWAY lpWpt);

	void FirstInit ();
	void Reset (CString szName="", short nVar=0, BYTE btFlag=0, long lPlAlt=0);
	void SetLoc (CLocation& Loc);
	void GetLoc (CLocation* ptLoc);
	CLocation GetLoc ();

	virtual void Serialize(CArchive& ar, short nVersion = ACT_WAY_VERS);
	LPWAY CreatePtr ();
	BOOL IsEqual(LPWAY lpPl);
	BOOL IsEqual(const CWayPoint& TestWpt);
	BOOL IsEqual(const CWayPoint* ptTestWpt);

	BOOL GetBearNameAndCat (short nIndex, CString* ptName, short* ptCat);
	BOOL NameCatToLoc (CString szName, short nCategory, CLocation* ptLoc);

	void SetAltDim(short nDim){m_nAltDim = nDim;}
	void SetPlannedAlt (long lAlt) { m_PlAlt = lAlt;}

	short GetAltDim () { return m_nAltDim; }
	long GetPlannedAlt () { return m_PlAlt; }

	long GetPlannedAlt(short nAltDim);

	BOOL GetBearLoc (short nIndex, double* ptLat, double* ptLon);
	CString GetLocNamePair ();
	CString GetRteNamePart();

	void DeleteBearing (short nIndex);
	BOOL HasBearing (short nIndex);
	BOOL GetBearString (short nIndex, CString* ptBearString);
	void CalculateBearing (short nIndex, CLocation& NavLoc);

	CString GetBearingName (short nIndex);
	BOOL BearingIsEqual (const CWayPoint& Wpt, short nIndex);

	void SetOrtho(BOOL bOrtho);
//	void SetUpDown(BOOL bUpDown);
	void SetUp(BOOL bUp);
	void SetDown(BOOL bDown);
	void SetAutoRoute(BOOL bAutoRouting);
	void SetElev(BOOL bElev);

	BOOL IsOrtho();
	BOOL IsUp();
	BOOL IsDown();
	BOOL IsUpDown();
	BOOL IsAutoRoute();
	BOOL IsElev();

	void SetActAlt_ft (long lActAlt) { m_ActAlt = lActAlt; }
	long GetActAlt_ft () { return m_ActAlt; }

	void SetActIAS_kt (short nActIAS) { m_ActIAS_kt = nActIAS; }
	short GetActIAS_kt () { return m_ActIAS_kt; }

	void SetWindDir (short nWindDir) { m_W_Dir = nWindDir; }
	short GetWindDir () { return m_W_Dir; }

	void SetWindSpeed_kt (short nWindSpeed) { m_W_Speed = nWindSpeed; }
	short GetWindSpeed_kt () { return m_W_Speed; }


private:
	void BearCopy (BEARTYPE* dest, const BEARTYPE& source) const;



};

/////////////////////////////////////////////////////////////////////////////
#endif
